StartupEvents.registry('palladium:abilities', event => {
  event.create('fsang:save_coords')
    .icon(palladium.createItemIcon('minecraft:command_block'))
    .addProperty('scoreboard_x', 'string', 'FSang.X', 'Scorebaord for the X coordinate to be saved to.')
    .addProperty('scoreboard_y', 'string', 'FSang.Y', 'Scorebaord for the Y coordinate to be saved to.')
    .addProperty('scoreboard_z', 'string', 'FSang.Z', 'Scorebaord for the Z coordinate to be saved to.')

    .tick((entity, entry, holder, enabled) => {
      if (enabled && entity.isPlayer()) {
        const xObj = entry.getPropertyByName('scoreboard_x');
        const yObj = entry.getPropertyByName('scoreboard_y');
        const zObj = entry.getPropertyByName('scoreboard_z');
        const adjustAmtX = Math.floor(entity.getX());
        const adjustAmtY = Math.floor(entity.getY());
        const adjustAmtZ = Math.floor(entity.getZ());
        const player = entity;

        if (xObj != null) {
          palladium.scoreboard.setScore(player, xObj, adjustAmtX);
        }
        if (yObj != null) {
          palladium.scoreboard.setScore(player, yObj, adjustAmtY);
        }
        if (zObj != null) {
          palladium.scoreboard.setScore(player, zObj, adjustAmtZ);
        }
        entity.tell(`Saved point: ${adjustAmtX}, ${adjustAmtY}, ${adjustAmtZ}`);
      }
    });

  // Put this in the same StartupEvents.registry block
  event.create('fsang:tp_to_saved_coords')
    .icon(palladium.createItemIcon('minecraft:command_block'))
    .addProperty('property_x', 'string', 'FSang.X', 'Scorebaord for the X coordinate to be saved to.')
    .addProperty('property_y', 'string', 'FSang.Y', 'Scorebaord for the Y coordinate to be saved to.')
    .addProperty('property_z', 'string', 'FSang.Z', 'Scorebaord for the Z coordinate to be saved to.')
    .addProperty('property_dimension', 'string', 'FSang.Dim', 'Scorebaord for the Z coordinate to be saved to.')

    .tick((entity, entry, holder, enabled) => {
      if (enabled && entity.isPlayer()) {
        const xObj = entry.getPropertyByName('property_x');
        const yObj = entry.getPropertyByName('property_y');
        const zObj = entry.getPropertyByName('property_z');
        const DObj = entry.getPropertyByName('property_dimension');
        const player = entity;

        const dimension = palladium.getProperty(player, DObj);

        const FSangX = palladium.getProperty(player, xObj);
        const FSangY = palladium.getProperty(player, yObj);
        const FSangZ = palladium.getProperty(player, zObj);

        entity.runCommandSilent(`execute in ${dimension} as @s run tp ${FSangX} ${FSangY} ${FSangZ}`)

      }
    });
});
