StartupEvents.registry('palladium:abilities', event => {
    event.create('fsang:scoreboard_modifier')
        .icon(palladium.createItemIcon('minecraft:command_block'))
        .addProperty('scoreboard_name', 'string', 'example_scoreboard', 'Name of the scoreboard to modify')
        .addProperty('adjustment_type', 'string', 'add', 'add, subtract or set')
        .addProperty('adjustment_amount', 'integer', 1, 'Amount to adjust')

        .tick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                const sbName = entry.getPropertyByName('scoreboard_name');
                const adjustType = entry.getPropertyByName('adjustment_type');
                const adjustAmt = entry.getPropertyByName('adjustment_amount');
                const player = entity;
                
                let scoreboard = Utils.server.scoreboard;
                let sbObj = scoreboard.getObjective(sbName);

                if (sbObj != null) {
                    let score = scoreboard.getOrCreatePlayerScore(player.getGameProfile().getName(), sbObj);
                    let currentScore = score.getScore();

                    if (adjustType === 'add') {
                        palladium.scoreboard.addScore(player, sbName, adjustAmt);
                    } else if (adjustType === 'subtract') {
                        palladium.scoreboard.subtractScore(player, sbName, adjustAmt);
                    } else if (adjustType === 'set') {
                        palladium.scoreboard.setScore(player, sbName, adjustAmt);
                    }
                }
            }
        });
});
