(function () {
    StartupEvents.registry('palladium:abilities', (event) => {

        event.create('fsang:custom_message')

            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('message', 'string', '{"text":"Hello, world!","color":"yellow"}', 'The JSON formatted tellraw message')
            .addProperty('message_color', 'string', 'yellow', 'The color of the message')

            .tick((entity, entry, holder, enabled) => {
                if (enabled && entity.isPlayer()) {
                    let message = entry.getPropertyByName('message');
                    let color = entry.getPropertyByName('message_color');

                    // Send the customized tellraw message to the player
                    let formattedMessage = JSON.parse(message);
                    formattedMessage.color = color; // Customize color if needed
                    entity.runCommand(`tellraw @s ${JSON.stringify(formattedMessage)}`);
                }
            });
    });
})();
