//Made by FSang18
const LivingEntity = Java.loadClass('net.minecraft.world.entity.LivingEntity');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('fsang:transfer_property_from')
        .icon(palladium.createItemIcon('minecraft:experience_bottle'))
        .documentationDescription('Transfers a specified amount of a numeric Palladium property from a raycasted living target within range to the player, if the target has at least the configured minimum.')
        .addProperty('property', 'string', 'fsang_property', 'Palladium property key to transfer')
        .addProperty('amount', 'integer', 1, 'Amount to transfer per tick')
        .addProperty('range', 'float', 8.0, 'Raycast range in blocks')
        .addProperty('min_required', 'integer', 1, 'Minimum value the target must have to allow transfer')
        .addProperty('respect_minimum', 'boolean', true, 'If true, the target will not be reduced below min_required')
        .addProperty('player_max', 'integer', 2147483647, 'Maximum value the player may hold for this property')
        .tick((entity, entry, holder, enabled) => {
            if (!enabled) return;

            const key = entry.getPropertyByName('property');
            const amt = entry.getPropertyByName('amount');
            const range = entry.getPropertyByName('range');
            const minReq = entry.getPropertyByName('min_required');
            const keepMin = !!entry.getPropertyByName('respect_minimum');
            const pMax = entry.getPropertyByName('player_max');

            const hit = entity.rayTrace(range).entity;
            if (!hit || !(hit instanceof LivingEntity) || !hit.isAlive() || hit === entity) return;

            let tVal = Number(palladium.getProperty(hit, key) ?? 0);
            if (tVal < minReq) return;

            let pVal = Number(palladium.getProperty(entity, key) ?? 0);
            let space = Math.max(0, pMax - pVal);
            if (space <= 0) return;

            let maxFromTarget = keepMin ? Math.max(0, tVal - minReq) : tVal;
            let transfer = Math.min(amt, maxFromTarget, space);
            if (transfer <= 0) return;

            palladium.setProperty(hit, key, tVal - transfer);
            palladium.setProperty(entity, key, pVal + transfer);
        });
});

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('fsang:transfer_property_to')
        .icon(palladium.createItemIcon('minecraft:experience_bottle'))
        .documentationDescription('Transfers a specified amount of a numeric Palladium property from the player to a raycasted living target within range, if the player meets the configured minimum.')
        .addProperty('property', 'string', 'fsang_property', 'Palladium property key to transfer')
        .addProperty('amount', 'integer', 1, 'Amount to transfer per tick')
        .addProperty('range', 'float', 8.0, 'Raycast range in blocks')
        .addProperty('min_required', 'integer', 1, 'Minimum value the player must retain/meet to allow transfer')
        .addProperty('respect_minimum', 'boolean', true, 'If true, the player will not be reduced below min_required')
        .addProperty('target_max', 'integer', 2147483647, 'Maximum value the target may hold for this property')
        .tick((entity, entry, holder, enabled) => {
            if (!enabled) return;

            const key = entry.getPropertyByName('property');
            const amt = entry.getPropertyByName('amount');
            const range = entry.getPropertyByName('range');
            const minReq = entry.getPropertyByName('min_required');
            const keepMin = !!entry.getPropertyByName('respect_minimum');
            const tMax = entry.getPropertyByName('target_max');

            const hit = entity.rayTrace(range).entity;
            if (!hit || !(hit instanceof LivingEntity) || !hit.isAlive() || hit === entity) return;

            let pVal = Number(palladium.getProperty(entity, key) ?? 0);
            if (pVal < minReq) return;

            let tVal = Number(palladium.getProperty(hit, key) ?? 0);
            let space = Math.max(0, tMax - tVal);
            if (space <= 0) return;

            let maxFromPlayer = keepMin ? Math.max(0, pVal - minReq) : pVal;
            let transfer = Math.min(amt, maxFromPlayer, space);
            if (transfer <= 0) return;

            palladium.setProperty(entity, key, pVal - transfer);
            palladium.setProperty(hit, key, tVal + transfer);
        });
});
