// addonpack_fsang_hero/kubejs_scripts/worthy_ability.js
// Replaces the old logic with a command-driven pull toward the player.

StartupEvents.registry('palladium:abilities', event => {
    event.create('fsang:worthy')
        .icon(palladium.createItemIcon('minecraft:ender_pearl'))
        .documentationDescription('Pull your named Mjolnir toward you if it is dropped nearby.')
        .addProperty('range', 'integer', 16, 'Search radius in blocks')
        .addProperty('interval', 'integer', 4, 'Ticks between pulls')
        .addProperty('step', 'double', 0.75, 'Blocks moved per pull')
        .tick((entity, entry, holder, enabled) => {

            const range = entry.getPropertyByName('range');
            const step = entry.getPropertyByName('step');
            const name = entity.getGameProfile().getName();

            entity.server.runCommandSilent(`execute as @e[type=item,nbt={Item:{tag:{display:{Name:'{"text":"FSang18's Mjolnir"}'}}}}] at @s run tp @s @p`);
        });
});
