// Name/key for the data, stored here to use everywhere else
const TARGET = 'asgardian_target';
const DIM = 'asgardian_dim';
const X = 'asgardian_x';
const Y = 'asgardian_y';
const Z = 'asgardian_z';


// Register the property on the client-side, so it should be the same code as in data/test/kubejs_scripts/broken_blocks_counter.js!
PalladiumEvents.registerPropertiesClientSided((event) => {
    // Only register for players
    if (event.getEntityType() === "minecraft:player") {
        // Arguments: Key of the property, type of the property, default/starting value
        event.registerProperty(TARGET, 'string', 'minecraft:air');
        event.registerProperty(DIM, 'string', 'minecraft:air');
        event.registerProperty(X, 'integer', 0);
        event.registerProperty(Y, 'integer', 0);
        event.registerProperty(Z, 'integer', 0);
    }
});

// Event for registering HUDs
PalladiumEvents.registerGuiOverlays((event) => {
    event.register('fsang/asgardian2_target', (minecraft, gui, poseStack, partialTick, screenWidth, screenHeight) => {
        let player = minecraft.player;

        if (palladium.abilities.isEnabled(player, `fsang:asgardian2`, `asgardian_true_sight_purchase`)) {

            const green_skill = palladium.getProperty(minecraft.player, TARGET);
            const dimension = palladium.getProperty(minecraft.player, DIM);

            const FSangX = palladium.getProperty(minecraft.player, X);
            const FSangY = palladium.getProperty(minecraft.player, Y);
            const FSangZ = palladium.getProperty(minecraft.player, Z);

            let x4 = screenWidth - 66;
            let y4 = screenHeight - 40;
            let x2 = screenWidth - 475;

            if (green_skill >= 0 && green_skill <= 9) {
                x2 -= -3;  // No shift
            } else if (green_skill >= 10 && green_skill <= 99) {
                x2 -= 0;  // Slight shift left
            } else if (green_skill === 100) {
                x2 -= 3;  // Further shift for 3-digit number
            }
            guiUtil.drawString(poseStack, Component.string(`Target:`), x2, y4 - 9, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Target:`), x2, y4 - 11, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Target:`), x2 - 1, y4 - 10, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Target:`), x2 + 1, y4 - 10, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Target:`), x2, y4 - 10, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Target:`), x2, y4 - 10, 0xffffff);

            guiUtil.drawString(poseStack, Component.string(`${green_skill}`), x2, y4 - 1, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${green_skill}`), x2, y4 + 1, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${green_skill}`), x2 - 1, y4, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${green_skill}`), x2 + 1, y4, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${green_skill}`), x2, y4, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${green_skill}`), x2, y4, 0xd1a020);

            guiUtil.drawString(poseStack, Component.string(`Dim: ${dimension}`), x2, y4 + 9, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Dim: ${dimension}`), x2, y4 + 11, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Dim: ${dimension}`), x2 - 1, y4 + 10, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Dim: ${dimension}`), x2 + 1, y4 + 10, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Dim: ${dimension}`), x2, y4 + 10, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`Dim: ${dimension}`), x2, y4 + 10, 0xffffff);

            guiUtil.drawString(poseStack, Component.string(`${FSangX}, ${FSangY}, ${FSangZ}`), x2, y4 + 19, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${FSangX}, ${FSangY}, ${FSangZ}`), x2, y4 + 21, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${FSangX}, ${FSangY}, ${FSangZ}`), x2 - 1, y4 + 20, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${FSangX}, ${FSangY}, ${FSangZ}`), x2 + 1, y4 + 20, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${FSangX}, ${FSangY}, ${FSangZ}`), x2, y4 + 20, 0x0000);
            guiUtil.drawString(poseStack, Component.string(`${FSangX}, ${FSangY}, ${FSangZ}`), x2, y4 + 20, 0xffffff);
        }
    }
    );
    event.register('fsang/speedforce_speed', (minecraft, gui, poseStack, partialTick, screenWidth, screenHeight) => {
        let player = minecraft.player;

        if (palladium.abilities.isEnabled(player, `fsang:speedforce`, `speedforce_speed_hud`)) {

            const curSpeed = palladium.getProperty(minecraft.player, `fsang_speedster_speed`);
            const colorSpeed = palladium.getProperty(minecraft.player, `fsang_speed_trail1`);
            const colorSpeed2 = palladium.getProperty(minecraft.player, `fsang_speed_trail2`);

            let x = screenWidth - 74.5;
            let y = screenHeight - 24.5;

            if (curSpeed >= 0 && curSpeed <= 9) {
                x -= -3;  // No shift
            } else if (curSpeed >= 10 && curSpeed <= 99) {
                x -= 0;  // Slight shift left
            } else if (curSpeed >= 100) {
                x -= 3;  // Further shift for 3-digit number
            }

            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y - 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y + 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x - 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x + 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed);
        }
        if (palladium.abilities.isEnabled(player, `fsang:speedforce_god`, `speedforce_speed_hud`)) {

            const curSpeed = palladium.getProperty(minecraft.player, `fsang_speedster_speed`);
            const colorSpeed = palladium.getProperty(minecraft.player, `fsang_speed_trail1`);
            const colorSpeed2 = palladium.getProperty(minecraft.player, `fsang_speed_trail2`);

            let x = screenWidth - 74.5;
            let y = screenHeight - 24.5;

            if (curSpeed >= 0 && curSpeed <= 9) {
                x -= -3;  // No shift
            } else if (curSpeed >= 10 && curSpeed <= 99) {
                x -= 0;  // Slight shift left
            } else if (curSpeed >= 100) {
                x -= 3;  // Further shift for 3-digit number
            }

            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y - 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y + 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x - 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x + 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed);
        }
        if (palladium.abilities.isEnabled(player, `fsang:speedforce_negative`, `speedforce_speed_hud`)) {

            const curSpeed = palladium.getProperty(minecraft.player, `fsang_speedster_speed`);
            const colorSpeed = palladium.getProperty(minecraft.player, `fsang_speed_trail1`);
            const colorSpeed2 = palladium.getProperty(minecraft.player, `fsang_speed_trail2`);

            let x = screenWidth - 74.5;
            let y = screenHeight - 24.5;

            if (curSpeed >= 0 && curSpeed <= 9) {
                x -= -3;  // No shift
            } else if (curSpeed >= 10 && curSpeed <= 99) {
                x -= 0;  // Slight shift left
            } else if (curSpeed >= 100) {
                x -= 3;  // Further shift for 3-digit number
            }

            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y - 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y + 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x - 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x + 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed);
        }
        if (palladium.abilities.isEnabled(player, `fsang:speedforce_strength`, `speedforce_speed_hud`)) {

            const curSpeed = palladium.getProperty(minecraft.player, `fsang_speedster_speed`);
            const colorSpeed = palladium.getProperty(minecraft.player, `fsang_speed_trail1`);
            const colorSpeed2 = palladium.getProperty(minecraft.player, `fsang_speed_trail2`);

            let x = screenWidth - 74.5;
            let y = screenHeight - 24.5;

            if (curSpeed >= 0 && curSpeed <= 9) {
                x -= -3;  // No shift
            } else if (curSpeed >= 10 && curSpeed <= 99) {
                x -= 0;  // Slight shift left
            } else if (curSpeed >= 100) {
                x -= 3;  // Further shift for 3-digit number
            }

            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y - 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y + 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x - 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x + 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed);
        }
        if (palladium.abilities.isEnabled(player, `fsang:speedforce_speed`, `speedforce_speed_hud`)) {

            const curSpeed = palladium.getProperty(minecraft.player, `fsang_speedster_speed`);
            const colorSpeed = palladium.getProperty(minecraft.player, `fsang_speed_trail1`);
            const colorSpeed2 = palladium.getProperty(minecraft.player, `fsang_speed_trail2`);

            let x = screenWidth - 74.5;
            let y = screenHeight - 24.5;

            if (curSpeed >= 0 && curSpeed <= 9) {
                x -= -3;  // No shift
            } else if (curSpeed >= 10 && curSpeed <= 99) {
                x -= 0;  // Slight shift left
            } else if (curSpeed >= 100) {
                x -= 3;  // Further shift for 3-digit number
            }

            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y - 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y + 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x - 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x + 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed);
        }
        if (palladium.abilities.isEnabled(player, `fsang:speedforce_leech`, `speedforce_speed_hud`)) {

            const curSpeed = palladium.getProperty(minecraft.player, `fsang_speedster_speed`);
            const colorSpeed = palladium.getProperty(minecraft.player, `fsang_speed_trail1`);
            const colorSpeed2 = palladium.getProperty(minecraft.player, `fsang_speed_trail2`);

            let x = screenWidth - 74.5;
            let y = screenHeight - 24.5;

            if (curSpeed >= 0 && curSpeed <= 9) {
                x -= -3;  // No shift
            } else if (curSpeed >= 10 && curSpeed <= 99) {
                x -= 0;  // Slight shift left
            } else if (curSpeed >= 100) {
                x -= 3;  // Further shift for 3-digit number
            }

            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y - 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y + 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x - 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x + 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed);
        }
        if (palladium.abilities.isEnabled(player, `fsang:speedforce_tachyon`, `speedforce_speed_hud`)) {

            const curSpeed = palladium.getProperty(minecraft.player, `fsang_speedster_speed`);
            const colorSpeed = palladium.getProperty(minecraft.player, `fsang_speed_trail1`);
            const colorSpeed2 = palladium.getProperty(minecraft.player, `fsang_speed_trail2`);

            let x = screenWidth - 74.5;
            let y = screenHeight - 24.5;

            if (curSpeed >= 0 && curSpeed <= 9) {
                x -= -3;  // No shift
            } else if (curSpeed >= 10 && curSpeed <= 99) {
                x -= 0;  // Slight shift left
            } else if (curSpeed >= 100) {
                x -= 3;  // Further shift for 3-digit number
            }

            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y - 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y + 1, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x - 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x + 1, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed2);
            guiUtil.drawString(poseStack, Component.string(`${curSpeed}`), x, y, colorSpeed);
        }
    }
    );
});

let Minecraft = Java.loadClass('net.minecraft.client.Minecraft');

PalladiumEvents.renderPowerScreen(e => {
    let player = Client.Player || Minecraft.getInstance().player;
    if (!player) return;

    if (e.tab === 'fsang:speedforce') {
        let sp_cur = palladium.getProperty(player, `fsang_speedster_speedforce`);

        let y = 50;
        let x = 323;

        let y2 = 51;
        let x2 = 334;

        if (sp_cur >= 0 && sp_cur <= 9) {
            x2 -= 6;  // No shift
        } else if (sp_cur >= 10 && sp_cur <= 99) {
            x2 -= 9;  // Slight shift left
        } else if (sp_cur >= 100) {
            x2 -= 12;  // Slight shift left
        }

        e.guiGraphics.blit(
            new ResourceLocation(`fsang:textures/icon/gui/powers/speedster_kingdom.png`),
            x + 10, y - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 14, y2 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 14, y2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 15, y2 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 13, y2 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 14, y2 + 1, 0xd1a020);
    }
    if (e.tab === 'fsang:speedforce_leech') {
        let sp_cur = palladium.getProperty(player, `fsang_living_speed`);

        let y = 50;
        let x = 323;

        let y2 = 51;
        let x2 = 334;

        if (sp_cur >= 0 && sp_cur <= 9) {
            x2 -= 6;  // No shift
        } else if (sp_cur >= 10 && sp_cur <= 99) {
            x2 -= 9;  // Slight shift left
        } else if (sp_cur >= 100) {
            x2 -= 12;  // Slight shift left
        }

        e.guiGraphics.blit(
            new ResourceLocation(`fsang:textures/icon/gui/powers/speedster_leech.png`),
            x + 10, y - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 14, y2 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 14, y2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 15, y2 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 13, y2 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${sp_cur} `), x2 + 14, y2 + 1, 0xffffff);
    }
    if (e.tab === 'fsang_secondary:phoenix_force') {
        let FSangSymbioteSkills = palladium.scoreboard.getScore(player, `FSang.2.Phoenix`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangSymbioteSkills >= 0 && FSangSymbioteSkills <= 9) {
            x2 -= -3;
        } else if (FSangSymbioteSkills >= 10 && FSangSymbioteSkills <= 99) {
            x2 -= 0;
        } else if (FSangSymbioteSkills >= 100 && FSangSymbioteSkills <= 999) {
            x2 -= 3;
        } else if (FSangSymbioteSkills >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation(`fsang:textures/icon/gui/powers/phoenix_force.png`),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 1, 0xffffff);
    }
    if (e.tab === 'fsang_secondary:cosmic') {
        let FSangSymbioteSkills = palladium.scoreboard.getScore(player, `FSang.2.Cosmic`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangSymbioteSkills >= 0 && FSangSymbioteSkills <= 9) {
            x2 -= -3;
        } else if (FSangSymbioteSkills >= 10 && FSangSymbioteSkills <= 99) {
            x2 -= 0;
        } else if (FSangSymbioteSkills >= 100 && FSangSymbioteSkills <= 999) {
            x2 -= 3;
        } else if (FSangSymbioteSkills >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation(`fsang:textures/icon/gui/powers/cosmic_board.png`),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 1, 0xffffff);
    }
    if (e.tab === 'fsang_secondary:kaiju_no_8') {
        let FSangSymbioteSkills = palladium.scoreboard.getScore(player, `FSang.2.Kaiju`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangSymbioteSkills >= 0 && FSangSymbioteSkills <= 9) {
            x2 -= -3;
        } else if (FSangSymbioteSkills >= 10 && FSangSymbioteSkills <= 99) {
            x2 -= 0;
        } else if (FSangSymbioteSkills >= 100 && FSangSymbioteSkills <= 999) {
            x2 -= 3;
        } else if (FSangSymbioteSkills >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation(`fsang:textures/icon/gui/powers/kaiju.png`),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 1, 0xffffff);
    }
    if (e.tab === 'fsang_secondary:scarab') {
        let FSangSymbioteSkills = palladium.scoreboard.getScore(player, `FSang.2.Scarab`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangSymbioteSkills >= 0 && FSangSymbioteSkills <= 9) {
            x2 -= -3;
        } else if (FSangSymbioteSkills >= 10 && FSangSymbioteSkills <= 99) {
            x2 -= 0;
        } else if (FSangSymbioteSkills >= 100 && FSangSymbioteSkills <= 999) {
            x2 -= 3;
        } else if (FSangSymbioteSkills >= 1000) {
            x2 -= 7;
        }

        let symbioteID = palladium.scoreboard.getScore(player, 'FSang.Scarab.Color', 0);
        let texturepath = `fsang:textures/icon/gui/dynamic_icons/scarabs/${symbioteID}.png`;

        e.guiGraphics.blit(
            new ResourceLocation(texturepath),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 1, 0xffffff);
    }
    if (e.tab === 'fsang_secondary:symbiote_natural') {
        let FSangSymbioteSkills = palladium.scoreboard.getScore(player, `FSang.2.Symb.Nat`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangSymbioteSkills >= 0 && FSangSymbioteSkills <= 9) {
            x2 -= -3;
        } else if (FSangSymbioteSkills >= 10 && FSangSymbioteSkills <= 99) {
            x2 -= 0;
        } else if (FSangSymbioteSkills >= 100 && FSangSymbioteSkills <= 999) {
            x2 -= 3;
        } else if (FSangSymbioteSkills >= 1000) {
            x2 -= 7;
        }

        let symbioteID = palladium.scoreboard.getScore(player, 'Symbiote_Assigner', 0);
        let texturepath = `fsang:textures/icon/gui/dynamic_icons/symbiotes/${symbioteID}.png`;

        e.guiGraphics.blit(
            new ResourceLocation(texturepath),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 1, 0xffffff);
    }
    if (e.tab === 'fsang_secondary:symbiote_natural') {
        let FSangSymbioteSkills = palladium.scoreboard.getScore(player, `FSang.Age.Symbiote`, 0);

        let x4 = e.screen.width - 185;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 183;

        //let x4 = e.screen.width - 160;
        //let y4 = e.screen.height - 55;
        //let x2 = e.screen.width - 158;

        if (FSangSymbioteSkills >= 0 && FSangSymbioteSkills <= 9) {
            x2 -= -3;
        } else if (FSangSymbioteSkills >= 10 && FSangSymbioteSkills <= 99) {
            x2 -= 0;
        } else if (FSangSymbioteSkills >= 100 && FSangSymbioteSkills <= 999) {
            x2 -= 3;
        } else if (FSangSymbioteSkills >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/symbiote_codex.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 1, 0xffffff);
    }
    if (e.tab === 'fsang_secondary:symbiote') {
        let FSangSymbioteSkills = palladium.scoreboard.getScore(player, `FSang.2.Symb.Art`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangSymbioteSkills >= 0 && FSangSymbioteSkills <= 9) {
            x2 -= -3;
        } else if (FSangSymbioteSkills >= 10 && FSangSymbioteSkills <= 99) {
            x2 -= 0;
        } else if (FSangSymbioteSkills >= 100 && FSangSymbioteSkills <= 999) {
            x2 -= 3;
        } else if (FSangSymbioteSkills >= 1000) {
            x2 -= 7;
        }

        let symbioteID = palladium.scoreboard.getScore(player, 'Symbiote_Assigner', 0);
        let texturepath = `fsang:textures/icon/gui/dynamic_icons/symbiotes/${symbioteID}.png`;

        e.guiGraphics.blit(
            new ResourceLocation(texturepath),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangSymbioteSkills}`), x2 + 14, y4 + 1, 0xffffff);
    }
    if (e.tab === 'fsang:asgardian') {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/asgardian.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 3, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 3, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 3, 0xcc9c1f);
    }
    if (e.tab === 'fsang:asgardian2') {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/asgardian2.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 3, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 3, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 3, 0xcc9c1f);
    }
    if (e.tab === 'fsang:viltrumite_thraxan') {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/viltrumite_thraxan.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 1, 0x67567f);
    }
    if (e.tab === 'fsang:viltrumite_scout') {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/viltrumite_scout.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 1, 0xafaeae);
    }
    if (e.tab === 'fsang:viltrumite_human') {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/viltrumite_human.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 1, 0x006eb7);
    }
    if (e.tab === 'fsang:viltrumite_brute') {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/viltrumite_brute.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 1, 0xaaaaaa);
    }
    if (e.tab === 'fsang:viltrumite') {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 160;
        let y4 = e.screen.height - 195;
        let x2 = e.screen.width - 158;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/viltrumite.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 1, 0xc44141);
    }
    if (palladium.abilities.isEnabled(player, `fsang:age`, `fsang_age`)) {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 150;
        let y4 = e.screen.height - 238;
        let x2 = e.screen.width - 148;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/kryptonian_absolute.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 1, 0xFFD700);
    }
    if (palladium.abilities.isEnabled(player, `fsang:age`, `bosa_age`)) {
        let FSangAge = palladium.scoreboard.getScore(player, `FSang.Age`, 0);

        let x4 = e.screen.width - 150;
        let y4 = e.screen.height - 238;
        let x2 = e.screen.width - 148;

        if (FSangAge >= 0 && FSangAge <= 9) {
            x2 -= -3;
        } else if (FSangAge >= 10 && FSangAge <= 99) {
            x2 -= 0;
        } else if (FSangAge >= 100 && FSangAge <= 999) {
            x2 -= 3;
        } else if (FSangAge >= 1000) {
            x2 -= 7;
        }

        e.guiGraphics.blit(
            new ResourceLocation('fsang:textures/icon/gui/powers/kryptonian_dcu.png'),
            x4 + 10, y4 - 6,
            0, 0,
            23, 23,
            23, 23
        );

        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 2, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 15, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 13, y4 + 1, 0x000000);
        palladium.gui.drawString(e.guiGraphics, Component.string(`${FSangAge}`), x2 + 14, y4 + 1, 0x25b2e3);
    }
});