const atlanteanWeights = [
    { power: 'fsang:atlantean', weight: 8, name: "Atlantean (Royal)" },
    { power: 'fsang:atlantean_sea_changed', weight: 5, name: "Atlantean (Sea-Changed)" }
];

function getRandomAtlantean() {
    const totalWeight = atlanteanWeights.reduce((acc, atlantean) => acc + atlantean.weight, 0);
    let random = Math.random() * totalWeight;

    for (const atlantean of atlanteanWeights) {
        if (random < atlantean.weight) {
            return atlantean;
        }
        random -= atlantean.weight;
    }
}

function getRandomScore(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

ItemEvents.rightClicked(event => {
    const { player, item, server, hand } = event;

    // Check if the item is "fsang:atlantean_artifact"
    if (item.id === 'fsang:atlantean_artifact') {

        event.server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang:all`);

        // Assign random atlantean based on weights
        const assignedAtlantean = getRandomAtlantean();

        // Assign the player the corresponding atlantean power
        superpowerUtil.addSuperpower(player, assignedAtlantean.power);

        // Send a message in the player's chat window
        player.tell(`You have been granted the atlantean power: ${assignedAtlantean.name}`);

        // Explicitly remove the item from the player's main hand
        player.setItemInHand(hand, Item.of('minecraft:air'));
    }
});