const configFilePath = 'config/fsang_config.json';

// Default configuration
const defaultConfig = {
    item_cooldown: true,
    symbiote_cooldown: true
};

// Load configuration from file or create it if it doesn't exist
function loadConfig() {
    let file = JsonIO.read(configFilePath);

    if (!file) {
        console.log(`Config file not found. Creating default config at ${configFilePath}`);
        saveConfig(defaultConfig);
        return defaultConfig;
    } else {
        console.log(`Config file found. Loading config from ${configFilePath}`);
        return file;
    }
}

// Save updated configuration to file
function saveConfig(config) {
    JsonIO.write(configFilePath, config);
    console.log(`Config file saved at ${configFilePath}`);
}

// Execute scoreboard commands for the player when they load into the game
function applyScoreboardCommandsForPlayer(player, config) {
    // Handle item_cooldown configuration
    let itemCooldownValue = config.item_cooldown ? 1 : 0;
    let addItemObjectiveCommand = `execute as ${player.name.string} run scoreboard objectives add FSang.Gamerule.item dummy`;
    let setItemCooldownCommand = `execute as ${player.name.string} run scoreboard players set .sang FSang.Gamerule.item ${itemCooldownValue}`;

    console.log(`Running command: ${addItemObjectiveCommand}`);
    player.server.runCommandSilent(addItemObjectiveCommand);

    console.log(`Running command: ${setItemCooldownCommand}`);
    player.server.runCommandSilent(setItemCooldownCommand);

    // Handle symbiote_cooldown configuration
    let symbioteCooldownValue = config.symbiote_cooldown ? 1 : 0;
    let addSymbioteObjectiveCommand = `execute as ${player.name.string} run scoreboard objectives add FSang.Gamerule.symbiote dummy`;
    let setSymbioteCooldownCommand = `execute as ${player.name.string} run scoreboard players set .sang FSang.Gamerule.symbiote ${symbioteCooldownValue}`;

    console.log(`Running command: ${addSymbioteObjectiveCommand}`);
    player.server.runCommandSilent(addSymbioteObjectiveCommand);

    console.log(`Running command: ${setSymbioteCooldownCommand}`);
    player.server.runCommandSilent(setSymbioteCooldownCommand);
}

// When the player logs in, apply the commands
PlayerEvents.loggedIn(event => {
    let config = loadConfig();
    console.log(`Applying config to player: ${event.player.name.string}`);
    applyScoreboardCommandsForPlayer(event.player, config);
});

// Initialize the configuration when the server starts
ServerEvents.loaded(event => {
    let config = loadConfig();
    console.log(`Config file loaded or created at ${configFilePath}`);
});
