const cursedUserWeights = [
    { power: 'fsang:boogie_woogie', weight: 8, name: "Cursed User (Boogie Woogie)" }
];

function getRandomCursedPower() {
    const totalWeight = cursedUserWeights.reduce((acc, cursedPower) => acc + cursedPower.weight, 0);
    let random = Math.random() * totalWeight;

    for (const cursedPower of cursedUserWeights) {
        if (random < cursedPower.weight) {
            return cursedPower;
        }
        random -= cursedPower.weight;
    }
}

function getRandomScore(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

ItemEvents.rightClicked(event => {
    const { player, item, server, hand } = event;

    if (item.id === 'fsang:cursed_totem') {

        event.server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang:all`);

        const assignedCursedPower = getRandomCursedPower();

        superpowerUtil.addSuperpower(player, assignedCursedPower.power);

        player.tell(`You have been granted the power: ${assignedCursedPower.name}`);

        player.setItemInHand(hand, Item.of('minecraft:air'));
    }
});