ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event// kubejs/server_scripts/fstp.js
    event.register(
        Commands.literal("ftp_coord")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();
                let dimension = ctx.source.getLevel().getDimension();
                let x_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepX")).getScore();
                let y_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepY")).getScore();
                let z_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepZ")).getScore();


                server.runCommandSilent(`execute in ${dimension} as ${username} at @s run tp ${x_value} ${y_value} ${z_value}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("FSang.Name")
            .then(
                Commands.argument("action", Arguments.STRING.create(event))
                    .suggests((ctx, builder) => {
                        builder.suggest("change")
                        builder.suggest("reset")
                        return builder.buildFuture()
                    })
                    .then(
                        Commands.argument("name", Arguments.STRING.create(event))
                            .requires(src => src.hasPermission(0))
                            .executes(ctx => {
                                const player = ctx.source.player;
                                const username = player.getGameProfile().getName();
                                const server = ctx.source.getServer();
                                const action = Arguments.STRING.getResult(ctx, "action");
                                const changedName = Arguments.STRING.getResult(ctx, "name");

                                const BLACKLIST = [
                                    "FSang", "F S a", "F Sa", "FS a", "f5", "fs4", "creator", "cr3", "cre4", "creat0", "admin", "owner", "moderator", "mod", "gm", "op",
                                    "server", "console", "npc", "null", "notch",
                                    "1", "2", "3", "4", "5", "6", "7", "8", "9", "0",
                                    "fuck",
                                    "bitch", "b1tch",
                                    "gay", "g4y",
                                    "fag", "f4g",
                                    "nigg", "n1gg",
                                    "ass", "a55", "4ss", "45", "55",
                                    "boner",
                                    "shit", "sh1",
                                    "peni", "p3ni", "pen1", "p3n1",
                                    "Al-Quada", "vag", "v4g", "puss", "pu5", "pus5",
                                    "cunt", "cum",
                                    "twat", "tw4t",
                                    "dick", "d1ck",
                                    "cock", "c0ck",
                                    "nazi", "n4z", "naz1",
                                    "negr", "n3g",
                                    "bastard", "b4", "ba5", "bast4",
                                    "pedo", "p3",
                                    "pervert", "perv3",
                                    "dyke", "dyk3", "d y",
                                    "chink", "ch1",
                                    "whore", "wh0", "whor3",
                                    "slut", "kike", "k1", "kik3",
                                    "gangbang", "g4", "gangb4ng", "gang bang",
                                    "threesome", "thr3", "thre3", "three some", "threesom3", "three som3",
                                    "Cocaine", "Coke", "C0", "Coc4", "Cocain3", "Cok3",
                                    "meth", "m3",
                                    "crack", "cr4",
                                    "Masturbate", "M4", "Ma5", "Masturb4", "Masturbat3", "Mastur",
                                    "Jizz", "Jiz", "j1",
                                    "Tranny", "Tr4", "Trann",
                                    "Kunt",
                                    "rape", "r4", "rap3", "rapi", "rap1", "*", "  "
                                ];
                                const containsBlacklisted = (name) => {
                                    const lower = name.toLowerCase();
                                    return BLACKLIST.some(term => lower.includes(term.toLowerCase()));
                                };

                                if (abilityUtil.isUnlocked(player, "fsang:name_changer", "name_change")) {
                                    if (action === "change") {
                                        // Validate against blacklist
                                        if (containsBlacklisted(changedName)) {
                                            server.runCommandSilent(
                                                `tellraw ${username} ["",{"text":"That name is not allowed.","color":"red"}]`
                                            );
                                            return 1; // Do not modify persistent data
                                        }

                                        // Save new name to persistent data
                                        player.persistentData.putString("name_changer", changedName);

                                        server.runCommandSilent(
                                            `tellraw ${username} ["",{"text":"Name Changed to: ${changedName}","color":"dark_green"}]`
                                        );
                                        // Refresh curios slot item
                                        server.runCommandSilent(`curios replace fsang_ai 0 ${username} with minecraft:air`);
                                        server.scheduleInTicks(2, () => {
                                            server.runCommandSilent(`curios replace fsang_ai 0 ${username} with fsang:name_changer`);
                                        });

                                    } else if (action === "reset") {
                                        // Reset to the player's original username
                                        player.persistentData.putString("name_changer", username);

                                        server.runCommandSilent(
                                            `tellraw ${username} ["",{"text":"Name Reset to Original Username.","color":"red"}]`
                                        );
                                        server.runCommandSilent(`curios replace fsang_ai 0 ${username} with minecraft:air`);
                                        server.scheduleInTicks(2, () => {
                                            server.runCommandSilent(`curios replace fsang_ai 0 ${username} with fsang:name_changer`);
                                        });
                                    }

                                } else {
                                    server.runCommandSilent(
                                        `tellraw ${username} ["",{"text":"You do not have a Name Changing Device equipped.","color":"dark_red"}]`
                                    );
                                }

                                return 1;
                            })
                    )
            )
    );
    event.register(
        Commands.literal("FSang.Skin")
            .then(
                Commands.literal("set")
                    .then(
                        Commands.argument("value", Arguments.STRING.create(event))
                            .then(
                                Commands.argument("Green", Arguments.BOOLEAN.create(event))
                                    .requires(src => src.hasPermission(0))
                                    .executes(ctx => {
                                        const player = ctx.source.player;
                                        if (!player) return 0;
                                        if (!palladium.superpowers.hasSuperpower(player, "fsang:martian_green")) return 0;

                                        const server = ctx.source.getServer();
                                        const username = player.getGameProfile().getName();
                                        const raw = Arguments.STRING.getResult(ctx, "value");
                                        const value = String(raw).trim();
                                        const giveTag = Arguments.BOOLEAN.getResult(ctx, "Green");

                                        palladium.setProperty(player, "skin_change", "minecraft:air");
                                        palladium.superpowers.removeSuperpower(player, "fsang:martian_green");
                                        server.scheduleInTicks(1, () => {
                                            player.persistentData.putString("skin_change", value);
                                            palladium.setProperty(player, "skin_change", value);
                                            palladium.superpowers.addSuperpower(player, "fsang:martian_green");
                                            if (giveTag) {
                                                server.runCommandSilent(`tag ${username} add FSang.Skin.Original`);
                                            } else {
                                                server.runCommandSilent(`tag ${username} remove FSang.Skin.Original`);
                                            }
                                            server.runCommandSilent(`tellraw ${username} ["",{"text":"Skin changed to: ","color":"white"},{"text":"${value}","color":"dark_green"}]`);
                                        });
                                        return 1;
                                    })
                            )
                    )
            )
            .then(
                Commands.literal("reset")
                    .requires(src => src.hasPermission(0))
                    .executes(ctx => {
                        const player = ctx.source.player;
                        if (!player) return 0;

                        const server = ctx.source.getServer();
                        const username = player.getGameProfile().getName();

                        server.scheduleInTicks(1, () => {
                            palladium.setProperty(player, "skin_change", "minecraft:air");
                            server.runCommandSilent(`tag ${username} remove FSang.Skin.Original`);
                            server.runCommandSilent(`tellraw ${username} ["",{"text":"Skin reset to default.","color":"red"}]`);
                        });
                        return 1;
                    })
            )
            .then(
                Commands.literal("slot")
                    .then(
                        Commands.argument("slot", Arguments.INTEGER.create(event))
                            .then(
                                Commands.argument("value", Arguments.STRING.create(event))
                                    .requires(src => src.hasPermission(0))
                                    .executes(ctx => {
                                        const player = ctx.source.player;
                                        if (!player) return 0;

                                        const server = ctx.source.getServer();
                                        const username = player.getGameProfile().getName();
                                        const slot = Arguments.INTEGER.getResult(ctx, "slot");
                                        const raw = Arguments.STRING.getResult(ctx, "value");
                                        const value = String(raw).trim();

                                        if (slot < 1 || slot > 5) {
                                            server.runCommandSilent(`tellraw ${username} ["",{"text":"Slot must be between 1 and 5.","color":"red"}]`);
                                            return 0;
                                        }

                                        server.scheduleInTicks(1, () => {
                                            palladium.setProperty(player, `Martian.Skin.${slot}`, value);
                                            server.runCommandSilent(`tellraw ${username} ["",{"text":"Martian.Skin.${slot} set to: ","color":"white"},{"text":"${value}","color":"dark_green"}]`);
                                        });
                                        return 1;
                                    })
                            )
                    )
            )
    );
    event.register(
        Commands.literal("FSang.Karma")
            .requires(src => src.hasPermission(0))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();

                server.runCommandSilent(`tellraw ${username} ["","${username}'s Karma: ",{"color":"gold","score":{"objective":"FSang.Karma","name":"${username}"}}]`);
                server.runCommandSilent(`title ${username} actionbar ["","${username}'s Karma: ",{"color":"gold","score":{"objective":"FSang.Karma","name":"${username}"}}]`);

                return 1;
            })
    );
    event.register(
        Commands.literal("FSang.Coords")
            .then(Commands.argument('entity', Arguments.PLAYER.create(event))
                .requires(src => src.hasPermission(0))
                .executes(ctx => {

                    const player = ctx.source.player;
                    const server = ctx.source.getServer();
                    const username = player.getGameProfile().getName();

                    const target = Arguments.PLAYER.getResult(ctx, 'entity');
                    const Targetusername = target.getGameProfile().getName();

                    // --- Robustly extract dimension id ---
                    const dimKey = target.getLevel().getDimension();
                    let fullId;
                    try {
                        // Preferred: ResourceKey#location() → ResourceLocation → "modid:path"
                        const loc = (dimKey && dimKey.location) ? dimKey.location() : null;
                        fullId = loc ? String(loc.toString()) : String(dimKey);
                    } catch (e) {
                        // Fallback to whatever string representation we can get
                        fullId = String(dimKey);
                    }

                    // Normalize: handle cases like "ResourceKey[minecraft:overworld]" or already "minecraft:overworld"
                    const match = fullId.match(/([a-z0-9_.-]+:[a-z0-9_\/.-]+)/i);
                    const namespacePath = match ? match[1] : fullId;          // e.g. "minecraft:overworld"
                    const pathOnly = namespacePath.includes(':')
                        ? namespacePath.split(':')[1]     // e.g. "overworld"
                        : namespacePath;                  // if somehow no colon present

                    const x_value = Math.floor(target.getX());
                    const y_value = Math.floor(target.getY());
                    const z_value = Math.floor(target.getZ());

                    if (abilityUtil.isUnlocked(player, 'fsang:asgardian2', 'asgardian_true_sight_purchase')) {

                        // Save target name and path-only dimension for properties
                        palladium.setProperty(player, 'asgardian_target', Targetusername);
                        palladium.setProperty(player, 'asgardian_dim', pathOnly);
                        palladium.setProperty(player, 'asgardian_x', x_value);
                        palladium.setProperty(player, 'asgardian_y', y_value);
                        palladium.setProperty(player, 'asgardian_z', z_value);

                        // Tellraw shows full modid:path for clarity
                        server.runCommandSilent(
                            `tellraw ${username} ["",{"text":"Target: ${Targetusername} Dimension: ${namespacePath} Coords: ${x_value}, ${y_value}, ${z_value}","color":"white"}]`
                        );
                    } else {
                        server.runCommandSilent(
                            `tellraw ${username} ["",{"text":"You do not have access to this command","color":"dark_red"}]`
                        );
                    }

                    return 1;
                })
            )
    );

    event.register(
        Commands.literal("fsang.mjolnir")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {
                const player = ctx.source.player;
                const username = player.getGameProfile().getName();
                const server = ctx.source.getServer();

                // Build the SNBT string for display.Name safely.
                // Result example: '{"text":"FSang18\'s Mjolnir"}'
                const snbtName = `'{"text":"${username}\\'s Mjolnir"}'`;

                // Teleport every dropped item with that exact custom name to the player.
                server.runCommandSilent(
                    `execute as @e[type=item,nbt={Item:{tag:{display:{Name:${snbtName}}}}}] at @s run tp @s @p[name=${username}]`
                );

                return 1;
            })
    );
    event.register(
        Commands.literal("fsang.summon_mjolnir")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {
                const player = ctx.source.player;
                const username = player.getGameProfile().getName();
                const server = ctx.source.getServer();

                // Properly escaped JSON text inside an SNBT string.
                const snbtName = `'{"text":"${username}\\'s Mjolnir"}'`;

                // Execute AT the player so ~ ~ ~ is their coords (and dimension).
                server.runCommandSilent(
                    `execute at @p[name=${username}] run summon item ~ ~ ~ {Item:{id:"fsang:mjolnir",Count:1b,tag:{display:{Name:${snbtName}}}}}`
                );

                return 1;
            })
    );
    event.register(
        Commands.literal("FSang.Mimic")
            .then(Commands.argument('action', Arguments.STRING.create(event))
                .suggests((ctx, builder) => {
                    builder.suggest("add")
                    builder.suggest("remove")
                    return builder.buildFuture()
                })
                .requires(src => src.hasPermission(2))
                .executes(ctx => {

                    let player = ctx.source.player;
                    let username = player.getGameProfile().getName();
                    let server = ctx.source.getServer();
                    const action = Arguments.STRING.getResult(ctx, "action")


                    if (action == 'add') {
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Angel`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Electrokinesis`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Luck`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Sonic`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Apocalypse`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Eyes`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Magnetism`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Speed`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Colossus`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Phasing`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Storm`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Face_Change`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Cryokinesis`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Gambit`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Pyrokinesis`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Telepathy`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Cyclops`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Reality_Warping`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Teleportation`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Havok`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Darwin`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Healing`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Sabretooth`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Vulcan`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Detonation`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Invisibility`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Size_Manipulation`);
                        server.runCommandSilent(`execute as ${username} run tag @s add FSang.Mimic.Wolverine`);
                        server.runCommandSilent(`tellraw ${username} ["",{"text":"All Mimicry powers added","color":"dark_green"}]`)
                    }
                    else if (action == 'remove') {
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Angel`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Electrokinesis`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Luck`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Sonic`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Apocalypse`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Eyes`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Magnetism`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Speed`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Colossus`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Phasing`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Storm`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Face_Change`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Cryokinesis`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Gambit`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Pyrokinesis`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Telepathy`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Cyclops`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Reality_Warping`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Teleportation`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Havok`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Darwin`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Healing`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Sabretooth`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Vulcan`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Detonation`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Invisibility`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Size_Manipulation`);
                        server.runCommandSilent(`execute as ${username} run tag @s remove FSang.Mimic.Wolverine`);
                        server.runCommandSilent(`tellraw ${username} ["",{"text":"All Mimicry powers removed","color":"dark_red"}]`)
                    }
                    return 1;
                }))
    );
    event.register(
        Commands.literal("FSang.Hive")
            .then(Commands.argument('entity', Arguments.PLAYER.create(event))
                .then(Commands.argument('action', Arguments.STRING.create(event))
                    .suggests((ctx, builder) => {
                        builder.suggest("transform")
                        builder.suggest("de-transform")
                        return builder.buildFuture()
                    })
                    .requires(src => src.hasPermission(2))
                    .executes(ctx => {

                        let player = ctx.source.player;
                        let username = player.getGameProfile().getName();
                        let server = ctx.source.getServer();
                        let target = Arguments.PLAYER.getResult(ctx, 'entity')
                        const action = Arguments.STRING.getResult(ctx, "action")


                        if (abilityUtil.isUnlocked(player, 'fsang_secondary:symbiote_natural', 'symbiote_creator_check')) {
                            if (action == 'de-transform') {
                                server.runCommandSilent(`execute as ${target.uuid} run effect give @s[tag=FSang.Symbiote.Created] fsang:symbiote_sickness 30 0 false`);
                            }
                            else if (action == 'transform') {
                                server.runCommandSilent(`execute as ${target.uuid} run effect give @s[tag=FSang.Symbiote.Created] fsang:symbiote_enhancement 30 0 false`);
                            }
                        }
                        else {
                            server.runCommandSilent(`tellraw ${username} ["",{"text":"You do not have access to this command","color":"dark_red"}]`)
                        }

                        return 1;
                    })))
    );
    event.register(
        Commands.literal("FSang.Gambit.Tag")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();


                server.runCommandSilent(`tag @s[tag=!FSang.Gambit.Tag] add FSang.Gambit.Tag`);
                server.runCommandSilent(`tag @s[tag=FSang.Gambit.Tag] remove FSang.Gambit.Tag`);

                return 1;
            })
    );
    event.register(
        Commands.literal("FSang.Age")
            .requires(src => src.hasPermission(0))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();


                if (superpowerUtil.hasSuperpower(player, 'fsang:viltrumite')) {
                    server.runCommandSilent(`tellraw ${username} ["You are ",{"color":"red","score":{"objective":"FSang.Age","name":"${username}"}}," Days Old."]`);

                }
                else if (superpowerUtil.hasSuperpower(player, 'fsang:viltrumite_human')) {
                    server.runCommandSilent(`tellraw ${username} ["You are ",{"color":"#0099ff","score":{"objective":"FSang.Age","name":"${username}"}}," Days Old."]`);

                }
                else if (superpowerUtil.hasSuperpower(player, 'fsang:viltrumite_thraxan')) {
                    server.runCommandSilent(`tellraw ${username} ["You are ",{"color":"magenta","score":{"objective":"FSang.Age","name":"${username}"}}," Days Old."]`);

                }
                else if (superpowerUtil.hasSuperpower(player, 'fsang:viltrumite_brute')) {
                    server.runCommandSilent(`tellraw ${username} ["You are ",{"color":"#dddddd","score":{"objective":"FSang.Age","name":"${username}"}}," Days Old."]`);

                }
                else if (superpowerUtil.hasSuperpower(player, 'fsang:viltrumite_scout')) {
                    server.runCommandSilent(`tellraw ${username} ["You are ",{"color":"#dddddd","score":{"objective":"FSang.Age","name":"${username}"}}," Days Old."]`);

                }
                else if (superpowerUtil.hasSuperpower(player, 'fsang:asgardian')) {
                    server.runCommandSilent(`tellraw ${username} ["You are ",{"color":"gold","score":{"objective":"FSang.Age","name":"${username}"}}," Days Old."]`);

                }
                else if (superpowerUtil.hasSuperpower(player, 'fsang:age')) {
                    server.runCommandSilent(`execute if entity FSang18 run tellraw ${username} ["You are ",{"color":"#FFD700","score":{"objective":"FSang.Age","name":"${username}"}}," Days Old."]`);
                    server.runCommandSilent(`execute if entity Bosatron04 run tellraw ${username} ["You are ",{"color":"#25b2e3","score":{"objective":"FSang.Age","name":"${username}"}}," Days Old."]`);

                }
                else {
                    server.runCommandSilent(`tellraw ${username} ["Your power does not have an age system."]`)
                }
                return 1;
            })
    );
    event.register(
        Commands.literal("FSang.Time.Increase")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();
                let TimeScore = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("FSang.Time.Control")).getScore();


                if (superpowerUtil.hasSuperpower(player, 'fsang:time')) {
                    server.runCommandSilent(`execute as ${username} run time add ${TimeScore}`);
                }
                return 1;
            })
    );
    event.register(
        Commands.literal("FSang.gamerule")
            .requires(src => src.hasPermission(2))
            .then(Commands.argument('type', Arguments.STRING.create(event))
                .suggests((ctx, builder) => {
                    builder.suggest("item")
                    builder.suggest("symbiote")
                    return builder.buildFuture()
                })
                .then(Commands.argument('enabled', Arguments.STRING.create(event))
                    .suggests((ctx, builder) => {
                        builder.suggest("true")
                        builder.suggest("false")
                        return builder.buildFuture()
                    })
                    .executes(ctx => {

                        const gameruleType = Arguments.WORD.getResult(ctx, "type")
                        const gameruleEnabled = Arguments.STRING.getResult(ctx, "enabled")

                        let player = ctx.source.player;
                        let username = player.getGameProfile().getName();
                        let server = ctx.source.getServer();


                        if (gameruleEnabled == "true") {
                            server.runCommandSilent(`execute as ${username} run scoreboard objectives add FSang.Gamerule.${gameruleType} dummy`)
                            server.runCommandSilent(`execute as ${username} run scoreboard players set .sang FSang.Gamerule.${gameruleType} 1`)
                            server.runCommandSilent(`execute as @a run tellraw @a ["Gamerule: ${gameruleType} Cooldown: ",{"text":"Enabled","color":"dark_green"}]`)
                        }
                        else if (gameruleEnabled == "false") {
                            server.runCommandSilent(`execute as ${username} run scoreboard objectives add FSang.Gamerule.${gameruleType} dummy`)
                            server.runCommandSilent(`execute as ${username} run scoreboard players set .sang FSang.Gamerule.${gameruleType} 0`)
                            server.runCommandSilent(`execute as @a run tellraw @a ["Gamerule: ${gameruleType} Cooldown: ",{"text":"Disabled","color":"dark_red"}]`)
                        }

                        return 1;
                    })
                )));
    event.register(
        Commands.literal("ftp_coord_group")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();
                let dimension = ctx.source.getLevel().getDimension();
                let x_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepX")).getScore();
                let y_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepY")).getScore();
                let z_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepZ")).getScore();


                server.runCommandSilent(`execute in ${dimension} as ${username} at @s run tp @e[distance=..2,sort=nearest,limit=4] ${x_value} ${y_value} ${z_value}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("FSang.Teleportation.Hotbar2")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();
                let dimension = ctx.source.getLevel().getDimension();
                let x_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepX2")).getScore();
                let y_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepY2")).getScore();
                let z_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepZ2")).getScore();


                server.runCommandSilent(`execute in ${dimension} as ${username} at @s run tp @e[distance=..2,sort=nearest,limit=4] ${x_value} ${y_value} ${z_value}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("FSang.Teleportation.Hotbar3")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();
                let dimension = ctx.source.getLevel().getDimension();
                let x_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepX3")).getScore();
                let y_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepY3")).getScore();
                let z_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("TelepZ3")).getScore();


                server.runCommandSilent(`execute in ${dimension} as ${username} at @s run tp @e[distance=..2,sort=nearest,limit=4] ${x_value} ${y_value} ${z_value}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("ftp_coord_group2")
            .executes(ctx => {
                try {
                    let player = ctx.source.player;
                    if (!player) {
                        console.error("Player context is missing.");
                        return 0;
                    }

                    let username = player.getName().getString();
                    let server = ctx.source.getServer();

                    let x_score = Utils.server.scoreboard.getObjective("TelepX");
                    let y_score = Utils.server.scoreboard.getObjective("TelepY");
                    let z_score = Utils.server.scoreboard.getObjective("TelepZ");

                    let x_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, x_score).getScore();
                    let y_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, y_score).getScore();
                    let z_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, z_score).getScore();

                    if (abilityUtil.isEnabled(player, 'fsang:reality_warping', 'reality_warping_pocket_reality_travel_leave')) {
                        server.runCommandSilent(`execute as ${username} in minecraft:overworld run tp @s ${x_value} ${y_value} ${z_value}`);
                    } else {
                        console.error("Player does not have the required ability.");
                    }

                } catch (error) {
                    console.error("An error occurred while executing the command:", error);
                }

                return 1;
            })
    );
    event.register(
        Commands.literal("ftp_coord_group3")
            .executes(ctx => {
                try {
                    let player = ctx.source.player;
                    if (!player) {
                        console.error("Player context is missing.");
                        return 0;
                    }

                    let username = player.getName().getString();
                    let server = ctx.source.getServer();

                    let x_score = Utils.server.scoreboard.getObjective("TelepX");
                    let y_score = Utils.server.scoreboard.getObjective("TelepY");
                    let z_score = Utils.server.scoreboard.getObjective("TelepZ");

                    let x_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, x_score).getScore();
                    let y_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, y_score).getScore();
                    let z_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, z_score).getScore();


                    server.runCommandSilent(`execute as ${username} in minecraft:overworld run tp @s ${x_value} ${y_value} ${z_value}`);

                } catch (error) {
                    console.error("An error occurred while executing the command:", error);
                }

                return 1;
            })
    );
    event.register(
        Commands.literal("ftp_coord_group4")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();
                let dimension = ctx.source.getLevel().getDimension();
                let x_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("FSang.TelepX")).getScore();
                let y_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("FSang.TelepY")).getScore();
                let z_value = Utils.server.scoreboard.getOrCreatePlayerScore(username, Utils.server.scoreboard.getObjective("FSang.TelepZ")).getScore();


                server.runCommandSilent(`execute in minecraft:overworld as ${username} run tp @s ${x_value} ${y_value} ${z_value}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("fsang_wolf_symbiote")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();


                server.runCommandSilent(`execute as ${username} run summon minecraft:wolf ~ ~1 ~ {Palladium:{Properties:{superpowers:["fsang:symbiosis_lasher"]}},Owner:${username},CollarColor:13,CustomName:'[{"text":"War Dog","color":"dark_green"}]',CustomNameVisible:1b}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("fsang_wolf_ice")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();


                server.runCommandSilent(`execute as ${username} run summon minecraft:wolf ~ ~1 ~ {Palladium:{Properties:{superpowers:["fsang:ice_golem"]}},Owner:${username},CollarColor:13,CustomName:'[{"text":"Pop","color":"blue"}]',CustomNameVisible:1b}`);
                server.runCommandSilent(`execute as ${username} run summon minecraft:wolf ~ ~1 ~ {Palladium:{Properties:{superpowers:["fsang:ice_golem"]}},Owner:${username},CollarColor:13,CustomName:'[{"text":"Sicle","color":"blue"}]',CustomNameVisible:1b}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("fsang_cat_symbiote")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();


                server.runCommandSilent(`execute as ${username} run summon minecraft:cat ~ ~1 ~ {Palladium:{Properties:{superpowers:["fsang:symbiosis_sleeper"]}},Owner:${username},CustomName:'[{"text":"War Cat","color":"green"}]',CustomNameVisible:1b,CollarColor:15}`);

                return 1;
            })
    );
    event.register(
        Commands.literal("fsang_rider_message")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();


                server.runCommandSilent(`title @p actionbar ["",{"text":"Pact signed...","color":"dark_red"}]`);

                return 1;
            })
    );
    event.register(
        Commands.literal("fsang_remove_all")
            .requires(src => src.hasPermission(2))
            .executes(ctx => {

                let player = ctx.source.player;
                let username = player.getGameProfile().getName();
                let server = ctx.source.getServer();

                superpowerUtil.removeSuperpower(player, 'fsang:all');

                return 1;
            })
    );
    event.register(
        Commands.literal("FSTP")
            .then(Commands.argument('x', Arguments.STRING.create(event))
                .then(Commands.argument('y', Arguments.STRING.create(event))
                    .then(Commands.argument('z', Arguments.STRING.create(event))
                        .executes(ctx => {
                            let x = Arguments.STRING.getResult(ctx, "x")
                            let y = Arguments.STRING.getResult(ctx, "y")
                            let z = Arguments.STRING.getResult(ctx, "z")


                            let server = ctx.source.getServer()
                            let player = ctx.source.player
                            let dim = player.getLevel().getDimension()

                            let username = player.getGameProfile().getName();

                            if (abilityUtil.isEnabled(player, 'fsang:teleportation', 'teleportation_teleportation_distance_purchase')) {
                                server.runCommandSilent(`execute as ${username} at @s in ${dim} as @e[distance=..3] run tp @s ${x} ${y} ${z}`)
                                server.runCommandSilent(`execute as ${username} if entity @s[scores={X_Gene=0..45}] at @s run particle dust_color_transition 0.37 0.37 0.37 2 0.03 0.31 0.53 ~ ~1 ~ 0.5 0.5 0.5 0.1 100`)
                                server.runCommandSilent(`execute as ${username} if entity @s[scores={X_Gene=46..90}] at @s run particle dust_color_transition 0.37 0.37 0.37 2 0.8 0.08 0.08 ~ ~1 ~ 0.5 0.5 0.5 1 100`)
                            }


                            return 1
                        })
                    )
                )
            )
    );
});