const fantasticfourWeights = [
    { power: "fsang:human_torch", weight: 10, name: "Pyrogenesis" }
];

function getRandomPower() {
    const totalWeight = fantasticfourWeights.reduce((sum, entry) => sum + entry.weight, 0);
    let rand = Math.random() * totalWeight;
    for (const entry of fantasticfourWeights) {
        rand -= entry.weight;
        if (rand <= 0) return entry;
    }
    return fantasticfourWeights[fantasticfourWeights.length - 1];
}

PlayerEvents.tick(event => {
    const player = event.player;
    let username = player.getGameProfile().getName();

    // Ensure the script runs only server-side
    const isInEnd = player.level.dimension.toString() === "minecraft:the_end";

    if (isInEnd && palladium.abilities.isEnabled(player, `fsang:cosmic_radiation`, `ff_activation`)) {
        const selectedPower = getRandomPower();

        player.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
        superpowerUtil.addSuperpower(player, selectedPower.power);
        player.tell(`You have been granted the Cosmic-Infusion: ${selectedPower.name}`);
    }
});
