const COOLDOWN_TIME = 300; // Cooldown time in seconds
const playerCooldowns = {}; // Object to store player cooldowns
const targetPlayer = ".sang"; // Target player name

function fsang_setRandomTrailProps(player) {
    function randHex6() {
        return Math.floor(Math.random() * 0x1000000).toString(16).padStart(6, '0');
    }
    const h1 = randHex6();
    const h2 = randHex6();
    const c1 = parseInt(h1, 16);
    const c2 = parseInt(h2, 16);
    try {
        palladium.setProperty(player, 'fsang_speed_trail1', c1);
        palladium.setProperty(player, 'fsang_speed_trail2', c2);
    } catch (_) {
        if (typeof propertyUtil !== 'undefined') {
            propertyUtil.set(player, 'fsang_speed_trail1', c1);
            propertyUtil.set(player, 'fsang_speed_trail2', c2);
        }
    }
}

ItemEvents.rightClicked(e => {
    const { hand, player, server, player: { username, mainHandItem, offhandItem } } = e;
    let power_amount = superpowerUtil.getSuperpowers(player).length;
    const itemId = mainHandItem.id;

    const remainingTime = Math.ceil((playerCooldowns[username] - Date.now()) / 1000);
    const minutes = Math.floor(remainingTime / 60);
    const seconds = remainingTime % 60;

    // Get the scoreboard value of the player named '.sang'
    const scoreboardValue = server.runCommandSilent(`scoreboard players get ${targetPlayer} FSang.Gamerule.item`);

    // List of items that will trigger the cooldown
    const cooldownItems = [
        "fsang:dna_purifier", "fsang:kryptonian_dna", "fsang:kryptonian_dna2", "fsang:kryptonian_dna3", "fsang:kryptonian_half_dna", "fsang:kryptonian_half2_dna",
        "fsang:viltrumite_dna", "fsang:viltrumite_dna2", "fsang:viltrumite_dna3", "fsang:viltrumite_dna4", "fsang:viltrumite_dna5",
        "fsang:shazam_dna", "fsang:speedforce_dna", "fsang:speedforce_kingdom_dna", "fsang:speedforce_speed_dna", "fsang:speedforce_strength_dna", "fsang:negative_speedforce_dna", "fsang:speedforce_leech_dna", "fsang:tachyon_dna",
        "fsang:thor_dna", "fsang:asgardian_dna2", "fsang:xgene_dna", "fsang:colossus_dna", "fsang:colossus_dna2", "fsang:cyclops_dna",
        "fsang:self_detonation_dna", "fsang:storm_dna", "fsang:wolverine_x23_dna", "fsang:wolverine_daken_dna",
        "fsang:pyrokinesis_dna", "fsang:electrokinesis_dna", "fsang:cryokinesis_dna", "fsang:havok_dna", "fsang:forgetmenot_dna", "fsang:martian_green_dna",
        "fsang:wolverine_dna", "fsang:teleportation_dna", "fsang:teleportation_dna2", "fsang:spirit_of_vengence_dna", "fsang:spirit_of_vengence_medallion",
        "fsang:silver_surfer_dna", "fsang:galactic_board", "fsang:angel_dna", "fsang:archangel_dna",
        "fsang:hellfire_pact", "fsang:spawn_dna", "fsang:human_torch_dna", "fsang:spiderman_dna",
        "fsang:hulk_dna", "fsang:gamma_syringe", "fsang:apocalypse_dna", "fsang:super_soldier_dna", "fsang:super_soldier_dna2", "fsang:super_soldier_dna3",
        "fsang:amazon_dna", "fsang:amazon_artifact", "fsang:regenerative_healing_dna", "fsang:lobo_dna",
        "fsang:magnetism_dna", "fsang:darwin_dna", "fsang:mimicry_dna", "fsang:sentry_dna", "fsang:daredevil_dna", "fsang:leech_dna", "fsang:boogie_woogie_dna", "fsang:geokinesis_dna",
        "fsang:atlantean_dna", "fsang:atlantean_dna2", "fsang:atlantean_artifact", "fsang:spiderman_miles_dna", "fsang:spiderman_kaine_dna",
        "fsang:spiderman_miguel_dna", "fsang:spiderman_jessica_dna", "fsang:spiderman_silk_dna", "fsang:reality_warping_dna", "fsang:matter_absorption_dna",
        "fsang:phasing_dna", "fsang:invisibility_dna", "fsang:eye_mutation_dna", "fsang:luck_mutation_dna", "fsang:sandman_dna", "fsang:anti_matter_dna", "fsang:kree_dna",
        "fsang:face_change_dna", "fsang:kaiju_dna", "fsang:gambit_dna", "fsang:telepathy_dna", "fsang:radiant_black_dna", "fsang:speed_mutation_dna",
        "fsang:size_change_dna", "fsang:vulcan_dna", "fsang:sound_mutation_dna", "fsang:sabretooth_dna", "fsang:telekinesis_dna", "fsang:time_dna", "fsang:phoenix_dna", "fsang:phoenix_dna2", "fsang:homelander_dna"
    ];

    let mutantPowers = [
        'fsang:cyclops',
        'fsang:colossus',
        'fsang:colossus2',
        'fsang:self_detonation',
        'fsang:storm',
        'fsang:wolverine',
        'fsang:wolverine2',
        'fsang:wolverine3',
        'fsang:pyrokinesis',
        'fsang:electrokinesis',
        'fsang:cryokinesis',
        'fsang:havok',
        'fsang:teleportation',
        'fsang:angel',
        'fsang:apocalypse',
        'fsang:regenerative_healing',
        'fsang:magnetism',
        'fsang:darwin',
        'fsang:mimicry',
        'fsang:reality_warping',
        'fsang:phasing',
        'fsang:invisibility',
        'fsang:eye_mutation',
        'fsang:luck_mutation',
        'fsang:face_change',
        'fsang:gambit',
        'fsang:telepathy',
        'fsang:speed_mutation',
        'fsang:size_change',
        'fsang:vulcan',
        'fsang:sound_mutation',
        'fsang:sabretooth',
        'fsang:telekinesis',
        'fsang:time',
        'fsang:leech_mutation'
    ];

    // Check if the item is in the cooldown list
    if (cooldownItems.includes(itemId)) {
        // Check if the player is already on cooldown
        if (playerCooldowns[username] && playerCooldowns[username] > Date.now()) {
            if (scoreboardValue === 0) {
                // If scoreboard is 0, reset the cooldown to 0
                playerCooldowns[username] = 0;
                server.runCommandSilent(`title ${username} actionbar {"text":"Cooldown removed due to gamerule change","color":"green"}`);
            } else {
                // Display remaining cooldown time
                server.runCommandSilent(`title ${username} actionbar {"text":"Cooldown: ${minutes}m ${seconds}s","color":"red"}`);
                return; // Prevent item usage while on cooldown
            }
        } else {
            // Set the cooldown based on the scoreboard value
            if (scoreboardValue === 1) {
                playerCooldowns[username] = Date.now() + COOLDOWN_TIME * 1000; // Set 300 seconds cooldown
            } else if (scoreboardValue === 0) {
                playerCooldowns[username] = 0; // No cooldown
            }
        }
    }

    //allows the player to remove powers or gain human DNA if they do not have any powers at all
    if (power_amount >= 0) {
        let hasMutantPower = mutantPowers.some(power => superpowerUtil.hasSuperpower(player, power));

        if (player.isCrouching() && mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air") {
            let playerName = player.name.string;
            player.setItemInHand(hand, Item.of('fsang:human_dna', { display: { Name: `{"text":"${playerName}'s Human DNA"}` } }));
        }
        else if (player.isCrouching() && mainHandItem.id == "fsang:human_dna" && offhandItem.id == "minecraft:air") {
            player.setItemInHand(hand, Item.of("fsang:empty_vial"));
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:matter_absorption')) {
            player.setItemInHand(hand, "fsang:matter_absorption_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:matter_absorption');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:kryptonian')) {
            player.setItemInHand(hand, "fsang:kryptonian_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:kryptonian');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:kryptonian_cw')) {
            player.setItemInHand(hand, "fsang:kryptonian_dna2")
            superpowerUtil.removeSuperpower(e.player, 'fsang:kryptonian_cw');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:kryptonian_dceu')) {
            player.setItemInHand(hand, "fsang:kryptonian_dna3")
            superpowerUtil.removeSuperpower(e.player, 'fsang:kryptonian_dceu');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:kryptonian_half')) {
            player.setItemInHand(hand, "fsang:kryptonian_half_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:kryptonian_half');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:kryptonian_half_yj')) {
            player.setItemInHand(hand, "fsang:kryptonian_half2_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:kryptonian_half_yj');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:viltrumite')) {
            player.setItemInHand(hand, "fsang:viltrumite_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:viltrumite');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:viltrumite_human')) {
            player.setItemInHand(hand, "fsang:viltrumite_dna2")
            superpowerUtil.removeSuperpower(e.player, 'fsang:viltrumite_human');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:viltrumite_thraxan')) {
            player.setItemInHand(hand, "fsang:viltrumite_dna3")
            superpowerUtil.removeSuperpower(e.player, 'fsang:viltrumite_thraxan');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:viltrumite_brute')) {
            player.setItemInHand(hand, "fsang:viltrumite_dna4")
            superpowerUtil.removeSuperpower(e.player, 'fsang:viltrumite_brute');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:viltrumite_scout')) {
            player.setItemInHand(hand, "fsang:viltrumite_dna5")
            superpowerUtil.removeSuperpower(e.player, 'fsang:viltrumite_scout');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:leech_mutation')) {
            player.setItemInHand(hand, "fsang:leech_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:leech_mutation');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:boogie_woogie')) {
            player.setItemInHand(hand, "fsang:boogie_woogie_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:boogie_woogie');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:geokinesis')) {
            player.setItemInHand(hand, "fsang:geokinesis_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:geokinesis');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:shazam')) {
            player.setItemInHand(hand, "fsang:shazam_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:shazam');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:speedforce')) {
            player.setItemInHand(hand, "fsang:speedforce_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:speedforce');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:speedforce_god')) {
            player.setItemInHand(hand, "fsang:speedforce_kingdom_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:speedforce_god');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:speedforce_speed')) {
            player.setItemInHand(hand, "fsang:speedforce_speed_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:speedforce_speed');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:speedforce_strength')) {
            player.setItemInHand(hand, "fsang:speedforce_strength_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:speedforce_strength');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:speedforce_negative')) {
            player.setItemInHand(hand, "fsang:negative_speedforce_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:speedforce_negative');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:speedforce_leech')) {
            player.setItemInHand(hand, "fsang:speedforce_leech_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:speedforce_leech');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:speedforce_tachyon')) {
            player.setItemInHand(hand, "fsang:tachyon_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:speedforce_tachyon');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:asgardian')) {
            player.setItemInHand(hand, "fsang:thor_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:asgardian');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:asgardian2')) {
            player.setItemInHand(hand, "fsang:asgardian_dna2")
            superpowerUtil.removeSuperpower(e.player, 'fsang:asgardian2');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:xgene')) {
            player.setItemInHand(hand, "fsang:xgene_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:xgene');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:colossus')) {
            player.setItemInHand(hand, "fsang:colossus_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:colossus');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:colossus2') & !superpowerUtil.hasSuperpower(e.player, 'fsang:telepathy')) {
            player.setItemInHand(hand, "fsang:colossus_dna2")
            superpowerUtil.removeSuperpower(e.player, 'fsang:colossus2');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:cyclops')) {
            player.setItemInHand(hand, "fsang:cyclops_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:cyclops');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:self_detonation')) {
            player.setItemInHand(hand, "fsang:self_detonation_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:self_detonation');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:storm')) {
            player.setItemInHand(hand, "fsang:storm_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:storm');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:pyrokinesis')) {
            player.setItemInHand(hand, "fsang:pyrokinesis_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:pyrokinesis');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:electrokinesis')) {
            player.setItemInHand(hand, "fsang:electrokinesis_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:electrokinesis');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:cryokinesis')) {
            player.setItemInHand(hand, "fsang:cryokinesis_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:cryokinesis');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:havok')) {
            player.setItemInHand(hand, "fsang:havok_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:havok');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:martian_green')) {
            player.setItemInHand(hand, "fsang:martian_green_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:martian_green');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:forgetmenot')) {
            player.setItemInHand(hand, "fsang:forgetmenot_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:forgetmenot');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:wolverine')) {
            player.setItemInHand(hand, "fsang:wolverine_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:wolverine');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:wolverine2')) {
            player.setItemInHand(hand, "fsang:wolverine_x23_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:wolverine2');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:wolverine3')) {
            player.setItemInHand(hand, "fsang:wolverine_daken_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:wolverine3');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:teleportation')) {
            server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={X_Gene=0..45}] weapon.mainhand with fsang:teleportation_dna 1`);
            server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={X_Gene=46..90}] weapon.mainhand with fsang:teleportation_dna2 1`);
            superpowerUtil.removeSuperpower(e.player, 'fsang:teleportation');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:spirit_of_vengence')) {
            player.setItemInHand(hand, "fsang:spirit_of_vengence_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:spirit_of_vengence');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang_secondary:cosmic')) {
            player.setItemInHand(hand, "fsang:silver_surfer_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang_secondary:cosmic');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:angel')) {
            player.setItemInHand(hand, "fsang:angel_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:angel');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:archangel')) {
            player.setItemInHand(hand, "fsang:archangel_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:archangel');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:spawn')) {
            player.setItemInHand(hand, "fsang:spawn_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:spawn');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:human_torch')) {
            player.setItemInHand(hand, "fsang:human_torch_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:human_torch');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:spiderman')) {
            player.setItemInHand(hand, "fsang:spiderman_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:spiderman');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:hulk')) {
            player.setItemInHand(hand, "fsang:hulk_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:hulk');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:apocalypse')) {
            player.setItemInHand(hand, "fsang:apocalypse_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:apocalypse');
        }
        else if (mainHandItem.id == "fsang:apocalypse_potion" && offhandItem.id == "minecraft:air") {
            player.setItemInHand(hand, Item.of("minecraft:air"));
            server.runCommandSilent(`execute as ${username} run effect give @s fsang:xgene_manipulation 60 1 true`);
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:super_soldier')) {
            player.setItemInHand(hand, "fsang:super_soldier_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:super_soldier');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:super_soldier_winter_soldier')) {
            player.setItemInHand(hand, "fsang:super_soldier_dna2")
            superpowerUtil.removeSuperpower(e.player, 'fsang:super_soldier_winter_soldier');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:super_soldier_red_skull')) {
            player.setItemInHand(hand, "fsang:super_soldier_dna3")
            superpowerUtil.removeSuperpower(e.player, 'fsang:super_soldier_red_skull');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:amazon')) {
            player.setItemInHand(hand, "fsang:amazon_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:amazon');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:lobo')) {
            player.setItemInHand(hand, "fsang:lobo_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:lobo');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:regenerative_healing')) {
            player.setItemInHand(hand, "fsang:regenerative_healing_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:regenerative_healing');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:magnetism')) {
            player.setItemInHand(hand, "fsang:magnetism_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:magnetism');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:darwin')) {
            player.setItemInHand(hand, "fsang:darwin_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:darwin');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:daredevil')) {
            player.setItemInHand(hand, "fsang:daredevil_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:daredevil');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:mimicry')) {
            player.setItemInHand(hand, "fsang:mimicry_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:mimicry');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:sentry')) {
            player.setItemInHand(hand, "fsang:sentry_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:sentry');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:atlantean')) {
            player.setItemInHand(hand, "fsang:atlantean_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:atlantean');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:atlantean_sea_changed')) {
            player.setItemInHand(hand, "fsang:atlantean_dna2")
            superpowerUtil.removeSuperpower(e.player, 'fsang:atlantean_sea_changed');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:spiderman_miles')) {
            player.setItemInHand(hand, "fsang:spiderman_miles_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:spiderman_miles');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:spiderman_kaine')) {
            player.setItemInHand(hand, "fsang:spiderman_kaine_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:spiderman_kaine');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:spiderman_miguel')) {
            player.setItemInHand(hand, "fsang:spiderman_miguel_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:spiderman_miguel');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:spiderman_jessica')) {
            player.setItemInHand(hand, "fsang:spiderman_jessica_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:spiderman_jessica');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:spiderman_silk')) {
            player.setItemInHand(hand, "fsang:spiderman_silk_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:spiderman_silk');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:reality_warping')) {
            player.setItemInHand(hand, "fsang:reality_warping_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:reality_warping');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:phasing')) {
            player.setItemInHand(hand, "fsang:phasing_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:phasing');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:invisibility')) {
            player.setItemInHand(hand, "fsang:invisibility_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:invisibility');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:eye_mutation')) {
            player.setItemInHand(hand, "fsang:eye_mutation_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:eye_mutation');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:luck_mutation')) {
            player.setItemInHand(hand, "fsang:luck_mutation_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:luck_mutation');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:sandman')) {
            player.setItemInHand(hand, "fsang:sandman_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:sandman');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:anti_matter')) {
            player.setItemInHand(hand, "fsang:anti_matter_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:anti_matter');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:face_change')) {
            player.setItemInHand(hand, "fsang:face_change_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:face_change');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:gambit')) {
            player.setItemInHand(hand, "fsang:gambit_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:gambit');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:telepathy') & !superpowerUtil.hasSuperpower(e.player, 'fsang:telekinesis') & !superpowerUtil.hasSuperpower(e.player, 'fsang:colossus2')) {
            player.setItemInHand(hand, "fsang:telepathy_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:telepathy');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang_secondary:kaiju_no_8')) {
            player.setItemInHand(hand, "fsang:kaiju_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang_secondary:kaiju_no_8');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:radiant_black')) {
            player.setItemInHand(hand, "fsang:radiant_black_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:radiant_black');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:speed_mutation')) {
            player.setItemInHand(hand, "fsang:speed_mutation_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:speed_mutation');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:size_change')) {
            player.setItemInHand(hand, "fsang:size_change_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:size_change');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:vulcan')) {
            player.setItemInHand(hand, "fsang:vulcan_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:vulcan');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:sound_mutation')) {
            player.setItemInHand(hand, "fsang:sound_mutation_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:sound_mutation');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:sabretooth')) {
            player.setItemInHand(hand, "fsang:sabretooth_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:sabretooth');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:homelander')) {
            player.setItemInHand(hand, "fsang:homelander_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:homelander');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:telekinesis') & !superpowerUtil.hasSuperpower(e.player, 'fsang:telepathy')) {
            player.setItemInHand(hand, "fsang:telekinesis_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:telekinesis');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:time')) {
            player.setItemInHand(hand, "fsang:time_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:time');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:kree_hybrid')) {
            player.setItemInHand(hand, "fsang:kree_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:kree_hybrid');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:telekinesis') && superpowerUtil.hasSuperpower(e.player, 'fsang:telepathy')) {
            player.setItemInHand(hand, "fsang:telep_telekin_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:telekinesis');
            superpowerUtil.removeSuperpower(e.player, 'fsang:telepathy');
        }
        else if (mainHandItem.id == "fsang:empty_vial" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang:colossus2') && superpowerUtil.hasSuperpower(e.player, 'fsang:telepathy')) {
            player.setItemInHand(hand, "fsang:telep_col_dna")
            superpowerUtil.removeSuperpower(e.player, 'fsang:colossus2');
            superpowerUtil.removeSuperpower(e.player, 'fsang:telepathy');
        }
        else if (mainHandItem.id == "fsang:phoenix_dna" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang_secondary:phoenix_force')) {
            player.setItemInHand(hand, "fsang:phoenix_dna2")
            superpowerUtil.removeSuperpower(e.player, 'fsang_secondary:phoenix_force');
        }
        //added support for fsang item that erases all powers you may have
        else if (mainHandItem.id == "fsang:dna_purifier") {
            player.setItemInHand(hand, "minecraft:air")
            superpowerUtil.removeAllSuperpowers(e.player);
        }
        else if (mainHandItem.id == "fsang:matter_absorption_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            superpowerUtil.addSuperpower(e.player, 'fsang:matter_absorption');
        }
        else if (mainHandItem.id == "fsang:kryptonian_half_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Kryptonian.Solar 0`);
            superpowerUtil.addSuperpower(e.player, 'fsang:kryptonian_half');
        }
        else if (mainHandItem.id == "fsang:kryptonian_half2_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Kryptonian.Solar 0`);
            superpowerUtil.addSuperpower(e.player, 'fsang:kryptonian_half_yj');
        }
        else if (mainHandItem.id == "fsang:kryptonian_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Kryptonian.Solar 0`);
            superpowerUtil.addSuperpower(e.player, 'fsang:kryptonian');
        }
        else if (mainHandItem.id == "fsang:kryptonian_dna2") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Kryptonian.Solar 0`);
            superpowerUtil.addSuperpower(e.player, 'fsang:kryptonian_cw');
        }
        else if (mainHandItem.id == "fsang:kryptonian_dna3") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Kryptonian.Solar 0`);
            superpowerUtil.addSuperpower(e.player, 'fsang:kryptonian_dceu');
        }
        else if (mainHandItem.id == "fsang:viltrumite_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age 0`);

            superpowerUtil.addSuperpower(e.player, 'fsang:viltrumite');
        }
        else if (mainHandItem.id == "fsang:viltrumite_dna2") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age 0`);

            superpowerUtil.addSuperpower(e.player, 'fsang:viltrumite_human');
        }
        else if (mainHandItem.id == "fsang:viltrumite_dna3") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age 0`);

            superpowerUtil.addSuperpower(e.player, 'fsang:viltrumite_thraxan');
        }
        else if (mainHandItem.id == "fsang:viltrumite_dna4") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age 0`);

            superpowerUtil.addSuperpower(e.player, 'fsang:viltrumite_brute');
        }
        else if (mainHandItem.id == "fsang:viltrumite_dna5") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age 0`);

            superpowerUtil.addSuperpower(e.player, 'fsang:viltrumite_scout');
        }
        else if (mainHandItem.id == "fsang:leech_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:leech_mutation');
        }
        else if (mainHandItem.id == "fsang:boogie_woogie_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:boogie_woogie');
        }
        else if (mainHandItem.id == "fsang:geokinesis_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:geokinesis');
        }
        else if (mainHandItem.id == "fsang:shazam_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:shazam');
        }
        else if (mainHandItem.id == "fsang:speedforce_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            fsang_setRandomTrailProps(e.player);
            superpowerUtil.addSuperpower(e.player, 'fsang:speedforce');
        }
        else if (mainHandItem.id == "fsang:speedforce_kingdom_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            fsang_setRandomTrailProps(e.player);
            superpowerUtil.addSuperpower(e.player, 'fsang:speedforce_god');
        }
        else if (mainHandItem.id == "fsang:speedforce_strength_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            fsang_setRandomTrailProps(e.player);
            superpowerUtil.addSuperpower(e.player, 'fsang:speedforce_strength');
        }
        else if (mainHandItem.id == "fsang:speedforce_speed_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            fsang_setRandomTrailProps(e.player);
            superpowerUtil.addSuperpower(e.player, 'fsang:speedforce_speed');
        }
        else if (mainHandItem.id == "fsang:negative_speedforce_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            fsang_setRandomTrailProps(e.player);
            superpowerUtil.addSuperpower(e.player, 'fsang:speedforce_negative');
        }
        else if (mainHandItem.id == "fsang:speedforce_leech_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            fsang_setRandomTrailProps(e.player);
            superpowerUtil.addSuperpower(e.player, 'fsang:speedforce_leech');
        }
        else if (mainHandItem.id == "fsang:tachyon_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            fsang_setRandomTrailProps(e.player);
            superpowerUtil.addSuperpower(e.player, 'fsang:speedforce_tachyon');
        }
        else if (mainHandItem.id == "fsang:thor_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age 0`);
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:asgardian');
        }
        else if (mainHandItem.id == "fsang:asgardian_dna2") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age 0`);
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:asgardian2');
        }
        else if (mainHandItem.id == "fsang:xgene_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:xgene');
        }
        else if (mainHandItem.id == "fsang:colossus_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:colossus');
        }
        else if (mainHandItem.id == "fsang:colossus_dna2") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:colossus2');
        }
        else if (mainHandItem.id == "fsang:cyclops_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`give @s[nbt=!{Inventory:[{id:\"fsang:cyclops_glasses\"}]}] fsang:cyclops_glasses`)

            superpowerUtil.addSuperpower(e.player, 'fsang:cyclops');
        }
        else if (mainHandItem.id == "fsang:self_detonation_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:self_detonation');
        }
        else if (mainHandItem.id == "fsang:storm_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:storm');
        }
        else if (mainHandItem.id == "fsang:wolverine_x23_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:wolverine2');
        }
        else if (mainHandItem.id == "fsang:wolverine_daken_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:wolverine3');
        }
        else if (mainHandItem.id == "fsang:pyrokinesis_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:pyrokinesis');
        }
        else if (mainHandItem.id == "fsang:electrokinesis_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:electrokinesis');
        }
        else if (mainHandItem.id == "fsang:cryokinesis_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:cryokinesis');
        }
        else if (mainHandItem.id == "fsang:havok_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:havok');
        }
        else if (mainHandItem.id == "fsang:martian_green_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:martian_green');
        }
        else if (mainHandItem.id == "fsang:forgetmenot_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:forgetmenot');
        }
        else if (mainHandItem.id == "fsang:wolverine_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:wolverine');
        }
        else if (mainHandItem.id == "fsang:teleportation_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`scoreboard objectives add X_Gene dummy`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s X_Gene 1`);

            superpowerUtil.addSuperpower(e.player, 'fsang:teleportation');
        }
        else if (mainHandItem.id == "fsang:teleportation_dna2") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`scoreboard objectives add X_Gene dummy`);
            server.runCommandSilent(`execute as ${username} run scoreboard players set @s X_Gene 80`);

            superpowerUtil.addSuperpower(e.player, 'fsang:teleportation');
        }
        else if (mainHandItem.id == "fsang:spirit_of_vengence_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spirit_of_vengence');
        }
        else if (mainHandItem.id == "fsang:spirit_of_vengence_medallion") {
            player.setItemInHand(hand, "minecraft:air")

            server.runCommandSilent(`title @p actionbar ["",{"text":"Pact signed...","color":"dark_red"}]`);
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            superpowerUtil.addSuperpower(e.player, 'fsang:spirit_of_vengence');
        }
        else if (mainHandItem.id == "fsang:silver_surfer_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang_secondary:cosmic');
        }
        else if (mainHandItem.id == "fsang:galactic_board") {
            player.setItemInHand(hand, "minecraft:air")

            superpowerUtil.addSuperpower(e.player, 'fsang_secondary:cosmic');
        }
        else if (mainHandItem.id == "fsang:angel_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:angel');
        }
        else if (mainHandItem.id == "fsang:hellfire_pact") {
            player.setItemInHand(hand, "minecraft:air")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spawn');
        }
        else if (mainHandItem.id == "fsang:spawn_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spawn');
        }
        else if (mainHandItem.id == "fsang:human_torch_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:human_torch');
        }
        else if (mainHandItem.id == "fsang:spiderman_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spiderman');
        }
        else if (mainHandItem.id == "fsang:hulk_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:hulk');
        }
        else if (mainHandItem.id == "fsang:gamma_syringe") {
            player.setItemInHand(hand, "minecraft:air")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            server.runCommandSilent(`execute as ${username} run effect give @s fsang:gamma_radiation 30 1`);

        }
        else if (mainHandItem.id == "fsang:particle_dna") {
            player.setItemInHand(hand, "minecraft:air")

            player.runCommandSilent(`execute as ${username} run effect give @p[distance=..10,limit=4,sort=nearest] fsang:cosmic_radiation 60 0 true`);

        }
        else if (mainHandItem.id == "fsang:apocalypse_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:apocalypse');
        }
        else if (mainHandItem.id == "fsang:super_soldier_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:super_soldier');
        }
        else if (mainHandItem.id == "fsang:super_soldier_dna2") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:super_soldier_winter_soldier');
        }
        else if (mainHandItem.id == "fsang:super_soldier_dna3") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:super_soldier_red_skull');
        }
        else if (mainHandItem.id == "fsang:amazon_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:amazon');
        }
        else if (mainHandItem.id == "fsang:amazon_artifact") {
            player.setItemInHand(hand, "minecraft:air")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:amazon');
        }
        else if (mainHandItem.id == "fsang:lobo_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:lobo');
        }
        else if (mainHandItem.id == "fsang:regenerative_healing_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:regenerative_healing');
        }
        else if (mainHandItem.id == "fsang:magnetism_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:magnetism');
        }
        else if (mainHandItem.id == "fsang:darwin_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:darwin');
        }
        else if (mainHandItem.id == "fsang:daredevil_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:daredevil');
        }
        else if (mainHandItem.id == "fsang:mimicry_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:mimicry');
        }
        else if (mainHandItem.id == "fsang:sentry_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:sentry');
        }
        else if (mainHandItem.id == "fsang:atlantean_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:atlantean');
        }
        else if (mainHandItem.id == "fsang:atlantean_dna2") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:atlantean_sea_changed');
        }
        else if (mainHandItem.id == "fsang:spiderman_miles_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spiderman_miles');
        }
        else if (mainHandItem.id == "fsang:spiderman_kaine_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spiderman_kaine');
        }
        else if (mainHandItem.id == "fsang:spiderman_miguel_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spiderman_miguel');
        }
        else if (mainHandItem.id == "fsang:spiderman_jessica_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spiderman_jessica');
        }
        else if (mainHandItem.id == "fsang:spiderman_silk_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:spiderman_silk');
        }
        else if (mainHandItem.id == "fsang:reality_warping_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:reality_warping');
        }
        else if (mainHandItem.id == "fsang:phasing_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:phasing');
        }
        else if (mainHandItem.id == "fsang:invisibility_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:invisibility');
        }
        else if (mainHandItem.id == "fsang:eye_mutation_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:eye_mutation');
        }
        else if (mainHandItem.id == "fsang:luck_mutation_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:luck_mutation');
        }
        else if (mainHandItem.id == "fsang:sandman_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:sandman');
        }
        else if (mainHandItem.id == "fsang:anti_matter_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:anti_matter');
        }
        else if (mainHandItem.id == "fsang:face_change_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:face_change');
        }
        else if (mainHandItem.id == "fsang:gambit_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:gambit');
        }
        else if (mainHandItem.id == "fsang:telepathy_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

            superpowerUtil.addSuperpower(e.player, 'fsang:telepathy');
        }
        else if (mainHandItem.id == "fsang:kaiju_dna") {
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang_secondary:kaiju_no_8');
        }
        else if (mainHandItem.id == "fsang:radiant_black_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:radiant_black');
        }
        else if (mainHandItem.id == "fsang:speed_mutation_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:speed_mutation');
        }
        else if (mainHandItem.id == "fsang:size_change_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:size_change');
        }
        else if (mainHandItem.id == "fsang:vulcan_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:vulcan');
        }
        else if (mainHandItem.id == "fsang:sound_mutation_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:sound_mutation');
        }
        else if (mainHandItem.id == "fsang:speedster_chemicals") {
            server.runCommandSilent(`execute as ${username} run effect give @s fsang:speedforce_chemicals 30 1 true`);
            player.setItemInHand(hand, "minecraft:air")
        }
        else if (mainHandItem.id == "fsang:sabretooth_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:sabretooth');
        }
        else if (mainHandItem.id == "fsang:homelander_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:homelander');
        }
        else if (mainHandItem.id == "fsang:telekinesis_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:telekinesis');
        }
        else if (mainHandItem.id == "fsang:time_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:time');
        }
        else if (mainHandItem.id == "fsang:kree_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:kree_hybrid');
        }
        else if (mainHandItem.id == "fsang:telep_telekin_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:telekinesis');
            superpowerUtil.addSuperpower(e.player, 'fsang:telepathy');
        }
        else if (mainHandItem.id == "fsang:telep_col_dna") {
            server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);
            player.setItemInHand(hand, "fsang:empty_vial")

            superpowerUtil.addSuperpower(e.player, 'fsang:colossus2');
            superpowerUtil.addSuperpower(e.player, 'fsang:telepathy');
        }
        else if (mainHandItem.id == "fsang:phoenix_dna2") {
            player.setItemInHand(hand, "fsang:phoenix_dna")
            superpowerUtil.addSuperpower(e.player, 'fsang_secondary:phoenix_force');
        }
    }
}
);