// kubejs/server_scripts/karma_on_kill.js

ServerEvents.loaded(e => {
    e.server.runCommandSilent('scoreboard objectives add FSang.Karma dummy');
});

// === Configure here ===
const KARMA_VALUES = {
    // Penalties
    player: -50,
    passiveDefault: -1,

    // Optional: give a small reward to ANY listed hostile not explicitly mapped below.
    // Set to 0 if you only want the ones listed in hostileByType to score.
    hostileDefault: 1,

    // Exact IDs with specific values (overrides any default)
    byType: {
        'minecraft:villager': -50,
        'minecraft:iron_golem': -50,
        'minecraft:wandering_trader': -50,
        'minecraft:player': -100
    },

    // Passive bucket (all get passiveDefault unless overridden in byType)
    passiveList: [
        'minecraft:cow', 'minecraft:sheep', 'minecraft:pig', 'minecraft:chicken', 'minecraft:mooshroom',
        'minecraft:rabbit', 'minecraft:horse', 'minecraft:donkey', 'minecraft:mule', 'minecraft:llama', 'minecraft:camel',
        'minecraft:cat', 'minecraft:fox', 'minecraft:parrot', 'minecraft:turtle', 'minecraft:frog', 'minecraft:goat',
        'minecraft:axolotl', 'minecraft:sniffer', 'minecraft:bat', 'minecraft:squid', 'minecraft:glow_squid',
        'minecraft:cod', 'minecraft:salmon', 'minecraft:tropical_fish',
        'minecraft:bee', 'minecraft:dolphin', 'minecraft:wolf'
    ],
    hostileByType: {
        // Basic undead/overworld
        'minecraft:zombie': 1,
        'minecraft:husk': 1,
        'minecraft:drowned': 1,
        'minecraft:skeleton': 1,
        'minecraft:stray': 1,
        'minecraft:spider': 1,
        'minecraft:cave_spider': 1,
        'minecraft:slime': 1,
        'minecraft:endermite': 1,
        'minecraft:silverfish': 1,

        // Threatening commons
        'minecraft:creeper': 2,
        'minecraft:enderman': 2,
        'minecraft:phantom': 2,
        'minecraft:pillager': 2,
        'minecraft:witch': 3,
        'minecraft:guardian': 3,
        'minecraft:blaze': 3,
        'minecraft:wither_skeleton': 4,
        'minecraft:ghast': 4,
        'minecraft:shulker': 4,
        'minecraft:vex': 3,
        'minecraft:ravager': 8,

        // Illager elites
        'minecraft:vindicator': 3,
        'minecraft:evoker': 6,

        // Nether
        'minecraft:magma_cube': 2,
        'minecraft:piglin': 1,
        'minecraft:hoglin': 2,
        'minecraft:zoglin': 3,
        'minecraft:zombified_piglin': 1,
        'minecraft:piglin_brute': 6,

        // Ocean/bossy
        'minecraft:elder_guardian': 8,

        // End/true bosses
        'minecraft:warden': 10,
        'minecraft:wither': 20,
        'minecraft:ender_dragon': 100
    }
};

EntityEvents.death(event => {
    const killer = event.source.getActual();
    const target = event.entity;

    if (!killer || !killer.isPlayer()) return;

    let change = 0;

    // Normalize ID like "minecraft:zombie"
    let id = target.type;
    if (typeof id !== 'string') id = String(id);

    if (target.isPlayer()) {
        change = KARMA_VALUES.player;
    } else if (id in KARMA_VALUES.byType) {
        change = KARMA_VALUES.byType[id];
    } else if (KARMA_VALUES.passiveList.includes(id)) {
        change = KARMA_VALUES.passiveDefault;
    } else if (id in KARMA_VALUES.hostileByType) {
        change = KARMA_VALUES.hostileByType[id];
    } else {
        // Fallback: treat unlisted hostiles (if any slip through) as this default.
        // Set hostileDefault to 0 to disable fallback.
        change = KARMA_VALUES.hostileDefault;
    }

    if (change !== 0) {
        palladium.scoreboard.addScore(killer, 'FSang.Karma', change);
    }
});
