const metasWeights = [
    { power: "fsang:geokinesis", weight: 4, name: "Geokinesis" }
];

function getRandomMetaPower() {
    const totalWeight = metasWeights.reduce((acc, mutation) => acc + mutation.weight, 0);
    let random = Math.random() * totalWeight;

    for (const mutation of metasWeights) {
        if (random < mutation.weight) {
            return mutation;
        }
        random -= mutation.weight;
    }
}
function getRandomScore(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

ItemEvents.rightClicked(event => {
    const { hand, player, server, player: { username, mainHandItem, offhandItem } } = event;

    if (mainHandItem.id == "fsang:dark_matter") {
        const selectedPower3 = getRandomMetaPower(metasWeights.power);
        player.setItemInHand(hand, "minecraft:air")

        server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

        superpowerUtil.addSuperpower(player, selectedPower3.power);
        player.tell(`You have been granted the Meta-Human Variant: ${selectedPower3.name}`);
    }
});
