// kubejs/server_scripts/fsang/save_coords_dynamic.js

// How often to write coordinates (in ticks). 20 = once per second.
const UPDATE_INTERVAL_TICKS = 20;

ServerEvents.loaded(e => {
    // Ensure objectives exist (silent if they already do)
    const s = e.server;
    ['FSang.X', 'FSang.Y', 'FSang.Z'].forEach(obj =>
        s.runCommandSilent(`scoreboard objectives add ${obj} dummy`)
    );
});

// Update all online players on a cadence
ServerEvents.tick(e => {
    const s = e.server;
    if (s.getTickCount() % UPDATE_INTERVAL_TICKS !== 0) return;

    // Iterate online players and set scores using Palladium API
    for (const p of s.players) {
        const x = Math.floor(p.getX());
        const y = Math.floor(p.getY());
        const z = Math.floor(p.getZ());

        palladium.scoreboard.setScore(p, 'FSang.X', x);
        palladium.scoreboard.setScore(p, 'FSang.Y', y);
        palladium.scoreboard.setScore(p, 'FSang.Z', z);
    }
});
