ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event;

    event.register(
        Commands.literal("FSang.ChangeFace")
            .requires(src => src.hasPermission(0))
            .then(Commands.argument("username", Arguments.STRING.create(event)) // Argument for entering the username
                .executes(ctx => {
                    let targetUsername = Arguments.STRING.getResult(ctx, "username");
                    let player = ctx.source.player;
                    let server = ctx.source.getServer();
                    let username = player.getGameProfile().getName();


                    if (superpowerUtil.hasSuperpower(player, 'fsang:face_change')) {

                        server.runCommandSilent(`team add disguise_team`);
                        server.runCommandSilent(`team modify disguise_team displayName {"text":"${targetUsername}"}`);
                        server.runCommandSilent(`team join disguise_team ${player.getName()}`);
                        server.runCommandSilent(`team modify disguise_team nametagVisibility always`);
                        server.runCommandSilent(`execute as ${username} run item replace entity @s armor.head with minecraft:player_head{SkullOwner:"${targetUsername}",display:{Name:'["",{"text":"Face","italic":false}]'},Enchantments:[{lvl:1,id:binding_curse},{lvl:1,id:vanishing_curse}],HideFlags:3}`);

                    }
                    else if (abilityUtil.isEnabled(player, 'fsang:mimicry', 'face_change_face_purchase')) {

                        server.runCommandSilent(`team add disguise_team`);
                        server.runCommandSilent(`team modify disguise_team displayName {"text":"${targetUsername}"}`);
                        server.runCommandSilent(`team join disguise_team ${player.getName()}`);
                        server.runCommandSilent(`team modify disguise_team nametagVisibility always`);
                        server.runCommandSilent(`execute as ${username} run item replace entity @s armor.head with minecraft:player_head{SkullOwner:"${targetUsername}",display:{Name:'["",{"text":"Face","italic":false}]'},Enchantments:[{lvl:1,id:binding_curse},{lvl:1,id:vanishing_curse}],HideFlags:3}`);

                    }
                    return 1;
                })
            )
    );
});
