const TRAIL_PRESETS = {
    yellow: [0xffd100, 0xffd100],
    blue: [0x0000b3, 0x0000ff],
    cyan: [0x00b3b3, 0x00ffff],
    green: [0x006700, 0x00ff00],
    orange: [0xb36621, 0xe6832a],
    pink: [0xf782a1, 0xf33a6a],
    purple: [0x8019c0, 0xa020f0],
    white: [0xffffff, 0xfaf9f6],
    red: [0xcc0000, 0xff0000],
    black: [0x000000, 0x262626]
};

const POSITIVE_SPEEDFORCE_POWERS = [
    'fsang:speedforce',
    'fsang:speedforce_god',
    'fsang:speedforce_speed',
    'fsang:speedforce_strength',
    'fsang:speedforce_tachyon'
];

const NEGATIVE_SPEEDFORCE_POWERS = [
    'fsang:negative_speedforce',
    'fsang:speedforce_leech'
];

function hasAnyPower(player, ids) {
    try {
        if (typeof superpowerUtil !== 'undefined') {
            for (const id of ids) if (superpowerUtil.hasSuperpower(player, id)) return true;
        } else if (typeof palladium !== 'undefined' && typeof palladium.hasSuperpower === 'function') {
            for (const id of ids) if (palladium.hasSuperpower(player, id)) return true;
        }
    } catch (_) { }
    return false;
}

ItemEvents.rightClicked('fsang:trail_changer_speedforce', event => {
    const player = event.player;
    if (!player || player.level.isClientSide()) return;
    const off = player.getOffHandItem();
    if (!off || off.isEmpty()) return;
    const id = String(off.id);
    const prefix = 'fsang:speedforce_trail_';
    if (!id.startsWith(prefix)) return;
    if (!hasAnyPower(player, POSITIVE_SPEEDFORCE_POWERS)) {
        player.displayClientMessage(Text.of('You do not have a connection to the Speedforce'), true);
        event.cancel();
        return;
    }
    const colorKey = id.substring(prefix.length);
    const pair = TRAIL_PRESETS[colorKey];
    if (!pair) return;
    try {
        palladium.setProperty(player, 'fsang_speed_trail1', pair[0]);
        palladium.setProperty(player, 'fsang_speed_trail2', pair[1]);
    } catch (_) {
        if (typeof propertyUtil !== 'undefined') {
            propertyUtil.set(player, 'fsang_speed_trail1', pair[0]);
            propertyUtil.set(player, 'fsang_speed_trail2', pair[1]);
        } else {
            player.displayClientMessage(Text.of('Could not set Speedforce trail colors'), true);
            event.cancel();
            return;
        }
    }
    off.shrink(1);
    event.cancel();
    player.displayClientMessage(Text.of(`Speedforce trail set to ${colorKey}`), true);
});

ItemEvents.rightClicked('fsang:trail_changer_negative_speedforce', event => {
    const player = event.player;
    if (!player || player.level.isClientSide()) return;
    const off = player.getOffHandItem();
    if (!off || off.isEmpty()) return;
    const id = String(off.id);
    const prefix = 'fsang:speedforce_trail_';
    if (!id.startsWith(prefix)) return;
    if (!hasAnyPower(player, NEGATIVE_SPEEDFORCE_POWERS)) {
        player.displayClientMessage(Text.of('You do not have a connection to the Negative Speedforce'), true);
        event.cancel();
        return;
    }
    const colorKey = id.substring(prefix.length);
    const pair = TRAIL_PRESETS[colorKey];
    if (!pair) return;
    try {
        palladium.setProperty(player, 'fsang_speed_trail1', pair[0]);
        palladium.setProperty(player, 'fsang_speed_trail2', pair[1]);
    } catch (_) {
        if (typeof propertyUtil !== 'undefined') {
            propertyUtil.set(player, 'fsang_speed_trail1', pair[0]);
            propertyUtil.set(player, 'fsang_speed_trail2', pair[1]);
        } else {
            player.displayClientMessage(Text.of('Could not set Negative Speedforce trail colors'), true);
            event.cancel();
            return;
        }
    }
    off.shrink(1);
    event.cancel();
    player.displayClientMessage(Text.of(`Negative Speedforce trail set to ${colorKey}`), true);
});