ServerEvents.tick(event => {
    const world = event.server.getLevel('fsang:codex');
    const { player, item, server, hand } = event;
    
    function getRandomSymbioteColor(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
    // Check if the dimension exists and is loaded
    if (world) {
        // Get all entities in the world and filter for zombies
        world.getEntities().forEach(entity => {
            if (entity.type === 'minecraft:zombie' && world.dimension === 'fsang:codex') {
                const randomSymbioteColor = getRandomSymbioteColor(0, 7);
                // Apply the Palladium power
                superpowerUtil.addSuperpower(entity, 'fsang:symbiote_zombie');

                // Optional: Additional modifications for the zombie
                entity.customName = Text.of("Symbiote").color(0xFFFFFF);
                entity.customNameVisible = true;
                entity.maxHealth = 30;
                entity.silent = true;
                server.runCommandSilent(`execute as @e[type=minecraft:zombie] unless entity @s[scores={Symbiote_Assigner=0..7}] run scoreboard players set @s Symbiote_Assigner ${randomSymbioteColor}`);

            }
            else if (entity.type === 'minecraft:drowned' && world.dimension === 'fsang:codex') {
                server.runCommandSilent(`execute as @e[type=minecraft:drowned] run kill @s`);

            }
            else if (entity.type === 'minecraft:chicken' && world.dimension === 'fsang:codex') {
                server.runCommandSilent(`execute as @e[type=minecraft:chicken] run kill @s`);

            }
        });
    }
});
