var $SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil');

global.dimensionOptions = [
    "minecraft:overworld",
    "minecraft:the_nether",
    "minecraft:the_end",
    "fsang:pocket_dimension"
];

function saveQuickSaves(player) {
    const saves = global.playerCoordState[player.uuid].quickSaves;
    const data = player.persistentData;
    ['slot1', 'slot2', 'slot3'].forEach(slot => {
        const entry = saves[slot];
        if (entry) {
            data.putString(`fsang.coord.${slot}`, `${entry.x},${entry.y},${entry.z},${entry.dim}`);
        } else {
            data.remove(`fsang.coord.${slot}`);
        }
    });
}

function loadQuickSaves(player) {
    const saves = {};
    const data = player.persistentData;
    ['slot1', 'slot2', 'slot3'].forEach(slot => {
        const raw = data.getString(`fsang.coord.${slot}`);
        if (raw && raw.includes(',')) {
            const [x, y, z, dim] = raw.split(',');
            saves[slot] = {
                x: parseInt(x),
                y: parseInt(y),
                z: parseInt(z),
                dim: dim
            };
        } else {
            saves[slot] = null;
        }
    });
    return saves;
}

// Session-only per-player coordinate memory
if (!global.playerCoordState) global.playerCoordState = {};

StartupEvents.registry('palladium:abilities', event => {
    event.create('fsang:coordinate_menu')
        .icon(palladium.createItemIcon('minecraft:compass'))
        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                global.openCoordinateKeypadGUI(entity);
            }
        });
});

global.openCoordinateKeypadGUI = (player) => {
    const uuid = player.uuid;

    if (!global.playerCoordState[uuid]) {
        global.playerCoordState[uuid] = {
            x: 0,
            y: 0,
            z: 0,
            dim: "minecraft:overworld",
            dimIndex: 0,
            editing: null,
            input: "",
            quickSaves: loadQuickSaves(player),
            lastSaveTarget: 'slot1'
        };
    }

    const pData = global.playerCoordState[uuid];

    player.openChestGUI(Text.of("§0Enter Coordinates"), 6, gui => {
        gui.playerSlots = false;

        // Saved Location buttons (first slot of rows 0–2) + Clear buttons (next slot)
        ['slot1', 'slot2', 'slot3'].forEach((slotKey, i) => {
            const save = pData.quickSaves[slotKey];
            const displayName = save ? `Go to ${slotKey.toUpperCase()} (${save.x},${save.y},${save.z})` : `Empty ${slotKey.toUpperCase()}`;

            // Saved Location (col 0, rows 0–2)
            gui.slot(0, i, slot => {
                slot.item = Item.of('minecraft:lodestone', 1, {
                    display: {
                        Name: JSON.stringify({ text: displayName, color: save ? "green" : "dark_gray" }),
                        Lore: save ? [
                            JSON.stringify({ text: `Dimension: ${save.dim}`, color: "gray" })
                        ] : []
                    }
                });
                slot.leftClicked = () => {
                    if (save) {
                        try {
                            player.server.runCommandSilent(`execute as ${uuid} in ${save.dim} run tp @s ${save.x} ${save.y} ${save.z}`);
                            let nearbyEntities = player.level.getEntitiesWithin(player.boundingBox.inflate(2));
                            for (const entity of nearbyEntities) {
                                if (entity.server) {
                                    player.server.runCommandSilent(`execute in ${save.dim} run tp ${entity.uuid} ${save.x} ${save.y} ${save.z}`);
                                }
                            }
                        } catch (err) {
                            player.tell(`§cQuick teleport failed: ${err}`);
                        }
                    } else {
                        pData.lastSaveTarget = slotKey;
                        player.tell(`§eNext 'Save to Slot' will target ${slotKey.toUpperCase()}`);
                    }
                };
            });

            // Clear Slot (col 1, rows 0–2)
            gui.slot(1, i, slot => {
                slot.item = Item.of('minecraft:barrier', 1, {
                    display: { Name: JSON.stringify({ text: `Clear ${slotKey.toUpperCase()}`, color: "red" }) }
                });
                slot.leftClicked = () => {
                    pData.quickSaves[slotKey] = null;
                    saveQuickSaves(player);
                    player.tell(`§cCleared ${slotKey.toUpperCase()}!`);
                    global.openCoordinateKeypadGUI(player);
                };
            });
        });

        // Save to Slot button (placed adjacent to quick save rows; middle row)
        gui.slot(1, 3, slot => {
            slot.item = Item.of('minecraft:book', 1, {
                display: {
                    Name: JSON.stringify({ text: `Save to Slot`, color: "aqua" }),
                    Lore: [
                        JSON.stringify({ text: `Saves current coords to ${pData.lastSaveTarget.toUpperCase()}`, color: "gray" }),
                        JSON.stringify({ text: `Left-click a save slot first to change target.`, color: "dark_gray" })
                    ]
                }
            });
            slot.leftClicked = () => {
                if (!['slot1', 'slot2', 'slot3'].includes(pData.lastSaveTarget)) {
                    player.tell(`§cInvalid save target.`);
                    return;
                }
                pData.quickSaves[pData.lastSaveTarget] = {
                    x: pData.x,
                    y: pData.y,
                    z: pData.z,
                    dim: pData.dim
                };
                saveQuickSaves(player);
                player.tell(`§aSaved to ${pData.lastSaveTarget.toUpperCase()} successfully!`);
                global.openCoordinateKeypadGUI(player);
            };
        });

        // Numeric keypad shifted right by one column (now cols 3–5)
        const makeNumButton = (num, x, y) => {
            gui.slot(x, y, slot => {
                slot.item = Item.of(`fsang:num_${num}`, 1, {
                    display: { Name: JSON.stringify({ text: `${num}`, color: "white" }) }
                });
                slot.leftClicked = () => {
                    pData.input += `${num}`;
                    global.openCoordinateKeypadGUI(player);
                };
            });
        };

        [1, 2, 3].forEach((n, i) => makeNumButton(n, 3 + i, 1));
        [4, 5, 6].forEach((n, i) => makeNumButton(n, 3 + i, 2));
        [7, 8, 9].forEach((n, i) => makeNumButton(n, 3 + i, 3));
        makeNumButton(0, 4, 4);

        gui.slot(3, 4, slot => {
            slot.item = Item.of('fsang:num_clear', 1, {
                display: { Name: JSON.stringify({ text: "Clear Input", color: "red" }) }
            });
            slot.leftClicked = () => {
                pData.input = "";
                global.openCoordinateKeypadGUI(player);
            };
        });

        gui.slot(5, 4, slot => {
            slot.item = Item.of('fsang:num_negative', 1, {
                display: { Name: JSON.stringify({ text: "Toggle Negative", color: "dark_red" }) }
            });
            slot.leftClicked = () => {
                pData.input = pData.input.startsWith("-") ? pData.input.substring(1) : "-" + pData.input;
                global.openCoordinateKeypadGUI(player);
            };
        });

        ['x', 'y', 'z'].forEach((axis, idx) => {
            gui.slot(6, 1 + idx, slot => {
                slot.item = Item.of(`fsang:num_${axis}`, 1, {
                    display: { Name: JSON.stringify({ text: `Set ${axis.toUpperCase()}`, color: "green" }) }
                });
                slot.leftClicked = () => {
                    pData.editing = axis;
                    pData.input = "";
                    global.openCoordinateKeypadGUI(player);
                };
            });
        });

        gui.slot(6, 4, slot => {
            slot.item = Item.of('fsang:num_confirm', 1, {
                display: { Name: JSON.stringify({ text: "Confirm Entry", color: "aqua", bold: true }) }
            });
            slot.leftClicked = () => {
                if (pData.editing) {
                    let value = parseInt(pData.input);
                    if (!isNaN(value)) {
                        pData[pData.editing] = value;
                    }
                    pData.input = "";
                    pData.editing = null;
                    global.openCoordinateKeypadGUI(player);
                } else {
                    player.tell("§cPlease select X/Y/Z first!");
                }
            };
        });

        gui.slot(3, 5, slot => {
            slot.item = Item.of('minecraft:map', 1, {
                display: {
                    Name: JSON.stringify({ text: `Input: ${pData.input || "(empty)"}`, color: "yellow" }),
                    Lore: [
                        JSON.stringify({ text: `Editing: ${pData.editing || "(none)"}`, color: "gray" }),
                        JSON.stringify({ text: `X: ${pData.x}`, color: "gray" }),
                        JSON.stringify({ text: `Y: ${pData.y}`, color: "gray" }),
                        JSON.stringify({ text: `Z: ${pData.z}`, color: "gray" }),
                        JSON.stringify({ text: `Dimension: ${pData.dim}`, color: "gray" })
                    ]
                }
            });
        });

        // Dimension selection (kept as-is from your base)
        global.dimensionOptions.forEach((dimId, index) => {
            gui.slot(index, 6, slot => {
                const isSelected = pData.dim === dimId;
                slot.item = Item.of('fsang:num_dimension', 1, {
                    display: {
                        Name: JSON.stringify({ text: dimId, color: isSelected ? "gold" : "gray" }),
                        Lore: [JSON.stringify({ text: isSelected ? "Current Dimension" : "Click to select", color: "dark_gray" })]
                    }
                });
                slot.leftClicked = () => {
                    pData.dim = dimId;
                    pData.dimIndex = index;
                    global.openCoordinateKeypadGUI(player);
                };
            });
        });

        // Teleport button
        gui.slot(5, 5, slot => {
            slot.item = Item.of('minecraft:ender_pearl', 1, {
                display: {
                    Name: JSON.stringify({ text: "Teleport", color: "light_purple", bold: true }),
                    Lore: [
                        JSON.stringify({ text: "Click to teleport to the set coordinates", color: "gray" }),
                        JSON.stringify({ text: "Supports dimension teleportation", color: "gray" }),
                        JSON.stringify({ text: "Teleports player and nearby entities", color: "gray" })
                    ]
                }
            });
            slot.leftClicked = () => {
                if (
                    typeof pData.x === "number" &&
                    typeof pData.y === "number" &&
                    typeof pData.z === "number" &&
                    typeof pData.dim === "string"
                ) {
                    try {
                        let x = pData.x;
                        let y = pData.y;
                        let z = pData.z;
                        let dim = pData.dim;

                        player.server.runCommandSilent(`execute as ${uuid} in ${dim} run tp @s ${x} ${y} ${z}`);
                        let nearbyEntities = player.level.getEntitiesWithin(player.boundingBox.inflate(2));
                        for (const entity of nearbyEntities) {
                            if (entity.server) {
                                player.server.runCommandSilent(`execute in ${dim} run tp ${entity.uuid} ${x} ${y} ${z}`);
                            }
                        }
                    } catch (err) {
                        player.tell(`§cTeleportation failed: ${err}`);
                    }
                } else {
                    player.tell("§cInvalid coordinate input.");
                }
            };
        });
    });
};
