StartupEvents.registry('palladium:condition_serializer', (event) => {
    event.create('fsang:time_based_condition')
        .addProperty("start_time", "integer", 0, "The starting time in ticks (0-24000)")
        .addProperty("end_time", "integer", 12000, "The ending time in ticks (0-24000)")
        .test((entity, props) => {
            const startTime = props.get("start_time");
            const endTime = props.get("end_time");
            const worldTime = entity.level.getDayTime() % 24000;

            return startTime <= endTime
                ? worldTime >= startTime && worldTime <= endTime
                : worldTime >= startTime || worldTime <= endTime;
        });
});
