(function () {
    let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');
    let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper');

    // Register the custom condition
    StartupEvents.registry('palladium:condition_serializer', (event) => {
        event.create('fsang:rf_percentage_condition')

            // Define properties
            .addProperty('curios_slot', 'string', "null", 'Curios slot ID (set to "null" to skip)')
            .addProperty('trinket_slot', 'string', "null", 'Trinket slot ID (set to "null" to skip)')
            .addProperty('armor_or_hand_slot', 'string', "null", 'Armor or hand slot (head, chest, legs, feet, mainhand, offhand, null)')
            .addProperty('percentage', 'float', 50.0, 'The RF percentage threshold')

            .test((entity, props) => {
                const curios_slot = props.get('curios_slot') || "null";
                const trinket_slot = props.get('trinket_slot') || "null";
                const armor_or_hand_slot = props.get('armor_or_hand_slot') || "null";
                const percentage = props.get('percentage');

                // Helper function to check if the item meets the RF percentage
                function checkRFPercentage(item) {
                    if (item && !item.isEmpty()) {
                        let holderWrapper = EnergyHelper.getFromItemStack(item);
                        if (holderWrapper.isPresent()) {
                            let energyHolder = holderWrapper.get();
                            let currentEnergy = energyHolder.getEnergyAmount();
                            let maxEnergy = energyHolder.getEnergyCapacity();
                            let currentPercentage = (currentEnergy / maxEnergy) * 100;
                            return currentPercentage <= percentage;
                        }
                    }
                    return false;
                }

                // Process Curios slot
                if (curios_slot.toLowerCase() !== "null") {
                    let curiosItems = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, curios_slot.toLowerCase());
                    for (let item of curiosItems) {
                        if (checkRFPercentage(item)) {
                            return true;
                        }
                    }
                }

                // Process Trinkets slot
                if (trinket_slot.toLowerCase() !== "null") {
                    let trinketItems = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, trinket_slot.toLowerCase());
                    for (let item of trinketItems) {
                        if (checkRFPercentage(item)) {
                            return true;
                        }
                    }
                }

                // Process Armor or Hand slots
                if (armor_or_hand_slot.toLowerCase() !== "null") {
                    let itemToCheck;
                    switch (armor_or_hand_slot.toLowerCase()) {
                        case "head":
                            itemToCheck = entity.getEquippedStack(EquipmentSlot.HEAD);
                            break;
                        case "chest":
                            itemToCheck = entity.getEquippedStack(EquipmentSlot.CHEST);
                            break;
                        case "legs":
                            itemToCheck = entity.getEquippedStack(EquipmentSlot.LEGS);
                            break;
                        case "feet":
                            itemToCheck = entity.getEquippedStack(EquipmentSlot.FEET);
                            break;
                        case "mainhand":
                            itemToCheck = entity.getMainHandItem();
                            break;
                        case "offhand":
                            itemToCheck = entity.getOffhandItem();
                            break;
                    }
                    if (checkRFPercentage(itemToCheck)) {
                        return true;
                    }
                }

                return false;
            });
    });
})();
