// Made originally by phantompig, but converted to use Scoreboards by FSang18
let $Util = Java.loadClass('net.minecraft.Util');
const IMMOVABLE_BLOCKS = [
    'minecraft:bedrock',
    'minecraft:barrier',
    'minecraft:end_portal',
    'minecraft:end_gateway',
    'minecraft:end_portal_frame',
    'minecraft:nether_portal',
    'minecraft:command_block',
    'minecraft:repeating_command_block',
    'minecraft:chain_command_block',
    'minecraft:structure_block',
    'minecraft:jigsaw',
    'minecraft:chest',
    'minecraft:trapped_chest',
    'minecraft:ender_chest',
    'minecraft:barrel',
    'minecraft:spawner'
];

const UNREPLACEABLE_BLOCKS = [
    'minecraft:bedrock',
    'minecraft:barrier',
    'minecraft:end_portal',
    'minecraft:end_gateway',
    'minecraft:end_portal_frame',
    'minecraft:nether_portal',
    'minecraft:command_block',
    'minecraft:repeating_command_block',
    'minecraft:chain_command_block',
    'minecraft:structure_block',
    'minecraft:jigsaw',
    'minecraft:spawner',
    'minecraft:reinforced_deepslate',
    'minecraft:chest',
    'minecraft:trapped_chest',
    'minecraft:ender_chest',
    'minecraft:barrel',
    'minecraft:beacon',
    'minecraft:enchanting_table',
    'minecraft:respawn_anchor',
    'minecraft:lodestone',
    'minecraft:dragon_egg',
    'minecraft:conduit'
];
function isShulkerBox(id) { return id.endsWith('_shulker_box') || id === 'minecraft:shulker_box'; }
function isImmovable(id) { return isShulkerBox(id) || IMMOVABLE_BLOCKS.indexOf(id) !== -1; }
function isUnreplaceable(id) { return isShulkerBox(id) || UNREPLACEABLE_BLOCKS.indexOf(id) !== -1; }

const FSANG_TLK = {
    PD_KEY: 'fsang.telekinesis.held_uuid',
    ZERO: '00000000-0000-0000-0000-000000000000',

    getHeldId(player) {
        let v = '';
        try { v = String(player.persistentData.getString(this.PD_KEY) || ''); } catch (_) { }
        if (!v || v.length < 36) {
            player.persistentData.putString(this.PD_KEY, this.ZERO);
            return this.ZERO;
        }
        return v;
    },

    setHeldId(player, uuidStr) {
        player.persistentData.putString(this.PD_KEY, (uuidStr && String(uuidStr).length >= 36) ? String(uuidStr) : this.ZERO);
    },

    _findEntityByUUIDString(level, uuidStr) {
        if (!uuidStr || uuidStr === this.ZERO) return null;
        const list = level.getEntities();
        for (let i = 0; i < list.size(); i++) {
            try {
                if (String(list.get(i).uuid) === uuidStr) return list.get(i);
            } catch (_) { }
        }
        return null;
    },

    getHeld(player) {
        const id = this.getHeldId(player);
        if (id === this.ZERO) return null;
        return this._findEntityByUUIDString(player.level, id);
    },

    setHeld(player, entityOrNull) {
        if (!entityOrNull) {
            this.setHeldId(player, this.ZERO);
            return;
        }
        try { this.setHeldId(player, String(entityOrNull.uuid)); } catch (_) { this.setHeldId(player, this.ZERO); }
    }
};


StartupEvents.registry('palladium:abilities', event => {
    event.create('fsang:telekinesis')
        .icon(palladium.createItemIcon('minecraft:player_head'))
        .documentationDescription('Telekinesis: grab blocks and entities and float them in front of you. Held target stored in persistentData (no Palladium UUID property).')

        .addProperty('range_objective', 'string', 'FSang.Range', 'Scoreboard objective that defines telekinesis range.')
        .addProperty('strength', 'float', 0.8, 'The strength/speed of the telekinesis.')
        .addProperty('damage', 'float', 2, 'The damage to apply when hitting an entity with a block via telekinesis.')

        .firstTick((player, entry, holder, enabled) => {
            if (!enabled || !player || !player.isPlayer()) return;

            const range = getRangeFromScore(player, entry);
            let rayTrace = player.rayTrace(range, false);

            if (rayTrace.entity != null) {
                FSANG_TLK.setHeld(player, rayTrace.entity);
            } else if (rayTrace.block != null) {
                if (isImmovable(rayTrace.block.id)) return;
                const spawned = spawnBlockDisplay(rayTrace.block);
                if (spawned) FSANG_TLK.setHeld(player, spawned);
            }
        })

        .tick((player, entry, holder, enabled) => {
            if (!enabled || !player || !player.isPlayer()) return;

            const range = getRangeFromScore(player, entry);
            let heldEntity = FSANG_TLK.getHeld(player);
            if (heldEntity == null) return;

            let targetPos = player.getEyePosition().add(player.getLookAngle().scale(range));
            let boundingBox = player.getBoundingBox();

            if (heldEntity.type == 'minecraft:block_display') {
                boundingBox = AABB.ofSize(heldEntity.position(), 1, 1, 1);
                targetPos = player.rayTrace(range).hit ?? targetPos;
                heldEntity.setPosition(targetPos.x() - 0.5, targetPos.y() - 0.5, targetPos.z() - 0.5);

                player.level.getEntities(heldEntity, boundingBox).forEach(collidedEntity => {
                    if (collidedEntity.living) collidedEntity.attack(entry.getPropertyByName('damage'));
                });
            } else {
                heldEntity.setDeltaMovement(
                    targetPos.subtract(heldEntity.getEyePosition()).scale(entry.getPropertyByName('strength'))
                );
                heldEntity.resetFallDistance();
            }

            player.level.sendParticles(
                'minecraft:enchant',
                heldEntity.x, heldEntity.y, heldEntity.z,
                1,
                boundingBox.getXsize(), boundingBox.getYsize(), boundingBox.getZsize(),
                0
            );
        })

        .lastTick((player, entry, holder, enabled) => {
            let heldEntity = FSANG_TLK.getHeld(player);
            if (heldEntity == null) return;

            if (heldEntity.type == 'minecraft:block_display') safePlaceBlockDisplay(heldEntity);

            FSANG_TLK.setHeld(player, null);
        });
});

function getRangeFromScore(entity, entry) {
    const objectiveName = entry.getPropertyByName('range_objective');
    let range = 0;
    try {
        range = palladium.scoreboard.getScore(entity, objectiveName, 0);
    } catch (_) {
        range = 0;
    }
    if (range <= 0) range = 1;
    return range;
}

function spawnBlockDisplay(block) {
    if (isImmovable(block.id)) return null;

    let entity = block.level.createEntity('minecraft:block_display');
    entity.setPosition(block);
    entity.mergeNbt({ block_state: { Name: block.id, Properties: block.properties } });

    block.set('air');

    entity.spawn();
    return entity;
}
function safePlaceBlockDisplay(entity) {
    if (entity.type != 'minecraft:block_display') return;

    let target = entity.block;

    let steps = 0;
    while (steps < 5 && isUnreplaceable(target.id)) {
        target = target.up;
        steps++;
    }

    if (isUnreplaceable(target.id)) {
        dropHeldBlockAsItem(entity);
        return;
    }

    target.level.destroyBlock(target.pos, true);

    let props = {};
    if (entity.nbt.block_state.Properties != null) {
        for (let [key, value] of Object.entries(entity.nbt.block_state.Properties)) {
            props[key] = value;
        }
    }

    target.set(entity.nbt.block_state.Name, props);
    target.level.markAndNotifyBlock(
        target.pos,
        target.level.getChunk(target.pos),
        target.blockState,
        target.blockState,
        3,
        512
    );
    entity.discard();
}

function dropHeldBlockAsItem(displayEntity) {
    try {
        const blockId = displayEntity.nbt.block_state.Name;

        let item = displayEntity.level.createEntity('minecraft:item');
        item.setPosition(displayEntity.x, displayEntity.y, displayEntity.z);
        item.mergeNbt({ Item: { id: blockId, Count: 1 } });
        item.spawn();
    } finally {
        displayEntity.discard();
    }
}

