(function () {
  var Minecraft = Java.loadClass('net.minecraft.client.Minecraft');
  var RenderSystem = Java.loadClass('com.mojang.blaze3d.systems.RenderSystem');
  var EditBox = Java.loadClass('net.minecraft.client.gui.components.EditBox');
  var GLFW = Java.loadClass('org.lwjgl.glfw.GLFW');
  var ResourceLocation = Java.loadClass('net.minecraft.resources.ResourceLocation');
  var Component = Java.loadClass('net.minecraft.network.chat.Component');
  var Quaternionf = Java.loadClass('org.joml.Quaternionf');
  var InventoryScreen = Java.loadClass('net.minecraft.client.gui.screens.inventory.InventoryScreen');

  var PANEL_TEX = 'fsang:textures/gui/jackets/panel.png';
  var SLIDER_ARROW_LEFT = 'fsang:textures/gui/jackets/slider_arrow_left.png';
  var SLIDER_ARROW_RIGHT = 'fsang:textures/gui/jackets/slider_arrow_right.png';
  var SLIDER_KNOB_TEX = 'fsang:textures/gui/jackets/slider_knob.png';
  var SAVE_BTN_TEX = 'fsang:textures/gui/jackets/save.png';

  var SLIDER = { width: 50, height: 4, knobW: 6, knobH: 12, spacingY: 12 };
  var ROT = { width: 160, height: 4, knobW: 6, knobH: 12 };
  var PANEL_W = 512, PANEL_H = 256;
  var TICK_MS = 50;

  function clamp(v, min, max) { return v < min ? min : (v > max ? max : v); }
  function toHex2(n) { var s = clamp(n, 0, 255).toString(16); return s.length === 1 ? ('0' + s) : s; }
  function hex6(r, g, b) { return (toHex2(r) + toHex2(g) + toHex2(b)).toLowerCase(); }
  function hexInt(r, g, b) { return ((clamp(r, 0, 255) << 16) | (clamp(g, 0, 255) << 8) | clamp(b, 0, 255)) >>> 0; }
  function intToRgb(n) { return { r: (n >> 16) & 255, g: (n >> 8) & 255, b: n & 255 }; }

  function drawOutlinedLabel(gx, text, x, y, centerColor) {
    var c = (centerColor == null ? 0xffffff : centerColor);
    palladium.gui.drawString(gx, Component.literal(text), x, y + 1, 0x000000);
    palladium.gui.drawString(gx, Component.literal(text), x, y - 1, 0x000000);
    palladium.gui.drawString(gx, Component.literal(text), x + 1, y, 0x000000);
    palladium.gui.drawString(gx, Component.literal(text), x - 1, y, 0x000000);
    palladium.gui.drawString(gx, Component.literal(text), x, y, c);
  }

  function drawDynamicBar(gx, x, y, w, h, rgb, channel) {
    RenderSystem.enableBlend();
    for (var i = 0; i < w; i++) {
      var val = Math.round((i / (w - 1)) * 255);
      var r = channel === 'r' ? val : rgb.r;
      var g = channel === 'g' ? val : rgb.g;
      var b = channel === 'b' ? val : rgb.b;
      var color = (0xFF << 24) | (r << 16) | (g << 8) | b;
      gx.fill((x + i) | 0, y | 0, (x + i + 1) | 0, (y + h) | 0, color | 0);
    }
    RenderSystem.disableBlend();
  }

  function drawSlider(gx, cx, cy, value, channel) {
    drawDynamicBar(gx, cx - 121, cy, SLIDER.width, SLIDER.height, this.rgb, channel);
    var rel = (clamp(value, 0, 255) / 255.0) * (SLIDER.width - 1);
    var kx = Math.floor(cx + rel - SLIDER.knobW / 2) - 121;
    var ky = cy - Math.floor((SLIDER.knobH - SLIDER.height) / 2);
    gx.blit(new ResourceLocation(SLIDER_KNOB_TEX), kx, ky, 0, 0, SLIDER.knobW, SLIDER.knobH, SLIDER.knobW, SLIDER.knobH);
    return { barX: cx - 121, barY: cy, barW: SLIDER.width, valueX: cx - 121 + SLIDER.width + 8, valueY: cy - 4 };
  }

  function drawPreviewBox(gx, x, y, w, h, r, g, b) {
    r = r | 0; g = g | 0; b = b | 0;
    if (r < 0) r = 0; else if (r > 255) r = 255;
    if (g < 0) g = 0; else if (g > 255) g = 255;
    if (b < 0) b = 0; else if (b > 255) b = 255;
    var fill = (((255 << 24) | (r << 16) | (g << 8) | b)) | 0;
    var border = ((255 << 24) | 0) | 0;
    gx.fill(x | 0, y | 0, (x + w) | 0, (y + h) | 0, fill);
    gx.fill(x | 0, y | 0, (x + w) | 0, (y + 1) | 0, border);
    gx.fill(x | 0, (y + h - 1) | 0, (x + w) | 0, (y + h) | 0, border);
    gx.fill(x | 0, y | 0, (x + 1) | 0, (y + h) | 0, border);
    gx.fill((x + w - 1) | 0, y | 0, (x + w) | 0, (y + h) | 0, border);
  }

  function drawRotationSlider(gx, cx, cy, deg) {
    var x = cx - Math.floor(ROT.width / 2);
    var y = cy - Math.floor(ROT.height / 2);
    gx.fill(x | 0, y | 0, (x + ROT.width) | 0, (y + ROT.height) | 0, 0xFF808080 | 0);
    var rel = Math.round((clamp(deg, 0, 360) / 360.0) * (ROT.width - 1));
    var knobW = ROT.knobW + 5;
    var knobH = ROT.knobH + 5;
    var kx = x + rel - Math.floor(knobW / 2);
    var ky = y - Math.floor((knobH - ROT.height) / 2);
    gx.blit(new ResourceLocation(SLIDER_KNOB_TEX), kx, ky, 0, 0, knobW, knobH, knobW, knobH);
    return { barX: x, barY: y, barW: ROT.width };
  }

  function makeNumericBox(font, screen, existing, x, y, w, h, channel, state, sendFn) {
    if (!existing) {
      var box = new EditBox(font, x, y, w, h, Component.literal(""));
      box.setMaxLength(3);
      box.setBordered(false);
      box.setVisible(false);
      if (box.setEditable) box.setEditable(true);
      if (box.setFilter) {
        box.setFilter(function (t) {
          if (t == null) return true;
          if (!/^\d{0,3}$/.test(t)) return false;
          if (t.length === 0) return true;
          var n = parseInt(t, 10);
          return n >= 0 && n <= 255;
        });
      }
      if (box.setResponder) {
        box.setResponder(function (t) {
          if (!(box && box.isFocused && box.isFocused())) return;
          if (t == null || t === "") return;
          var n = clamp(parseInt(t, 10) | 0, 0, 255);
          if (channel === 'r') state.rgb.r = n; else if (channel === 'g') state.rgb.g = n; else state.rgb.b = n;
          sendFn();
        });
      }
      if (screen.addRenderableWidget) screen.addRenderableWidget(box);
      return box;
    } else {
      if (existing.setPosition) existing.setPosition(x, y); else { existing.x = x; existing.y = y; }
      if (existing.setWidth) existing.setWidth(w); else { existing.width = w; }
      return existing;
    }
  }

  function ensureHexBox(screen, state, x, y, sendFn) {
    if (state.screenRef !== screen || state.sw !== screen.width || state.sh !== screen.height) {
      if (state.hexBox && state.screenRef && state.screenRef.removeWidget) state.screenRef.removeWidget(state.hexBox);
      if (state.rBox && state.screenRef && state.screenRef.removeWidget) state.screenRef.removeWidget(state.rBox);
      if (state.gBox && state.screenRef && state.screenRef.removeWidget) state.screenRef.removeWidget(state.gBox);
      if (state.bBox && state.screenRef && state.screenRef.removeWidget) state.screenRef.removeWidget(state.bBox);
      state.hexBox = state.rBox = state.gBox = state.bBox = null;
      state.screenRef = screen; state.sw = screen.width; state.sh = screen.height;
    }
    if (!state.hexBox) {
      var font = Minecraft.getInstance().font;
      state.hexBox = new EditBox(font, x, y, state.hexRect.w, state.hexRect.h, Component.literal(""));
      state.hexBox.setMaxLength(6);
      state.hexBox.setBordered(false);
      state.hexBox.setEditable(true);
      state.hexBox.setVisible(false);
      if (state.hexBox.setFilter) state.hexBox.setFilter(function (t) { return /^[0-9A-Fa-f]{0,6}$/.test(t || ""); });
      if (state.hexBox.setResponder) {
        state.hexBox.setResponder(function (t) {
          if (!(state.hexBox && state.hexBox.isFocused && state.hexBox.isFocused())) return;
          if (t && t.length === 6 && /^[0-9A-Fa-f]{6}$/.test(t)) {
            var n = parseInt(t, 16); if (isNaN(n)) return;
            state.rgb.r = (n >> 16) & 0xFF; state.rgb.g = (n >> 8) & 0xFF; state.rgb.b = n & 0xFF;
            sendFn();
          }
        });
      }
      if (screen.addRenderableWidget) screen.addRenderableWidget(state.hexBox);
    } else {
      if (state.hexBox.setPosition) state.hexBox.setPosition(x, y); else { state.hexBox.x = x; state.hexBox.y = y; }
    }
    state.hexRect.x = x; state.hexRect.y = y;
    state.applyKnob.x = x + state.hexRect.w + 4;
    state.applyKnob.y = y + Math.floor((state.hexRect.h - SLIDER.knobH) / 2);
  }

  function blur(box) { if (!box) return; box.setVisible(false); if (box.setFocused) box.setFocused(false); }
  function blurAll(state) { [state.rBox, state.gBox, state.bBox, state.hexBox].forEach(blur); }
  function focusOnly(state, box, text) { [state.rBox, state.gBox, state.bBox, state.hexBox].forEach(function (b) { if (b !== box) blur(b); }); if (!box) return; if (text != null && box.setValue) box.setValue(text); box.setVisible(true); box.setFocused(true); }
  function isF(box) { return !!(box && box.isFocused && box.isFocused()); }

  function renderPlayer(state, e, width, height, rotDeg) {
    var size = 55;
    var padX = 220;
    var padY = 60;
    var xBR = (width - padX) | 0;
    var yBR = (height - padY) | 0;
    var pose = e.guiGraphics.pose();
    pose.pushPose();
    pose.translate(0, 0, 800);
    var bodyRot = new Quaternionf();
    bodyRot.rotateZ(3.1415927);
    bodyRot.rotateY(rotDeg * 0.017453292);
    var headRot = new Quaternionf();
    headRot.rotateZ(3.1415927);
    InventoryScreen.renderEntityInInventory(e.guiGraphics, xBR, yBR, size, bodyRot, headRot, Minecraft.getInstance().player);
    pose.popPose();
  }

  function makeState() {
    return {
      hexBox: null, rBox: null, gBox: null, bBox: null,
      dragging: { r: false, g: false, b: false },
      draggingRot: false,
      rgb: { r: 255, g: 255, b: 255 },
      lastSent: { r: -1, g: -1, b: -1 },
      lastTick: 0, wasDown: false,
      screenRef: null, sw: 0, sh: 0,
      hexRect: { x: 0, y: 0, w: 43, h: 14 },
      hydrated: false,
      rotDeg: 180,
      labels: null,
      labelIndex: 0,
      leftBtn: { x: 0, y: 0, w: 8, h: 12 },
      rightBtn: { x: 0, y: 0, w: 8, h: 12 },
      applyKnob: { x: 0, y: 0, w: 12, h: 12 },
      PREVIEW: { w: 40, h: 40, offsetX: -28, offsetY: 0 }
    };
  }

  function ensureRGBBoxes(screen, state, positions, sendFn) {
    var font = Minecraft.getInstance().font;
    state.rBox = makeNumericBox(font, screen, state.rBox, positions.r.x, positions.r.y, positions.w, positions.h, 'r', state, sendFn);
    state.gBox = makeNumericBox(font, screen, state.gBox, positions.g.x, positions.g.y, positions.w, positions.h, 'g', state, sendFn);
    state.bBox = makeNumericBox(font, screen, state.bBox, positions.b.x, positions.b.y, positions.w, positions.h, 'b', state, sendFn);
    if (!isF(state.rBox)) state.rBox.setValue(String(state.rgb.r));
    if (!isF(state.gBox)) state.gBox.setValue(String(state.rgb.g));
    if (!isF(state.bBox)) state.bBox.setValue(String(state.rgb.b));
  }

  function handleMouse(which, bounds, mx, my, isDown, justPressed, state, sendFn) {
    var onBar = (mx >= bounds.barX && mx <= bounds.barX + bounds.barW && my >= bounds.barY - 6 && my <= bounds.barY + 10);
    if (justPressed && onBar) { blurAll(state); }
    if (justPressed && onBar) state.dragging[which] = true;
    if (!isDown) state.dragging[which] = false;
    if (state.dragging[which]) {
      var rel = clamp(mx - bounds.barX, 0, bounds.barW);
      var val = Math.round((rel / bounds.barW) * 255);
      if (which === 'r') state.rgb.r = val; else if (which === 'g') state.rgb.g = val; else state.rgb.b = val;
      sendFn();
    }
  }

  function commitRGBBox(state, box, ch, sendFn) {
    if (!box) return;
    var t = box.getValue ? box.getValue() : "";
    if (t && /^\d{1,3}$/.test(t)) {
      var n = clamp(parseInt(t, 10) | 0, 0, 255);
      if (ch === 'r') state.rgb.r = n; else if (ch === 'g') state.rgb.g = n; else state.rgb.b = n;
      sendFn();
    }
    blur(box);
  }

  function commitHexBox(state, sendFn) {
    if (!state.hexBox) return;
    var t = state.hexBox.getValue ? state.hexBox.getValue() : "";
    if (/^[0-9A-Fa-f]{6}$/.test(t)) {
      var n = parseInt(t, 16);
      state.rgb.r = (n >> 16) & 0xFF; state.rgb.g = (n >> 8) & 0xFF; state.rgb.b = n & 0xFF;
      sendFn();
    }
    blur(state.hexBox);
  }

  function clickIn(mx, my, x, y, w, h) { return mx >= x && mx <= x + w && my >= y && my <= y + h; }

  var jackets = makeState();
  jackets.labels = ['Primary', 'Secondary', 'Hood'];

  function jacketsSend() {
    var r = clamp(jackets.rgb.r, 0, 255) | 0;
    var g = clamp(jackets.rgb.g, 0, 255) | 0;
    var b = clamp(jackets.rgb.b, 0, 255) | 0;
    if (r === jackets.lastSent.r && g === jackets.lastSent.g && b === jackets.lastSent.b) return;
    jackets.lastSent = { r: r, g: g, b: b };
    Client.player.sendData("fsang:sync_rgb", { r: r, g: g, b: b });
  }

  function jacketsHydrate(player) {
    if (jackets.hydrated) return;
    jackets.hydrated = true;
    var r0 = palladium.getProperty(player, "fsang_menu_r");
    var g0 = palladium.getProperty(player, "fsang_menu_g");
    var b0 = palladium.getProperty(player, "fsang_menu_b");
    if (typeof r0 === 'number' && typeof g0 === 'number' && typeof b0 === 'number') {
      jackets.rgb.r = clamp(r0, 0, 255) | 0;
      jackets.rgb.g = clamp(g0, 0, 255) | 0;
      jackets.rgb.b = clamp(b0, 0, 255) | 0;
      jackets.lastSent = { r: -1, g: -1, b: -1 };
    }
  }

  PalladiumEvents.renderPowerScreen(function (e) {
    if (!e.tab) return;
    var tabId = String(e.tab);
    if (String(e.tab) !== 'fsang:jackets') return;
    var mc = Minecraft.getInstance();
    var player = mc.player; if (!player) return;
    jacketsHydrate(player);
    var win = mc.getWindow().getWindow();
    var mouseX = e.mouseX, mouseY = e.mouseY;
    var isDown = GLFW.glfwGetMouseButton(win, GLFW.GLFW_MOUSE_BUTTON_LEFT) === GLFW.GLFW_PRESS;
    var justPressed = isDown && !jackets.wasDown; jackets.wasDown = isDown;
    var width = e.screen.width, height = e.screen.height;
    var cx = Math.floor(width / 2), cy = Math.floor(height / 2);
    var px = cx - Math.floor(PANEL_W / 2);
    var py = cy - Math.floor(PANEL_H / 2) + 6;
    RenderSystem.enableBlend();
    e.guiGraphics.blit(new ResourceLocation(PANEL_TEX), px, py, 0, 0, PANEL_W, PANEL_H, PANEL_W, PANEL_H);
    RenderSystem.disableBlend();
    var font = Minecraft.getInstance().font;
    var labelY = py + 46;
    var leftX = cx - 205;
    var rightX = cx - 135;
    jackets.leftBtn.x = leftX;
    jackets.leftBtn.y = labelY - Math.floor(jackets.leftBtn.h / 2);
    e.guiGraphics.blit(new ResourceLocation(SLIDER_ARROW_LEFT), jackets.leftBtn.x, jackets.leftBtn.y + 5, 0, 0, jackets.leftBtn.w, jackets.leftBtn.h, jackets.leftBtn.w, jackets.leftBtn.h);
    jackets.rightBtn.x = rightX;
    jackets.rightBtn.y = labelY - Math.floor(jackets.rightBtn.h / 2);
    e.guiGraphics.blit(new ResourceLocation(SLIDER_ARROW_RIGHT), jackets.rightBtn.x, jackets.rightBtn.y + 5, 0, 0, jackets.rightBtn.w, jackets.rightBtn.h, jackets.rightBtn.w, jackets.rightBtn.h);
    var labelText = jackets.labels[jackets.labelIndex];
    var labelWidth = font.width(labelText);
    var centerX = (leftX + rightX + jackets.leftBtn.w) / 2;
    var labelX = centerX - labelWidth / 2;
    drawOutlinedLabel(e.guiGraphics, labelText, labelX, labelY);
    if (justPressed) {
      if (mouseX >= jackets.leftBtn.x && mouseX <= jackets.leftBtn.x + jackets.leftBtn.w && mouseY >= jackets.leftBtn.y && mouseY <= jackets.leftBtn.y + jackets.leftBtn.h) {
        jackets.labelIndex = (jackets.labelIndex + jackets.labels.length - 1) % jackets.labels.length;
      } else if (mouseX >= jackets.rightBtn.x && mouseX <= jackets.rightBtn.x + jackets.rightBtn.w && mouseY >= jackets.rightBtn.y && mouseY <= jackets.rightBtn.y + jackets.rightBtn.h) {
        jackets.labelIndex = (jackets.labelIndex + 1) % jackets.labels.length;
      }
    }
    var sx = cx - 80;
    var sy = py + 63;
    var rB = drawSlider.call(jackets, e.guiGraphics, sx, sy + 0 * SLIDER.spacingY, jackets.rgb.r, 'r');
    var gB = drawSlider.call(jackets, e.guiGraphics, sx, sy + 1 * SLIDER.spacingY, jackets.rgb.g, 'g');
    var bB = drawSlider.call(jackets, e.guiGraphics, sx, sy + 2 * SLIDER.spacingY, jackets.rgb.b, 'b');
    drawOutlinedLabel(e.guiGraphics, 'R', sx - 130, sy - 4);
    drawOutlinedLabel(e.guiGraphics, 'G', sx - 130, sy + 8);
    drawOutlinedLabel(e.guiGraphics, 'B', sx - 130, sy + 20);
    ensureRGBBoxes(e.screen, jackets, { r: { x: rB.valueX, y: rB.valueY - 2 }, g: { x: gB.valueX, y: gB.valueY - 2 }, b: { x: bB.valueX, y: bB.valueY - 2 }, w: Math.max(18, font.width("255") + 4), h: 12 }, jacketsSend);
    var rEditing = isF(jackets.rBox), gEditing = isF(jackets.gBox), bEditing = isF(jackets.bBox);
    if (jackets.rBox) jackets.rBox.setVisible(rEditing);
    if (jackets.gBox) jackets.gBox.setVisible(gEditing);
    if (jackets.bBox) jackets.bBox.setVisible(bEditing);
    if (!rEditing) drawOutlinedLabel(e.guiGraphics, String(jackets.rgb.r), rB.valueX, rB.valueY);
    if (!gEditing) drawOutlinedLabel(e.guiGraphics, String(jackets.rgb.g), gB.valueX, gB.valueY);
    if (!bEditing) drawOutlinedLabel(e.guiGraphics, String(jackets.rgb.b), bB.valueX, bB.valueY);
    var pvX = sx + SLIDER.width - 130 + jackets.PREVIEW.offsetX;
    var pvY = sy + 3 * SLIDER.spacingY + 2 + jackets.hexRect.h + jackets.PREVIEW.offsetY;
    ensureHexBox(e.screen, jackets, pvX, sy + 3 * SLIDER.spacingY + 2, jacketsSend);
    var hexEditing = isF(jackets.hexBox);
    if (jackets.hexBox) jackets.hexBox.setVisible(hexEditing);
    if (!hexEditing) drawOutlinedLabel(e.guiGraphics, hex6(jackets.rgb.r, jackets.rgb.g, jackets.rgb.b), jackets.hexRect.x, jackets.hexRect.y);
    drawPreviewBox(e.guiGraphics, pvX, pvY, jackets.PREVIEW.w, jackets.PREVIEW.h, jackets.rgb.r, jackets.rgb.g, jackets.rgb.b);
    if (justPressed) {
      var wNum = Math.max(18, font.width("255") + 4), hNum = 12;
      var focused = false;
      if (clickIn(mouseX, mouseY, rB.valueX, rB.valueY - 2, wNum, hNum)) { focusOnly(jackets, jackets.rBox, String(jackets.rgb.r)); focused = true; }
      else if (clickIn(mouseX, mouseY, gB.valueX, gB.valueY - 2, wNum, hNum)) { focusOnly(jackets, jackets.gBox, String(jackets.rgb.g)); focused = true; }
      else if (clickIn(mouseX, mouseY, bB.valueX, bB.valueY - 2, wNum, hNum)) { focusOnly(jackets, jackets.bBox, String(jackets.rgb.b)); focused = true; }
      else if (clickIn(mouseX, mouseY, jackets.hexRect.x, jackets.hexRect.y, jackets.hexRect.w, jackets.hexRect.h)) { focusOnly(jackets, jackets.hexBox, hex6(jackets.rgb.r, jackets.rgb.g, jackets.rgb.b)); focused = true; }
      if (!focused) {
        commitRGBBox(jackets, jackets.rBox, 'r', jacketsSend);
        commitRGBBox(jackets, jackets.gBox, 'g', jacketsSend);
        commitRGBBox(jackets, jackets.bBox, 'b', jacketsSend);
        commitHexBox(jackets, jacketsSend);
      }
    }
    if (rEditing || gEditing || bEditing || hexEditing) {
      var keyEnter = (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_ENTER) === GLFW.GLFW_PRESS) || (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_KP_ENTER) === GLFW.GLFW_PRESS);
      var keyEsc = (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_ESCAPE) === GLFW.GLFW_PRESS);
      if (keyEnter) {
        commitRGBBox(jackets, jackets.rBox, 'r', jacketsSend);
        commitRGBBox(jackets, jackets.gBox, 'g', jacketsSend);
        commitRGBBox(jackets, jackets.bBox, 'b', jacketsSend);
        commitHexBox(jackets, jacketsSend);
      }
      if (keyEsc) {
        if (jackets.rBox) { jackets.rBox.setValue(String(jackets.rgb.r)); blur(jackets.rBox); }
        if (jackets.gBox) { jackets.gBox.setValue(String(jackets.rgb.g)); blur(jackets.gBox); }
        if (jackets.bBox) { jackets.bBox.setValue(String(jackets.rgb.b)); blur(jackets.bBox); }
        if (jackets.hexBox) { jackets.hexBox.setValue(hex6(jackets.rgb.r, jackets.rgb.g, jackets.rgb.b)); blur(jackets.hexBox); }
      }
    }
    e.guiGraphics.blit(new ResourceLocation(SAVE_BTN_TEX), jackets.applyKnob.x - 60, jackets.applyKnob.y - 2, 0, 0, jackets.applyKnob.w, jackets.applyKnob.h - 2, jackets.applyKnob.w, jackets.applyKnob.h - 2);
    if (justPressed) {
      if (mouseX >= jackets.applyKnob.x - 60 && mouseX <= jackets.applyKnob.x - 60 + jackets.applyKnob.w && mouseY >= jackets.applyKnob.y - 2 && mouseY <= jackets.applyKnob.y - 2 + jackets.applyKnob.h) {
        var mode = jackets.labels[jackets.labelIndex].toLowerCase();
        Client.player.sendData("fsang:apply_jacket_rgb", { r: clamp(jackets.rgb.r, 0, 255) | 0, g: clamp(jackets.rgb.g, 0, 255) | 0, b: clamp(jackets.rgb.b, 0, 255) | 0, mode: mode });
      }
    }
    var rotCx = sx + 100;
    var rotCy = sy + 3 * SLIDER.spacingY + 18 + 85;
    drawOutlinedLabel(e.guiGraphics, 'Rotate', rotCx - 130, rotCy - 4);
    var rotBounds = drawRotationSlider(e.guiGraphics, rotCx, rotCy, jackets.rotDeg);
    var onRot = (mouseX >= rotBounds.barX && mouseX <= rotBounds.barX + rotBounds.barW && mouseY >= rotBounds.barY - 6 && mouseY <= rotBounds.barY + 10);
    if (justPressed && onRot) { jackets.draggingRot = true; blurAll(jackets); }
    if (!isDown) jackets.draggingRot = false;
    if (jackets.draggingRot) {
      var relRot = clamp(mouseX - rotBounds.barX, 0, rotBounds.barW - 1);
      jackets.rotDeg = Math.round((relRot / (rotBounds.barW - 1)) * 360);
    }
    handleMouse('r', rB, mouseX, mouseY, isDown, justPressed, jackets, jacketsSend);
    handleMouse('g', gB, mouseX, mouseY, isDown, justPressed, jackets, jacketsSend);
    handleMouse('b', bB, mouseX, mouseY, isDown, justPressed, jackets, jacketsSend);
    renderPlayer(jackets, e, width, height, jackets.rotDeg);
    var now = Date.now();
    if (now - jackets.lastTick >= TICK_MS) { jackets.lastTick = now; jacketsSend(); }
  });

  PalladiumEvents.registerGuiOverlays(function (ev) {
    ev.register('fsang/jacket_rgb_reset', function (mc) {
      if (mc.screen == null || mc.screen.getClass().getSimpleName() !== 'PowersScreen') jackets.hydrated = false;
    });
  });

  var reactor = makeState();

  function reactorSend() {
    var r = clamp(reactor.rgb.r, 0, 255) | 0;
    var g = clamp(reactor.rgb.g, 0, 255) | 0;
    var b = clamp(reactor.rgb.b, 0, 255) | 0;
    if (r === reactor.lastSent.r && g === reactor.lastSent.g && b === reactor.lastSent.b) return;
    reactor.lastSent = { r: r, g: g, b: b };
    Client.player.sendData("fsang:sync_rgb", { r: r, g: g, b: b });
  }

  function reactorHydrate(player) {
    if (reactor.hydrated) return;
    reactor.hydrated = true;
    var r0 = palladium.getProperty(player, "fsang_reactor_r");
    var g0 = palladium.getProperty(player, "fsang_reactor_g");
    var b0 = palladium.getProperty(player, "fsang_reactor_b");
    if (typeof r0 === 'number' && typeof g0 === 'number' && typeof b0 === 'number') {
      reactor.rgb.r = clamp(r0, 0, 255) | 0;
      reactor.rgb.g = clamp(g0, 0, 255) | 0;
      reactor.rgb.b = clamp(b0, 0, 255) | 0;
      reactor.lastSent = { r: -1, g: -1, b: -1 };
    }
  }

  PalladiumEvents.renderPowerScreen(function (e) {
    if (!e.tab) return;
    var tabId = String(e.tab);
    if (String(e.tab) !== 'fsang:arc_reactor') return;
    var mc = Minecraft.getInstance();
    var player = mc.player; if (!player) return;
    reactorHydrate(player);
    var win = mc.getWindow().getWindow();
    var mouseX = e.mouseX, mouseY = e.mouseY;
    var isDown = GLFW.glfwGetMouseButton(win, GLFW.GLFW_MOUSE_BUTTON_LEFT) === GLFW.GLFW_PRESS;
    var justPressed = isDown && !reactor.wasDown; reactor.wasDown = isDown;
    var width = e.screen.width, height = e.screen.height;
    var cx = Math.floor(width / 2), cy = Math.floor(height / 2);
    var px = cx - Math.floor(PANEL_W / 2);
    var py = cy - Math.floor(PANEL_H / 2) + 6;
    RenderSystem.enableBlend();
    e.guiGraphics.blit(new ResourceLocation(PANEL_TEX), px, py, 0, 0, PANEL_W, PANEL_H, PANEL_W, PANEL_H);
    RenderSystem.disableBlend();
    var font = Minecraft.getInstance().font;
    drawOutlinedLabel(e.guiGraphics, 'Color', cx - Math.floor(font.width('Color') / 2) - 175, py + 46);
    var sx = cx - 80;
    var sy = py + 63;
    var rB = drawSlider.call(reactor, e.guiGraphics, sx, sy + 0 * SLIDER.spacingY, reactor.rgb.r, 'r');
    var gB = drawSlider.call(reactor, e.guiGraphics, sx, sy + 1 * SLIDER.spacingY, reactor.rgb.g, 'g');
    var bB = drawSlider.call(reactor, e.guiGraphics, sx, sy + 2 * SLIDER.spacingY, reactor.rgb.b, 'b');
    drawOutlinedLabel(e.guiGraphics, 'R', sx - 130, sy - 4);
    drawOutlinedLabel(e.guiGraphics, 'G', sx - 130, sy + 8);
    drawOutlinedLabel(e.guiGraphics, 'B', sx - 130, sy + 20);
    ensureRGBBoxes(e.screen, reactor, { r: { x: rB.valueX, y: rB.valueY - 2 }, g: { x: gB.valueX, y: gB.valueY - 2 }, b: { x: bB.valueX, y: bB.valueY - 2 }, w: Math.max(18, font.width("255") + 4), h: 12 }, reactorSend);
    var rEditing = isF(reactor.rBox), gEditing = isF(reactor.gBox), bEditing = isF(reactor.bBox);
    if (reactor.rBox) reactor.rBox.setVisible(rEditing);
    if (reactor.gBox) reactor.gBox.setVisible(gEditing);
    if (reactor.bBox) reactor.bBox.setVisible(bEditing);
    if (!rEditing) drawOutlinedLabel(e.guiGraphics, String(reactor.rgb.r), rB.valueX, rB.valueY);
    if (!gEditing) drawOutlinedLabel(e.guiGraphics, String(reactor.rgb.g), gB.valueX, gB.valueY);
    if (!bEditing) drawOutlinedLabel(e.guiGraphics, String(reactor.rgb.b), bB.valueX, bB.valueY);
    var pvX = sx + SLIDER.width - 130 + reactor.PREVIEW.offsetX;
    var pvY = sy + 3 * SLIDER.spacingY + 2 + reactor.hexRect.h + reactor.PREVIEW.offsetY;
    ensureHexBox(e.screen, reactor, pvX, sy + 3 * SLIDER.spacingY + 2, reactorSend);
    var hexEditing = isF(reactor.hexBox);
    if (reactor.hexBox) reactor.hexBox.setVisible(hexEditing);
    if (!hexEditing) drawOutlinedLabel(e.guiGraphics, hex6(reactor.rgb.r, reactor.rgb.g, reactor.rgb.b), reactor.hexRect.x, reactor.hexRect.y);
    drawPreviewBox(e.guiGraphics, pvX, pvY, reactor.PREVIEW.w, reactor.PREVIEW.h, reactor.rgb.r, reactor.rgb.g, reactor.rgb.b);
    if (justPressed) {
      var wNum = Math.max(18, font.width("255") + 4), hNum = 12;
      var focused = false;
      if (clickIn(mouseX, mouseY, rB.valueX, rB.valueY - 2, wNum, hNum)) { focusOnly(reactor, reactor.rBox, String(reactor.rgb.r)); focused = true; }
      else if (clickIn(mouseX, mouseY, gB.valueX, gB.valueY - 2, wNum, hNum)) { focusOnly(reactor, reactor.gBox, String(reactor.rgb.g)); focused = true; }
      else if (clickIn(mouseX, mouseY, bB.valueX, bB.valueY - 2, wNum, hNum)) { focusOnly(reactor, reactor.bBox, String(reactor.rgb.b)); focused = true; }
      else if (clickIn(mouseX, mouseY, reactor.hexRect.x, reactor.hexRect.y, reactor.hexRect.w, reactor.hexRect.h)) { focusOnly(reactor, reactor.hexBox, hex6(reactor.rgb.r, reactor.rgb.g, reactor.rgb.b)); focused = true; }
      if (!focused) {
        commitRGBBox(reactor, reactor.rBox, 'r', reactorSend);
        commitRGBBox(reactor, reactor.gBox, 'g', reactorSend);
        commitRGBBox(reactor, reactor.bBox, 'b', reactorSend);
        commitHexBox(reactor, reactorSend);
      }
    }
    if (rEditing || gEditing || bEditing || hexEditing) {
      var keyEnter = (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_ENTER) === GLFW.GLFW_PRESS) || (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_KP_ENTER) === GLFW.GLFW_PRESS);
      var keyEsc = (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_ESCAPE) === GLFW.GLFW_PRESS);
      if (keyEnter) {
        commitRGBBox(reactor, reactor.rBox, 'r', reactorSend);
        commitRGBBox(reactor, reactor.gBox, 'g', reactorSend);
        commitRGBBox(reactor, reactor.bBox, 'b', reactorSend);
        commitHexBox(reactor, reactorSend);
      }
      if (keyEsc) {
        if (reactor.rBox) { reactor.rBox.setValue(String(reactor.rgb.r)); blur(reactor.rBox); }
        if (reactor.gBox) { reactor.gBox.setValue(String(reactor.rgb.g)); blur(reactor.gBox); }
        if (reactor.bBox) { reactor.bBox.setValue(String(reactor.rgb.b)); blur(reactor.bBox); }
        if (reactor.hexBox) { reactor.hexBox.setValue(hex6(reactor.rgb.r, reactor.rgb.g, reactor.rgb.b)); blur(reactor.hexBox); }
      }
    }
    e.guiGraphics.blit(new ResourceLocation(SAVE_BTN_TEX), reactor.applyKnob.x - 60, reactor.applyKnob.y - 2, 0, 0, reactor.applyKnob.w, reactor.applyKnob.h - 2, reactor.applyKnob.w, reactor.applyKnob.h - 2);
    if (justPressed) {
      if (mouseX >= reactor.applyKnob.x - 60 && mouseX <= reactor.applyKnob.x - 60 + reactor.applyKnob.w && mouseY >= reactor.applyKnob.y - 2 && mouseY <= reactor.applyKnob.y - 2 + reactor.applyKnob.h) {
        Client.player.sendData("fsang:apply_reactor_rgb", { r: clamp(reactor.rgb.r, 0, 255) | 0, g: clamp(reactor.rgb.g, 0, 255) | 0, b: clamp(reactor.rgb.b, 0, 255) | 0 });
      }
    }
    var rotCx = sx + 100;
    var rotCy = sy + 3 * SLIDER.spacingY + 18 + 85;
    drawOutlinedLabel(e.guiGraphics, 'Rotate', rotCx - 130, rotCy - 4);
    var rotBounds = drawRotationSlider(e.guiGraphics, rotCx, rotCy, reactor.rotDeg);
    var onRot = (mouseX >= rotBounds.barX && mouseX <= rotBounds.barX + rotBounds.barW && mouseY >= rotBounds.barY - 6 && mouseY <= rotBounds.barY + 10);
    if (justPressed && onRot) { reactor.draggingRot = true; blurAll(reactor); }
    if (!isDown) reactor.draggingRot = false;
    if (reactor.draggingRot) {
      var relRot = clamp(mouseX - rotBounds.barX, 0, rotBounds.barW - 1);
      reactor.rotDeg = Math.round((relRot / (rotBounds.barW - 1)) * 360);
    }
    handleMouse('r', rB, mouseX, mouseY, isDown, justPressed, reactor, reactorSend);
    handleMouse('g', gB, mouseX, mouseY, isDown, justPressed, reactor, reactorSend);
    handleMouse('b', bB, mouseX, mouseY, isDown, justPressed, reactor, reactorSend);
    renderPlayer(reactor, e, width, height, reactor.rotDeg);
    var now = Date.now();
    if (now - reactor.lastTick >= TICK_MS) { reactor.lastTick = now; reactorSend(); }
  });

  PalladiumEvents.registerGuiOverlays(function (ev) {
    ev.register('fsang/reactor_rgb_reset', function (mc) {
      if (mc.screen == null || mc.screen.getClass().getSimpleName() !== 'PowersScreen') reactor.hydrated = false;
    });
  });

  var capes = makeState()
  capes.labels = ['Primary', 'Secondary']

  function capesSend() {
    var r = clamp(capes.rgb.r, 0, 255) | 0
    var g = clamp(capes.rgb.g, 0, 255) | 0
    var b = clamp(capes.rgb.b, 0, 255) | 0
    if (r === capes.lastSent.r && g === capes.lastSent.g && b === capes.lastSent.b) return
    capes.lastSent = { r: r, g: g, b: b }
    Client.player.sendData("fsang:sync_rgb", { r: r, g: g, b: b })
  }

  function capesHydrate(player) {
    if (capes.hydrated) return
    capes.hydrated = true
    var r0, g0, b0
    if (capes.labelIndex === 0) {
      r0 = palladium.getProperty(player, "fsang_cape_r")
      g0 = palladium.getProperty(player, "fsang_cape_g")
      b0 = palladium.getProperty(player, "fsang_cape_b")
    } else {
      r0 = palladium.getProperty(player, "fsang_inner_cape_r")
      g0 = palladium.getProperty(player, "fsang_inner_cape_g")
      b0 = palladium.getProperty(player, "fsang_inner_cape_b")
    }
    if (typeof r0 === 'number' && typeof g0 === 'number' && typeof b0 === 'number') {
      capes.rgb.r = clamp(r0, 0, 255) | 0
      capes.rgb.g = clamp(g0, 0, 255) | 0
      capes.rgb.b = clamp(b0, 0, 255) | 0
      capes.lastSent = { r: -1, g: -1, b: -1 }
    }
  }

  PalladiumEvents.renderPowerScreen(function (e) {
    if (!e.tab) return
    if (String(e.tab) !== 'fsang:capes') return

    var mc = Minecraft.getInstance()
    var player = mc.player
    if (!player) return
    capesHydrate(player)

    var win = mc.getWindow().getWindow()
    var mouseX = e.mouseX, mouseY = e.mouseY
    var isDown = GLFW.glfwGetMouseButton(win, GLFW.GLFW_MOUSE_BUTTON_LEFT) === GLFW.GLFW_PRESS
    var justPressed = isDown && !capes.wasDown
    capes.wasDown = isDown

    var width = e.screen.width, height = e.screen.height
    var cx = Math.floor(width / 2), cy = Math.floor(height / 2)
    var px = cx - Math.floor(PANEL_W / 2)
    var py = cy - Math.floor(PANEL_H / 2) + 6

    RenderSystem.enableBlend()
    e.guiGraphics.blit(new ResourceLocation(PANEL_TEX), px, py, 0, 0, PANEL_W, PANEL_H, PANEL_W, PANEL_H)
    RenderSystem.disableBlend()

    var font = Minecraft.getInstance().font
    var labelY = py + 46
    var leftX = cx - 205
    var rightX = cx - 135
    capes.leftBtn.x = leftX
    capes.leftBtn.y = labelY - Math.floor(capes.leftBtn.h / 2)
    e.guiGraphics.blit(new ResourceLocation(SLIDER_ARROW_LEFT), capes.leftBtn.x, capes.leftBtn.y + 5, 0, 0, capes.leftBtn.w, capes.leftBtn.h, capes.leftBtn.w, capes.leftBtn.h)
    capes.rightBtn.x = rightX
    capes.rightBtn.y = labelY - Math.floor(capes.rightBtn.h / 2)
    e.guiGraphics.blit(new ResourceLocation(SLIDER_ARROW_RIGHT), capes.rightBtn.x, capes.rightBtn.y + 5, 0, 0, capes.rightBtn.w, capes.rightBtn.h, capes.rightBtn.w, capes.rightBtn.h)

    var labelText = capes.labels[capes.labelIndex]
    var labelWidth = font.width(labelText)
    var centerX = (leftX + rightX + capes.leftBtn.w) / 2
    var labelX = centerX - labelWidth / 2
    drawOutlinedLabel(e.guiGraphics, labelText, labelX, labelY)

    if (justPressed) {
      if (mouseX >= capes.leftBtn.x && mouseX <= capes.leftBtn.x + capes.leftBtn.w && mouseY >= capes.leftBtn.y && mouseY <= capes.leftBtn.y + capes.leftBtn.h) {
        capes.labelIndex = (capes.labelIndex + capes.labels.length - 1) % capes.labels.length
        capes.hydrated = false
      } else if (mouseX >= capes.rightBtn.x && mouseX <= capes.rightBtn.x + capes.rightBtn.w && mouseY >= capes.rightBtn.y && mouseY <= capes.rightBtn.y + capes.rightBtn.h) {
        capes.labelIndex = (capes.labelIndex + 1) % capes.labels.length
        capes.hydrated = false
      }
    }

    var sx = cx - 80
    var sy = py + 63
    var rB = drawSlider.call(capes, e.guiGraphics, sx, sy + 0 * SLIDER.spacingY, capes.rgb.r, 'r')
    var gB = drawSlider.call(capes, e.guiGraphics, sx, sy + 1 * SLIDER.spacingY, capes.rgb.g, 'g')
    var bB = drawSlider.call(capes, e.guiGraphics, sx, sy + 2 * SLIDER.spacingY, capes.rgb.b, 'b')

    drawOutlinedLabel(e.guiGraphics, 'R', sx - 130, sy - 4)
    drawOutlinedLabel(e.guiGraphics, 'G', sx - 130, sy + 8)
    drawOutlinedLabel(e.guiGraphics, 'B', sx - 130, sy + 20)

    ensureRGBBoxes(e.screen, capes, { r: { x: rB.valueX, y: rB.valueY - 2 }, g: { x: gB.valueX, y: gB.valueY - 2 }, b: { x: bB.valueX, y: bB.valueY - 2 }, w: Math.max(18, font.width("255") + 4), h: 12 }, capesSend)

    var rEditing = isF(capes.rBox), gEditing = isF(capes.gBox), bEditing = isF(capes.bBox)
    if (capes.rBox) capes.rBox.setVisible(rEditing)
    if (capes.gBox) capes.gBox.setVisible(gEditing)
    if (capes.bBox) capes.bBox.setVisible(bEditing)
    if (!rEditing) drawOutlinedLabel(e.guiGraphics, String(capes.rgb.r), rB.valueX, rB.valueY)
    if (!gEditing) drawOutlinedLabel(e.guiGraphics, String(capes.rgb.g), gB.valueX, gB.valueY)
    if (!bEditing) drawOutlinedLabel(e.guiGraphics, String(capes.rgb.b), bB.valueX, bB.valueY)

    var pvX = sx + SLIDER.width - 130 + capes.PREVIEW.offsetX
    var pvY = sy + 3 * SLIDER.spacingY + 2 + capes.hexRect.h + capes.PREVIEW.offsetY
    ensureHexBox(e.screen, capes, pvX, sy + 3 * SLIDER.spacingY + 2, capesSend)
    var hexEditing = isF(capes.hexBox)
    if (capes.hexBox) capes.hexBox.setVisible(hexEditing)
    if (!hexEditing) drawOutlinedLabel(e.guiGraphics, hex6(capes.rgb.r, capes.rgb.g, capes.rgb.b), capes.hexRect.x, capes.hexRect.y)
    drawPreviewBox(e.guiGraphics, pvX, pvY, capes.PREVIEW.w, capes.PREVIEW.h, capes.rgb.r, capes.rgb.g, capes.rgb.b)

    e.guiGraphics.blit(
      new ResourceLocation(SAVE_BTN_TEX),
      capes.applyKnob.x - 60, capes.applyKnob.y - 2,
      0, 0, capes.applyKnob.w, capes.applyKnob.h - 2,
      capes.applyKnob.w, capes.applyKnob.h - 2
    )

    if (justPressed) {
      if (mouseX >= capes.applyKnob.x - 60 &&
        mouseX <= capes.applyKnob.x - 60 + capes.applyKnob.w &&
        mouseY >= capes.applyKnob.y - 2 &&
        mouseY <= capes.applyKnob.y - 2 + capes.applyKnob.h) {
        var mode = capes.labels[capes.labelIndex].toLowerCase()
        Client.player.sendData("fsang:apply_cape_rgb", {
          r: clamp(capes.rgb.r, 0, 255) | 0,
          g: clamp(capes.rgb.g, 0, 255) | 0,
          b: clamp(capes.rgb.b, 0, 255) | 0,
          mode: mode
        })
      }
    }

    var rotCx = sx + 100
    var rotCy = sy + 3 * SLIDER.spacingY + 18 + 85
    drawOutlinedLabel(e.guiGraphics, 'Rotate', rotCx - 130, rotCy - 4)
    var rotBounds = drawRotationSlider(e.guiGraphics, rotCx, rotCy, capes.rotDeg)
    var onRot = (mouseX >= rotBounds.barX && mouseX <= rotBounds.barX + rotBounds.barW && mouseY >= rotBounds.barY - 6 && mouseY <= rotBounds.barY + 10)
    if (justPressed && onRot) { capes.draggingRot = true; blurAll(capes) }
    if (!isDown) capes.draggingRot = false
    if (capes.draggingRot) {
      var relRot = clamp(mouseX - rotBounds.barX, 0, rotBounds.barW - 1)
      capes.rotDeg = Math.round((relRot / (rotBounds.barW - 1)) * 360)
    }

    handleMouse('r', rB, mouseX, mouseY, isDown, justPressed, capes, capesSend)
    handleMouse('g', gB, mouseX, mouseY, isDown, justPressed, capes, capesSend)
    handleMouse('b', bB, mouseX, mouseY, isDown, justPressed, capes, capesSend)
    renderPlayer(capes, e, width, height, capes.rotDeg)

    var now = Date.now()
    if (now - capes.lastTick >= TICK_MS) { capes.lastTick = now; capesSend() }
  })


  var iron51 = makeState();
  iron51.labels = ['Primary', 'Secondary'];
  var DEFAULTS_51 = { primary: { r: 158, g: 23, b: 0 }, secondary: { r: 255, g: 212, b: 94 } };

  function iron51Send() {
    var r = clamp(iron51.rgb.r, 0, 255) | 0;
    var g = clamp(iron51.rgb.g, 0, 255) | 0;
    var b = clamp(iron51.rgb.b, 0, 255) | 0;
    if (r === iron51.lastSent.r && g === iron51.lastSent.g && b === iron51.lastSent.b) return;
    iron51.lastSent = { r: r, g: g, b: b };
    Client.player.sendData("fsang:sync_rgb", { r: r, g: g, b: b, iron51: true, mode: String(iron51.labels[iron51.labelIndex]).toLowerCase() });
  }

  function iron51Hydrate(player) {
    if (iron51.hydrated) return;
    iron51.hydrated = true;
    var r0, g0, b0;
    if (iron51.labelIndex === 0) {
      r0 = palladium.getProperty(player, "fsang_51_main_r");
      g0 = palladium.getProperty(player, "fsang_51_main_g");
      b0 = palladium.getProperty(player, "fsang_51_main_b");
    } else {
      r0 = palladium.getProperty(player, "fsang_51_second_r");
      g0 = palladium.getProperty(player, "fsang_51_second_g");
      b0 = palladium.getProperty(player, "fsang_51_second_b");
    }
    if (typeof r0 === 'number' && typeof g0 === 'number' && typeof b0 === 'number') {
      iron51.rgb.r = clamp(r0, 0, 255) | 0;
      iron51.rgb.g = clamp(g0, 0, 255) | 0;
      iron51.rgb.b = clamp(b0, 0, 255) | 0;
      iron51.lastSent = { r: -1, g: -1, b: -1 };
    }
  }

  PalladiumEvents.renderPowerScreen(function (e) {
    if (!e.tab) return;
    if (String(e.tab) !== 'fsang:iron_man_model_51') return;
    var mc = Minecraft.getInstance();
    var player = mc.player; if (!player) return;
    iron51Hydrate(player);
    var win = mc.getWindow().getWindow();
    var mouseX = e.mouseX, mouseY = e.mouseY;
    var isDown = GLFW.glfwGetMouseButton(win, GLFW.GLFW_MOUSE_BUTTON_LEFT) === GLFW.GLFW_PRESS;
    var justPressed = isDown && !iron51.wasDown; iron51.wasDown = isDown;
    var width = e.screen.width, height = e.screen.height;
    var cx = Math.floor(width / 2), cy = Math.floor(height / 2);
    var px = cx - Math.floor(PANEL_W / 2);
    var py = cy - Math.floor(PANEL_H / 2) + 6;
    RenderSystem.enableBlend();
    e.guiGraphics.blit(new ResourceLocation(PANEL_TEX), px, py, 0, 0, PANEL_W, PANEL_H, PANEL_W, PANEL_H);
    RenderSystem.disableBlend();
    var font = Minecraft.getInstance().font;
    var labelY = py + 46;
    var leftX = cx - 205;
    var rightX = cx - 135;
    iron51.leftBtn.x = leftX;
    iron51.leftBtn.y = labelY - Math.floor(iron51.leftBtn.h / 2);
    e.guiGraphics.blit(new ResourceLocation(SLIDER_ARROW_LEFT), iron51.leftBtn.x, iron51.leftBtn.y + 5, 0, 0, iron51.leftBtn.w, iron51.leftBtn.h, iron51.leftBtn.w, iron51.leftBtn.h);
    iron51.rightBtn.x = rightX;
    iron51.rightBtn.y = labelY - Math.floor(iron51.rightBtn.h / 2);
    e.guiGraphics.blit(new ResourceLocation(SLIDER_ARROW_RIGHT), iron51.rightBtn.x, iron51.rightBtn.y + 5, 0, 0, iron51.rightBtn.w, iron51.rightBtn.h, iron51.rightBtn.w, iron51.rightBtn.h);
    var labelText = iron51.labels[iron51.labelIndex];
    var labelWidth = font.width(labelText);
    var centerX = (leftX + rightX + iron51.leftBtn.w) / 2;
    var labelX = centerX - labelWidth / 2;
    drawOutlinedLabel(e.guiGraphics, labelText, labelX, labelY);
    if (justPressed) {
      if (mouseX >= iron51.leftBtn.x && mouseX <= iron51.leftBtn.x + iron51.leftBtn.w && mouseY >= iron51.leftBtn.y && mouseY <= iron51.leftBtn.y + iron51.leftBtn.h) {
        iron51.labelIndex = (iron51.labelIndex + iron51.labels.length - 1) % iron51.labels.length;
        iron51.hydrated = false;
      } else if (mouseX >= iron51.rightBtn.x && mouseX <= iron51.rightBtn.x + iron51.rightBtn.w && mouseY >= iron51.rightBtn.y && mouseY <= iron51.rightBtn.y + iron51.rightBtn.h) {
        iron51.labelIndex = (iron51.labelIndex + 1) % iron51.labels.length;
        iron51.hydrated = false;
      }
    }
    var sx = cx - 80;
    var sy = py + 63;
    var rB = drawSlider.call(iron51, e.guiGraphics, sx, sy + 0 * SLIDER.spacingY, iron51.rgb.r, 'r');
    var gB = drawSlider.call(iron51, e.guiGraphics, sx, sy + 1 * SLIDER.spacingY, iron51.rgb.g, 'g');
    var bB = drawSlider.call(iron51, e.guiGraphics, sx, sy + 2 * SLIDER.spacingY, iron51.rgb.b, 'b');
    drawOutlinedLabel(e.guiGraphics, 'R', sx - 130, sy - 4);
    drawOutlinedLabel(e.guiGraphics, 'G', sx - 130, sy + 8);
    drawOutlinedLabel(e.guiGraphics, 'B', sx - 130, sy + 20);
    ensureRGBBoxes(e.screen, iron51, { r: { x: rB.valueX, y: rB.valueY - 2 }, g: { x: gB.valueX, y: gB.valueY - 2 }, b: { x: bB.valueX, y: bB.valueY - 2 }, w: Math.max(18, font.width("255") + 4), h: 12 }, iron51Send);
    var rEditing = isF(iron51.rBox), gEditing = isF(iron51.gBox), bEditing = isF(iron51.bBox);
    if (iron51.rBox) iron51.rBox.setVisible(rEditing);
    if (iron51.gBox) iron51.gBox.setVisible(gEditing);
    if (iron51.bBox) iron51.bBox.setVisible(bEditing);
    if (!rEditing) drawOutlinedLabel(e.guiGraphics, String(iron51.rgb.r), rB.valueX, rB.valueY);
    if (!gEditing) drawOutlinedLabel(e.guiGraphics, String(iron51.rgb.g), gB.valueX, gB.valueY);
    if (!bEditing) drawOutlinedLabel(e.guiGraphics, String(iron51.rgb.b), bB.valueX, bB.valueY);
    var resetText = "Reset";
    var resetX = rB.valueX - 5;
    var resetY = bB.valueY + 15;
    drawOutlinedLabel(e.guiGraphics, resetText, resetX, resetY);
    var pvX = sx + SLIDER.width - 130 + iron51.PREVIEW.offsetX;
    var pvY = sy + 3 * SLIDER.spacingY + 2 + iron51.hexRect.h + iron51.PREVIEW.offsetY;
    ensureHexBox(e.screen, iron51, pvX, sy + 3 * SLIDER.spacingY + 2, iron51Send);
    var hexEditing = isF(iron51.hexBox);
    if (iron51.hexBox) iron51.hexBox.setVisible(hexEditing);
    if (!hexEditing) drawOutlinedLabel(e.guiGraphics, hex6(iron51.rgb.r, iron51.rgb.g, iron51.rgb.b), iron51.hexRect.x, iron51.hexRect.y);
    drawPreviewBox(e.guiGraphics, pvX, pvY, iron51.PREVIEW.w, iron51.PREVIEW.h, iron51.rgb.r, iron51.rgb.g, iron51.rgb.b);
    if (justPressed) {
      var wNum = Math.max(18, font.width("255") + 4), hNum = 12;
      var focused = false;
      if (clickIn(mouseX, mouseY, rB.valueX, rB.valueY - 2, wNum, hNum)) { focusOnly(iron51, iron51.rBox, String(iron51.rgb.r)); focused = true; }
      else if (clickIn(mouseX, mouseY, gB.valueX, gB.valueY - 2, wNum, hNum)) { focusOnly(iron51, iron51.gBox, String(iron51.rgb.g)); focused = true; }
      else if (clickIn(mouseX, mouseY, bB.valueX, bB.valueY - 2, wNum, hNum)) { focusOnly(iron51, iron51.bBox, String(iron51.rgb.b)); focused = true; }
      else if (clickIn(mouseX, mouseY, iron51.hexRect.x, iron51.hexRect.y, iron51.hexRect.w, iron51.hexRect.h)) { focusOnly(iron51, iron51.hexBox, hex6(iron51.rgb.r, iron51.rgb.g, iron51.rgb.b)); focused = true; }
      if (!focused) {
        commitRGBBox(iron51, iron51.rBox, 'r', iron51Send);
        commitRGBBox(iron51, iron51.gBox, 'g', iron51Send);
        commitRGBBox(iron51, iron51.bBox, 'b', iron51Send);
        commitHexBox(iron51, iron51Send);
      }
      var wReset = Minecraft.getInstance().font.width(resetText), hReset = 12;
      if (mouseX >= resetX && mouseX <= resetX + wReset && mouseY >= resetY && mouseY <= resetY + hReset) {
        var mode = String(iron51.labels[iron51.labelIndex]).toLowerCase();
        var d = DEFAULTS_51[mode] || DEFAULTS_51.primary;
        iron51.rgb.r = d.r | 0;
        iron51.rgb.g = d.g | 0;
        iron51.rgb.b = d.b | 0;
        if (iron51.rBox) iron51.rBox.setValue(String(iron51.rgb.r));
        if (iron51.gBox) iron51.gBox.setValue(String(iron51.rgb.g));
        if (iron51.bBox) iron51.bBox.setValue(String(iron51.rgb.b));
        if (iron51.hexBox) iron51.hexBox.setValue(hex6(iron51.rgb.r, iron51.rgb.g, iron51.rgb.b));
        iron51Send();
      }
    }
    if (rEditing || gEditing || bEditing || hexEditing) {
      var keyEnter = (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_ENTER) === GLFW.GLFW_PRESS) || (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_KP_ENTER) === GLFW.GLFW_PRESS);
      var keyEsc = (GLFW.glfwGetKey(win, GLFW.GLFW_KEY_ESCAPE) === GLFW.GLFW_PRESS);
      if (keyEnter) {
        commitRGBBox(iron51, iron51.rBox, 'r', iron51Send);
        commitRGBBox(iron51, iron51.gBox, 'g', iron51Send);
        commitRGBBox(iron51, iron51.bBox, 'b', iron51Send);
        commitHexBox(iron51, iron51Send);
      }
      if (keyEsc) {
        if (iron51.rBox) { iron51.rBox.setValue(String(iron51.rgb.r)); blur(iron51.rBox); }
        if (iron51.gBox) { iron51.gBox.setValue(String(iron51.rgb.g)); blur(iron51.gBox); }
        if (iron51.bBox) { iron51.bBox.setValue(String(iron51.rgb.b)); blur(iron51.bBox); }
        if (iron51.hexBox) { iron51.hexBox.setValue(hex6(iron51.rgb.r, iron51.rgb.g, iron51.rgb.b)); blur(iron51.hexBox); }
      }
    }
    e.guiGraphics.blit(new ResourceLocation(SAVE_BTN_TEX), iron51.applyKnob.x - 60, iron51.applyKnob.y - 2, 0, 0, iron51.applyKnob.w, iron51.applyKnob.h - 2, iron51.applyKnob.w, iron51.applyKnob.h - 2);
    if (justPressed) {
      if (mouseX >= iron51.applyKnob.x - 60 && mouseX <= iron51.applyKnob.x - 60 + iron51.applyKnob.w && mouseY >= iron51.applyKnob.y - 2 && mouseY <= iron51.applyKnob.y - 2 + iron51.applyKnob.h) {
        var mode2 = iron51.labels[iron51.labelIndex].toLowerCase();
        Client.player.sendData("fsang:apply_iron51_rgb", {
          r: clamp(iron51.rgb.r, 0, 255) | 0,
          g: clamp(iron51.rgb.g, 0, 255) | 0,
          b: clamp(iron51.rgb.b, 0, 255) | 0,
          props: mode2 === 'primary'
            ? ['fsang_51_main_r', 'fsang_51_main_g', 'fsang_51_main_b']
            : ['fsang_51_second_r', 'fsang_51_second_g', 'fsang_51_second_b']
        });
      }
    }
    var rotCx = sx + 100;
    var rotCy = sy + 3 * SLIDER.spacingY + 18 + 85;
    drawOutlinedLabel(e.guiGraphics, 'Rotate', rotCx - 130, rotCy - 4);
    var rotBounds = drawRotationSlider(e.guiGraphics, rotCx, rotCy, iron51.rotDeg);
    var onRot = (mouseX >= rotBounds.barX && mouseX <= rotBounds.barX + rotBounds.barW && mouseY >= rotBounds.barY - 6 && mouseY <= rotBounds.barY + 10);
    if (justPressed && onRot) { iron51.draggingRot = true; blurAll(iron51); }
    if (!isDown) iron51.draggingRot = false;
    if (iron51.draggingRot) {
      var relRot = clamp(mouseX - rotBounds.barX, 0, rotBounds.barW - 1);
      iron51.rotDeg = Math.round((relRot / (rotBounds.barW - 1)) * 360);
    }
    handleMouse('r', rB, mouseX, mouseY, isDown, justPressed, iron51, iron51Send);
    handleMouse('g', gB, mouseX, mouseY, isDown, justPressed, iron51, iron51Send);
    handleMouse('b', bB, mouseX, mouseY, isDown, justPressed, iron51, iron51Send);
    renderPlayer(iron51, e, width, height, iron51.rotDeg);
    var now = Date.now();
    if (now - iron51.lastTick >= TICK_MS) { iron51.lastTick = now; iron51Send(); }
  });

  function buildHexOnlyTab(state, tabIds, getProps, applyChannel) {
    PalladiumEvents.renderPowerScreen(function (e) {
      if (!e.tab) return;
      var id = String(e.tab);
      var match = false;
      for (var i = 0; i < tabIds.length; i++) { if (id === tabIds[i]) { match = true; break; } }
      if (!match) return;
      var mc = Minecraft.getInstance();
      var player = mc.player; if (!player) return;
      if (!state.hydrated) {
        state.hydrated = true;
        var props = getProps(state);
        var prim = palladium.getProperty(player, props.primary) | 0;
        var sec = palladium.getProperty(player, props.secondary) | 0;
        var v = state.labelIndex === 0 ? prim : sec;
        if (v > 0) {
          var c = intToRgb(v);
          state.rgb.r = c.r; state.rgb.g = c.g; state.rgb.b = c.b;
        }
      }
      var win = mc.getWindow().getWindow();
      var mouseX = e.mouseX, mouseY = e.mouseY;
      var isDown = GLFW.glfwGetMouseButton(win, GLFW.GLFW_MOUSE_BUTTON_LEFT) === GLFW.GLFW_PRESS;
      var justPressed = isDown && !state.wasDown; state.wasDown = isDown;
      var width = e.screen.width, height = e.screen.height;
      var cx = Math.floor(width / 2), cy = Math.floor(height / 2);
      var px = cx - Math.floor(PANEL_W / 2);
      var py = cy - Math.floor(PANEL_H / 2) + 6;
      RenderSystem.enableBlend();
      e.guiGraphics.blit(new ResourceLocation(PANEL_TEX), px, py, 0, 0, PANEL_W, PANEL_H, PANEL_W, PANEL_H);
      RenderSystem.disableBlend();
      var font = Minecraft.getInstance().font;
      var labelY = py + 46;
      var leftX = cx - 205;
      var rightX = cx - 135;
      state.leftBtn.x = leftX;
      state.leftBtn.y = labelY - Math.floor(state.leftBtn.h / 2);
      e.guiGraphics.blit(new ResourceLocation(SLIDER_ARROW_LEFT), state.leftBtn.x, state.leftBtn.y + 5, 0, 0, state.leftBtn.w, state.leftBtn.h, state.leftBtn.w, state.leftBtn.h);
      state.rightBtn.x = rightX;
      state.rightBtn.y = labelY - Math.floor(state.rightBtn.h / 2);
      e.guiGraphics.blit(new ResourceLocation(SLIDER_ARROW_RIGHT), state.rightBtn.x, state.rightBtn.y + 5, 0, 0, state.rightBtn.w, state.rightBtn.h, state.rightBtn.w, state.rightBtn.h);
      var labelText = state.labels[state.labelIndex];
      var labelWidth = font.width(labelText);
      var centerX = (leftX + rightX + state.leftBtn.w) / 2;
      var labelX = centerX - labelWidth / 2;
      drawOutlinedLabel(e.guiGraphics, labelText, labelX, labelY);
      if (justPressed) {
        if (mouseX >= state.leftBtn.x && mouseX <= state.leftBtn.x + state.leftBtn.w && mouseY >= state.leftBtn.y && mouseY <= state.leftBtn.y + state.leftBtn.h) {
          state.labelIndex = (state.labelIndex + state.labels.length - 1) % state.labels.length;
          state.hydrated = false;
        } else if (mouseX >= state.rightBtn.x && mouseX <= state.rightBtn.x + state.rightBtn.w && mouseY >= state.rightBtn.y && mouseY <= state.rightBtn.y + state.rightBtn.h) {
          state.labelIndex = (state.labelIndex + 1) % state.labels.length;
          state.hydrated = false;
        }
      }
      var sx = cx - 80;
      var sy = py + 63;
      var rB = drawSlider.call(state, e.guiGraphics, sx, sy + 0 * SLIDER.spacingY, state.rgb.r, 'r');
      var gB = drawSlider.call(state, e.guiGraphics, sx, sy + 1 * SLIDER.spacingY, state.rgb.g, 'g');
      var bB = drawSlider.call(state, e.guiGraphics, sx, sy + 2 * SLIDER.spacingY, state.rgb.b, 'b');
      drawOutlinedLabel(e.guiGraphics, 'R', sx - 130, sy - 4);
      drawOutlinedLabel(e.guiGraphics, 'G', sx - 130, sy + 8);
      drawOutlinedLabel(e.guiGraphics, 'B', sx - 130, sy + 20);
      ensureRGBBoxes(e.screen, state, { r: { x: rB.valueX, y: rB.valueY - 2 }, g: { x: gB.valueX, y: gB.valueY - 2 }, b: { x: bB.valueX, y: bB.valueY - 2 }, w: Math.max(18, font.width("255") + 4), h: 12 }, function () { });
      var rEditing = isF(state.rBox), gEditing = isF(state.gBox), bEditing = isF(state.bBox);
      if (state.rBox) state.rBox.setVisible(rEditing);
      if (state.gBox) state.gBox.setVisible(gEditing);
      if (state.bBox) state.bBox.setVisible(bEditing);
      if (!rEditing) drawOutlinedLabel(e.guiGraphics, String(state.rgb.r), rB.valueX, rB.valueY);
      if (!gEditing) drawOutlinedLabel(e.guiGraphics, String(state.rgb.g), gB.valueX, gB.valueY);
      if (!bEditing) drawOutlinedLabel(e.guiGraphics, String(state.rgb.b), bB.valueX, bB.valueY);
      var pvX = sx + SLIDER.width - 130 + state.PREVIEW.offsetX;
      ensureHexBox(e.screen, state, pvX, sy + 3 * SLIDER.spacingY + 2, function () { });
      var hexEditing = isF(state.hexBox);
      if (state.hexBox) state.hexBox.setVisible(hexEditing);
      if (!hexEditing) drawOutlinedLabel(e.guiGraphics, hex6(state.rgb.r, state.rgb.g, state.rgb.b), state.hexRect.x, state.hexRect.y);
      var pvY = sy + 3 * SLIDER.spacingY + 2 + state.hexRect.h + state.PREVIEW.offsetY;
      drawPreviewBox(e.guiGraphics, pvX, pvY, state.PREVIEW.w, state.PREVIEW.h, state.rgb.r, state.rgb.g, state.rgb.b);
      if (justPressed) {
        var wNum = Math.max(18, font.width("255") + 4), hNum = 12;
        var focused = false;
        if (clickIn(mouseX, mouseY, rB.valueX, rB.valueY - 2, wNum, hNum)) { focusOnly(state, state.rBox, String(state.rgb.r)); focused = true; }
        else if (clickIn(mouseX, mouseY, gB.valueX, gB.valueY - 2, wNum, hNum)) { focusOnly(state, state.gBox, String(state.rgb.g)); focused = true; }
        else if (clickIn(mouseX, mouseY, bB.valueX, bB.valueY - 2, wNum, hNum)) { focusOnly(state, state.bBox, String(state.rgb.b)); focused = true; }
        else if (clickIn(mouseX, mouseY, state.hexRect.x, state.hexRect.y, state.hexRect.w, state.hexRect.h)) { focusOnly(state, state.hexBox, hex6(state.rgb.r, state.rgb.g, state.rgb.b)); focused = true; }
        if (!focused) {
          commitRGBBox(state, state.rBox, 'r', function () { });
          commitRGBBox(state, state.gBox, 'g', function () { });
          commitRGBBox(state, state.bBox, 'b', function () { });
          commitHexBox(state, function () { });
        }
      }
      handleMouse('r', rB, mouseX, mouseY, isDown, justPressed, state, function () { });
      handleMouse('g', gB, mouseX, mouseY, isDown, justPressed, state, function () { });
      handleMouse('b', bB, mouseX, mouseY, isDown, justPressed, state, function () { });
      e.guiGraphics.blit(new ResourceLocation(SAVE_BTN_TEX), state.applyKnob.x - 60, state.applyKnob.y - 2, 0, 0, state.applyKnob.w, state.applyKnob.h - 2, state.applyKnob.w, state.applyKnob.h - 2);
      if (justPressed) {
        if (mouseX >= state.applyKnob.x - 60 && mouseX <= state.applyKnob.x - 60 + state.applyKnob.w && mouseY >= state.applyKnob.y - 2 && mouseY <= state.applyKnob.y - 2 + state.applyKnob.h) {
          var mode = state.labels[state.labelIndex].toLowerCase();
          var props = getProps(state);
          var payload = { hex: hexInt(state.rgb.r, state.rgb.g, state.rgb.b), mode: mode, props: [props.primary, props.secondary] };
          Client.player.sendData(applyChannel, payload);
        }
      }
    });
  }

  var electro = makeState();
  electro.labels = ['Primary', 'Secondary'];
  buildHexOnlyTab(electro, ['fsang:electrokinesis'], function () { return { primary: 'fsang_electrokinesis', secondary: 'fsang_electrokinesis2' }; }, "fsang:apply_electro_hex");

  var speed = makeState();
  speed.labels = ['Primary', 'Secondary'];
  buildHexOnlyTab(
    speed,
    ['fsang:speedforce', 'fsang:speedforce_god', 'fsang:speedforce_leech', 'fsang:speedforce_negative', 'fsang:speedforce_speed', 'fsang:speedforce_strength', 'fsang:speedforce_tachyon'],
    function () { return { primary: 'fsang_speed_trail1', secondary: 'fsang_speed_trail2' }; },
    "fsang:apply_speedtrail_hex"
  );
})();
