// Define the chance for the symbiote transformation (e.g., 100% for testing)
const KAIJU_CHANCE = 0.05; // 5% chance

EntityEvents.spawned(event => {
    const { entity, world } = event;

    // Check if the spawned entity is a silverfish
    if (entity.type === 'minecraft:silverfish') {
        // Generate a random number between 0 and 1
        let random = Math.random();

        if (random <= KAIJU_CHANCE) {
            entity.maxHealth = 20;
            entity.health = 20;
            entity.silent = true;
            entity.getAttribute("generic.max_health").baseValue = 20;

            entity.addTag("FSang.Kaiju.Spawn");
        }
    }
});
