BlockEvents.rightClicked('fsang:mjolnir_block', event => {
    const { player, hand, server, block } = event;
    const heldItem = player.getItemInHand(hand);

    // Require empty hand
    if (heldItem.id !== 'minecraft:air') return;

    // Require FSang.Karma >= 1000
    const karma = palladium.scoreboard.getScore(player, 'FSang.Karma', 0);
    const username = player.getGameProfile().getName();

    if (karma < 1000) {
        server.runCommandSilent(`execute as ${username} run title ${username} actionbar ["",{"text":"You are not Worthy ","color":"dark_red"},"(",{"score":{"objective":"FSang.Karma","name":"@s"}},"/1000)"]`);
        return;
    }

    // Replace the clicked block with air
    block.set('minecraft:air');

    // Positive feedback
    server.runCommandSilent(`title ${username} actionbar {"text":"You are Worthy","color":"gold"}`);

    // Give named Mjolnir shortly after
    server.scheduleInTicks(1, () => {
        const nameJson = JSON.stringify({ text: `${username}'s Mjolnir`, italic: true });
        player.give(Item.of('fsang:mjolnir', { display: { Name: nameJson } }));
    });
});


BlockEvents.rightClicked('fsang:stormbreaker_block', event => {
    const { player, hand, server, block } = event;
    const heldItem = player.getItemInHand(hand);

    // Require empty hand
    if (heldItem.id !== 'minecraft:air') return;

    // Require FSang.Karma >= 1000
    const karma = palladium.scoreboard.getScore(player, 'FSang.Karma', 0);
    const username = player.getGameProfile().getName();

    if (karma < 600) {
        server.runCommandSilent(`execute as ${username} run title ${username} actionbar ["",{"text":"You are not Worthy ","color":"dark_red"},"(",{"score":{"objective":"FSang.Karma","name":"@p"}},"/600)"]`);
        return;
    }

    // Replace the clicked block with air
    block.set('minecraft:air');

    // Positive feedback
    server.runCommandSilent(`title ${username} actionbar {"text":"You are Worthy","color":"gold"}`);

    // Give named stormbreaker shortly after
    server.scheduleInTicks(1, () => {
        const nameJson = JSON.stringify({ text: `${username}'s Stormbreaker`, italic: true });
        player.give(Item.of('fsang:stormbreaker', { display: { Name: nameJson } }));
    });
});

BlockEvents.rightClicked('fsang:neptune_trident_block', event => {
    const { player, hand, server, block } = event;
    const heldItem = player.getItemInHand(hand);

    // Require empty hand
    if (heldItem.id !== 'minecraft:air') return;

    // Replace the clicked block with air
    block.set('minecraft:air');

    // Give named stormbreaker shortly after
    server.scheduleInTicks(1, () => {
        player.give(Item.of('fsang:neptune_trident'));
    });
});