// Firstly, register the property in the entity
PalladiumEvents.registerProperties((event) => {
    // Only register for players
    if (event.getEntityType() === "minecraft:player") {
        // Arguments: Key of the property, type of the property, default/starting value
        event.registerProperty('asgardian_target', 'string', 'minecraft:air');
        event.registerProperty('asgardian_dim', 'string', 'minecraft:air');
        event.registerProperty('asgardian_x', 'integer', 0);
        event.registerProperty('asgardian_y', 'integer', 0);
        event.registerProperty('asgardian_z', 'integer', 0);
        event.registerProperty('fsang_r', 'integer', 0);
        event.registerProperty('fsang_g', 'integer', 0);
        event.registerProperty('fsang_b', 'integer', 0);
        event.registerProperty('fsang_cape_r', 'integer', 0);
        event.registerProperty('fsang_cape_g', 'integer', 0);
        event.registerProperty('fsang_cape_b', 'integer', 0);
        event.registerProperty('fsang_jacket_color', 'integer', 0);
        event.registerProperty('fsang_jacket_r', 'integer', 0);
        event.registerProperty('fsang_jacket_g', 'integer', 0);
        event.registerProperty('fsang_jacket_b', 'integer', 0);
        event.registerProperty('fsang_jacket_color2', 'integer', 0);
        event.registerProperty('fsang_jacket_r2', 'integer', 0);
        event.registerProperty('fsang_jacket_g2', 'integer', 0);
        event.registerProperty('fsang_jacket_b2', 'integer', 0);
        event.registerProperty('fsang_hood_color', 'integer', 0);
        event.registerProperty('fsang_hood_r', 'integer', 0);
        event.registerProperty('fsang_hood_g', 'integer', 0);
        event.registerProperty('fsang_hood_b', 'integer', 0);
        event.registerProperty('fsang_inner_cape_r', 'integer', 0);
        event.registerProperty('fsang_inner_cape_g', 'integer', 0);
        event.registerProperty('fsang_inner_cape_b', 'integer', 0);
        event.registerProperty('cape_type', 'string', 'fsang:cape_white');
        event.registerProperty('fsang_speed_trail1', 'integer', 0);
        event.registerProperty('fsang_speed_trail2', 'integer', 0);
        event.registerProperty('fsang_electrokinesis', 'integer', 0);
        event.registerProperty('fsang_electrokinesis2', 'integer', 0);
        event.registerProperty('fsang_electrokinesis_r', 'integer', 0);
        event.registerProperty('fsang_electrokinesis_g', 'integer', 0);
        event.registerProperty('fsang_electrokinesis_b', 'integer', 0);
        event.registerProperty('cursed_energy', 'integer', 0);
        event.registerProperty('name_changer', 'string', 'minecraft:air');
        event.registerProperty('skin_change', 'string', 'minecraft:air');
        event.registerProperty('Martian.Skin.1', 'string', 'minecraft:air');
        event.registerProperty('Martian.Skin.2', 'string', 'minecraft:air');
        event.registerProperty('Martian.Skin.3', 'string', 'minecraft:air');
        event.registerProperty('Martian.Skin.4', 'string', 'minecraft:air');
        event.registerProperty('Martian.Skin.5', 'string', 'minecraft:air');
        event.registerProperty('standing_on_block', 'string', 'minecraft:stone');
        event.registerProperty('fsang_speedster_speed', 'integer', 0);
        event.registerProperty('fsang_speedster_speedforce', 'integer', 0);
        event.registerProperty('fsang_living_speed', 'integer', 5);
        event.registerProperty('fsang_jacket_color_slide', 'string', "ffffff");
        event.registerProperty('fsang_reactor_r', 'integer', 0);
        event.registerProperty('fsang_reactor_g', 'integer', 0);
        event.registerProperty('fsang_reactor_b', 'integer', 0);
        event.registerProperty('fsang_menu_r', 'integer', 0);
        event.registerProperty('fsang_menu_g', 'integer', 0);
        event.registerProperty('fsang_menu_b', 'integer', 0);
        event.registerProperty('fsang_51_main_r', 'integer', 158);
        event.registerProperty('fsang_51_main_g', 'integer', 23);
        event.registerProperty('fsang_51_main_b', 'integer', 0);
        event.registerProperty('fsang_51_second_r', 'integer', 255);
        event.registerProperty('fsang_51_second_g', 'integer', 212);
        event.registerProperty('fsang_51_second_b', 'integer', 94);
    }
    if (event.getEntityType() === "palladium:custom_projectile") {
        event.registerProperty('fsang_speed_trail1', 'integer', 0);
        event.registerProperty('fsang_speed_trail2', 'integer', 0);
    }
    if (event.getEntityType() !== "minecraft:player") {
        event.registerProperty('fsang_living_speed', 'integer', 3);
    }
});
PlayerEvents.loggedIn(event => {
    const p = event.player;
    if (!p) return;
    if (!palladium.hasProperty(p, 'name_changer')) return;

    const raw = String(palladium.getProperty(p, 'name_changer') ?? '').trim().toLowerCase();
    if (raw === '' || raw === 'minecraft:air' || raw === 'air' || raw === 'null' || raw === 'none') {
        const username = p.getGameProfile().getName();
        palladium.setProperty(p, 'name_changer', username);
    }
});

PlayerEvents.tick(event => {
    const player = event.player;
    // Safety net: if name_changer is ever empty, set it to username
    if (palladium.hasProperty(player, 'name_changer')) {
        const current = String(palladium.getProperty(player, 'name_changer') ?? '').trim();
        if (current === '' || current === 'minecraft:air' || current === 'air') {
            palladium.setProperty(player, 'name_changer', player.getGameProfile().getName());
        }
    }


    // Pre-determined list of allowed blocks (use block IDs as strings)
    const allowedBlocks = [
        //wood level tools
        "minecraft:oak_log", "minecraft:stripped_oak_log", "minecraft:oak_planks",
        "minecraft:spruce_log", "minecraft:stripped_spruce_log", "minecraft:spruce_planks",
        "minecraft:birch_log", "minecraft:stripped_birch_log", "minecraft:birch_planks",
        "minecraft:jungle_log", "minecraft:stripped_jungle_log", "minecraft:jungle_planks",
        "minecraft:acacia_log", "minecraft:stripped_acacia_log", "minecraft:acacia_planks",
        "minecraft:dark_oak_log", "minecraft:stripped_dark_oak_log", "minecraft:dark_oak_planks",
        "minecraft:mangrove_log", "minecraft:stripped_mangrove_log", "minecraft:mangrove_planks",
        "minecraft:cherry_log", "minecraft:stripped_cherry_log", "minecraft:cherry_planks",
        "minecraft:grass_block", "minecraft:dirt", "minecraft:coarse_dirt",
        "minecraft:sand", "minecraft:red_sand", "minecraft:sponge",
        "minecraft:honey_block", "minecraft:slime_block", "minecraft:glowstone",

        //stone level tools
        "minecraft:stone", "minecraft:andesite", "minecraft:diorite",
        "minecraft:cobblestone", "minecraft:mossy_cobblestone", "minecraft:smooth_stone",
        "minecraft:stone_bricks", "minecraft:mossy_stone_bricks",
        "minecraft:gravel",
        "minecraft:red_sandstone", "minecraft:sandstone",
        "minecraft:granite", "minecraft:bone_block", "minecraft:amethyst_block",
        "minecraft:magma_block", "minecraft:iron_ore",

        //iron level tools
        "minecraft:iron_block",
        "minecraft:ice", "minecraft:blue_ice", "minecraft:snow_block",

        //gold level tools
        "minecraft:gold_ore", "minecraft:gold_block",
        "minecraft:diamond_ore", "fsang:kryptonite_ore",

        //diamond level tools 
        "minecraft:diamond_block",
        "minecraft:obsidian",
        "fsang:kryptonite_block", "minecraft:ancient_debris",
        "fsang:uru_ore", "fsang:adamantium_ore", "palladium:vibranium_ore",

        //netherite level tools
        "minecraft:netherite_block",
        "palladium:vibranium_block",
        "fsang:uru_block",
        "fsang:adamantium_block"
    ];

    if (palladium.hasProperty(player, 'standing_on_block') && !palladium.abilities.isUnlocked(player, 'fsang:matter_absorption', 'matter_absorption_partial_control')) {
        let blockId = player.getBlock().getDown().getId();

        if (allowedBlocks.includes(blockId)) {
            // Keep just the block name (without namespace) if you want consistency
            palladium.setProperty(player, 'standing_on_block', blockId.split(":")[1]);
        } else {
            // Not in the list → default to "air"
            palladium.setProperty(player, 'standing_on_block', "air");
        }
    }
    else if (palladium.hasProperty(player, 'standing_on_block') && palladium.abilities.isUnlocked(player, 'fsang:matter_absorption', 'matter_absorption_partial_control') & !palladium.abilities.isUnlocked(player, 'fsang:matter_absorption', 'matter_absorption_storage_purchase')) {
        let heldItem = player.offHandItem;
        if (!heldItem.isEmpty() && allowedBlocks.includes(heldItem.id)) {
            // Store the block name (without namespace)
            palladium.setProperty(player, 'standing_on_block', heldItem.id.split(":")[1]);
        }
        else {
            palladium.setProperty(player, 'standing_on_block', "air");
        }
    }
    else if (
        palladium.hasProperty(player, 'standing_on_block') &&
        palladium.abilities.isUnlocked(player, 'fsang:matter_absorption', 'matter_absorption_storage_purchase')
    ) {
        let storedItem = player.persistentData.get('fsang.matter_absorption.off'); // get the stored ItemStack

        if (!storedItem || storedItem.id === 'minecraft:air') {
            // Only set to air if player does NOT have FSang.MA.Held tag
            if (!player.tags.contains("FSang.MA.Change")) {
                palladium.setProperty(player, 'standing_on_block', "air");
            }
        } else {
            // Store just the block/item name without the namespace
            palladium.setProperty(player, 'standing_on_block', storedItem.id.split(":")[1]);
        }
    }

});


const SCARAB_COLOR_MAP = {
    0: [3, 68, 142],
    1: [80, 80, 80],
    2: [133, 91, 55],
    3: [0, 255, 243],
    4: [0, 97, 20],
    5: [36, 174, 0],
    6: [254, 106, 0],
    7: [255, 24, 174],
    8: [90, 50, 158],
    9: [116, 14, 0],
    10: [234, 234, 234],
    11: [255, 227, 0]
};

function applyRGBProps(player, r, g, b) {
    if (!palladium.hasProperty(player, 'fsang_r')) return;
    if (!palladium.hasProperty(player, 'fsang_g')) return;
    if (!palladium.hasProperty(player, 'fsang_b')) return;

    // Only write when something actually changes (avoids ticking spam)
    const curR = palladium.getProperty(player, 'fsang_r') ?? 0;
    const curG = palladium.getProperty(player, 'fsang_g') ?? 0;
    const curB = palladium.getProperty(player, 'fsang_b') ?? 0;

    if (curR !== r) palladium.setProperty(player, 'fsang_r', r);
    if (curG !== g) palladium.setProperty(player, 'fsang_g', g);
    if (curB !== b) palladium.setProperty(player, 'fsang_b', b);
}

// Do the check on login and every tick (lightweight comparison)
PlayerEvents.loggedIn(event => {
    const p = event.player;
    const score = palladium.scoreboard.getScore(p, 'FSang.Scarab.Color', -1);
    const rgb = SCARAB_COLOR_MAP[score];
    if (rgb) applyRGBProps(p, rgb[0], rgb[1], rgb[2]);
});

PlayerEvents.tick(event => {
    const p = event.player;
    const score = palladium.scoreboard.getScore(p, 'FSang.Scarab.Color', -1);
    const rgb = SCARAB_COLOR_MAP[score];
    if (rgb) applyRGBProps(p, rgb[0], rgb[1], rgb[2]);
});

const TRAIL1_COLORS = {
    0: 0xffd100,
    1: 0xffd100,
    2: 0x8019c0,
    3: 0x006700,
    4: 0xf782a1,
    5: 0x0000b3,
    6: 0xb36621,
    7: 0xffffff,
    8: 0x00b3b3,
    9: 0xcc0000,
    10: 0x000000
};

const TRAIL2_COLORS = {
    0: 0xff9000,
    1: 0xffd100,
    2: 0xa020f0,
    3: 0x00ff00,
    4: 0xf33a6a,
    5: 0x0000ff,
    6: 0xe6832a,
    7: 0xfaf9f6,
    8: 0x00ffff,
    9: 0xff0000,
    10: 0x262626
};

const SPEEDFORCE_POWERS = [
    'fsang:speedforce',
    'fsang:speedforce_god',
    'fsang:speedforce_speed',
    'fsang:speedforce_strength',
    'fsang:speedforce_leech',
    'fsang:speedforce_negative',
    'fsang:speedforce_tachyon'
];

function hasAnySpeedforcePower(player) {
    if (palladium?.superpowers?.hasSuperpower) {
        return SPEEDFORCE_POWERS.some(p => palladium.superpowers.hasSuperpower(player, p));
    }
    return false;
}

function applySpeedTrails(player) {
    if (!palladium.hasProperty(player, 'fsang_speed_trail1')) return;
    if (!palladium.hasProperty(player, 'fsang_speed_trail2')) return;

    const score = palladium.scoreboard.getScore(player, 'SpeedsterTrail', -1);
    const c1 = TRAIL1_COLORS[score];
    const c2 = TRAIL2_COLORS[score];
    if (c1 === undefined || c2 === undefined) return;

    const cur1 = palladium.getProperty(player, 'fsang_speed_trail1') ?? 0;
    const cur2 = palladium.getProperty(player, 'fsang_speed_trail2') ?? 0;

    if (cur1 !== c1) palladium.setProperty(player, 'fsang_speed_trail1', c1);
    if (cur2 !== c2) palladium.setProperty(player, 'fsang_speed_trail2', c2);
}

ServerEvents.commandRegistry(e => {
    const { commands: Commands, arguments: Arguments } = e;
    const HEX_RE = /^[0-9a-fA-F]{6}$/;

    function resolveProp(which) {
        which = (which || "").toLowerCase();
        if (which === 'primary') return 'fsang_speed_trail1';
        if (which === 'secondary') return 'fsang_speed_trail2';
        return null;
    }

    e.register(
        Commands.literal('FSang.SpeedTrail')
            .requires(src => src.hasPermission(0))
            .then(
                Commands.literal('set')
                    .then(
                        Commands.argument('which', Arguments.STRING.create(e))
                            .suggests((ctx, b) => {
                                b.suggest('primary');
                                b.suggest('secondary');
                                return b.buildFuture();
                            })
                            .then(
                                Commands.argument('hex', Arguments.STRING.create(e)).executes(ctx => {
                                    const player = ctx.source.player;
                                    if (!player) return 0;

                                    if (!hasAnySpeedforcePower(player)) {
                                        player.tell('§cYou do not have any Speedforce powers.');
                                        return 0;
                                    }

                                    const which = Arguments.STRING.getResult(ctx, 'which');
                                    const prop = resolveProp(which);
                                    if (!prop) {
                                        player.tell('§cPick "primary" or "secondary".');
                                        return 0;
                                    }
                                    if (!palladium.hasProperty(player, prop)) {
                                        player.tell(`§cMissing property: ${prop}`);
                                        return 0;
                                    }

                                    const hexIn = Arguments.STRING.getResult(ctx, 'hex').replace('#', '').trim();
                                    if (!HEX_RE.test(hexIn)) {
                                        player.tell('§cInvalid hex. Use exactly 6 hex digits, no "#". Example: 296AD4');
                                        return 0;
                                    }

                                    const value = parseInt(hexIn, 16);
                                    palladium.setProperty(player, prop, value);
                                    player.tell(`§aSet ${which.toLowerCase()} color to #${hexIn.toUpperCase()}.`);
                                    return 1;
                                })
                            )
                    )
            )
            .then(
                Commands.literal('get')
                    .then(
                        Commands.argument('which', Arguments.STRING.create(e))
                            .suggests((ctx, b) => {
                                b.suggest('primary');
                                b.suggest('secondary');
                                return b.buildFuture();
                            })
                            .executes(ctx => {
                                const player = ctx.source.player;
                                if (!player) return 0;

                                if (!hasAnySpeedforcePower(player)) {
                                    player.tell('§cYou do not have any Speedforce powers.');
                                    return 0;
                                }

                                const which = Arguments.STRING.getResult(ctx, 'which');
                                const prop = resolveProp(which);
                                if (!prop) {
                                    player.tell('§cPick "primary" or "secondary".');
                                    return 0;
                                }
                                if (!palladium.hasProperty(player, prop)) {
                                    player.tell(`§cMissing property: ${prop}`);
                                    return 0;
                                }

                                const val = palladium.getProperty(player, prop);
                                // Ensure 6-digit uppercase hex, zero-padded
                                const hex = (Number(val) >>> 0).toString(16).toUpperCase().padStart(6, '0');
                                player.tell(`§eYour ${which.toLowerCase()} trail color is #${hex}.`);
                                return 1;
                            })
                    )
            )
    );
});

