const superSoldierWeights = [
    { power: "fsang:super_soldier", weight: 4, name: "Steve" },
    { power: "fsang:super_soldier_winter_soldier", weight: 2, name: "Winter Soldier" },
    { power: "fsang:super_soldier_red_skull", weight: 2, name: "Red Skull" }
];

function getRandomSoldierPower() {
    const totalWeight = superSoldierWeights.reduce((acc, mutation) => acc + mutation.weight, 0);
    let random = Math.random() * totalWeight;

    for (const mutation of superSoldierWeights) {
        if (random < mutation.weight) {
            return mutation;
        }
        random -= mutation.weight;
    }
}
function getRandomScore(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

ItemEvents.rightClicked(event => {
    const { hand, player, server, player: { username, mainHandItem, offhandItem } } = event;

    if (mainHandItem.id == "fsang:super_soldier_serum") {
        const selectedPower2 = getRandomSoldierPower(superSoldierWeights.power);
        player.setItemInHand(hand, "minecraft:air")

        server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

        superpowerUtil.addSuperpower(player, selectedPower2.power);
        player.tell(`You have been granted the Super Soldier Variant: ${selectedPower2.name}`);
    }
});
