function clamp01(v) { v = v | 0; return v < 0 ? 0 : (v > 255 ? 255 : v) }

NetworkEvents.dataReceived("fsang:apply_iron51_rgb", event => {
    const p = event.entity || event.player; if (!p) return
    const d = event.data || {}
    const r = clamp01(d.r), g = clamp01(d.g), b = clamp01(d.b)

    if (Array.isArray(d.props) && d.props.length === 3) {
        palladium.setProperty(p, String(d.props[0]), r)
        palladium.setProperty(p, String(d.props[1]), g)
        palladium.setProperty(p, String(d.props[2]), b)
        return
    }

    const mode = String(d.mode || "primary").toLowerCase()
    if (mode === "secondary") {
        palladium.setProperty(p, "fsang_51_second_r", r)
        palladium.setProperty(p, "fsang_51_second_g", g)
        palladium.setProperty(p, "fsang_51_second_b", b)
    } else {
        palladium.setProperty(p, "fsang_51_main_r", r)
        palladium.setProperty(p, "fsang_51_main_g", g)
        palladium.setProperty(p, "fsang_51_main_b", b)
    }
})

NetworkEvents.dataReceived("fsang:sync_rgb", event => {
    const p = event.entity || event.player; if (!p) return
    const d = event.data || {}
    const r = clamp01(d.r), g = clamp01(d.g), b = clamp01(d.b)

    palladium.setProperty(p, "fsang_menu_r", r)
    palladium.setProperty(p, "fsang_menu_g", g)
    palladium.setProperty(p, "fsang_menu_b", b)

    if (d.iron51 === true) {
        const mode = String(d.mode || "primary").toLowerCase()
        if (mode === "secondary") {
            palladium.setProperty(p, "fsang_51_second_r", r)
            palladium.setProperty(p, "fsang_51_second_g", g)
            palladium.setProperty(p, "fsang_51_second_b", b)
        } else {
            palladium.setProperty(p, "fsang_51_main_r", r)
            palladium.setProperty(p, "fsang_51_main_g", g)
            palladium.setProperty(p, "fsang_51_main_b", b)
        }
    }
})

NetworkEvents.dataReceived("fsang:apply_jacket_rgb", event => {
    let player = event.entity || event.player;
    if (!player) return;

    let data = event.data || {};
    let r = Math.max(0, Math.min(255, (data.r | 0)));
    let g = Math.max(0, Math.min(255, (data.g | 0)));
    let b = Math.max(0, Math.min(255, (data.b | 0)));
    let mode = String(data.mode || "primary").toLowerCase();

    if (mode === "secondary") {
        palladium.setProperty(player, "fsang_jacket_r2", r);
        palladium.setProperty(player, "fsang_jacket_g2", g);
        palladium.setProperty(player, "fsang_jacket_b2", b);
    } else if (mode === "hood") {
        palladium.setProperty(player, "fsang_hood_r", r);
        palladium.setProperty(player, "fsang_hood_g", g);
        palladium.setProperty(player, "fsang_hood_b", b);
    } else {
        palladium.setProperty(player, "fsang_jacket_r", r);
        palladium.setProperty(player, "fsang_jacket_g", g);
        palladium.setProperty(player, "fsang_jacket_b", b);
    }
})

NetworkEvents.dataReceived("fsang:apply_reactor_rgb", event => {
    let player = event.entity || event.player;
    if (!player) return;
    let data = event.data || {};
    let r = Math.max(0, Math.min(255, (data.r | 0)));
    let g = Math.max(0, Math.min(255, (data.g | 0)));
    let b = Math.max(0, Math.min(255, (data.b | 0)));
    palladium.setProperty(player, "fsang_reactor_r", r);
    palladium.setProperty(player, "fsang_reactor_g", g);
    palladium.setProperty(player, "fsang_reactor_b", b);
})

function clampHex24(v) { v = v | 0; if (v < 0) v = 0; if (v > 0xFFFFFF) v = 0xFFFFFF; return v; }

NetworkEvents.dataReceived("fsang:apply_electro_hex", event => {
    const p = event.entity || event.player; if (!p) return;
    const d = event.data || {};
    const hex = clampHex24(d.hex);
    const mode = String(d.mode || "primary").toLowerCase();
    if (mode === "secondary") {
        palladium.setProperty(p, "fsang_electrokinesis2", hex);
    } else {
        palladium.setProperty(p, "fsang_electrokinesis", hex);
    }
})

NetworkEvents.dataReceived("fsang:apply_speedtrail_hex", event => {
    const p = event.entity || event.player; if (!p) return;
    const d = event.data || {};
    const hex = clampHex24(d.hex);
    const mode = String(d.mode || "primary").toLowerCase();
    if (mode === "secondary") {
        palladium.setProperty(p, "fsang_speed_trail2", hex);
    } else {
        palladium.setProperty(p, "fsang_speed_trail1", hex);
    }
})
NetworkEvents.dataReceived("fsang:apply_cape_rgb", event => {
    const p = event.entity || event.player
    if (!p) return
    const d = event.data || {}
    const r = Math.max(0, Math.min(255, (d.r | 0)))
    const g = Math.max(0, Math.min(255, (d.g | 0)))
    const b = Math.max(0, Math.min(255, (d.b | 0)))
    const mode = String(d.mode || "primary").toLowerCase()

    if (mode === "secondary") {
        palladium.setProperty(p, "fsang_inner_cape_r", r)
        palladium.setProperty(p, "fsang_inner_cape_g", g)
        palladium.setProperty(p, "fsang_inner_cape_b", b)
    } else {
        palladium.setProperty(p, "fsang_cape_r", r)
        palladium.setProperty(p, "fsang_cape_g", g)
        palladium.setProperty(p, "fsang_cape_b", b)
    }
})
