/*
 * Decompiled with CFR 0.152.
 */
package com.spl.xyz;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"simpleplayerlogger.events");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Path JOIN_LOG = Paths.get("logs", "player_joins.log");
    private static final Path CHAT_LOG = Paths.get("logs", "chat_messages.log");
    private static final Path COMMAND_LOG = Paths.get("logs", "commands.log");

    public static void registerEvents() {
        LOGGER.debug("Registering event handlers");
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerLoggedInEvent.class, event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                EventHandler.logToFile(JOIN_LOG, String.format("[%s] Player %s (%s) joined", FORMATTER.format(LocalDateTime.now()), player.getName().getString(), player.getUUID()));
            }
        });
        NeoForge.EVENT_BUS.addListener(PlayerEvent.PlayerLoggedOutEvent.class, event -> {
            Player patt0$temp = event.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                EventHandler.logToFile(JOIN_LOG, String.format("[%s] Player %s (%s) left", FORMATTER.format(LocalDateTime.now()), player.getName().getString(), player.getUUID()));
            }
        });
        NeoForge.EVENT_BUS.addListener(ServerChatEvent.class, event -> {
            ServerPlayer player = event.getPlayer();
            EventHandler.logToFile(CHAT_LOG, String.format("[%s] %s: %s", FORMATTER.format(LocalDateTime.now()), player.getName().getString(), event.getMessage().getString()));
        });
        NeoForge.EVENT_BUS.addListener(ServerStartingEvent.class, event -> LOGGER.debug("Server starting, initializing command logging"));
        NeoForge.EVENT_BUS.addListener(ServerStoppingEvent.class, event -> LOGGER.info("Server stopping, finalizing logs"));
    }

    public static void logCommand(String command, ServerPlayer player) {
        EventHandler.logToFile(COMMAND_LOG, String.format("[%s] %s executed: %s", FORMATTER.format(LocalDateTime.now()), player != null ? player.getName().getString() : "Server", command));
    }

    private static void logToFile(Path path, String message) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)(message + System.lineSeparator()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            LOGGER.debug("Logged to {}: {}", (Object)path, (Object)message);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write to {}: {}", (Object)path, (Object)e.getMessage());
        }
    }
}

