/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tysontheember.apertureapi.ICameraModifier;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(modid="apertureapi", value={Dist.CLIENT})
public class CameraModifierManager {
    private static final HashMap<String, Modifier> modifiersH = new HashMap();
    private static final HashMap<String, Modifier> modifiersL = new HashMap();
    private static final HashMap<String, Modifier> modifiersB = new HashMap();
    private static final HashMap<String, Modifier>[] positiveModifiers = new HashMap[]{modifiersH, modifiersL};
    private static final HashMap<String, Modifier>[] negativeModifiers = new HashMap[]{modifiersL, modifiersH};
    private static final List<String> playerOrder = new ArrayList<String>();
    private static final List<String> playerRemovedBackground = new ArrayList<String>();
    private static final Vector3d globalPos = new Vector3d();
    private static final Vector3d globalPosO = new Vector3d();
    private static final Vector3d selfPos = new Vector3d();
    private static final Vector3d selfPosO = new Vector3d();
    private static final Vector3f rotation = new Vector3f();
    private static final Vector3f rotationO = new Vector3f();
    private static double FOV;
    private static double FOV_O;
    private static int STATE;
    private static int STATE_O;
    private static final Vector3f ROT_RESULT;

    public static void modify() {
        CameraModifierManager.cleanCache();
        CameraModifierManager.applyPlayerOrderModifier();
        if (!CameraModifierManager.isStateEnabledOr(1)) {
            CameraModifierManager.applyEffectiveModifierFromPositive();
        }
        CameraModifierManager.applyBackgroundModifier();
        if (!CameraModifierManager.isStateEnabledOr(1)) {
            CameraModifierManager.cleanCache();
            CameraModifierManager.saveToOld();
            return;
        }
        float partialTick = CameraModifierManager.getPartialTickTime();
        Entity entity = CameraModifierManager.camera().m_90592_();
        float yRot = entity.m_146908_() % 360.0f;
        CameraModifierManager.applyModifyToPos(partialTick, yRot, entity);
        CameraModifierManager.applyModifyToRot(partialTick, yRot);
        CameraModifierManager.saveToOld();
    }

    private static void applyPlayerOrderModifier() {
        for (int i = playerOrder.size() - 1; i >= 0; --i) {
            String id = playerOrder.get(i);
            Modifier modifier = CameraModifierManager.findModifierFromNegativeById(id);
            if (modifier == null || !modifier.isStateEnabledOr(1) || !modifier.isEffective || !modifier.isStateEnabledOr(14)) continue;
            CameraModifierManager.applyValue(modifier);
            return;
        }
    }

    @Nullable
    private static Modifier findModifierFromNegativeById(String modId) {
        HashMap<String, Modifier> map;
        Modifier modifier = null;
        HashMap<String, Modifier>[] hashMapArray = negativeModifiers;
        int n = hashMapArray.length;
        for (int i = 0; i < n && (modifier = (map = hashMapArray[i]).get(modId)) == null; ++i) {
        }
        return modifier;
    }

    private static void applyEffectiveModifierFromPositive() {
        for (HashMap<String, Modifier> map : positiveModifiers) {
            Modifier modifier = CameraModifierManager.getEffectiveModifierFromMap(map);
            if (modifier == null) continue;
            CameraModifierManager.applyValue(modifier);
            return;
        }
    }

    @Nullable
    private static Modifier getEffectiveModifierFromMap(HashMap<String, Modifier> map) {
        for (Modifier modifier : map.values()) {
            if (!modifier.isStateEnabledOr(1) || !modifier.isEffective || !modifier.isStateEnabledOr(14)) continue;
            return modifier;
        }
        return null;
    }

    private static void applyBackgroundModifier() {
        for (int i = playerRemovedBackground.size() - 1; i >= 0; --i) {
            String modId = playerRemovedBackground.get(i);
            Modifier modifier = modifiersB.get(modId);
            if (modifier == null) {
                playerRemovedBackground.remove(i);
                continue;
            }
            modifier.isEffective = false;
        }
        for (Modifier modifier : modifiersB.values()) {
            if (!modifier.isStateEnabledOr(1) || !modifier.isEffective || !modifier.isStateEnabledOr(14)) continue;
            CameraModifierManager.applyValue(modifier);
        }
    }

    private static void applyValue(Modifier modifier) {
        STATE |= modifier.state;
        if (modifier.isStateEnabledOr(2)) {
            if (modifier.isStateEnabledOr(32)) {
                globalPos.add((Vector3dc)modifier.pos);
            } else {
                selfPos.add((Vector3dc)modifier.pos);
            }
        }
        if (CameraModifierManager.isStateEnabledOr(4)) {
            rotation.add((Vector3fc)modifier.rot);
        }
        if (CameraModifierManager.isStateEnabledOr(8)) {
            FOV += modifier.fov;
        }
    }

    private static void saveToOld() {
        globalPosO.set((Vector3dc)globalPos);
        selfPosO.set((Vector3dc)selfPos);
        rotationO.set((Vector3fc)rotation);
        FOV_O = FOV;
        STATE_O = STATE;
    }

    private static void applyModifyToRot(float partialTick, float yRot) {
        Vector3f rot;
        if (!CameraModifierManager.isStateEnabledOr(4)) {
            return;
        }
        if (CameraModifierManager.isStateEnabledOr(32)) {
            rot = CameraModifierManager.isOldStateEnabledAnd(69) ? new Vector3f(Mth.m_14179_((float)partialTick, (float)CameraModifierManager.rotationO.x, (float)CameraModifierManager.rotation.x), Mth.m_14179_((float)partialTick, (float)CameraModifierManager.rotationO.y, (float)CameraModifierManager.rotation.y), Mth.m_14179_((float)partialTick, (float)CameraModifierManager.rotationO.z, (float)CameraModifierManager.rotation.z)) : rotation;
        } else {
            rot = new Vector3f(0.0f, yRot, 0.0f);
            if (CameraModifierManager.isOldStateEnabledAnd(69)) {
                rot.add(Mth.m_14179_((float)partialTick, (float)CameraModifierManager.rotationO.x, (float)CameraModifierManager.rotation.x), Mth.m_14179_((float)partialTick, (float)CameraModifierManager.rotationO.y, (float)CameraModifierManager.rotation.y), Mth.m_14179_((float)partialTick, (float)CameraModifierManager.rotationO.z, (float)CameraModifierManager.rotation.z));
            } else {
                rot.add((Vector3fc)rotation);
            }
        }
        ROT_RESULT.set((Vector3fc)rot);
    }

    private static void applyModifyToPos(float partialTick, float yRot, Entity entity) {
        Vector3d pos;
        if (!CameraModifierManager.isStateEnabledOr(2)) {
            return;
        }
        if (CameraModifierManager.isStateEnabledOr(32)) {
            pos = CameraModifierManager.isOldStateEnabledAnd(99) ? new Vector3d(Mth.m_14139_((double)partialTick, (double)CameraModifierManager.globalPosO.x, (double)CameraModifierManager.globalPos.x), Mth.m_14139_((double)partialTick, (double)CameraModifierManager.globalPosO.y, (double)CameraModifierManager.globalPos.y), Mth.m_14139_((double)partialTick, (double)CameraModifierManager.globalPosO.z, (double)CameraModifierManager.globalPos.z)) : new Vector3d((Vector3dc)globalPos);
        } else {
            pos = CameraModifierManager.isOldStateEnabledAnd(67) && !CameraModifierManager.isOldStateEnabledOr(32) ? new Vector3d(Mth.m_14139_((double)partialTick, (double)CameraModifierManager.selfPosO.x, (double)CameraModifierManager.selfPos.x), Mth.m_14139_((double)partialTick, (double)CameraModifierManager.selfPosO.y, (double)CameraModifierManager.selfPos.y), Mth.m_14139_((double)partialTick, (double)CameraModifierManager.selfPosO.z, (double)CameraModifierManager.selfPos.z)) : new Vector3d((Vector3dc)selfPos);
            pos.rotateY((double)(-yRot * ((float)java.lang.Math.PI / 180)));
            pos.add(Mth.m_14139_((double)partialTick, (double)entity.f_19854_, (double)entity.m_20185_()), Mth.m_14139_((double)partialTick, (double)entity.f_19855_, (double)entity.m_20186_()), Mth.m_14139_((double)partialTick, (double)entity.f_19856_, (double)entity.m_20189_()));
        }
        CameraModifierManager.camera().m_90584_(pos.x, pos.y, pos.z);
    }

    private static void cleanCache() {
        selfPos.zero();
        globalPos.zero();
        rotation.zero();
        FOV = 0.0;
        STATE = 0;
    }

    private static boolean isStateEnabledOr(int state) {
        return (STATE & state) != 0;
    }

    private static boolean isStateEnabledAnd(int state) {
        return (STATE & state) == state;
    }

    private static boolean isOldStateEnabledOr(int state) {
        return (STATE_O & state) != 0;
    }

    private static boolean isOldStateEnabledAnd(int state) {
        return (STATE_O & state) == state;
    }

    private static Camera camera() {
        return Minecraft.m_91087_().f_91063_.m_109153_();
    }

    private static float getPartialTickTime() {
        return Minecraft.m_91087_().m_91296_();
    }

    public static ICameraModifier createModifier(String modID, boolean high) {
        if (high) {
            return modifiersH.computeIfAbsent(modID, Modifier::new);
        }
        return modifiersL.computeIfAbsent(modID, Modifier::new);
    }

    public static ICameraModifier createBackgroundModifier(String modID) {
        return modifiersB.computeIfAbsent(modID, Modifier::new);
    }

    public static Map<String, Modifier> getModifiersH() {
        return modifiersH;
    }

    public static Map<String, Modifier> getModifiersL() {
        return modifiersL;
    }

    public static Map<String, Modifier> getModifiersB() {
        return modifiersB;
    }

    public static List<String> getPlayerOrder() {
        return playerOrder;
    }

    public static List<String> getPlayerRemovedBackground() {
        return playerRemovedBackground;
    }

    @SubscribeEvent
    public static void modifyFov(ViewportEvent.ComputeFov event) {
        if (!CameraModifierManager.isStateEnabledAnd(9)) {
            return;
        }
        double fov = CameraModifierManager.isOldStateEnabledAnd(73) ? Mth.m_14139_((double)event.getPartialTick(), (double)FOV_O, (double)FOV) : FOV;
        event.setFOV((double)((float)fov));
    }

    @SubscribeEvent
    public static void modifyCamera(ViewportEvent.ComputeCameraAngles event) {
        CameraModifierManager.modify();
        if (CameraModifierManager.isStateEnabledAnd(5)) {
            event.setPitch(CameraModifierManager.ROT_RESULT.x);
            event.setYaw(CameraModifierManager.ROT_RESULT.y);
            event.setRoll(CameraModifierManager.ROT_RESULT.z);
        }
    }

    @SubscribeEvent
    public static void modifyFirstPersonHand(RenderHandEvent event) {
        if (!CameraModifierManager.isStateEnabledAnd(17) || CameraModifierManager.isStateEnabledOr(32)) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        float partialTick = event.getPartialTick();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (CameraModifierManager.isStateEnabledOr(4)) {
            poseStack.m_252781_(new Quaternionf().rotateZ(CameraModifierManager.rotation.z * ((float)java.lang.Math.PI / 180)).rotateX(CameraModifierManager.rotation.x * ((float)java.lang.Math.PI / 180)).rotateY(CameraModifierManager.rotation.y * ((float)java.lang.Math.PI / 180)).rotateX(-player.m_146909_() * ((float)java.lang.Math.PI / 180)));
        }
        if (CameraModifierManager.isStateEnabledOr(2)) {
            Vector3d pos = CameraModifierManager.isOldStateEnabledAnd(67) ? new Vector3d(Mth.m_14139_((double)partialTick, (double)CameraModifierManager.selfPosO.x, (double)CameraModifierManager.selfPos.x), (double)player.m_20192_() - Mth.m_14139_((double)partialTick, (double)CameraModifierManager.selfPosO.y, (double)CameraModifierManager.selfPos.y), Mth.m_14139_((double)partialTick, (double)CameraModifierManager.selfPosO.z, (double)CameraModifierManager.selfPos.z)) : new Vector3d(CameraModifierManager.selfPos.x, (double)player.m_20192_() - CameraModifierManager.selfPos.y, CameraModifierManager.selfPos.z);
            poseStack.m_85837_(pos.x, pos.y, pos.z);
        }
    }

    static {
        ROT_RESULT = new Vector3f();
    }

    public static class Modifier
    implements ICameraModifier {
        private final String modId;
        private final Vector3d pos = new Vector3d();
        private final Vector3f rot = new Vector3f();
        private double fov;
        private boolean isEffective = true;
        private int state;

        private Modifier(String modId) {
            this.modId = modId;
        }

        @Override
        public Modifier enablePos() {
            this.state |= 2;
            return this;
        }

        @Override
        public Modifier disablePos() {
            this.state &= 0xFFFFFFFD;
            return this;
        }

        @Override
        public Modifier setPos(double x, double y, double z) {
            this.pos.set(x, y, z);
            return this;
        }

        @Override
        public Modifier setPos(Vector3d pos) {
            return this.setPos(pos.x, pos.y, pos.z);
        }

        @Override
        public Modifier addPos(double x, double y, double z) {
            this.pos.add(x, y, z);
            return this;
        }

        @Override
        public Modifier addPos(Vector3d pos) {
            return this.addPos(pos.x, pos.y, pos.z);
        }

        @Override
        public Modifier enableRotation() {
            this.state |= 4;
            return this;
        }

        @Override
        public Modifier disableRotation() {
            this.state &= 0xFFFFFFFB;
            return this;
        }

        @Override
        public Modifier setRotationYXZ(float xRot, float yRot, float zRot) {
            this.rot.set(xRot, yRot, zRot);
            return this;
        }

        @Override
        public Modifier setRotationYXZ(Vector3f rot) {
            return this.setRotationYXZ(rot.x, rot.y, rot.z);
        }

        @Override
        public Modifier setRotationZYX(float xRot, float yRot, float zRot) {
            return this.setRotationYXZ(this.eulerZYXToYXZ(xRot, yRot, zRot));
        }

        @Override
        public Modifier setRotationZYX(Vector3f rot) {
            return this.setRotationYXZ(this.eulerZYXToYXZ(rot.x, rot.y, rot.z));
        }

        @Override
        public Modifier rotateYXZ(float xRot, float yRot, float zRot) {
            this.rot.add(xRot, yRot, zRot);
            return this;
        }

        private Vector3f eulerZYXToYXZ(float x, float y, float z) {
            return new Quaternionf().rotationZYX(z *= (float)java.lang.Math.PI / 180, y *= (float)java.lang.Math.PI / 180, x *= (float)java.lang.Math.PI / 180).getEulerAnglesYXZ(new Vector3f()).mul(57.295776f);
        }

        @Override
        public Modifier enableFov() {
            this.state |= 8;
            return this;
        }

        @Override
        public Modifier disableFov() {
            this.state &= 0xFFFFFFF7;
            return this;
        }

        @Override
        public Modifier setFov(double fov) {
            this.fov = fov;
            return this;
        }

        @Override
        public Modifier move(double x, double y, double z) {
            Vector3d vec = new Vector3d(x, y, z).rotateX((double)(this.rot.x * ((float)java.lang.Math.PI / 180))).rotateY((double)(-this.rot.y * ((float)java.lang.Math.PI / 180))).rotateZ((double)(this.rot.z * ((float)java.lang.Math.PI / 180)));
            this.pos.add((Vector3dc)vec);
            return this;
        }

        @Override
        public Modifier aimAt(double x, double y, double z) {
            Vector3d aim = new Vector3d(x - this.pos.x, y - this.pos.y, z - this.pos.z);
            this.rot.x = (float)Math.acos((double)(Math.sqrt((double)(aim.x * aim.x + aim.z * aim.z)) / aim.length())) * 57.295776f * (float)(aim.y < 0.0 ? 1 : -1);
            this.rot.y = (float)(-(Mth.m_14136_((double)aim.x, (double)aim.z) * 57.2957763671875));
            return this;
        }

        @Override
        public Vector3d getPos() {
            return this.pos;
        }

        @Override
        public Vector3f getRot() {
            return this.rot;
        }

        @Override
        public double getFov() {
            return this.fov;
        }

        @Override
        public Modifier enable() {
            this.state |= 1;
            return this;
        }

        @Override
        public Modifier disable() {
            this.state &= 0xFFFFFFFE;
            return this;
        }

        @Override
        public ICameraModifier disableAll() {
            this.state = 0;
            return this;
        }

        @Override
        public Modifier enableFirstPersonArmFixed() {
            this.state |= 0x10;
            return this;
        }

        @Override
        public Modifier disableFirstPersonArmFixed() {
            this.state &= 0xFFFFFFEF;
            return this;
        }

        @Override
        public Modifier enableGlobalMode() {
            this.state |= 0x20;
            return this;
        }

        @Override
        public Modifier disableGlobalMode() {
            this.state &= 0xFFFFFFDF;
            return this;
        }

        @Override
        public Modifier enableLerp() {
            this.state |= 0x40;
            return this;
        }

        @Override
        public Modifier disableLerp() {
            this.state &= 0xFFFFFFBF;
            return this;
        }

        @Override
        public ICameraModifier reset() {
            this.disableAll();
            this.pos.zero();
            this.rot.zero();
            this.fov = 0.0;
            return this;
        }

        @Override
        public ICameraModifier setState(int state) {
            this.state = state;
            return this;
        }

        @Override
        public ICameraModifier getState(int[] state) {
            state[0] = this.state;
            return this;
        }

        private boolean isStateEnabledOr(int state) {
            return (this.state & state) != 0;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}

