/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.camera;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.tysontheember.apertureapi.camera.CameraPathDef;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CameraPathRegistry
extends SimpleJsonResourceReloadListener {
    public static final Logger LOGGER = LogManager.getLogger((String)"CameraPathRegistry");
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    public static final String FOLDER = "camera_paths";
    private static Map<String, CameraPathDef> PATHS = Collections.emptyMap();

    public CameraPathRegistry() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> input, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap temp = new HashMap();
        LOGGER.info("CameraPathRegistry: scanning folder '{}' with {} resource(s)", (Object)FOLDER, (Object)input.size());
        input.keySet().forEach(rl -> LOGGER.debug("Found resource candidate: {}", rl));
        input.forEach((rl, json) -> {
            try {
                JsonObject obj = json.getAsJsonObject();
                CameraPathDef def = (CameraPathDef)GSON.fromJson((JsonElement)obj, CameraPathDef.class);
                if (!CameraPathRegistry.validate(def, rl)) {
                    return;
                }
                if (temp.containsKey(def.id)) {
                    LOGGER.warn("Duplicate camera path id '{}' encountered. Keeping the last one ({}).", (Object)def.id, rl);
                }
                temp.put(def.id, def);
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse camera path {}: {}", rl, (Object)e.toString());
            }
        });
        PATHS = Map.copyOf(temp);
        LOGGER.info("Loaded {} camera path(s) from datapacks.", (Object)PATHS.size());
    }

    private static boolean validate(CameraPathDef def, ResourceLocation rl) {
        if (def == null) {
            LOGGER.warn("Skipping camera path {} (null root)", (Object)rl);
            return false;
        }
        if (def.id == null || def.id.isBlank()) {
            LOGGER.warn("Skipping camera path {} (missing id)", (Object)rl);
            return false;
        }
        if (def.keyframes == null || def.keyframes.isEmpty()) {
            LOGGER.warn("Skipping '{}' in {}: no keyframes.", (Object)def.id, (Object)rl);
            return false;
        }
        float last = -3.4028235E38f;
        int idx = 0;
        for (CameraPathDef.KeyframeDef kf : def.keyframes) {
            if (kf == null) {
                LOGGER.warn("'{}' in {}: keyframe {} is null", (Object)def.id, (Object)rl, (Object)idx);
                return false;
            }
            if (kf.pos == null) {
                LOGGER.warn("'{}' in {}: keyframe {} missing pos", (Object)def.id, (Object)rl, (Object)idx);
                return false;
            }
            if (kf.lookAt == null && kf.rot == null) {
                LOGGER.debug("'{}' in {}: keyframe {} has no rot or lookAt; rotation will be resolved at runtime", (Object)def.id, (Object)rl, (Object)idx);
            }
            if (kf.time < last) {
                LOGGER.warn("'{}' in {}: keyframe {} time {} < previous {} (must be non-decreasing)", (Object)def.id, (Object)rl, (Object)idx, (Object)Float.valueOf(kf.time), (Object)Float.valueOf(last));
                return false;
            }
            last = kf.time;
            ++idx;
        }
        return true;
    }

    public static Map<String, CameraPathDef> all() {
        return PATHS;
    }

    public static CameraPathDef get(String id) {
        return PATHS.get(id);
    }

    public static boolean exists(String id) {
        return PATHS.containsKey(id);
    }
}

