/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client;

import java.util.Map;
import net.tysontheember.apertureapi.InterpolationMath;
import net.tysontheember.apertureapi.client.ClientUtil;
import net.tysontheember.apertureapi.client.gui.overlay.CutsceneFadeOverlay;
import net.tysontheember.apertureapi.client.network.ClientPayloadSender;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.JitterPrevention;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import net.tysontheember.apertureapi.common.animation.TimeInterpolator;
import net.tysontheember.apertureapi.path.ArcLengthLUT;
import net.tysontheember.apertureapi.path.CatmullRom;
import net.tysontheember.apertureapi.path.OrientationUtil;
import org.joml.Matrix3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Animator {
    public static final Animator INSTANCE = new Animator();
    private GlobalCameraPath path;
    private boolean playing;
    private boolean loop = true;
    private boolean autoReset = true;
    private int time;
    private boolean exiting;
    private final Vector3f center = new Vector3f();
    private final Vector3f rotation = new Vector3f();
    private final Matrix3f rotationMatrix = new Matrix3f();
    private boolean constantSpeed = true;
    private boolean quaternionOrientation = true;
    private SegmentLUT currentLUT;

    public void tick() {
        if (!this.playing || this.path == null) {
            return;
        }
        if (this.exiting) {
            return;
        }
        if (this.time >= this.path.getLength()) {
            if (this.loop) {
                this.time = 0;
            } else if (this.autoReset) {
                this.beginExitSequence();
            } else {
                this.playing = false;
            }
        } else {
            ++this.time;
        }
    }

    public void play() {
        this.playing = true;
    }

    public void stop() {
        if (this.autoReset) {
            this.beginExitSequence();
        } else {
            this.playing = false;
            this.path = null;
            this.time = 0;
            this.exiting = false;
        }
    }

    public void reset() {
        if (this.autoReset) {
            this.beginExitSequence();
        } else {
            this.time = 0;
        }
    }

    private void beginExitSequence() {
        if (!this.playing || this.path == null || this.exiting) {
            return;
        }
        this.exiting = true;
        try {
            CutsceneFadeOverlay.startExitSequence(() -> {
                try {
                    ClientPayloadSender.cutsceneInvul(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ClientUtil.resetCameraType();
                this.playing = false;
                this.path = null;
                this.time = 0;
                this.exiting = false;
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resetAndPlay() {
        this.time = 0;
        this.playing = true;
    }

    public Animator setLoop(boolean loop) {
        this.loop = loop;
        return this;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public Animator setAutoReset(boolean autoReset) {
        this.autoReset = autoReset;
        return this;
    }

    public boolean isAutoReset() {
        return this.autoReset;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPathAndPlay(GlobalCameraPath path) {
        this.path = path;
        this.currentLUT = null;
        this.resetAndPlay();
    }

    public void setPathAndPlay(GlobalCameraPath path, Vector3f center, Vector3f rotation) {
        this.path = path;
        this.center.set((Vector3fc)center);
        this.rotation.set((Vector3fc)rotation);
        this.rotationMatrix.identity().rotateY((360.0f - rotation.y) * ((float)Math.PI / 180));
        this.currentLUT = null;
        this.resetAndPlay();
    }

    public boolean prepareCameraInfo(Vector3f posDest, Vector3f rotDest, float[] fov) {
        if (this.path == null) {
            return false;
        }
        float partialTicks = this.isPlaying() ? ClientUtil.partialTicks() : 0.0f;
        float currentTime = (float)this.time + partialTicks;
        Map.Entry<Integer, CameraKeyframe> preEntry = this.path.getPreEntry(this.time + 1);
        Map.Entry<Integer, CameraKeyframe> nextEntry = this.path.getNextEntry(this.time);
        if (preEntry == null) {
            if (nextEntry == null) {
                return false;
            }
            posDest.set((Vector3fc)nextEntry.getValue().getPos());
            rotDest.set((Vector3fc)nextEntry.getValue().getRot());
            fov[0] = nextEntry.getValue().getFov();
            return true;
        }
        if (nextEntry == null) {
            posDest.set((Vector3fc)preEntry.getValue().getPos());
            rotDest.set((Vector3fc)preEntry.getValue().getRot());
            fov[0] = preEntry.getValue().getFov();
            return true;
        }
        float timeDelta = nextEntry.getKey() - preEntry.getKey();
        float t = timeDelta <= 0.001f ? 0.0f : JitterPrevention.calculateSmoothT(currentTime, preEntry.getKey(), nextEntry.getKey());
        CameraKeyframe pre = preEntry.getValue();
        CameraKeyframe next = nextEntry.getValue();
        float t1 = next.getPosTimeInterpolator() == TimeInterpolator.BEZIER ? next.getPosBezier().interpolate(t) : t;
        float tPos = t1;
        if (this.constantSpeed && next.getPathInterpolator() != PathInterpolator.STEP) {
            this.ensureSegmentLUT(this.path, preEntry, nextEntry, next.getPathInterpolator());
            if (this.currentLUT != null && this.currentLUT.lut != null && this.currentLUT.lut.totalLength() > 1.0E-6f) {
                float desired = this.currentLUT.lut.totalLength() * t1;
                tPos = this.currentLUT.lut.tForDistance(desired);
            }
        }
        switch (next.getPathInterpolator()) {
            case LINEAR: {
                InterpolationMath.line(tPos, pre.getPos(), next.getPos(), posDest);
                break;
            }
            case COSINE: {
                float tCos = (1.0f - (float)Math.cos(Math.PI * (double)tPos)) * 0.5f;
                InterpolationMath.line(tCos, pre.getPos(), next.getPos(), posDest);
                break;
            }
            case SMOOTH: {
                Map.Entry<Integer, CameraKeyframe> prePre = this.path.getPreEntry(preEntry.getKey());
                Vector3f p0 = prePre == null ? pre.getPos() : prePre.getValue().getPos();
                Map.Entry<Integer, CameraKeyframe> nextNext = this.path.getNextEntry(nextEntry.getKey());
                Vector3f p3 = nextNext == null ? next.getPos() : nextNext.getValue().getPos();
                InterpolationMath.catmullRom(tPos, p0, pre.getPos(), next.getPos(), p3, posDest);
                break;
            }
            case CATMULL_UNIFORM: 
            case CATMULL_CHORDAL: 
            case CATMULL_CENTRIPETAL: {
                Map.Entry<Integer, CameraKeyframe> prePre = this.path.getPreEntry(preEntry.getKey());
                Vector3f p0 = prePre == null ? pre.getPos() : prePre.getValue().getPos();
                Map.Entry<Integer, CameraKeyframe> nextNext = this.path.getNextEntry(nextEntry.getKey());
                Vector3f p3 = nextNext == null ? next.getPos() : nextNext.getValue().getPos();
                float alpha = switch (next.getPathInterpolator()) {
                    case PathInterpolator.CATMULL_UNIFORM -> 0.0f;
                    case PathInterpolator.CATMULL_CHORDAL -> 1.0f;
                    default -> 0.5f;
                };
                CatmullRom.eval(tPos, p0, pre.getPos(), next.getPos(), p3, alpha, posDest);
                break;
            }
            case BEZIER: {
                next.getPathBezier().interpolate(tPos, pre.getPos(), next.getPos(), posDest);
                break;
            }
            case STEP: {
                posDest.set((Vector3fc)pre.getPos());
            }
        }
        t1 = next.getRotTimeInterpolator() == TimeInterpolator.BEZIER ? next.getRotBezier().interpolate(t) : t;
        Vector3f preRot = pre.getRot();
        Vector3f nextRot = next.getRot();
        if (this.quaternionOrientation) {
            Quaternionf qa = OrientationUtil.yprDegToQuat(preRot.y, preRot.x, preRot.z, new Quaternionf());
            Quaternionf qb = OrientationUtil.yprDegToQuat(nextRot.y, nextRot.x, nextRot.z, new Quaternionf());
            Quaternionf qOut = new Quaternionf();
            OrientationUtil.slerp(qa, qb, t1, qOut);
            OrientationUtil.quatToYprDeg(qOut, rotDest);
        } else {
            JitterPrevention.smoothRotationLerp(t1, preRot, nextRot, rotDest);
        }
        t1 = next.getFovTimeInterpolator() == TimeInterpolator.BEZIER ? next.getFovBezier().interpolate(t) : t;
        fov[0] = JitterPrevention.smoothFovLerp(t1, pre.getFov(), next.getFov());
        if (this.path.isNativeMode()) {
            this.rotationMatrix.transform(posDest).add((Vector3fc)this.center);
            rotDest.add((Vector3fc)this.rotation);
        }
        return true;
    }

    private void ensureSegmentLUT(GlobalCameraPath path, Map.Entry<Integer, CameraKeyframe> preEntry, Map.Entry<Integer, CameraKeyframe> nextEntry, PathInterpolator mode) {
        int preTime = preEntry.getKey();
        int nextTime = nextEntry.getKey();
        if (this.currentLUT != null && this.currentLUT.preTime == preTime && this.currentLUT.nextTime == nextTime && this.currentLUT.mode == mode) {
            return;
        }
        this.currentLUT = new SegmentLUT();
        this.currentLUT.preTime = preTime;
        this.currentLUT.nextTime = nextTime;
        this.currentLUT.mode = mode;
        CameraKeyframe pre = preEntry.getValue();
        CameraKeyframe next = nextEntry.getValue();
        Map.Entry<Integer, CameraKeyframe> prePre = path.getPreEntry(preEntry.getKey());
        Vector3f p0 = prePre == null ? pre.getPos() : prePre.getValue().getPos();
        Map.Entry<Integer, CameraKeyframe> nextNext = path.getNextEntry(nextEntry.getKey());
        Vector3f p3 = nextNext == null ? next.getPos() : nextNext.getValue().getPos();
        ArcLengthLUT.Evaluator f = (tt, out) -> {
            switch (mode) {
                case LINEAR: {
                    InterpolationMath.line(tt, pre.getPos(), next.getPos(), out);
                    break;
                }
                case COSINE: {
                    float tCos = (1.0f - (float)Math.cos(Math.PI * (double)tt)) * 0.5f;
                    InterpolationMath.line(tCos, pre.getPos(), next.getPos(), out);
                    break;
                }
                case SMOOTH: {
                    InterpolationMath.catmullRom(tt, p0, pre.getPos(), next.getPos(), p3, out);
                    break;
                }
                case CATMULL_UNIFORM: {
                    CatmullRom.eval(tt, p0, pre.getPos(), next.getPos(), p3, 0.0f, out);
                    break;
                }
                case CATMULL_CENTRIPETAL: {
                    CatmullRom.eval(tt, p0, pre.getPos(), next.getPos(), p3, 0.5f, out);
                    break;
                }
                case CATMULL_CHORDAL: {
                    CatmullRom.eval(tt, p0, pre.getPos(), next.getPos(), p3, 1.0f, out);
                    break;
                }
                case BEZIER: {
                    pre.getPathBezier().interpolate(tt, pre.getPos(), next.getPos(), out);
                    break;
                }
                case STEP: {
                    out.set((Vector3fc)pre.getPos());
                }
            }
            return out;
        };
        this.currentLUT.lut = new ArcLengthLUT(f, 64);
    }

    public Animator setConstantSpeed(boolean enabled) {
        this.constantSpeed = enabled;
        return this;
    }

    public Animator setQuaternionOrientation(boolean enabled) {
        this.quaternionOrientation = enabled;
        return this;
    }

    private static final class SegmentLUT {
        int preTime;
        int nextTime;
        PathInterpolator mode;
        ArcLengthLUT lut;

        private SegmentLUT() {
        }
    }
}

