/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.util.Mth;
import net.tysontheember.apertureapi.client.ClientUtil;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import net.tysontheember.apertureapi.common.animation.Vec3BezierController;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CameraAnimIdeCache {
    public static final float POINT_PICK_EXPAND = 0.2f;
    public static boolean EDIT;
    public static boolean VIEW;
    public static boolean PREVIEW;
    private static Mode MODE;
    private static final MoveModeData MOVE_DATA;
    private static GlobalCameraPath PATH;
    private static final SelectedPoint SELECTED_POINT;
    private static final float BEZIER_PICK_EXPAND = 0.1f;
    private static final Vector3f NATIVE_POS;
    private static final Vector3f NATIVE_ROT;

    public static void tick() {
        if (MODE == Mode.MOVE || MODE == Mode.ROTATE) {
            MOVE_DATA.move();
        }
    }

    public static void leftPick(Vector3f origin, Vector3f direction, float length) {
        if ((MODE == Mode.MOVE || MODE == Mode.ROTATE) && CameraAnimIdeCache.MOVE_DATA.moveType != MoveType.NONE) {
            return;
        }
        if (MODE == Mode.ROTATE && MOVE_DATA.pickRotateModule(origin, direction)) {
            return;
        }
        length += 0.1f;
        length *= length;
        if (MODE == Mode.MOVE && MOVE_DATA.pickMoveModule(origin, direction, true)) {
            return;
        }
        length = CameraAnimIdeCache.pickBezier(length, origin, direction);
        CameraAnimIdeCache.pickPoint(length, origin, direction);
    }

    public static void rightPick(Vector3f origin, Vector3f direction, float length) {
        if (MODE == Mode.MOVE && CameraAnimIdeCache.MOVE_DATA.moveType != MoveType.NONE) {
            return;
        }
        if (CameraAnimIdeCache.SELECTED_POINT.pointTime < 0) {
            return;
        }
        if (MODE == Mode.MOVE) {
            MOVE_DATA.pickMoveModule(origin, direction, false);
        }
    }

    private static float pickBezier(float length, Vector3f origin, Vector3f direction) {
        CameraKeyframe pre;
        int selectedTime = SELECTED_POINT.getPointTime();
        if (selectedTime <= 0) {
            return length;
        }
        CameraKeyframe point = PATH.getPoint(selectedTime);
        if (point == null || point.getPathInterpolator() != PathInterpolator.BEZIER) {
            return length;
        }
        Vec3BezierController controller = point.getPathBezier();
        Vector3f right = controller.getRight();
        float rightL = right.distanceSquared((Vector3fc)origin);
        if (rightL <= length && Intersectionf.testRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)right).sub(0.1f, 0.1f, 0.1f), (Vector3fc)new Vector3f((Vector3fc)right).add(0.1f, 0.1f, 0.1f))) {
            length = rightL;
            SELECTED_POINT.setControl(ControlType.RIGHT);
        }
        if ((pre = PATH.getPrePoint(selectedTime)) == null) {
            return length;
        }
        Vector3f left = controller.getLeft();
        float leftL = left.distanceSquared((Vector3fc)origin);
        if (leftL <= length && Intersectionf.testRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)left).sub(0.1f, 0.1f, 0.1f), (Vector3fc)new Vector3f((Vector3fc)left).add(0.1f, 0.1f, 0.1f))) {
            length = leftL;
            SELECTED_POINT.setControl(ControlType.LEFT);
        }
        return length;
    }

    private static void pickPoint(float length, Vector3f origin, Vector3f direction) {
        int time = -1;
        for (Int2ObjectMap.Entry entry : PATH.getEntries()) {
            Vector3f position = ((CameraKeyframe)entry.getValue()).getPos();
            float d = position.distanceSquared((Vector3fc)origin);
            if (d > length || !Intersectionf.testRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)position).sub(0.2f, 0.2f, 0.2f), (Vector3fc)new Vector3f((Vector3fc)position).add(0.2f, 0.2f, 0.2f)) || !(d < length)) continue;
            length = d;
            time = entry.getIntKey();
        }
        if (time >= 0) {
            SELECTED_POINT.setSelected(time);
        }
    }

    public static GlobalCameraPath getPath() {
        return PATH;
    }

    public static void setPath(GlobalCameraPath path) {
        PATH = path;
        SELECTED_POINT.reset();
    }

    public static SelectedPoint getSelectedPoint() {
        return SELECTED_POINT;
    }

    public static Mode getMode() {
        return MODE;
    }

    public static MoveModeData getMoveMode() {
        return MOVE_DATA;
    }

    public static void setNative(Vector3f pos, Vector3f rot) {
        NATIVE_POS.set((Vector3fc)pos);
        NATIVE_ROT.set((Vector3fc)rot);
        PATH.setNativeMode(true);
    }

    public static Vector3f getNativePos() {
        return NATIVE_POS;
    }

    public static Vector3f getNativeRot() {
        return NATIVE_ROT;
    }

    public static void toggleMode() {
        MODE = MODE == Mode.ROTATE ? Mode.MOVE : Mode.ROTATE;
    }

    public static boolean isRotating() {
        return MODE == Mode.ROTATE && CameraAnimIdeCache.MOVE_DATA.moveType == MoveType.RX || CameraAnimIdeCache.MOVE_DATA.moveType == MoveType.RY || CameraAnimIdeCache.MOVE_DATA.moveType == MoveType.RZ;
    }

    public static float getCurrentRotateDelta() {
        return CameraAnimIdeCache.MOVE_DATA.currentDeltaDeg;
    }

    public static char getCurrentRotateAxis() {
        return CameraAnimIdeCache.MOVE_DATA.currentAxis;
    }

    static {
        MODE = Mode.MOVE;
        MOVE_DATA = new MoveModeData();
        PATH = new GlobalCameraPath("new");
        SELECTED_POINT = new SelectedPoint();
        NATIVE_POS = new Vector3f();
        NATIVE_ROT = new Vector3f();
    }

    public static enum Mode {
        NONE,
        MOVE,
        ROTATE;

    }

    public static class MoveModeData {
        private MoveType moveType = MoveType.NONE;
        private final Vector3f delta = new Vector3f();
        private float startAngle;
        private float rotStartX;
        private float rotStartY;
        private float rotStartZ;
        private float currentDeltaDeg;
        private char currentAxis = '\u0000';

        private MoveModeData() {
        }

        public MoveType getMoveType() {
            return this.moveType;
        }

        public void reset() {
            this.moveType = MoveType.NONE;
        }

        private boolean pickMoveModule(Vector3f origin, Vector3f direction, boolean leftClick) {
            Vector3f max;
            Vector3f min;
            int selectedTime = SELECTED_POINT.getPointTime();
            if (selectedTime < 0) {
                return false;
            }
            if (leftClick) {
                Vector3f pos = SELECTED_POINT.getPosition();
                if (pos == null) {
                    return false;
                }
                float deadZone = 0.1f;
                float l = 1.25f;
                float w = 0.1f;
                if (!Intersectionf.testRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).sub(w, w, 0.0f), (Vector3fc)new Vector3f((Vector3fc)pos).add(deadZone + l, deadZone + l, deadZone + l))) {
                    return false;
                }
                float min2 = Float.MAX_VALUE;
                Vector2f resultPos = new Vector2f();
                boolean result = false;
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(deadZone, -w, -w), (Vector3fc)new Vector3f((Vector3fc)pos).add(deadZone + l, w, w), (Vector2f)resultPos)) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.X;
                }
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(-w, deadZone, -w), (Vector3fc)new Vector3f((Vector3fc)pos).add(w, deadZone + l, w), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.Y;
                }
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(-w, -w, deadZone), (Vector3fc)new Vector3f((Vector3fc)pos).add(w, w, deadZone + l), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.Z;
                }
                float spacing = 0.2f;
                float size = 0.3f;
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(spacing, spacing, -w), (Vector3fc)new Vector3f((Vector3fc)pos).add(size + spacing, size + spacing, w), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.XY;
                }
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(spacing, -w, spacing), (Vector3fc)new Vector3f((Vector3fc)pos).add(size + spacing, w, size + spacing), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.XZ;
                }
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(-w, spacing, spacing), (Vector3fc)new Vector3f((Vector3fc)pos).add(w, size + spacing, size + spacing), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.YZ;
                }
                CameraAnimIdeCache.MOVE_DATA.delta.set((Vector3fc)direction).mul(min2).add((Vector3fc)origin).sub((Vector3fc)pos).mul(-1.0f);
                return result;
            }
            switch (CameraAnimIdeCache.SELECTED_POINT.control) {
                case LEFT: {
                    CameraKeyframe point = PATH.getPoint(CameraAnimIdeCache.SELECTED_POINT.pointTime);
                    if (point == null) {
                        return false;
                    }
                    Vector3f pos = point.getPathBezier().getLeft();
                    min = new Vector3f((Vector3fc)pos).sub(0.1f, 0.1f, 0.1f);
                    max = new Vector3f((Vector3fc)pos).add(0.1f, 0.1f, 0.1f);
                    break;
                }
                case RIGHT: {
                    CameraKeyframe point = PATH.getPoint(CameraAnimIdeCache.SELECTED_POINT.pointTime);
                    if (point == null) {
                        return false;
                    }
                    Vector3f pos = point.getPathBezier().getRight();
                    min = new Vector3f((Vector3fc)pos).sub(0.1f, 0.1f, 0.1f);
                    max = new Vector3f((Vector3fc)pos).add(0.1f, 0.1f, 0.1f);
                    break;
                }
                case NONE: {
                    CameraKeyframe point = PATH.getPoint(CameraAnimIdeCache.SELECTED_POINT.pointTime);
                    if (point == null) {
                        return false;
                    }
                    Vector3f pos = point.getPos();
                    min = new Vector3f((Vector3fc)pos).sub(0.2f, 0.2f, 0.2f);
                    max = new Vector3f((Vector3fc)pos).add(0.2f, 0.2f, 0.2f);
                    break;
                }
                default: {
                    return false;
                }
            }
            Vector2f resultPos = new Vector2f();
            if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)min, (Vector3fc)max, (Vector2f)resultPos)) {
                CameraAnimIdeCache.MOVE_DATA.delta.set(resultPos.x);
                CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.XYZ;
                return true;
            }
            return false;
        }

        private boolean pickRotateModule(Vector3f origin, Vector3f direction) {
            float d;
            Vector3f hit;
            int selectedTime = SELECTED_POINT.getPointTime();
            if (selectedTime < 0) {
                return false;
            }
            CameraKeyframe point = PATH.getPoint(selectedTime);
            if (point == null) {
                return false;
            }
            Vector3f center = point.getPos();
            float r = 1.2f;
            float ringHalfWidth = 0.06f;
            float pickHalfWidth = ringHalfWidth * 2.5f + 0.02f;
            float inner = r - pickHalfWidth;
            float outer = r + pickHalfWidth;
            float bestT = Float.MAX_VALUE;
            MoveType best = MoveType.NONE;
            float angleAtPick = 0.0f;
            BiFunction<Vector3f, Character, Float> testAxis = (c, axis) -> {
                float d;
                float nz;
                float ny;
                float nx = axis.charValue() == 'x' ? 1.0f : 0.0f;
                float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)direction.x, (float)direction.y, (float)direction.z, (float)center.x, (float)center.y, (float)center.z, (float)nx, (float)(ny = axis.charValue() == 'y' ? 1.0f : 0.0f), (float)(nz = axis.charValue() == 'z' ? 1.0f : 0.0f), (float)1.0E-6f);
                if (Float.isNaN(t) || Float.isInfinite(t)) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                Vector3f hit = new Vector3f((Vector3fc)direction).mul(t).add((Vector3fc)origin).sub((Vector3fc)center);
                float f = axis.charValue() == 'x' ? Math.sqrt((float)(hit.y * hit.y + hit.z * hit.z)) : (d = axis.charValue() == 'y' ? Math.sqrt((float)(hit.x * hit.x + hit.z * hit.z)) : Math.sqrt((float)(hit.x * hit.x + hit.y * hit.y)));
                if (d >= inner && d <= outer) {
                    return Float.valueOf(t);
                }
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            };
            Float tx = testAxis.apply(center, Character.valueOf('x'));
            Float ty = testAxis.apply(center, Character.valueOf('y'));
            Float tz = testAxis.apply(center, Character.valueOf('z'));
            class Candidate {
                float t;
                float dev;
                MoveType type;

                Candidate(float t, float dev, MoveType type) {
                    this.t = t;
                    this.dev = dev;
                    this.type = type;
                }
            }
            ArrayList<Candidate> cands = new ArrayList<Candidate>(3);
            if (tx.floatValue() != Float.NEGATIVE_INFINITY) {
                hit = new Vector3f((Vector3fc)direction).mul(tx.floatValue()).add((Vector3fc)origin).sub((Vector3fc)center);
                d = Math.sqrt((float)(hit.y * hit.y + hit.z * hit.z));
                cands.add(new Candidate(tx.floatValue(), Math.abs((float)(d - r)), MoveType.RX));
            }
            if (ty.floatValue() != Float.NEGATIVE_INFINITY) {
                hit = new Vector3f((Vector3fc)direction).mul(ty.floatValue()).add((Vector3fc)origin).sub((Vector3fc)center);
                d = Math.sqrt((float)(hit.x * hit.x + hit.z * hit.z));
                cands.add(new Candidate(ty.floatValue(), Math.abs((float)(d - r)), MoveType.RY));
            }
            if (tz.floatValue() != Float.NEGATIVE_INFINITY) {
                hit = new Vector3f((Vector3fc)direction).mul(tz.floatValue()).add((Vector3fc)origin).sub((Vector3fc)center);
                d = Math.sqrt((float)(hit.x * hit.x + hit.y * hit.y));
                cands.add(new Candidate(tz.floatValue(), Math.abs((float)(d - r)), MoveType.RZ));
            }
            Candidate bestCand = null;
            for (Candidate c2 : cands) {
                if (bestCand != null && !(c2.dev < bestCand.dev) && (c2.dev != bestCand.dev || !(Math.abs((float)c2.t) < Math.abs((float)bestCand.t)))) continue;
                bestCand = c2;
            }
            if (bestCand == null) {
                return false;
            }
            bestT = bestCand.t;
            best = bestCand.type;
            if (best == MoveType.NONE) {
                return false;
            }
            Vector3f hit2 = new Vector3f((Vector3fc)direction).mul(bestT).add((Vector3fc)origin).sub((Vector3fc)center);
            switch (best) {
                case RX: {
                    this.startAngle = (float)Math.toDegrees((double)Math.atan2((float)hit2.z, (float)hit2.y));
                    this.currentAxis = (char)88;
                    break;
                }
                case RY: {
                    this.startAngle = (float)Math.toDegrees((double)Math.atan2((float)hit2.x, (float)hit2.z));
                    this.currentAxis = (char)89;
                    break;
                }
                case RZ: {
                    this.startAngle = (float)Math.toDegrees((double)Math.atan2((float)hit2.y, (float)hit2.x));
                    this.currentAxis = (char)90;
                }
            }
            this.currentDeltaDeg = 0.0f;
            this.rotStartX = point.getRot().x;
            this.rotStartY = point.getRot().y;
            this.rotStartZ = point.getRot().z;
            this.moveType = best;
            return true;
        }

        private void move() {
            if (CameraAnimIdeCache.SELECTED_POINT.pointTime < 0 || this.moveType == MoveType.NONE) {
                return;
            }
            Vector3f pos = SELECTED_POINT.getPosition();
            if (pos == null) {
                return;
            }
            Vector3f view = ClientUtil.playerView();
            Vector3f origin = ClientUtil.playerEyePos();
            float yRot = ClientUtil.playerYHeadRot();
            float xRot = ClientUtil.playerXRot();
            block0 : switch (this.moveType) {
                case X: {
                    float t;
                    float a = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)(xRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)1.0E-6f);
                    float b = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)0.0f, (float)(Math.abs((float)yRot) >= 90.0f ? 1.0f : -1.0f), (float)1.0E-6f);
                    float f = a == 0.0f ? b : (t = b == 0.0f ? a : Math.min((float)a, (float)b));
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.x = view.x * t + origin.x + this.delta.x;
                    break;
                }
                case Y: {
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)(yRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)0.0f, (float)1.0E-6f);
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.y = view.y * t + origin.y + this.delta.y;
                    break;
                }
                case Z: {
                    float t;
                    float a = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)(xRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)1.0E-6f);
                    float b = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)(yRot >= 0.0f ? 1.0f : -1.0f), (float)0.0f, (float)0.0f, (float)1.0E-6f);
                    float f = a == 0.0f ? b : (t = b == 0.0f ? a : Math.min((float)a, (float)b));
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.z = view.z * t + origin.z + this.delta.z;
                    break;
                }
                case XY: {
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)0.0f, (float)(Math.abs((float)yRot) < 90.0f ? -1.0f : 1.0f), (float)1.0E-6f);
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.x = view.x * t + origin.x + this.delta.x;
                    pos.y = view.y * t + origin.y + this.delta.y;
                    break;
                }
                case XZ: {
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)(xRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)1.0E-6f);
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.x = view.x * t + origin.x + this.delta.x;
                    pos.z = view.z * t + origin.z + this.delta.z;
                    break;
                }
                case YZ: {
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)(yRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)0.0f, (float)1.0E-6f);
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.z = view.z * t + origin.z + this.delta.z;
                    pos.y = view.y * t + origin.y + this.delta.y;
                    break;
                }
                case XYZ: {
                    pos.set((Vector3fc)view).mul(this.delta.x).add((Vector3fc)origin);
                    break;
                }
                case RX: 
                case RY: 
                case RZ: {
                    float nz;
                    float ny;
                    CameraKeyframe point = PATH.getPoint(SELECTED_POINT.getPointTime());
                    if (point == null) {
                        return;
                    }
                    Vector3f center = point.getPos();
                    float nx = this.moveType == MoveType.RX ? 1.0f : 0.0f;
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)center.x, (float)center.y, (float)center.z, (float)nx, (float)(ny = this.moveType == MoveType.RY ? 1.0f : 0.0f), (float)(nz = this.moveType == MoveType.RZ ? 1.0f : 0.0f), (float)1.0E-6f);
                    if (Float.isNaN(t) || Float.isInfinite(t)) {
                        return;
                    }
                    Vector3f hit = new Vector3f((Vector3fc)view).mul(t).add((Vector3fc)origin).sub((Vector3fc)center);
                    float deltaAng = Mth.m_14177_((float)((switch (this.moveType) {
                        case MoveType.RX -> (float)Math.toDegrees((double)Math.atan2((float)hit.z, (float)hit.y));
                        case MoveType.RY -> (float)Math.toDegrees((double)Math.atan2((float)hit.x, (float)hit.z));
                        default -> (float)Math.toDegrees((double)Math.atan2((float)hit.y, (float)hit.x));
                    }) - this.startAngle));
                    float snap = 0.0f;
                    boolean sh = ClientUtil.shiftDown();
                    boolean al = ClientUtil.altDown();
                    if (sh && al) {
                        snap = 0.5f;
                    } else if (sh) {
                        snap = 5.0f;
                    } else if (al) {
                        snap = 1.0f;
                    }
                    if (snap > 0.0f) {
                        deltaAng = (float)Math.round((float)(deltaAng / snap)) * snap;
                    }
                    this.currentDeltaDeg = deltaAng;
                    Vector3f rot = point.getRot();
                    switch (this.moveType) {
                        case RX: {
                            rot.x = Mth.m_14177_((float)(this.rotStartX + deltaAng));
                            break block0;
                        }
                        case RY: {
                            rot.y = Mth.m_14177_((float)(this.rotStartY + deltaAng));
                            break block0;
                        }
                        case RZ: {
                            rot.z = Mth.m_14177_((float)(this.rotStartZ + deltaAng));
                        }
                    }
                }
            }
        }
    }

    public static enum MoveType {
        X,
        Y,
        Z,
        XY,
        XZ,
        YZ,
        XYZ,
        RX,
        RY,
        RZ,
        NONE;

    }

    public static class SelectedPoint {
        private int pointTime = -1;
        private ControlType control = ControlType.NONE;

        public void setSelected(int time) {
            this.pointTime = time;
            this.control = ControlType.NONE;
        }

        private void setControl(ControlType control) {
            this.control = control;
        }

        public int getPointTime() {
            return this.pointTime;
        }

        public ControlType getControl() {
            return this.control;
        }

        @Nullable
        public Vector3f getPosition() {
            Vector3f pos = null;
            switch (this.control) {
                case LEFT: {
                    CameraKeyframe point = PATH.getPoint(this.pointTime);
                    if (point == null) break;
                    pos = point.getPathBezier().getLeft();
                    break;
                }
                case RIGHT: {
                    CameraKeyframe point = PATH.getPoint(this.pointTime);
                    if (point == null) break;
                    pos = point.getPathBezier().getRight();
                    break;
                }
                case NONE: {
                    CameraKeyframe point = PATH.getPoint(this.pointTime);
                    if (point == null) break;
                    pos = point.getPos();
                }
            }
            return pos;
        }

        public void reset() {
            this.pointTime = -1;
            this.control = ControlType.NONE;
        }
    }

    public static enum ControlType {
        LEFT,
        RIGHT,
        NONE;

    }
}

