/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.tysontheember.apertureapi.CameraModifierManager;
import net.tysontheember.apertureapi.ModConf;
import org.joml.Math;

public class CameraModifierScreen
extends Screen {
    public CameraModifierScreen() {
        super((Component)Component.m_237115_((String)"camera_modifier_screen.title"));
    }

    protected void m_7856_() {
        NormalModifierWidget normal = NormalModifierWidget.create(5, 15, 60, 151);
        PlayerOrderModifierWidget order = PlayerOrderModifierWidget.create(70, 15, 60, 151);
        BackgroundModifierWidget background = BackgroundModifierWidget.create(145, 15, 60, 151);
        PlayerRemovedModifierWidget removed = PlayerRemovedModifierWidget.create(215, 15, 60, 151);
        normal.playerOrder = order;
        order.normalModifier = normal;
        background.playerRemoved = removed;
        removed.backgroundModifier = background;
        this.m_142416_((GuiEventListener)normal);
        this.m_142416_((GuiEventListener)order);
        this.m_142416_((GuiEventListener)background);
        this.m_142416_((GuiEventListener)removed);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ModConf.setPlayerOrder(CameraModifierManager.getPlayerOrder());
        ModConf.setRemoved(CameraModifierManager.getPlayerRemovedBackground());
        ModConf.save();
    }

    private static class NormalModifierWidget
    extends ComponentSCRollWidget {
        private final List<String> ids;
        private PlayerOrderModifierWidget playerOrder;

        public NormalModifierWidget(int x, int y, int width, int height, Component message, List<String> ids, List<MutableComponent> list) {
            super(x, y, width, height, message, list);
            this.ids = ids;
        }

        @Override
        protected void onDoubleSelected(int index) {
            String id = this.ids.get(index);
            if (CameraModifierManager.getPlayerOrder().contains(id)) {
                return;
            }
            CameraModifierManager.getPlayerOrder().add(id);
            this.list.remove(index);
            this.ids.remove(index);
            this.playerOrder.reload();
            this.onListChanged();
        }

        protected void reload() {
            this.ids.clear();
            this.list.clear();
            NormalModifierWidget.loadModifier(this.ids, this.list);
            this.onListChanged();
        }

        private static NormalModifierWidget create(int x, int y, int width, int height) {
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            NormalModifierWidget.loadModifier(ids, components);
            return new NormalModifierWidget(x, y, width, height, (Component)Component.m_237115_((String)"camera_modifier_screen.normal_modifier"), ids, components);
        }

        private static void loadModifier(List<String> ids, List<MutableComponent> components) {
            HashMap<String, CameraModifierManager.Modifier> h = new HashMap<String, CameraModifierManager.Modifier>(CameraModifierManager.getModifiersH());
            HashMap<String, CameraModifierManager.Modifier> l = new HashMap<String, CameraModifierManager.Modifier>(CameraModifierManager.getModifiersL());
            for (String order : CameraModifierManager.getPlayerOrder()) {
                h.remove(order);
                l.remove(order);
            }
            for (String id : h.keySet()) {
                ids.add(id);
                components.add(Component.m_237115_((String)("freecamera.modifier." + id)));
            }
            for (String id : l.keySet()) {
                ids.add(id);
                components.add(Component.m_237115_((String)("freecamera.modifier." + id)));
            }
        }
    }

    private static class PlayerOrderModifierWidget
    extends ComponentSCRollWidget {
        private NormalModifierWidget normalModifier;

        public PlayerOrderModifierWidget(int x, int y, int width, int height, Component message, List<MutableComponent> list) {
            super(x, y, width, height, message, list);
        }

        @Override
        protected void onDoubleSelected(int index) {
            CameraModifierManager.getPlayerOrder().remove(index);
            this.list.remove(index);
            this.normalModifier.reload();
            this.onListChanged();
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.selected < 0) {
                return false;
            }
            List<String> playerOrder = CameraModifierManager.getPlayerOrder();
            switch (keyCode) {
                case 265: {
                    if (this.selected == 0) {
                        return false;
                    }
                    String temple = playerOrder.get(this.selected);
                    playerOrder.set(this.selected, playerOrder.get(this.selected - 1));
                    playerOrder.set(this.selected - 1, temple);
                    --this.selected;
                    break;
                }
                case 264: {
                    if (this.selected == this.list.size() - 1) {
                        return false;
                    }
                    String temple = playerOrder.get(this.selected);
                    playerOrder.set(this.selected, playerOrder.get(this.selected + 1));
                    playerOrder.set(this.selected + 1, temple);
                    ++this.selected;
                }
            }
            this.reload();
            return true;
        }

        private static PlayerOrderModifierWidget create(int x, int y, int width, int height) {
            List<String> playerOrder = CameraModifierManager.getPlayerOrder();
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            for (String id : playerOrder) {
                components.add(Component.m_237115_((String)("freecamera.modifier." + id)));
            }
            return new PlayerOrderModifierWidget(x, y, width, height, (Component)Component.m_237115_((String)"camera_modifier_screen.player_order"), components);
        }

        protected void reload() {
            this.list.clear();
            for (String id : CameraModifierManager.getPlayerOrder()) {
                this.list.add(Component.m_237115_((String)("freecamera.modifier." + id)));
            }
            this.onListChanged();
        }
    }

    private static class BackgroundModifierWidget
    extends ComponentSCRollWidget {
        private final List<String> ids;
        private PlayerRemovedModifierWidget playerRemoved;

        public BackgroundModifierWidget(int x, int y, int width, int height, Component message, List<String> ids, List<MutableComponent> list) {
            super(x, y, width, height, message, list);
            this.ids = ids;
        }

        @Override
        protected void onDoubleSelected(int index) {
            String id = this.ids.get(index);
            if (CameraModifierManager.getPlayerRemovedBackground().contains(id)) {
                return;
            }
            CameraModifierManager.getPlayerRemovedBackground().add(id);
            this.list.remove(index);
            this.ids.remove(index);
            this.playerRemoved.reload();
            this.onListChanged();
        }

        protected void reload() {
            this.ids.clear();
            this.list.clear();
            BackgroundModifierWidget.loadModifier(this.ids, this.list);
            this.onListChanged();
        }

        private static BackgroundModifierWidget create(int x, int y, int width, int height) {
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            BackgroundModifierWidget.loadModifier(ids, components);
            return new BackgroundModifierWidget(x, y, width, height, (Component)Component.m_237115_((String)"camera_modifier_screen.background_modifier"), ids, components);
        }

        private static void loadModifier(List<String> ids, List<MutableComponent> components) {
            HashMap<String, CameraModifierManager.Modifier> b = new HashMap<String, CameraModifierManager.Modifier>(CameraModifierManager.getModifiersB());
            for (String order : CameraModifierManager.getPlayerRemovedBackground()) {
                b.remove(order);
            }
            for (String id : b.keySet()) {
                ids.add(id);
                components.add(Component.m_237115_((String)("freecamera.modifier." + id)));
            }
        }
    }

    private static class PlayerRemovedModifierWidget
    extends ComponentSCRollWidget {
        private BackgroundModifierWidget backgroundModifier;

        public PlayerRemovedModifierWidget(int x, int y, int width, int height, Component message, List<MutableComponent> list) {
            super(x, y, width, height, message, list);
        }

        @Override
        protected void onDoubleSelected(int index) {
            CameraModifierManager.getPlayerRemovedBackground().remove(index);
            this.list.remove(index);
            this.backgroundModifier.reload();
            this.onListChanged();
        }

        private static PlayerRemovedModifierWidget create(int x, int y, int width, int height) {
            List<String> playerOrder = CameraModifierManager.getPlayerRemovedBackground();
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            for (String id : playerOrder) {
                components.add(Component.m_237115_((String)("freecamera.modifier." + id)));
            }
            return new PlayerRemovedModifierWidget(x, y, width, height, (Component)Component.m_237115_((String)"camera_modifier_screen.removed_modifier"), components);
        }

        protected void reload() {
            this.list.clear();
            for (String id : CameraModifierManager.getPlayerRemovedBackground()) {
                this.list.add(Component.m_237115_((String)("freecamera.modifier." + id)));
            }
            this.onListChanged();
        }
    }

    private static class ComponentSCRollWidget
    extends AbstractWidget {
        protected final List<MutableComponent> list;
        private final int maxCount;
        private int paneLength;
        private double roll;
        protected int selected = -1;

        public ComponentSCRollWidget(int x, int y, int width, int height, Component message, List<MutableComponent> list) {
            super(x, y, width, height, message);
            this.list = list;
            this.maxCount = (height - 8) / 11;
            this.paneLength = list.size() <= this.maxCount ? height - 3 : (int)java.lang.Math.max(3.0, java.lang.Math.ceil((float)(height - 8) / (float)java.lang.Math.max(list.size() - this.maxCount, 1)));
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            ComponentContents contents;
            Font font = Minecraft.m_91087_().f_91062_;
            int x = this.m_252754_();
            int y = this.m_252907_();
            int width = this.m_5711_();
            int height = this.m_93694_();
            guiGraphics.m_280430_(font, this.m_6035_(), x + 5, y + height + 5, -1);
            guiGraphics.m_280315_(x + 2, y + height + 2, y + height + 17, -29548);
            guiGraphics.m_280315_(x + width - 2, y + height + 2, y + height + 17, -29548);
            guiGraphics.m_280656_(x + 2, x + width - 2, y + height + 2, -29548);
            guiGraphics.m_280656_(x + 2, x + width - 2, y + height + 17, -29548);
            guiGraphics.m_280315_(x, y, y + height, -29548);
            guiGraphics.m_280315_(x + width, y, y + height, -29548);
            guiGraphics.m_280656_(x, x + width, y, -29548);
            guiGraphics.m_280656_(x, x + width, y + height, -29548);
            int index = java.lang.Math.min((int)this.roll, this.list.size() - 1);
            guiGraphics.m_280509_((x += 4) + (width -= 8), (y += 4) - 2, x + width + 3, y + (height -= 8) + 3, -1);
            int paneStart = (int)((float)(y - 2) + (float)index / (float)java.lang.Math.max(1, this.list.size() - this.maxCount) * (float)(height + 5 - this.paneLength));
            paneStart = java.lang.Math.max(y - 2, paneStart);
            guiGraphics.m_280509_(x + width, paneStart, x + width + 3, paneStart + this.paneLength, -16777216);
            if (this.list.isEmpty()) {
                guiGraphics.m_280137_(font, "null", x + width / 2, y + height / 2, 0xFFFFFF);
            } else {
                for (int count = this.maxCount; index < this.list.size() && count > 0; ++index, --count) {
                    MutableComponent literal = this.list.get(index).m_6881_();
                    if (index == this.selected) {
                        guiGraphics.m_280509_(x - 1, y - 1, x + width - 2, y + 9, 0x77FFFFFF);
                        literal.m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.BOLD);
                        guiGraphics.m_280430_(font, (Component)literal, x, y, -1);
                    } else {
                        guiGraphics.m_280430_(font, (Component)literal, x, y, -1);
                    }
                    guiGraphics.m_280656_(x - 2, x + width - 2, y - 2, -21850);
                    guiGraphics.m_280315_(x - 2, y - 2, y + 9, -21850);
                    guiGraphics.m_280315_(x + width - 2, y - 2, y + 9, -21850);
                    y += 11;
                }
                guiGraphics.m_280656_(x - 2, x + width - 2, y - 2, -21850);
            }
            if (mouseX > this.m_252754_() + 2 && mouseX < this.m_252754_() + this.m_5711_() - 2 && mouseY > this.m_252907_() + this.m_93694_() + 2 && mouseY < this.m_252907_() + this.m_93694_() + 17 && (contents = this.m_6035_().m_214077_()) instanceof TranslatableContents) {
                TranslatableContents c = (TranslatableContents)contents;
                guiGraphics.m_280666_(font, List.of(Component.m_237115_((String)(c.m_237508_() + ".tip1")), Component.m_237115_((String)(c.m_237508_() + ".tip2"))), mouseX, mouseY);
            }
        }

        public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
            this.roll = Math.clamp((double)(this.roll - pDelta), (double)0.0, (double)java.lang.Math.max(this.list.size() - this.maxCount, 0));
            return true;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.f_93623_ && this.f_93624_ && button == 0) {
                int x = this.m_252754_() + 2;
                int y = this.m_252907_() + 2;
                int width = this.m_5711_() - 7;
                int height = this.maxCount * 11 + 1;
                if (!(mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height))) {
                    this.selected = -1;
                    return false;
                }
                int i = java.lang.Math.min((int)(mouseY - (double)y) / 11, this.maxCount - 1) + java.lang.Math.min((int)this.roll, this.list.size() - 1);
                if (i >= this.list.size()) {
                    this.selected = -1;
                    return true;
                }
                if (this.selected == i) {
                    this.onDoubleSelected(i);
                } else {
                    this.selected = i;
                }
                return true;
            }
            return false;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }

        protected void onDoubleSelected(int index) {
        }

        protected void onListChanged() {
            this.paneLength = this.list.size() <= this.maxCount ? this.f_93619_ - 3 : (int)java.lang.Math.max(3.0, java.lang.Math.ceil((float)(this.f_93619_ - 8) / (float)java.lang.Math.max(this.list.size() - this.maxCount, 1)));
        }
    }
}

