/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client;

import java.util.Map;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.tysontheember.apertureapi.InterpolationMath;
import net.tysontheember.apertureapi.client.CameraAnimIdeCache;
import net.tysontheember.apertureapi.client.ClientUtil;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.JitterPrevention;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import net.tysontheember.apertureapi.common.animation.TimeInterpolator;
import net.tysontheember.apertureapi.path.ArcLengthLUT;
import net.tysontheember.apertureapi.path.CatmullRom;
import net.tysontheember.apertureapi.path.OrientationUtil;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PreviewAnimator {
    public static final PreviewAnimator INSTANCE = new PreviewAnimator();
    private boolean playing;
    private boolean loop = false;
    private int time;
    private boolean constantSpeed = true;
    private boolean quaternionOrientation = true;
    private SpeedMode speedMode = SpeedMode.DURATION;
    private float speedBlocksPerSec = 6.0f;
    private float segDistance = 0.0f;
    private Integer segPreTime = null;
    private Integer segNextTime = null;
    private boolean followTargetEnabled = false;
    private final Vector3f followTarget = new Vector3f();
    private float followLag = 0.2f;
    private final Vector3f lastAimDir = new Vector3f();
    private boolean hasLastAimDir = false;
    private SegmentLUT currentLUT;

    public void tick() {
        if (!this.playing) {
            return;
        }
        if (this.speedMode == SpeedMode.SPEED) {
            float dt = 0.05f;
            this.segDistance += Math.max(0.0f, this.speedBlocksPerSec) * dt;
        } else if (this.time >= CameraAnimIdeCache.getPath().getLength()) {
            if (this.loop) {
                this.time = 0;
            } else {
                this.finishPreview();
            }
        } else {
            ++this.time;
        }
    }

    public void play() {
        this.playing = true;
    }

    public void stop() {
        this.playing = false;
        try {
            CameraAnimIdeCache.PREVIEW = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reset();
    }

    public void reset() {
        this.time = 0;
        this.playing = false;
        this.currentLUT = null;
        this.segDistance = 0.0f;
        this.segPreTime = null;
        this.segNextTime = null;
        this.hasLastAimDir = false;
    }

    private void finishPreview() {
        this.playing = false;
        try {
            CameraAnimIdeCache.PREVIEW = false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reset();
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void back() {
        if (this.time <= 0) {
            return;
        }
        this.time = Math.max(0, this.time - 5);
    }

    public void forward() {
        if (this.time >= CameraAnimIdeCache.getPath().getLength()) {
            return;
        }
        this.time = Math.min(CameraAnimIdeCache.getPath().getLength(), this.time + 5);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean prepareCameraInfo(Vector3f posDest, Vector3f rotDest, float[] fov) {
        float t;
        Map.Entry<Integer, CameraKeyframe> nextEntry;
        Map.Entry<Integer, CameraKeyframe> preEntry;
        float currentTime;
        GlobalCameraPath track;
        block39: {
            Map.Entry<Integer, CameraKeyframe> second;
            Map.Entry<Integer, CameraKeyframe> first;
            float partialTicks = this.isPlaying() ? ClientUtil.partialTicks() : 0.0f;
            track = CameraAnimIdeCache.getPath();
            currentTime = (float)this.time + partialTicks;
            if (this.speedMode == SpeedMode.SPEED) {
                if (this.segPreTime == null || this.segNextTime == null) {
                    first = track.getNextEntry(Integer.MIN_VALUE);
                    if (first == null) {
                        return false;
                    }
                    second = track.getNextEntry(first.getKey());
                    if (second == null) {
                        return false;
                    }
                    this.segPreTime = first.getKey();
                    this.segNextTime = second.getKey();
                    this.segDistance = 0.0f;
                    this.currentLUT = null;
                }
                if ((preEntry = track.getEntry(this.segPreTime)) == null || !Objects.equals(preEntry.getKey(), this.segPreTime)) {
                    preEntry = track.getPreEntry(this.segPreTime + 1);
                }
                if ((nextEntry = track.getEntry(this.segNextTime)) == null || !Objects.equals(nextEntry.getKey(), this.segNextTime)) {
                    nextEntry = track.getNextEntry(this.segPreTime);
                }
            } else {
                preEntry = track.getPreEntry(this.time + 1);
                nextEntry = track.getNextEntry(this.time);
            }
            if (preEntry == null) {
                if (nextEntry == null) {
                    return false;
                }
                posDest.set((Vector3fc)nextEntry.getValue().getPos());
                rotDest.set((Vector3fc)nextEntry.getValue().getRot());
                fov[0] = nextEntry.getValue().getFov();
                return true;
            }
            if (nextEntry == null) {
                if (this.speedMode == SpeedMode.SPEED && this.loop && track.getPoints().size() >= 2) {
                    first = track.getNextEntry(Integer.MIN_VALUE);
                    Map.Entry<Integer, CameraKeyframe> entry = second = first == null ? null : track.getNextEntry(first.getKey());
                    if (first != null && second != null) {
                        this.segPreTime = first.getKey();
                        this.segNextTime = second.getKey();
                        this.segDistance = 0.0f;
                        this.currentLUT = null;
                        preEntry = first;
                        nextEntry = second;
                        break block39;
                    } else {
                        this.finishPreview();
                        posDest.set((Vector3fc)preEntry.getValue().getPos());
                        rotDest.set((Vector3fc)preEntry.getValue().getRot());
                        fov[0] = preEntry.getValue().getFov();
                        return true;
                    }
                }
                this.finishPreview();
                posDest.set((Vector3fc)preEntry.getValue().getPos());
                rotDest.set((Vector3fc)preEntry.getValue().getRot());
                fov[0] = preEntry.getValue().getFov();
                return true;
            }
        }
        if (this.speedMode != SpeedMode.SPEED) {
            float timeDelta = nextEntry.getKey() - preEntry.getKey();
            t = timeDelta <= 0.001f ? 0.0f : JitterPrevention.calculateSmoothT(currentTime, preEntry.getKey(), nextEntry.getKey());
        } else {
            this.ensureSegmentLUT(track, preEntry, nextEntry, nextEntry.getValue().getPathInterpolator());
            float segLen = this.currentLUT != null && this.currentLUT.lut != null ? this.currentLUT.lut.totalLength() : 0.0f;
            while (segLen > 1.0E-6f && this.segDistance > segLen) {
                this.segDistance -= segLen;
                Map.Entry<Integer, CameraKeyframe> newPre = nextEntry;
                Map.Entry<Integer, CameraKeyframe> newNext = track.getNextEntry(newPre.getKey());
                if (newNext == null) {
                    if (this.loop) {
                        Map.Entry<Integer, CameraKeyframe> first = track.getNextEntry(Integer.MIN_VALUE);
                        if (first == null || (newNext = track.getNextEntry((newPre = first).getKey())) == null) {
                            break;
                        }
                    } else {
                        this.playing = false;
                        break;
                    }
                }
                preEntry = newPre;
                nextEntry = newNext;
                this.ensureSegmentLUT(track, preEntry, nextEntry, nextEntry.getValue().getPathInterpolator());
                segLen = this.currentLUT != null && this.currentLUT.lut != null ? this.currentLUT.lut.totalLength() : 0.0f;
            }
            t = this.currentLUT != null && this.currentLUT.lut != null && this.currentLUT.lut.totalLength() > 1.0E-6f ? this.currentLUT.lut.tForDistance(Math.max(0.0f, Math.min(this.segDistance, this.currentLUT.lut.totalLength()))) : 0.0f;
        }
        CameraKeyframe pre = preEntry.getValue();
        CameraKeyframe next = nextEntry.getValue();
        float t1 = next.getPosTimeInterpolator() == TimeInterpolator.BEZIER ? next.getPosBezier().interpolate(t) : t;
        float tPos = t1;
        if (this.constantSpeed && next.getPathInterpolator() != PathInterpolator.STEP) {
            this.ensureSegmentLUT(track, preEntry, nextEntry, next.getPathInterpolator());
            if (this.currentLUT != null && this.currentLUT.lut != null && this.currentLUT.lut.totalLength() > 1.0E-6f) {
                float desired = this.currentLUT.lut.totalLength() * t1;
                tPos = this.currentLUT.lut.tForDistance(desired);
            }
        }
        switch (next.getPathInterpolator()) {
            case LINEAR: {
                InterpolationMath.line(tPos, pre.getPos(), next.getPos(), posDest);
                break;
            }
            case COSINE: {
                float tCos = (1.0f - (float)Math.cos(Math.PI * (double)tPos)) * 0.5f;
                InterpolationMath.line(tCos, pre.getPos(), next.getPos(), posDest);
                break;
            }
            case SMOOTH: {
                Map.Entry<Integer, CameraKeyframe> prePre = track.getPreEntry(preEntry.getKey());
                Vector3f p0 = prePre == null ? pre.getPos() : prePre.getValue().getPos();
                Map.Entry<Integer, CameraKeyframe> nextNext = track.getNextEntry(nextEntry.getKey());
                Vector3f p3 = nextNext == null ? next.getPos() : nextNext.getValue().getPos();
                InterpolationMath.catmullRom(tPos, p0, pre.getPos(), next.getPos(), p3, posDest);
                break;
            }
            case CATMULL_UNIFORM: 
            case CATMULL_CHORDAL: 
            case CATMULL_CENTRIPETAL: {
                Map.Entry<Integer, CameraKeyframe> prePre = track.getPreEntry(preEntry.getKey());
                Vector3f p0 = prePre == null ? pre.getPos() : prePre.getValue().getPos();
                Map.Entry<Integer, CameraKeyframe> nextNext = track.getNextEntry(nextEntry.getKey());
                Vector3f p3 = nextNext == null ? next.getPos() : nextNext.getValue().getPos();
                float alpha = switch (next.getPathInterpolator()) {
                    case PathInterpolator.CATMULL_UNIFORM -> 0.0f;
                    case PathInterpolator.CATMULL_CHORDAL -> 1.0f;
                    default -> 0.5f;
                };
                CatmullRom.eval(tPos, p0, pre.getPos(), next.getPos(), p3, alpha, posDest);
                break;
            }
            case BEZIER: {
                next.getPathBezier().interpolate(tPos, pre.getPos(), next.getPos(), posDest);
                break;
            }
            case STEP: {
                posDest.set((Vector3fc)pre.getPos());
                break;
            }
        }
        t1 = next.getRotTimeInterpolator() == TimeInterpolator.BEZIER ? next.getRotBezier().interpolate(t) : t;
        if (this.followTargetEnabled) {
            Vector3f desired = new Vector3f((Vector3fc)this.followTarget).sub((Vector3fc)posDest).normalize();
            if (!this.hasLastAimDir) {
                this.lastAimDir.set((Vector3fc)desired);
                this.hasLastAimDir = true;
            }
            this.lastAimDir.lerp((Vector3fc)desired, Mth.m_14036_((float)this.followLag, (float)0.0f, (float)1.0f));
            float yaw = (float)Math.toDegrees(Math.atan2(-this.lastAimDir.x, this.lastAimDir.z));
            float pitch = (float)(-Math.toDegrees(Math.atan2(this.lastAimDir.y, Math.sqrt(this.lastAimDir.x * this.lastAimDir.x + this.lastAimDir.z * this.lastAimDir.z))));
            rotDest.set(pitch, yaw, 0.0f);
        } else {
            Vector3f preRot = pre.getRot();
            Vector3f nextRot = next.getRot();
            if (this.quaternionOrientation) {
                Quaternionf qa = OrientationUtil.yprDegToQuat(preRot.y, preRot.x, preRot.z, new Quaternionf());
                Quaternionf qb = OrientationUtil.yprDegToQuat(nextRot.y, nextRot.x, nextRot.z, new Quaternionf());
                Quaternionf qOut = new Quaternionf();
                OrientationUtil.slerp(qa, qb, t1, qOut);
                OrientationUtil.quatToYprDeg(qOut, rotDest);
            } else {
                JitterPrevention.smoothRotationLerp(t1, preRot, nextRot, rotDest);
            }
        }
        t1 = next.getFovTimeInterpolator() == TimeInterpolator.BEZIER ? next.getFovBezier().interpolate(t) : t;
        fov[0] = JitterPrevention.smoothFovLerp(t1, pre.getFov(), next.getFov());
        return true;
    }

    private void ensureSegmentLUT(GlobalCameraPath track, Map.Entry<Integer, CameraKeyframe> preEntry, Map.Entry<Integer, CameraKeyframe> nextEntry, PathInterpolator mode) {
        int preTime = preEntry.getKey();
        int nextTime = nextEntry.getKey();
        if (this.currentLUT != null && this.currentLUT.preTime == preTime && this.currentLUT.nextTime == nextTime && this.currentLUT.mode == mode) {
            return;
        }
        this.currentLUT = new SegmentLUT();
        this.currentLUT.preTime = preTime;
        this.currentLUT.nextTime = nextTime;
        this.currentLUT.mode = mode;
        CameraKeyframe pre = preEntry.getValue();
        CameraKeyframe next = nextEntry.getValue();
        Map.Entry<Integer, CameraKeyframe> prePre = track.getPreEntry(preEntry.getKey());
        Vector3f p0 = prePre == null ? pre.getPos() : prePre.getValue().getPos();
        Map.Entry<Integer, CameraKeyframe> nextNext = track.getNextEntry(nextEntry.getKey());
        Vector3f p3 = nextNext == null ? next.getPos() : nextNext.getValue().getPos();
        ArcLengthLUT.Evaluator f = (tt, out) -> {
            switch (mode) {
                case LINEAR: {
                    InterpolationMath.line(tt, pre.getPos(), next.getPos(), out);
                    break;
                }
                case COSINE: {
                    float tCos = (1.0f - (float)Math.cos(Math.PI * (double)tt)) * 0.5f;
                    InterpolationMath.line(tCos, pre.getPos(), next.getPos(), out);
                    break;
                }
                case SMOOTH: {
                    InterpolationMath.catmullRom(tt, p0, pre.getPos(), next.getPos(), p3, out);
                    break;
                }
                case CATMULL_UNIFORM: {
                    CatmullRom.eval(tt, p0, pre.getPos(), next.getPos(), p3, 0.0f, out);
                    break;
                }
                case CATMULL_CENTRIPETAL: {
                    CatmullRom.eval(tt, p0, pre.getPos(), next.getPos(), p3, 0.5f, out);
                    break;
                }
                case CATMULL_CHORDAL: {
                    CatmullRom.eval(tt, p0, pre.getPos(), next.getPos(), p3, 1.0f, out);
                    break;
                }
                case BEZIER: {
                    pre.getPathBezier().interpolate(tt, pre.getPos(), next.getPos(), out);
                    break;
                }
                case STEP: {
                    out.set((Vector3fc)pre.getPos());
                }
            }
            return out;
        };
        this.currentLUT.lut = new ArcLengthLUT(f, 64);
    }

    public PreviewAnimator setLoop(boolean loop) {
        this.loop = loop;
        return this;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public PreviewAnimator setConstantSpeed(boolean enabled) {
        this.constantSpeed = enabled;
        return this;
    }

    public PreviewAnimator setQuaternionOrientation(boolean enabled) {
        this.quaternionOrientation = enabled;
        return this;
    }

    public PreviewAnimator setSpeedMode(SpeedMode mode) {
        this.speedMode = mode == null ? SpeedMode.DURATION : mode;
        return this;
    }

    public PreviewAnimator setSpeedBlocksPerSec(float bps) {
        this.speedBlocksPerSec = Math.max(0.0f, bps);
        return this;
    }

    public PreviewAnimator enableFollowTarget(boolean enabled) {
        this.followTargetEnabled = enabled;
        if (!enabled) {
            this.hasLastAimDir = false;
        }
        return this;
    }

    public PreviewAnimator setFollowTarget(float x, float y, float z) {
        this.followTarget.set(x, y, z);
        return this;
    }

    public PreviewAnimator setFollowLag(float lag) {
        this.followLag = lag;
        return this;
    }

    public static enum SpeedMode {
        DURATION,
        SPEED;

    }

    private static final class SegmentLUT {
        int preTime;
        int nextTime;
        PathInterpolator mode;
        ArcLengthLUT lut;

        private SegmentLUT() {
        }
    }
}

