/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tysontheember.apertureapi.CommonConf;

@Mod.EventBusSubscriber(modid="apertureapi", value={Dist.CLIENT})
public class CutsceneFadeOverlay
implements IGuiOverlay {
    private static Phase phase = Phase.IDLE;
    private static int phaseTimer = 0;
    private static int phaseDuration = 0;
    private static int enterOutTicks = 0;
    private static int enterInTicks = 0;
    private static int exitOutTicks = 0;
    private static int exitInTicks = 0;
    private static Runnable atBlackCallback = null;
    private static Runnable atBlackExitCallback = null;
    private static Boolean prevHideGui = null;

    public static void onCutsceneStart() {
        CutsceneFadeOverlay.startEnterSequence(null);
    }

    public static void startEnterSequence(Runnable atBlack) {
        enterOutTicks = (Integer)CommonConf.CUTSCENE_ENTER_FADE_OUT_TICKS.get();
        enterInTicks = (Integer)CommonConf.CUTSCENE_ENTER_FADE_IN_TICKS.get();
        atBlackCallback = atBlack;
        try {
            if (prevHideGui == null) {
                prevHideGui = Minecraft.m_91087_().f_91066_.f_92062_;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (enterOutTicks > 0) {
            phase = Phase.ENTER_OUT;
            phaseDuration = enterOutTicks;
            phaseTimer = 0;
        } else if (enterInTicks > 0) {
            if (atBlackCallback != null) {
                try {
                    atBlackCallback.run();
                }
                catch (Throwable throwable) {
                }
                finally {
                    atBlackCallback = null;
                }
            }
            phase = Phase.ENTER_IN;
            phaseDuration = enterInTicks;
            phaseTimer = 0;
        } else {
            if (atBlackCallback != null) {
                try {
                    atBlackCallback.run();
                }
                catch (Throwable throwable) {
                }
                finally {
                    atBlackCallback = null;
                }
            }
            phase = Phase.IDLE;
            phaseTimer = 0;
            phaseDuration = 0;
        }
    }

    public static void onCutsceneEnd() {
        CutsceneFadeOverlay.startExitSequence(null);
    }

    public static void startExitSequence(Runnable atBlack) {
        exitOutTicks = (Integer)CommonConf.CUTSCENE_EXIT_FADE_OUT_TICKS.get();
        exitInTicks = (Integer)CommonConf.CUTSCENE_EXIT_FADE_IN_TICKS.get();
        atBlackExitCallback = atBlack;
        if (exitOutTicks > 0) {
            phase = Phase.EXIT_OUT;
            phaseDuration = exitOutTicks;
            phaseTimer = 0;
        } else if (exitInTicks > 0) {
            if (atBlackExitCallback != null) {
                try {
                    atBlackExitCallback.run();
                }
                catch (Throwable throwable) {
                }
                finally {
                    atBlackExitCallback = null;
                }
            }
            phase = Phase.EXIT_IN;
            phaseDuration = exitInTicks;
            phaseTimer = 0;
        } else {
            if (atBlackExitCallback != null) {
                try {
                    atBlackExitCallback.run();
                }
                catch (Throwable throwable) {
                }
                finally {
                    atBlackExitCallback = null;
                }
            }
            phase = Phase.IDLE;
            phaseTimer = 0;
            phaseDuration = 0;
            try {
                if (prevHideGui != null) {
                    Minecraft.m_91087_().f_91066_.f_92062_ = prevHideGui;
                    prevHideGui = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent e) {
        block28: {
            if (e.phase != TickEvent.Phase.END) {
                return;
            }
            if (phase == Phase.IDLE) {
                return;
            }
            if (phaseDuration > 0 && ++phaseTimer < phaseDuration) break block28;
            switch (phase) {
                case ENTER_OUT: {
                    if (atBlackCallback != null) {
                        try {
                            atBlackCallback.run();
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            atBlackCallback = null;
                        }
                    }
                    if (enterInTicks > 0) {
                        phase = Phase.ENTER_IN;
                        phaseDuration = enterInTicks;
                        phaseTimer = 0;
                        break;
                    }
                    phase = Phase.IDLE;
                    try {
                        if (prevHideGui == null) break;
                        Minecraft.m_91087_().f_91066_.f_92062_ = true;
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                case ENTER_IN: {
                    phase = Phase.IDLE;
                    try {
                        if (prevHideGui == null) break;
                        Minecraft.m_91087_().f_91066_.f_92062_ = true;
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                case EXIT_OUT: {
                    if (atBlackExitCallback != null) {
                        try {
                            atBlackExitCallback.run();
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            atBlackExitCallback = null;
                        }
                    }
                    if (exitInTicks > 0) {
                        phase = Phase.EXIT_IN;
                        phaseDuration = exitInTicks;
                        phaseTimer = 0;
                        break;
                    }
                    phase = Phase.IDLE;
                    try {
                        if (prevHideGui == null) break;
                        Minecraft.m_91087_().f_91066_.f_92062_ = prevHideGui;
                        prevHideGui = null;
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                case EXIT_IN: {
                    phase = Phase.IDLE;
                    try {
                        if (prevHideGui == null) break;
                        Minecraft.m_91087_().f_91066_.f_92062_ = prevHideGui;
                        prevHideGui = null;
                    }
                    catch (Throwable throwable) {}
                    break;
                }
            }
        }
    }

    public void render(ForgeGui gui, GuiGraphics g, float partialTick, int screenWidth, int screenHeight) {
        float alpha = CutsceneFadeOverlay.currentAlpha();
        if (alpha <= 0.001f) {
            return;
        }
        int a = Math.min(255, Math.max(0, (int)(alpha * 255.0f)));
        int color = a << 24 | 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        g.m_280509_(0, 0, screenWidth, screenHeight, color);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static float currentAlpha() {
        if (phase == Phase.IDLE) {
            return 0.0f;
        }
        float t = phaseDuration <= 0 ? 1.0f : Math.min(1.0f, Math.max(0.0f, (float)phaseTimer / (float)phaseDuration));
        return switch (phase) {
            default -> throw new IncompatibleClassChangeError();
            case Phase.ENTER_OUT -> t;
            case Phase.ENTER_IN -> 1.0f - t;
            case Phase.EXIT_OUT -> t;
            case Phase.EXIT_IN -> 1.0f - t;
            case Phase.IDLE -> 0.0f;
        };
    }

    public static boolean isActive() {
        return phase != Phase.IDLE;
    }

    private static enum Phase {
        IDLE,
        ENTER_OUT,
        ENTER_IN,
        EXIT_OUT,
        EXIT_IN;

    }
}

