/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client.gui.screen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.loading.FMLPaths;
import net.tysontheember.apertureapi.client.CameraAnimIdeCache;
import net.tysontheember.apertureapi.client.ClientUtil;
import net.tysontheember.apertureapi.client.gui.screen.InfoScreen;
import net.tysontheember.apertureapi.client.gui.screen.RemotePathSearchScreen;
import net.tysontheember.apertureapi.client.gui.widget.NumberEditBox;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import oshi.util.tuples.Triplet;

public class LocalPathSearchScreen
extends Screen {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private final List<Triplet<Component, Component, Component>> list = new ArrayList<Triplet<Component, Component, Component>>();
    private EditBox filterBox;
    private EditBox pathBox;
    private EditBox newIdBox;
    private int scrollOffset = 0;
    private int lastClickIndex = -1;
    private long lastClickTimeMs = 0L;
    private static final Gson GSON = new Gson();
    private static final String SERIALIZER_VERSION = "1.0.0";
    private static final Component PAGE = Component.m_237115_((String)"gui.camera_anim.local_path_search.page");
    private static final Component SEARCH = Component.m_237115_((String)"gui.camera_anim.local_path_search.search");
    private static final Component LOAD = Component.m_237115_((String)"gui.camera_anim.local_path_search.load");
    private static final Component LOAD_ID = Component.m_237115_((String)"gui.camera_anim.local_path_search.load_id");
    private static final Component SAVE = Component.m_237115_((String)"gui.camera_anim.local_path_search.save");
    private static final Component SAVE_ID = Component.m_237115_((String)"gui.camera_anim.local_path_search.save_id");
    private static final Component REMOTE_MODE = Component.m_237115_((String)"gui.camera_anim.local_path_search.remote_mode");
    private static final Component PATH_ID = Component.m_237115_((String)"gui.camera_anim.local_path_search.path_id");
    private static final Component MODIFIER = Component.m_237115_((String)"gui.camera_anim.local_path_search.modifier");
    private static final Component TIME = Component.m_237115_((String)"gui.camera_anim.local_path_search.time");
    private static final Component TIP = Component.m_237115_((String)"gui.camera_anim.local_path_search.tip");
    private static final Component LOCAL_FILE = Component.m_237115_((String)"gui.camera_anim.local_path_search.local_file");
    private static final Component LOAD_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.load_error");
    private static final Component VERSION_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.version_error");
    private static final Component FILE_LOAD_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_load_error");
    private static final Component FILE_FORMAT_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_format_error");
    private static final Component FILE_EXIST_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_exist_error");
    private static final Component FILE_SAVE_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_save_error");
    private static final Component FILE_LOAD_SUCCESS = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_load_success");

    public LocalPathSearchScreen() {
        super((Component)Component.m_237113_((String)"local path search"));
    }

    protected void m_7856_() {
        int m = 20;
        int s = 10;
        int y = m;
        int rowH = 20;
        int avail = this.f_96543_ - m * 2;
        int pageW = 40;
        int searchW = 100;
        int loadBtnW = 60;
        int saveBtnW = 60;
        int modeW = 120;
        int gaps = 6;
        int remaining = avail - (pageW + searchW + loadBtnW + saveBtnW + modeW) - s * gaps;
        int flexW = Math.max(100, remaining / 2);
        int x = m;
        NumberEditBox page = (NumberEditBox)this.m_142416_((GuiEventListener)new NumberEditBox(this.f_96547_, x, y, pageW, rowH, 1, (Component)Component.m_237113_((String)"page")));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)SEARCH, b -> this.searchFromFile()).m_252794_(x += pageW + s, y).m_253046_(searchW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Refreshes the local animations list"))).m_253136_());
        this.pathBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x += searchW + s, y, flexW, rowH, (Component)Component.m_237113_((String)"path id")));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)LOAD, b -> this.getFromFile(this.pathBox.m_94155_())).m_252794_(x += flexW + s, y).m_253046_(loadBtnW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Load the animation with the given ID"))).m_253136_());
        this.newIdBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x += loadBtnW + s, y, flexW, rowH, (Component)Component.m_237113_((String)"new id")));
        this.newIdBox.m_94144_(CameraAnimIdeCache.getPath().getId());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)SAVE, b -> this.saveToFile(this.newIdBox.m_94155_())).m_252794_(x += flexW + s, y).m_253046_(saveBtnW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Save the current path to a local file with this ID"))).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)REMOTE_MODE, b -> Minecraft.m_91087_().m_91152_((Screen)new RemotePathSearchScreen())).m_252794_(this.f_96543_ - m - modeW, y).m_253046_(modeW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Switch to Remote mode"))).m_253136_());
        this.filterBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, m, y += rowH + 20, this.f_96543_ - m * 2, 18, (Component)Component.m_237113_((String)"filter")));
        this.filterBox.m_257771_((Component)Component.m_237113_((String)"Search..."));
        this.scrollOffset = 0;
        this.searchFromFile();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int m = 20;
        int avail = this.f_96543_ - m * 2;
        int idW = (int)((float)avail * 0.5f);
        int modW = (int)((float)avail * 0.2f);
        int timeW = avail - idW - modW;
        int idX = m;
        int modX = m + idW + 10;
        int timeX = modX + modW + 10;
        guiGraphics.m_280430_(this.f_96547_, PAGE, m + 5, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, LOAD_ID, m + 205, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, SAVE_ID, m + 365, 10, -1);
        int headerY = m + 20 + 20 + 24;
        guiGraphics.m_280430_(this.f_96547_, PATH_ID, idX, headerY, -1);
        guiGraphics.m_280430_(this.f_96547_, MODIFIER, modX, headerY, -1);
        guiGraphics.m_280430_(this.f_96547_, TIME, timeX, headerY, -1);
        ArrayList<Triplet<Component, Component, Component>> filtered = new ArrayList<Triplet<Component, Component, Component>>();
        String q = this.filterBox.m_94155_() == null ? "" : this.filterBox.m_94155_().toLowerCase(Locale.ROOT);
        for (Triplet<Component, Component, Component> t : this.list) {
            String id = ((Component)t.getA()).getString().toLowerCase(Locale.ROOT);
            if (!q.isEmpty() && !id.contains(q)) continue;
            filtered.add(t);
        }
        int top = headerY + 12;
        int rowH = 11;
        int visible = Math.max(0, (this.f_96544_ - top - 40) / rowH);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, Math.max(0, filtered.size() - visible)));
        if (!filtered.isEmpty()) {
            for (int i = 0; i < visible && i + this.scrollOffset < filtered.size(); ++i) {
                Triplet info = (Triplet)filtered.get(i + this.scrollOffset);
                int y = top + i * rowH;
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getA(), idX, y, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getB(), modX, y, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getC(), timeX, y, -1);
            }
        } else {
            guiGraphics.m_280653_(this.f_96547_, TIP, this.f_96543_ / 2, this.f_96544_ / 2, -1);
        }
    }

    private void searchFromFile() {
        Path path = FMLPaths.GAMEDIR.get().resolve("camera-anim");
        this.list.clear();
        if (path.toFile().exists()) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                    private int count = 0;

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String name = file.getFileName().toString();
                        if (name.endsWith(".json")) {
                            LocalPathSearchScreen.this.list.add((Triplet<Component, Component, Component>)new Triplet((Object)Component.m_237113_((String)name.substring(0, name.length() - 5)), (Object)LOCAL_FILE, (Object)Component.m_237113_((String)FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(attrs.lastModifiedTime().toMillis()), ZONE_ID)))));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                ClientUtil.pushGuiLayer(new InfoScreen(LOAD_ERROR));
            }
        }
    }

    private void getFromFile(String id) {
        block6: {
            Path path = FMLPaths.GAMEDIR.get().resolve("camera-anim").resolve(id + ".json");
            File file = path.toFile();
            if (file.exists()) {
                try {
                    String json = Files.readString(path);
                    JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
                    if (jsonObject.has("version") && jsonObject.get("version").getAsString().equals(SERIALIZER_VERSION)) {
                        TypeToken<TreeMap<Integer, CameraKeyframe>> type = new TypeToken<TreeMap<Integer, CameraKeyframe>>(){};
                        TreeMap map = (TreeMap)GSON.fromJson(jsonObject.get("anim"), type.getType());
                        CameraAnimIdeCache.setPath(new GlobalCameraPath(map, id));
                        ClientUtil.pushGuiLayer(new InfoScreen(FILE_LOAD_SUCCESS));
                        break block6;
                    }
                    ClientUtil.pushGuiLayer(new InfoScreen(VERSION_ERROR));
                }
                catch (IOException e) {
                    ClientUtil.pushGuiLayer(new InfoScreen(FILE_LOAD_ERROR));
                }
                catch (JsonSyntaxException | NullPointerException e) {
                    ClientUtil.pushGuiLayer(new InfoScreen(FILE_FORMAT_ERROR));
                }
            } else {
                ClientUtil.pushGuiLayer(new InfoScreen(FILE_EXIST_ERROR));
            }
        }
    }

    private void saveToFile(String id) {
        Path path = FMLPaths.GAMEDIR.get().resolve("camera-anim").resolve(id + ".json");
        try {
            JsonObject json = (JsonObject)GSON.fromJson(CameraAnimIdeCache.getPath().toJsonString(GSON), JsonObject.class);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("version", SERIALIZER_VERSION);
            jsonObject.add("anim", (JsonElement)json);
            Files.writeString(path, (CharSequence)jsonObject.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            ClientUtil.pushGuiLayer(new InfoScreen(FILE_SAVE_ERROR));
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int m = 20;
        int headerY = m + 20 + 20 + 24;
        int top = headerY + 12;
        int rowH = 11;
        int visible = Math.max(0, (this.f_96544_ - top - 40) / rowH);
        int max = Math.max(0, this.list.size() - visible);
        this.scrollOffset = (int)Math.max(0.0, Math.min((double)max, (double)this.scrollOffset - Math.signum(delta)));
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int m = 20;
        int headerY = m + 20 + 20 + 24;
        int top = headerY + 12;
        int rowH = 11;
        int right = this.f_96543_ - m;
        if (mouseY >= (double)top && mouseX >= (double)m && mouseX <= (double)right) {
            int index = (int)((mouseY - (double)top) / (double)rowH) + this.scrollOffset;
            String q = this.filterBox.m_94155_() == null ? "" : this.filterBox.m_94155_().toLowerCase(Locale.ROOT);
            ArrayList<Triplet<Component, Component, Component>> filtered = new ArrayList<Triplet<Component, Component, Component>>();
            for (Triplet<Component, Component, Component> t : this.list) {
                String id = ((Component)t.getA()).getString().toLowerCase(Locale.ROOT);
                if (!q.isEmpty() && !id.contains(q)) continue;
                filtered.add(t);
            }
            if (index >= 0 && index < filtered.size()) {
                String id = ((Component)((Triplet)filtered.get(index)).getA()).getString();
                this.pathBox.m_94144_(id);
                long now = System.currentTimeMillis();
                if (button == 0 && index == this.lastClickIndex && now - this.lastClickTimeMs < 300L) {
                    this.getFromFile(id);
                }
                this.lastClickIndex = index;
                this.lastClickTimeMs = now;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

