/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client.gui.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.tysontheember.apertureapi.client.CameraAnimIdeCache;
import net.tysontheember.apertureapi.client.gui.screen.InterpolationSettingScreen;
import net.tysontheember.apertureapi.client.gui.widget.NumberEditBox;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import org.joml.Vector3f;

public class PointSettingScreen
extends Screen {
    private final NumberEditBox[] numbers = new NumberEditBox[5];
    private CycleButton<PathInterpolator> type;
    private int panelX;
    private int panelY;
    private int panelW;
    private int panelH;
    private static final Component POS = Component.m_237115_((String)"gui.camera_anim.point_setting.pos");
    private static final Component ROT = Component.m_237115_((String)"gui.camera_anim.point_setting.rot");
    private static final Component ZOOM = Component.m_237115_((String)"gui.camera_anim.point_setting.zoom");
    private static final Component TIME = Component.m_237115_((String)"gui.camera_anim.point_setting.time");
    private static final Component SAVE = Component.m_237115_((String)"gui.camera_anim.point_setting.save");
    private static final Component TYPE = Component.m_237115_((String)"gui.camera_anim.point_setting.type");
    private static final Component POS_ERROR = Component.m_237115_((String)"gui.camera_anim.point_setting.pos_error");
    private static final Component ROT_ERROR = Component.m_237115_((String)"gui.camera_anim.point_setting.rot_error");
    private static final Component ZOOM_ERROR = Component.m_237115_((String)"gui.camera_anim.point_setting.zoom_error");
    private static final Component TIME_ERROR = Component.m_237115_((String)"gui.camera_anim.point_setting.time_error");
    private static final Component TIP = Component.m_237115_((String)"gui.camera_anim.point_setting.tip");
    private static final Component INTERPOLATION = Component.m_237115_((String)"gui.camera_anim.point_setting.interpolation");

    public PointSettingScreen() {
        super((Component)Component.m_237113_((String)"Point Setting"));
    }

    protected void m_7856_() {
        CameraAnimIdeCache.SelectedPoint selectedPoint = CameraAnimIdeCache.getSelectedPoint();
        GlobalCameraPath track = CameraAnimIdeCache.getPath();
        int time = selectedPoint.getPointTime();
        Vector3f pos = selectedPoint.getPosition();
        if (pos == null) {
            return;
        }
        int m = 16;
        int s = 8;
        this.panelX = 12;
        this.panelY = 12;
        int y = this.panelY + 4;
        int maxRight = this.panelX + 4;
        int labelW = 40;
        int boxW = 80;
        int boxH = 16;
        int btnW = 110;
        this.m_169394_((Renderable)new StringWidget(this.panelX + 5, y, labelW, 12, POS, this.f_96547_));
        NumberEditBox[] xyz = new NumberEditBox[3];
        int x = this.panelX + 5 + labelW + s;
        xyz[0] = new NumberEditBox(this.f_96547_, x, y, boxW, boxH, pos.x, (Component)Component.m_237113_((String)"x"));
        xyz[1] = new NumberEditBox(this.f_96547_, x += boxW + s, y, boxW, boxH, pos.y, (Component)Component.m_237113_((String)"y"));
        xyz[2] = new NumberEditBox(this.f_96547_, x += boxW + s, y, boxW, boxH, pos.z, (Component)Component.m_237113_((String)"z"));
        x += boxW + s;
        this.m_142416_((GuiEventListener)xyz[0]);
        this.m_142416_((GuiEventListener)xyz[1]);
        this.m_142416_((GuiEventListener)xyz[2]);
        maxRight = Math.max(maxRight, x);
        if (selectedPoint.getControl() == CameraAnimIdeCache.ControlType.NONE) {
            Button posInterpBtn = Button.m_253074_((Component)INTERPOLATION, b -> Minecraft.m_91087_().pushGuiLayer((Screen)new InterpolationSettingScreen(1))).m_252794_(x, y).m_253046_(btnW, boxH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Open position interpolation settings"))).m_253136_();
            this.m_142416_((GuiEventListener)posInterpBtn);
            maxRight = Math.max(maxRight, x + btnW);
            CameraKeyframe point = track.getPoint(time);
            assert (point != null);
            float fov = point.getFov();
            Vector3f rot = point.getRot();
            this.m_169394_((Renderable)new StringWidget(this.panelX + 5, y += boxH + s, labelW, 12, ROT, this.f_96547_));
            x = this.panelX + 5 + labelW + s;
            this.numbers[0] = new NumberEditBox(this.f_96547_, x, y, boxW, boxH, rot.x, (Component)Component.m_237113_((String)"xRot"));
            this.m_142416_((GuiEventListener)this.numbers[0]);
            this.numbers[1] = new NumberEditBox(this.f_96547_, x += boxW + s, y, boxW, boxH, rot.y, (Component)Component.m_237113_((String)"yRot"));
            this.m_142416_((GuiEventListener)this.numbers[1]);
            this.numbers[2] = new NumberEditBox(this.f_96547_, x += boxW + s, y, boxW, boxH, rot.z, (Component)Component.m_237113_((String)"zRot"));
            this.m_142416_((GuiEventListener)this.numbers[2]);
            maxRight = Math.max(maxRight, x += boxW + s);
            Button rotInterpBtn = Button.m_253074_((Component)INTERPOLATION, b -> Minecraft.m_91087_().pushGuiLayer((Screen)new InterpolationSettingScreen(2))).m_252794_(x, y).m_253046_(btnW, boxH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Open rotation interpolation settings"))).m_253136_();
            this.m_142416_((GuiEventListener)rotInterpBtn);
            maxRight = Math.max(maxRight, x + btnW);
            this.m_169394_((Renderable)new StringWidget(this.panelX + 5, y += boxH + s, labelW, 12, ZOOM, this.f_96547_));
            x = this.panelX + 5 + labelW + s;
            this.numbers[3] = new NumberEditBox(this.f_96547_, x, y, boxW, boxH, fov, (Component)Component.m_237113_((String)"zoom"));
            this.m_142416_((GuiEventListener)this.numbers[3]);
            maxRight = Math.max(maxRight, x += boxW + s);
            Button zoomInterpBtn = Button.m_253074_((Component)INTERPOLATION, b -> Minecraft.m_91087_().pushGuiLayer((Screen)new InterpolationSettingScreen(3))).m_252794_(x, y).m_253046_(btnW, boxH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Open zoom interpolation settings"))).m_253136_();
            this.m_142416_((GuiEventListener)zoomInterpBtn);
            maxRight = Math.max(maxRight, x + btnW);
            this.type = CycleButton.m_168894_(PathInterpolator::getDisplayName).m_168961_((Object[])PathInterpolator.values()).m_168948_((Object)point.getPathInterpolator()).m_168936_(this.panelX + 5 + labelW + s, y += boxH + s, 100, boxH + 2, TYPE, (btn, value) -> btn.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(value.getDisplayNameKey() + ".tooltip")))));
            this.m_142416_((GuiEventListener)this.type);
            this.type.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(((PathInterpolator)((Object)this.type.m_168883_())).getDisplayNameKey() + ".tooltip"))));
            this.m_169394_((Renderable)new StringWidget(this.panelX + 5, y + boxH + s, labelW, 12, TIME, this.f_96547_));
            this.numbers[4] = new NumberEditBox(this.f_96547_, this.panelX + 5 + labelW + s, y + boxH + s, boxW, boxH, time, (Component)Component.m_237113_((String)"time"));
            this.m_142416_((GuiEventListener)this.numbers[4]);
            maxRight = Math.max(maxRight, this.panelX + 5 + labelW + s + boxW);
            this.m_142416_((GuiEventListener)this.numbers[4]);
        }
        StringWidget info = new StringWidget(this.panelX + 5, y += (boxH + s) * 2, 240, 12, (Component)Component.m_237113_((String)""), this.f_96547_);
        this.m_169394_((Renderable)info);
        this.m_169394_((Renderable)new StringWidget(this.panelX + 4, y + boxH + s, 400, 12, TIP, this.f_96547_));
        int saveW = 100;
        int saveX = Math.max(this.panelX + 8, maxRight - saveW);
        this.panelW = Math.max(maxRight, saveX + saveW) + s - this.panelX;
        this.panelH = y + boxH + s * 3 - this.panelY;
        Button button = Button.m_253074_((Component)SAVE, b -> {
            float zn;
            float yn;
            float xn;
            try {
                xn = Float.parseFloat(xyz[0].m_94155_());
                yn = Float.parseFloat(xyz[1].m_94155_());
                zn = Float.parseFloat(xyz[2].m_94155_());
            }
            catch (NumberFormatException e) {
                info.m_93666_(POS_ERROR);
                return;
            }
            switch (selectedPoint.getControl()) {
                case LEFT: 
                case RIGHT: {
                    pos.set(xn, yn, zn);
                    this.m_7379_();
                    break;
                }
                case NONE: {
                    CameraKeyframe point = track.getPoint(time);
                    assert (point != null);
                    pos.set(xn, yn, zn);
                    try {
                        float xRot = Float.parseFloat(this.numbers[0].m_94155_());
                        float yRot = Float.parseFloat(this.numbers[1].m_94155_());
                        float zRot = Float.parseFloat(this.numbers[2].m_94155_());
                        point.getRot().set(xRot, yRot, zRot);
                    }
                    catch (NumberFormatException e) {
                        info.m_93666_(ROT_ERROR);
                        return;
                    }
                    try {
                        point.setFov(Float.parseFloat(this.numbers[3].m_94155_()));
                    }
                    catch (NumberFormatException e) {
                        info.m_93666_(ZOOM_ERROR);
                        return;
                    }
                    if (point.getPathInterpolator() != this.type.m_168883_()) {
                        point.setPathInterpolator((PathInterpolator)((Object)((Object)this.type.m_168883_())));
                        track.updateBezier(time);
                    }
                    try {
                        int newTime = Integer.parseInt(this.numbers[4].m_94155_());
                        track.setTime(time, newTime);
                        this.m_7379_();
                        break;
                    }
                    catch (NumberFormatException e) {
                        info.m_93666_(TIME_ERROR);
                    }
                }
            }
        }).m_252794_(saveX, y - 2).m_253046_(saveW, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Save changes to this keyframe"))).m_253136_();
        this.m_142416_((GuiEventListener)button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int x = this.panelX;
        int y = this.panelY;
        int w = Math.max(220, Math.min(this.f_96543_ - 24, this.panelW));
        int h = Math.max(90, this.panelH);
        guiGraphics.m_280656_(x, x + w, y, -6954541);
        guiGraphics.m_280656_(x, x + w, y + h, -6954541);
        guiGraphics.m_280315_(x + w, y, y + h, -6954541);
        guiGraphics.m_280315_(x, y, y + h, -6954541);
    }
}

