/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client.gui.screen;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.tysontheember.apertureapi.client.CameraAnimIdeCache;
import net.tysontheember.apertureapi.client.gui.screen.LocalPathSearchScreen;
import net.tysontheember.apertureapi.client.gui.widget.NumberEditBox;
import net.tysontheember.apertureapi.client.network.ClientPayloadSender;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.data_entity.GlobalCameraPathInfo;
import oshi.util.tuples.Triplet;

public class RemotePathSearchScreen
extends Screen {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private static final Component PAGE = Component.m_237115_((String)"gui.camera_anim.remote_path_search.page");
    private static final Component SEARCH = Component.m_237115_((String)"gui.camera_anim.remote_path_search.search");
    private static final Component LOAD = Component.m_237115_((String)"gui.camera_anim.remote_path_search.load");
    private static final Component LOAD_ID = Component.m_237115_((String)"gui.camera_anim.remote_path_search.load_id");
    private static final Component SAVE = Component.m_237115_((String)"gui.camera_anim.remote_path_search.save");
    private static final Component SAVE_ID = Component.m_237115_((String)"gui.camera_anim.remote_path_search.save_id");
    private static final Component DELETE = Component.m_237115_((String)"gui.camera_anim.remote_path_search.delete");
    private static final Component DELETE_ID = Component.m_237115_((String)"gui.camera_anim.remote_path_search.delete_id");
    private static final Component LOCAL_MODE = Component.m_237115_((String)"gui.camera_anim.remote_path_search.local_mode");
    private static final Component PATH_ID = Component.m_237115_((String)"gui.camera_anim.remote_path_search.path_id");
    private static final Component MODIFIER = Component.m_237115_((String)"gui.camera_anim.remote_path_search.modifier");
    private static final Component TIME = Component.m_237115_((String)"gui.camera_anim.remote_path_search.time");
    private static final Component NO_SERVER = Component.m_237115_((String)"gui.camera_anim.remote_path_search.no_server");
    private static final Component TIP = Component.m_237115_((String)"gui.camera_anim.remote_path_search.tip");
    public static boolean REMOTE;
    private final List<Triplet<Component, Component, Component>> list = new ArrayList<Triplet<Component, Component, Component>>();
    private EditBox filterBox;
    private EditBox pathBox;
    private EditBox newIdBox;
    private EditBox removeIdBox;
    private int scrollOffset = 0;
    private int lastClickIndex = -1;
    private long lastClickTimeMs = 0L;

    public RemotePathSearchScreen() {
        super((Component)Component.m_237113_((String)"remote path search"));
    }

    protected void m_7856_() {
        int m;
        int y = m = 20;
        int rowH = 20;
        int s = 10;
        int avail = this.f_96543_ - m * 2;
        int pageW = 40;
        int searchW = 100;
        int loadBtnW = 60;
        int saveBtnW = 60;
        int deleteBtnW = 60;
        int modeW = 120;
        int gaps = 8;
        int remaining = avail - (pageW + searchW + loadBtnW + saveBtnW + deleteBtnW + modeW) - s * gaps;
        int flexW = Math.max(100, remaining / 3);
        int x = m;
        NumberEditBox page = (NumberEditBox)this.m_142416_((GuiEventListener)new NumberEditBox(this.f_96547_, x, y, pageW, rowH, 1, (Component)Component.m_237113_((String)"page")));
        MutableComponent RELOAD = Component.m_237115_((String)"gui.camera_anim.remote_path_search.reload");
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)RELOAD, b -> {
            if (REMOTE) {
                ClientPayloadSender.checkGlobalPath(Integer.parseInt(page.m_94155_()), 128);
            }
        }).m_252794_(x += pageW + s, y).m_253046_(searchW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Refresh list from server"))).m_253136_());
        this.pathBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x += searchW + s, y, flexW, rowH, (Component)Component.m_237113_((String)"path id")));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)LOAD, b -> {
            if (REMOTE) {
                ClientPayloadSender.getGlobalPath(this.pathBox.m_94155_(), 0);
            }
        }).m_252794_(x += flexW + s, y).m_253046_(loadBtnW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Load animation with the given ID from server"))).m_253136_());
        this.newIdBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x += loadBtnW + s, y, flexW, rowH, (Component)Component.m_237113_((String)"new id")));
        this.newIdBox.m_94144_(CameraAnimIdeCache.getPath().getId());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)SAVE, b -> {
            if (REMOTE) {
                GlobalCameraPath track = CameraAnimIdeCache.getPath();
                if (!track.getId().equals(this.newIdBox.m_94155_())) {
                    track = track.resetID(this.newIdBox.m_94155_());
                }
                if (track.isNativeMode()) {
                    track = track.toNative(CameraAnimIdeCache.getNativePos(), CameraAnimIdeCache.getNativeRot().y);
                }
                ClientPayloadSender.putGlobalPath(track);
            }
        }).m_252794_(x += flexW + s, y).m_253046_(saveBtnW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Save current path to server"))).m_253136_());
        this.removeIdBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, x += saveBtnW + s, y, flexW, rowH, (Component)Component.m_237113_((String)"remove id")));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)DELETE, b -> {
            if (REMOTE) {
                ClientPayloadSender.removeGlobalPath(this.removeIdBox.m_94155_());
            }
        }).m_252794_(x += flexW + s, y).m_253046_(deleteBtnW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Delete animation by ID on server"))).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)LOCAL_MODE, b -> Minecraft.m_91087_().m_91152_((Screen)new LocalPathSearchScreen())).m_252794_(this.f_96543_ - m - modeW, y).m_253046_(modeW, rowH).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Switch to Local mode"))).m_253136_());
        this.filterBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, m, y += rowH + 20, this.f_96543_ - m * 2, 18, (Component)Component.m_237113_((String)"filter")));
        this.filterBox.m_257771_((Component)Component.m_237113_((String)"Search..."));
        this.scrollOffset = 0;
        if (REMOTE) {
            ClientPayloadSender.checkGlobalPath(1, 128);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int m = 20;
        int avail = this.f_96543_ - m * 2;
        int idW = (int)((float)avail * 0.5f);
        int modW = (int)((float)avail * 0.2f);
        int timeW = avail - idW - modW;
        int idX = m;
        int modX = m + idW + 10;
        int timeX = modX + modW + 10;
        guiGraphics.m_280430_(this.f_96547_, PAGE, m + 5, 10, -1);
        int loadLabelX = this.pathBox.m_252754_() + this.pathBox.m_5711_() / 2 - this.f_96547_.m_92852_((FormattedText)LOAD_ID) / 2;
        int saveLabelX = this.newIdBox.m_252754_() + this.newIdBox.m_5711_() / 2 - this.f_96547_.m_92852_((FormattedText)SAVE_ID) / 2;
        int deleteLabelX = this.removeIdBox.m_252754_() + this.removeIdBox.m_5711_() / 2 - this.f_96547_.m_92852_((FormattedText)DELETE_ID) / 2;
        guiGraphics.m_280430_(this.f_96547_, LOAD_ID, loadLabelX, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, SAVE_ID, saveLabelX, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, DELETE_ID, deleteLabelX, 10, -1);
        int headerY = m + 20 + 20 + 24;
        guiGraphics.m_280430_(this.f_96547_, PATH_ID, idX, headerY, -1);
        guiGraphics.m_280430_(this.f_96547_, MODIFIER, modX, headerY, -1);
        guiGraphics.m_280430_(this.f_96547_, TIME, timeX, headerY, -1);
        ArrayList<Triplet<Component, Component, Component>> filtered = new ArrayList<Triplet<Component, Component, Component>>();
        String q = this.filterBox.m_94155_() == null ? "" : this.filterBox.m_94155_().toLowerCase(Locale.ROOT);
        for (Triplet<Component, Component, Component> t : this.list) {
            String id = ((Component)t.getA()).getString().toLowerCase(Locale.ROOT);
            if (!q.isEmpty() && !id.contains(q)) continue;
            filtered.add(t);
        }
        int headerY2 = m + 20 + 20 + 24;
        int top = headerY2 + 12;
        int rowH = 11;
        int visible = Math.max(0, (this.f_96544_ - top - 40) / rowH);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, Math.max(0, filtered.size() - visible)));
        if (!filtered.isEmpty()) {
            for (int i = 0; i < visible && i + this.scrollOffset < filtered.size(); ++i) {
                Triplet info = (Triplet)filtered.get(i + this.scrollOffset);
                int y = top + i * rowH;
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getA(), idX, y, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getB(), modX, y, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getC(), timeX, y, -1);
            }
        } else {
            guiGraphics.m_280653_(this.f_96547_, TIP, this.f_96543_ / 2, this.f_96544_ / 2, -1);
        }
        if (!REMOTE) {
            guiGraphics.m_280653_(this.f_96547_, NO_SERVER, 100, 100, -2026476);
        }
    }

    public void setInfo(List<GlobalCameraPathInfo> list) {
        this.list.clear();
        for (GlobalCameraPathInfo info : list) {
            MutableComponent id = Component.m_237113_((String)info.id());
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(info.lastModifier());
            Object playerName = player == null ? Component.m_237113_((String)"\u672a\u77e5") : player.m_5446_();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(info.version()), ZONE_ID);
            MutableComponent time = Component.m_237113_((String)FORMATTER.format(localDateTime));
            this.list.add((Triplet<Component, Component, Component>)new Triplet((Object)id, playerName, (Object)time));
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int m = 20;
        int headerY2 = m + 20 + 20 + 24;
        int top = headerY2 + 12;
        int rowH = 11;
        int visible = Math.max(0, (this.f_96544_ - top - 40) / rowH);
        int max = Math.max(0, this.list.size() - visible);
        this.scrollOffset = (int)Math.max(0.0, Math.min((double)max, (double)this.scrollOffset - Math.signum(delta)));
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int m = 20;
        int headerY2 = m + 20 + 20 + 24;
        int top = headerY2 + 12;
        int rowH = 11;
        int right = this.f_96543_ - m;
        if (mouseY >= (double)top && mouseX >= (double)m && mouseX <= (double)right) {
            int index = (int)((mouseY - (double)top) / (double)rowH) + this.scrollOffset;
            String q = this.filterBox.m_94155_() == null ? "" : this.filterBox.m_94155_().toLowerCase(Locale.ROOT);
            ArrayList<Triplet<Component, Component, Component>> filtered = new ArrayList<Triplet<Component, Component, Component>>();
            for (Triplet<Component, Component, Component> t : this.list) {
                String id = ((Component)t.getA()).getString().toLowerCase(Locale.ROOT);
                if (!q.isEmpty() && !id.contains(q)) continue;
                filtered.add(t);
            }
            if (index >= 0 && index < filtered.size()) {
                String id = ((Component)((Triplet)filtered.get(index)).getA()).getString();
                if (this.pathBox != null) {
                    this.pathBox.m_94144_(id);
                }
                if (this.removeIdBox != null) {
                    this.removeIdBox.m_94144_(id);
                }
                long now = System.currentTimeMillis();
                if (button == 0 && index == this.lastClickIndex && now - this.lastClickTimeMs < 300L && REMOTE) {
                    ClientPayloadSender.getGlobalPath(id, 0);
                }
                this.lastClickIndex = index;
                this.lastClickTimeMs = now;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

