/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client.listener;

import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tysontheember.apertureapi.client.CameraAnimIdeCache;
import net.tysontheember.apertureapi.client.ClientUtil;
import net.tysontheember.apertureapi.client.PreviewAnimator;
import net.tysontheember.apertureapi.client.gui.screen.PointSettingScreen;
import net.tysontheember.apertureapi.client.gui.screen.RemotePathSearchScreen;
import net.tysontheember.apertureapi.client.register.ModKeyMapping;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="apertureapi", value={Dist.CLIENT})
public class ModKeyClicked {
    @SubscribeEvent
    public static void keyClick(TickEvent.ClientTickEvent event) {
        CameraAnimIdeCache.SelectedPoint selectedPoint;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        while (((KeyMapping)ModKeyMapping.ADD_GLOBAL_CAMERA_POINT.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            Minecraft mc = Minecraft.m_91087_();
            Camera camera = mc.f_91063_.m_109153_();
            float yRot = Mth.m_14177_((float)camera.m_90590_());
            float xRot = Mth.m_14177_((float)camera.m_90589_());
            CameraAnimIdeCache.getPath().add(new CameraKeyframe(camera.m_90583_().m_252839_(), new Vector3f(xRot, yRot, 0.0f), ((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue(), PathInterpolator.LINEAR));
        }
        while (((KeyMapping)ModKeyMapping.DELETE_GLOBAL_CAMERA_POINT.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            int time = selectedPoint.getPointTime();
            GlobalCameraPath track = CameraAnimIdeCache.getPath();
            track.remove(time);
            Map.Entry<Integer, CameraKeyframe> pre = track.getPreEntry(time);
            if (pre == null) {
                selectedPoint.reset();
                continue;
            }
            selectedPoint.setSelected(pre.getKey());
        }
        while (((KeyMapping)ModKeyMapping.EDIT_MODE.get()).m_90859_()) {
            if (!ClientUtil.player().m_7500_()) continue;
            CameraAnimIdeCache.EDIT = !CameraAnimIdeCache.EDIT;
        }
        while (((KeyMapping)ModKeyMapping.VIEW_MODE.get()).m_90859_()) {
            if (!ClientUtil.player().m_7500_()) continue;
            CameraAnimIdeCache.VIEW = !CameraAnimIdeCache.VIEW;
        }
        while (((KeyMapping)ModKeyMapping.ROTATE_MODE.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            CameraAnimIdeCache.toggleMode();
        }
        while (((KeyMapping)ModKeyMapping.POINT_SETTING.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT || CameraAnimIdeCache.getSelectedPoint().getPointTime() < 0) continue;
            Minecraft.m_91087_().m_91152_((Screen)new PointSettingScreen());
        }
        while (((KeyMapping)ModKeyMapping.PREVIEW_MODE.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            CameraAnimIdeCache.PREVIEW = !CameraAnimIdeCache.PREVIEW;
        }
        while (((KeyMapping)ModKeyMapping.PLAY.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            if (PreviewAnimator.INSTANCE.isPlaying()) {
                PreviewAnimator.INSTANCE.stop();
                continue;
            }
            PreviewAnimator.INSTANCE.play();
        }
        while (((KeyMapping)ModKeyMapping.RESET.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            PreviewAnimator.INSTANCE.reset();
        }
        while (((KeyMapping)ModKeyMapping.SET_CAMERA_TIME.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT || CameraAnimIdeCache.getSelectedPoint().getPointTime() < 0) continue;
            PreviewAnimator.INSTANCE.setTime(CameraAnimIdeCache.getSelectedPoint().getPointTime());
        }
        if (((KeyMapping)ModKeyMapping.BACK.get()).m_90857_() && CameraAnimIdeCache.EDIT) {
            PreviewAnimator.INSTANCE.back();
        }
        if (((KeyMapping)ModKeyMapping.FORWARD.get()).m_90857_() && CameraAnimIdeCache.EDIT) {
            PreviewAnimator.INSTANCE.forward();
        }
        while (((KeyMapping)ModKeyMapping.MANAGER.get()).m_90859_()) {
            if (!ClientUtil.player().m_7500_()) {
                return;
            }
            Minecraft.m_91087_().m_91152_((Screen)new RemotePathSearchScreen());
        }
        while (((KeyMapping)ModKeyMapping.CLEAN.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) {
                return;
            }
            CameraAnimIdeCache.setPath(new GlobalCameraPath("id"));
        }
        while (((KeyMapping)ModKeyMapping.NATIVE_CENTER.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            CameraAnimIdeCache.setNative(ClientUtil.player().m_20182_().m_252839_(), new Vector3f(0.0f, Mth.m_14177_((float)ClientUtil.playerYHeadRot()), 0.0f));
        }
        while (((KeyMapping)ModKeyMapping.REMOVE_NATIVE_CENTER.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            CameraAnimIdeCache.getPath().setNativeMode(false);
        }
        while (((KeyMapping)ModKeyMapping.DUPLICATE_KEYFRAME.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT || CameraAnimIdeCache.getSelectedPoint().getPointTime() < 0) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            int selectedTime = selectedPoint.getPointTime();
            GlobalCameraPath path = CameraAnimIdeCache.getPath();
            CameraKeyframe originalKeyframe = path.getPoint(selectedTime);
            if (originalKeyframe == null) continue;
            int newTime = selectedTime + 1;
            while (path.getPoint(newTime) != null) {
                ++newTime;
            }
            CameraKeyframe duplicateKeyframe = originalKeyframe.copy();
            path.add(newTime, duplicateKeyframe);
            selectedPoint.setSelected(newTime);
        }
        while (((KeyMapping)ModKeyMapping.UPDATE_KEYFRAME_FROM_CAMERA.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT || CameraAnimIdeCache.getSelectedPoint().getPointTime() < 0) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            int selectedTime = selectedPoint.getPointTime();
            GlobalCameraPath path = CameraAnimIdeCache.getPath();
            CameraKeyframe keyframe = path.getPoint(selectedTime);
            if (keyframe == null) continue;
            Minecraft mc = Minecraft.m_91087_();
            Camera camera = mc.f_91063_.m_109153_();
            keyframe.setPos((float)camera.m_90583_().f_82479_, (float)camera.m_90583_().f_82480_, (float)camera.m_90583_().f_82481_);
            keyframe.getRot().set(Mth.m_14177_((float)camera.m_90589_()), Mth.m_14177_((float)camera.m_90590_()), 0.0f);
            keyframe.setFov(((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue());
        }
        while (((KeyMapping)ModKeyMapping.NEXT_KEYFRAME.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            GlobalCameraPath path = CameraAnimIdeCache.getPath();
            if (selectedPoint.getPointTime() < 0) {
                Map.Entry<Integer, CameraKeyframe> first = path.getNextEntry(Integer.MIN_VALUE);
                if (first == null) continue;
                selectedPoint.setSelected(first.getKey());
                continue;
            }
            Map.Entry<Integer, CameraKeyframe> next = path.getNextEntry(selectedPoint.getPointTime());
            if (next == null) continue;
            selectedPoint.setSelected(next.getKey());
        }
        while (((KeyMapping)ModKeyMapping.PREVIOUS_KEYFRAME.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            GlobalCameraPath path = CameraAnimIdeCache.getPath();
            if (selectedPoint.getPointTime() < 0) {
                Map.Entry<Integer, CameraKeyframe> last = path.getPreEntry(Integer.MAX_VALUE);
                if (last == null) continue;
                selectedPoint.setSelected(last.getKey());
                continue;
            }
            Map.Entry<Integer, CameraKeyframe> prev = path.getPreEntry(selectedPoint.getPointTime());
            if (prev == null) continue;
            selectedPoint.setSelected(prev.getKey());
        }
        while (((KeyMapping)ModKeyMapping.CYCLE_INTERPOLATION.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT || CameraAnimIdeCache.getSelectedPoint().getPointTime() < 0) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            int selectedTime = selectedPoint.getPointTime();
            GlobalCameraPath path = CameraAnimIdeCache.getPath();
            CameraKeyframe keyframe = path.getPoint(selectedTime);
            if (keyframe == null) continue;
            PathInterpolator[] interpolators = PathInterpolator.values();
            PathInterpolator current = keyframe.getPathInterpolator();
            int currentIndex = current.index;
            int nextIndex = (currentIndex + 1) % interpolators.length;
            PathInterpolator next = PathInterpolator.fromIndex(nextIndex);
            keyframe.setPathInterpolator(next);
            path.updateBezier(selectedTime);
        }
        while (((KeyMapping)ModKeyMapping.DECREASE_FOV.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT || CameraAnimIdeCache.getSelectedPoint().getPointTime() < 0) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            int selectedTime = selectedPoint.getPointTime();
            GlobalCameraPath path = CameraAnimIdeCache.getPath();
            CameraKeyframe keyframe = path.getPoint(selectedTime);
            if (keyframe == null) continue;
            float currentFov = keyframe.getFov();
            float newFov = Math.max(1.0f, currentFov - 5.0f);
            keyframe.setFov(newFov);
        }
        while (((KeyMapping)ModKeyMapping.INCREASE_FOV.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT || CameraAnimIdeCache.getSelectedPoint().getPointTime() < 0) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            int selectedTime = selectedPoint.getPointTime();
            GlobalCameraPath path = CameraAnimIdeCache.getPath();
            CameraKeyframe keyframe = path.getPoint(selectedTime);
            if (keyframe == null) continue;
            float currentFov = keyframe.getFov();
            float newFov = Math.min(179.0f, currentFov + 5.0f);
            keyframe.setFov(newFov);
        }
        while (((KeyMapping)ModKeyMapping.INSERT_KEYFRAME_BETWEEN.get()).m_90859_()) {
            if (!CameraAnimIdeCache.EDIT || CameraAnimIdeCache.getSelectedPoint().getPointTime() < 0) continue;
            selectedPoint = CameraAnimIdeCache.getSelectedPoint();
            int selectedTime = selectedPoint.getPointTime();
            GlobalCameraPath path = CameraAnimIdeCache.getPath();
            Map.Entry<Integer, CameraKeyframe> current = path.getEntry(selectedTime);
            Map.Entry<Integer, CameraKeyframe> next = path.getNextEntry(selectedTime);
            if (current == null || next == null) continue;
            int insertTime = (selectedTime + next.getKey()) / 2;
            while (path.getPoint(insertTime) != null) {
                ++insertTime;
            }
            Vector3f currentPos = current.getValue().getPos();
            Vector3f nextPos = next.getValue().getPos();
            Vector3f newPos = new Vector3f((currentPos.x + nextPos.x) / 2.0f, (currentPos.y + nextPos.y) / 2.0f, (currentPos.z + nextPos.z) / 2.0f);
            Vector3f currentRot = current.getValue().getRot();
            Vector3f nextRot = next.getValue().getRot();
            Vector3f newRot = new Vector3f((currentRot.x + nextRot.x) / 2.0f, Mth.m_14177_((float)((currentRot.y + nextRot.y) / 2.0f)), (currentRot.z + nextRot.z) / 2.0f);
            float currentFov = current.getValue().getFov();
            float nextFov = next.getValue().getFov();
            float newFov = (currentFov + nextFov) / 2.0f;
            CameraKeyframe newKeyframe = new CameraKeyframe(newPos, newRot, newFov, PathInterpolator.LINEAR);
            path.add(insertTime, newKeyframe);
            selectedPoint.setSelected(insertTime);
        }
    }
}

