/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client.network;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.tysontheember.apertureapi.client.Animator;
import net.tysontheember.apertureapi.client.CameraAnimIdeCache;
import net.tysontheember.apertureapi.client.ClientUtil;
import net.tysontheember.apertureapi.client.gui.overlay.CutsceneFadeOverlay;
import net.tysontheember.apertureapi.client.gui.screen.InfoScreen;
import net.tysontheember.apertureapi.client.gui.screen.RemotePathSearchScreen;
import net.tysontheember.apertureapi.client.network.ClientPayloadSender;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.data_entity.GlobalCameraPathInfo;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ClientPayloadManager {
    public static final ClientPayloadManager INSTANCE = new ClientPayloadManager();
    private static final Component PUT_GLOBAL_PATH_SUCCESS = Component.m_237115_((String)"gui.camera_anim.client_payload_manager.put_global_path_success");
    private static final Component PUT_GLOBAL_PATH_FAILURE = Component.m_237115_((String)"gui.camera_anim.client_payload_manager.put_global_path_failure");
    private static final Component DELETE_GLOBAL_PATH_SUCCESS = Component.m_237115_((String)"gui.camera_anim.client_payload_manager.delete_global_path_success");
    private static final Component DELETE_GLOBAL_PATH_FAILURE = Component.m_237115_((String)"gui.camera_anim.client_payload_manager.delete_global_path_failure");
    private static final Component GET_GLOBAL_PATH_SUCCESS = Component.m_237115_((String)"gui.camera_anim.client_payload_manager.get_global_path_success");
    private static final Component GET_GLOBAL_PATH_FAILURE = Component.m_237115_((String)"gui.camera_anim.client_payload_manager.get_global_path_failure");

    public void checkGlobalPath(int page, int size, boolean succeed, @Nullable List<GlobalCameraPathInfo> paths, NetworkEvent.Context context) {
        if (succeed && paths != null) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (!(screen instanceof RemotePathSearchScreen)) {
                return;
            }
            RemotePathSearchScreen search = (RemotePathSearchScreen)screen;
            search.setInfo(paths);
        }
    }

    public void putGlobalPath(boolean succeed, NetworkEvent.Context context) {
        if (succeed) {
            ClientUtil.pushGuiLayer(new InfoScreen(PUT_GLOBAL_PATH_SUCCESS));
        } else {
            ClientUtil.pushGuiLayer(new InfoScreen(PUT_GLOBAL_PATH_FAILURE));
        }
    }

    public void removeGlobalPath(boolean succeed, NetworkEvent.Context context) {
        if (succeed) {
            ClientUtil.pushGuiLayer(new InfoScreen(DELETE_GLOBAL_PATH_SUCCESS));
        } else {
            ClientUtil.pushGuiLayer(new InfoScreen(DELETE_GLOBAL_PATH_FAILURE));
        }
    }

    public void getGlobalPath(@Nullable GlobalCameraPath path, boolean succeed, int receiver, NetworkEvent.Context context) {
        switch (receiver) {
            case 0: {
                if (succeed && path != null) {
                    if (path.isNativeMode()) {
                        Vector3f pos = ClientUtil.player().m_20182_().m_252839_();
                        float v = ClientUtil.playerYHeadRot();
                        path = path.fromNative(pos, v);
                        CameraAnimIdeCache.setNative(pos, new Vector3f(0.0f, v, 0.0f));
                    }
                    CameraAnimIdeCache.setPath(path);
                    ClientUtil.pushGuiLayer(new InfoScreen(GET_GLOBAL_PATH_SUCCESS));
                    break;
                }
                ClientUtil.pushGuiLayer(new InfoScreen(GET_GLOBAL_PATH_FAILURE));
                break;
            }
            case 1: {
                if (!succeed || path == null) break;
                GlobalCameraPath pth = path;
                CutsceneFadeOverlay.startEnterSequence(() -> {
                    Animator.INSTANCE.setLoop(true).setPathAndPlay(pth);
                    ClientPayloadSender.cutsceneInvul(true);
                    ClientUtil.toThirdView();
                });
                break;
            }
            case 2: {
                if (!succeed || path == null) break;
                GlobalCameraPath pth = path;
                CutsceneFadeOverlay.startEnterSequence(() -> {
                    Animator.INSTANCE.setLoop(false).setPathAndPlay(pth);
                    ClientPayloadSender.cutsceneInvul(true);
                    ClientUtil.toThirdView();
                });
                break;
            }
            case 3: {
                if (!succeed || path == null) break;
                GlobalCameraPath pth = path;
                CutsceneFadeOverlay.startEnterSequence(() -> {
                    Animator.INSTANCE.setLoop(true).setAutoReset(false).setPathAndPlay(pth);
                    ClientPayloadSender.cutsceneInvul(true);
                    ClientUtil.toThirdView();
                });
                break;
            }
            case 4: {
                if (!succeed || path == null) break;
                GlobalCameraPath pth = path;
                CutsceneFadeOverlay.startEnterSequence(() -> {
                    Animator.INSTANCE.setLoop(false).setAutoReset(false).setPathAndPlay(pth);
                    ClientPayloadSender.cutsceneInvul(true);
                    ClientUtil.toThirdView();
                });
            }
        }
    }

    public void getNativePath(@Nullable GlobalCameraPath path, @Nullable Entity entity, boolean succeed, NetworkEvent.Context context) {
        if (succeed && path != null && entity != null) {
            GlobalCameraPath pth = path;
            Entity ent = entity;
            CutsceneFadeOverlay.startEnterSequence(() -> {
                Animator.INSTANCE.setPathAndPlay(pth, ent.m_20182_().m_252839_(), new Vector3f(0.0f, ent.m_146908_(), 0.0f));
                ClientUtil.toThirdView();
            });
        }
    }

    public void stopCamera(NetworkEvent.Context context) {
        Animator.INSTANCE.stop();
    }

    public void resetCamera(NetworkEvent.Context context) {
        Animator.INSTANCE.setAutoReset(true).stop();
    }
}

