/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client.preview;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tysontheember.apertureapi.CameraModifierManager;
import net.tysontheember.apertureapi.ICameraModifier;
import net.tysontheember.apertureapi.camera.CameraPathDef;
import net.tysontheember.apertureapi.camera.CameraPathRegistry;
import net.tysontheember.apertureapi.client.CameraAnimIdeCache;
import net.tysontheember.apertureapi.client.ClientUtil;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(modid="apertureapi", value={Dist.CLIENT})
public class JsonCameraPreview {
    private static final ICameraModifier PREVIEW_MOD = CameraModifierManager.createModifier("apertureapi_json_preview", true).enableGlobalMode().enablePos().enableRotation().enableFov().enableLerp();
    private static CameraPathDef def;
    private static boolean playing;
    private static float t;
    private static float duration;
    private static Vector3f savedPos;
    private static Vector3f savedRot;
    private static boolean savedNoGravity;

    public static void start(String id) {
        CameraPathDef found = CameraPathRegistry.get(id);
        if (found == null || found.keyframes == null || found.keyframes.isEmpty()) {
            JsonCameraPreview.stop();
            return;
        }
        def = found;
        duration = JsonCameraPreview.def.keyframes.get((int)(JsonCameraPreview.def.keyframes.size() - 1)).time;
        t = 0.0f;
        playing = true;
        CameraAnimIdeCache.PREVIEW = true;
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null) {
            savedPos = new Vector3f((float)p.m_20185_(), (float)p.m_20186_(), (float)p.m_20189_());
            savedRot = new Vector3f(p.m_146909_(), p.m_146908_(), 0.0f);
            savedNoGravity = p.m_20068_();
            p.m_20242_(true);
            p.m_20334_(0.0, 0.0, 0.0);
            p.m_6034_((double)JsonCameraPreview.savedPos.x, (double)JsonCameraPreview.savedPos.y, (double)JsonCameraPreview.savedPos.z);
            p.m_146926_(JsonCameraPreview.savedRot.x);
            p.m_146922_(JsonCameraPreview.savedRot.y);
        }
        ClientUtil.toThirdView();
    }

    public static void stop() {
        playing = false;
        def = null;
        PREVIEW_MOD.disable();
        CameraAnimIdeCache.PREVIEW = false;
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null) {
            p.m_20242_(savedNoGravity);
        }
        ClientUtil.resetCameraType();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        float dt;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        if (!playing || def == null) {
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p != null && savedPos != null && savedRot != null) {
            p.m_20334_(0.0, 0.0, 0.0);
            p.m_6034_((double)JsonCameraPreview.savedPos.x, (double)JsonCameraPreview.savedPos.y, (double)JsonCameraPreview.savedPos.z);
            p.m_146926_(JsonCameraPreview.savedRot.x);
            p.m_146922_(JsonCameraPreview.savedRot.y);
        }
        if ((t += (dt = 0.05f) * Math.max(0.001f, JsonCameraPreview.def.speed <= 0.0f ? 1.0f : JsonCameraPreview.def.speed)) > duration) {
            if (JsonCameraPreview.def.loop) {
                t %= Math.max(1.0E-4f, duration);
            } else {
                JsonCameraPreview.stop();
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onRenderStage(RenderLevelStageEvent event) {
        if (!playing || def == null) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        float frame = Minecraft.m_91087_().m_91296_();
        float timeSec = t + frame * Math.max(0.001f, JsonCameraPreview.def.speed <= 0.0f ? 1.0f : JsonCameraPreview.def.speed) / 20.0f;
        if (timeSec > duration) {
            timeSec = JsonCameraPreview.def.loop ? timeSec % Math.max(1.0E-4f, duration) : duration;
        }
        JsonCameraPreview.sampleAndApply(timeSec);
    }

    private static void sampleAndApply(float timeSec) {
        List<CameraPathDef.KeyframeDef> kfs = JsonCameraPreview.def.keyframes;
        int preIdx = 0;
        int nextIdx = 0;
        for (int i = 0; i < kfs.size(); ++i) {
            if (kfs.get((int)i).time <= timeSec) {
                preIdx = i;
            }
            if (!(kfs.get((int)i).time >= timeSec)) continue;
            nextIdx = i;
            break;
        }
        CameraPathDef.KeyframeDef pre = kfs.get(preIdx);
        CameraPathDef.KeyframeDef next = kfs.get(nextIdx);
        float span = Math.max(1.0E-6f, next.time - pre.time);
        float localT = Mth.m_14036_((float)((timeSec - pre.time) / span), (float)0.0f, (float)1.0f);
        Vector3f p0 = new Vector3f((float)pre.pos.x, (float)pre.pos.y, (float)pre.pos.z);
        Vector3f p1 = new Vector3f((float)next.pos.x, (float)next.pos.y, (float)next.pos.z);
        Vector3f pos = new Vector3f(Mth.m_14179_((float)localT, (float)p0.x, (float)p1.x), Mth.m_14179_((float)localT, (float)p0.y, (float)p1.y), Mth.m_14179_((float)localT, (float)p0.z, (float)p1.z));
        Vector3f f0 = JsonCameraPreview.resolveForward(pre);
        Vector3f f1 = JsonCameraPreview.resolveForward(next);
        Vector3f f = JsonCameraPreview.slerpDir(f0, f1, localT);
        float yaw = (float)Math.toDegrees(Math.atan2(-f.x, f.z));
        float pitch = (float)(-Math.toDegrees(Math.atan2(f.y, Math.sqrt(f.x * f.x + f.z * f.z))));
        Vector3f rot = new Vector3f(pitch, yaw, 0.0f);
        float fov = 70.0f;
        if (JsonCameraPreview.def.fov != null) {
            if ("fixed".equalsIgnoreCase(JsonCameraPreview.def.fov.mode) || "inherit".equalsIgnoreCase(JsonCameraPreview.def.fov.mode)) {
                fov = JsonCameraPreview.def.fov._default;
            } else if ("keyframed".equalsIgnoreCase(JsonCameraPreview.def.fov.mode)) {
                float fov0 = pre.fov != null ? pre.fov.floatValue() : JsonCameraPreview.def.fov._default;
                float fov1 = next.fov != null ? next.fov.floatValue() : JsonCameraPreview.def.fov._default;
                fov = Mth.m_14179_((float)localT, (float)fov0, (float)fov1);
            }
        }
        PREVIEW_MOD.enable().setPos(pos.x, pos.y, pos.z).setRotationYXZ(rot.x, rot.y, rot.z).setFov(fov);
    }

    private static Vector3f resolveForward(CameraPathDef.KeyframeDef kf) {
        if (kf.lookAt != null && kf.pos != null) {
            double dx = kf.lookAt.x - kf.pos.x;
            double dy = kf.lookAt.y - kf.pos.y;
            double dz = kf.lookAt.z - kf.pos.z;
            Vector3f v = new Vector3f((float)dx, (float)dy, (float)dz);
            if (v.lengthSquared() < 1.0E-6f) {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            v.normalize();
            return v;
        }
        if (kf.rot != null) {
            float yawRad = (float)Math.toRadians(kf.rot.yaw);
            float pitchRad = (float)Math.toRadians(kf.rot.pitch);
            float cp = Mth.m_14089_((float)pitchRad);
            float sp = Mth.m_14031_((float)pitchRad);
            float cy = Mth.m_14089_((float)yawRad);
            float sy = Mth.m_14031_((float)yawRad);
            float x = -cp * sy;
            float y = -sp;
            float z = cp * cy;
            return new Vector3f(x, y, z).normalize();
        }
        return new Vector3f(0.0f, 0.0f, 1.0f);
    }

    private static Vector3f slerpDir(Vector3f a, Vector3f b, float t) {
        Vector3f v1;
        Vector3f v0 = new Vector3f((Vector3fc)a).normalize();
        float dot = Mth.m_14036_((float)v0.dot((Vector3fc)(v1 = new Vector3f((Vector3fc)b).normalize())), (float)-1.0f, (float)1.0f);
        if (dot > 0.9995f) {
            return new Vector3f(Mth.m_14179_((float)t, (float)v0.x, (float)v1.x), Mth.m_14179_((float)t, (float)v0.y, (float)v1.y), Mth.m_14179_((float)t, (float)v0.z, (float)v1.z)).normalize();
        }
        double theta0 = Math.acos(dot);
        double sin0 = Math.sin(theta0);
        double theta = theta0 * (double)t;
        double sin1 = Math.sin(theta);
        double sin2 = Math.sin(theta0 - theta);
        float s0 = (float)(sin2 / sin0);
        float s1 = (float)(sin1 / sin0);
        return new Vector3f(v0.x * s0 + v1.x * s1, v0.y * s0 + v1.y * s1, v0.z * s0 + v1.z * s1);
    }
}

