/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.tysontheember.apertureapi.InterpolationMath;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import net.tysontheember.apertureapi.path.CatmullRom;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class PathDebugRenderer {
    private static final Vector3f V0 = new Vector3f();
    private static final Vector3f V1 = new Vector3f();
    private static final Vector3f V2 = new Vector3f();
    private static final Vector3f V3 = new Vector3f();
    private static final Vector3f P = new Vector3f();
    private static final Vector3f Q = new Vector3f();
    public static boolean showVelocityColor = false;
    public static boolean showDirectionTicks = false;

    private PathDebugRenderer() {
    }

    public static void render(GlobalCameraPath path, PoseStack.Pose pose, MultiBufferSource.BufferSource buffers, Vec3 cameraPos) {
        ArrayList<CameraKeyframe> points = path.getPoints();
        if (points.size() < 2) {
            return;
        }
        VertexConsumer lines = buffers.m_6299_((RenderType)RenderType.f_110371_);
        Matrix4f m = pose.m_252922_();
        Matrix3f n = pose.m_252943_();
        for (int i = 1; i < points.size(); ++i) {
            int s;
            CameraKeyframe pre = points.get(i - 1);
            CameraKeyframe next = points.get(i);
            Vector3f p1 = new Vector3f((Vector3fc)pre.getPos()).sub((float)cameraPos.f_82479_, (float)cameraPos.f_82480_, (float)cameraPos.f_82481_);
            Vector3f p2 = new Vector3f((Vector3fc)next.getPos()).sub((float)cameraPos.f_82479_, (float)cameraPos.f_82480_, (float)cameraPos.f_82481_);
            int samples = 32;
            Vector3f prev = new Vector3f((Vector3fc)p1);
            float maxVel = 1.0E-6f;
            float[] speeds = new float[samples + 1];
            Vector3f[] pts = new Vector3f[samples + 1];
            pts[0] = new Vector3f((Vector3fc)prev);
            speeds[0] = 0.0f;
            for (s = 1; s <= samples; ++s) {
                float v;
                float t = (float)s / (float)samples;
                PathDebugRenderer.eval(path, i, t, pre, next, cameraPos, P);
                pts[s] = new Vector3f((Vector3fc)P);
                speeds[s] = v = P.distance((Vector3fc)prev);
                if (v > maxVel) {
                    maxVel = v;
                }
                prev.set((Vector3fc)P);
            }
            for (s = 1; s <= samples; ++s) {
                int color;
                if (showVelocityColor) {
                    float v = speeds[s] / (maxVel <= 1.0E-6f ? 1.0f : maxVel);
                    color = PathDebugRenderer.lerpColor(-16776961, -65536, v);
                } else {
                    color = -1;
                }
                Vector3f a = pts[s - 1];
                Vector3f b = pts[s];
                PathDebugRenderer.addLine(lines, m, n, a, b, color);
                if (!showDirectionTicks || s % 4 != 0) continue;
                Q.set((Vector3fc)b).sub((Vector3fc)a).normalize().mul(0.2f);
                Vector3f tickEnd = new Vector3f((Vector3fc)b).add((Vector3fc)Q);
                PathDebugRenderer.addLine(lines, m, n, b, tickEnd, -16711681);
            }
        }
        buffers.m_109912_((RenderType)RenderType.f_110371_);
    }

    private static void eval(GlobalCameraPath path, int segIndex, float t, CameraKeyframe pre, CameraKeyframe next, Vec3 cam, Vector3f out) {
        PathInterpolator mode = next.getPathInterpolator();
        int i = segIndex;
        ArrayList<CameraKeyframe> pts = path.getPoints();
        Vector3f p0 = i - 2 >= 0 ? pts.get(i - 2).getPos() : pre.getPos();
        Vector3f p3 = i < pts.size() ? pts.get(i).getPos() : next.getPos();
        switch (mode) {
            case LINEAR: {
                InterpolationMath.line(t, new Vector3f((Vector3fc)pre.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)next.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), out);
                break;
            }
            case COSINE: {
                float tc = (1.0f - (float)Math.cos(Math.PI * (double)t)) * 0.5f;
                InterpolationMath.line(tc, new Vector3f((Vector3fc)pre.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)next.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), out);
                break;
            }
            case SMOOTH: {
                InterpolationMath.catmullRom(t, new Vector3f((Vector3fc)p0).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)pre.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)next.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)p3).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), out);
                break;
            }
            case CATMULL_UNIFORM: {
                CatmullRom.eval(t, new Vector3f((Vector3fc)p0).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)pre.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)next.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)p3).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), 0.0f, out);
                break;
            }
            case CATMULL_CENTRIPETAL: {
                CatmullRom.eval(t, new Vector3f((Vector3fc)p0).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)pre.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)next.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)p3).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), 0.5f, out);
                break;
            }
            case CATMULL_CHORDAL: {
                CatmullRom.eval(t, new Vector3f((Vector3fc)p0).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)pre.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)next.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)p3).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), 1.0f, out);
                break;
            }
            case BEZIER: {
                pre.getPathBezier().interpolate(t, new Vector3f((Vector3fc)pre.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), new Vector3f((Vector3fc)next.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_), out);
                break;
            }
            case STEP: {
                out.set((Vector3fc)new Vector3f((Vector3fc)pre.getPos()).sub((float)cam.f_82479_, (float)cam.f_82480_, (float)cam.f_82481_));
            }
        }
    }

    private static void addLine(VertexConsumer buffer, Matrix4f m, Matrix3f nrm, Vector3f a, Vector3f b, int color) {
        Vector3f dir = new Vector3f((Vector3fc)b).sub((Vector3fc)a).normalize();
        buffer.m_252986_(m, a.x, a.y, a.z).m_193479_(color).m_252939_(nrm, dir.x, dir.y, dir.z).m_5752_();
        buffer.m_252986_(m, b.x, b.y, b.z).m_193479_(color).m_252939_(nrm, dir.x, dir.y, dir.z).m_5752_();
    }

    private static int lerpColor(int c1, int c2, float t) {
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        int a1 = c1 >>> 24 & 0xFF;
        int r1 = c1 >>> 16 & 0xFF;
        int g1 = c1 >>> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int a2 = c2 >>> 24 & 0xFF;
        int r2 = c2 >>> 16 & 0xFF;
        int g2 = c2 >>> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

