/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.tysontheember.apertureapi.commandutil.CameraPathService;
import net.tysontheember.apertureapi.commandutil.CommandUtils;
import net.tysontheember.apertureapi.common.GlobalCameraSavedData;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import net.tysontheember.apertureapi.common.network.ServerPayloadSender;

public class CameraCommand {
    private static final SuggestionProvider<CommandSourceStack> PATH_SUGGESTER = (ctx, b) -> CameraCommand.suggestPathIds((CommandContext<CommandSourceStack>)ctx, b);

    public static void register(CommandDispatcher<CommandSourceStack> d, String root) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)root).then(Commands.m_82127_((String)"list").executes(CameraCommand::list))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"play").requires(s -> CommandUtils.permCheck(s, 2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PATH_SUGGESTER).executes(CameraCommand::play)).then(Commands.m_82129_((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.05f, (float)10.0f)).suggests(CameraCommand::suggestSpeeds).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"loop", (ArgumentType)BoolArgumentType.bool()).executes(CameraCommand::playWithLoop)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"auto-reset", (ArgumentType)BoolArgumentType.bool()).executes(CameraCommand::playWithOptions)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(CameraCommand::playForTargetWithOptions)))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"stop").executes(CameraCommand::stopSelf)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).requires(s -> CommandUtils.permCheck(s, 2))).executes(CameraCommand::stopTarget)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").executes(CameraCommand::resetSelf)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).requires(s -> CommandUtils.permCheck(s, 2))).executes(CameraCommand::resetTarget)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"interpolation").requires(s -> CommandUtils.permCheck(s, 2))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PATH_SUGGESTER).then(Commands.m_82129_((String)"mode", (ArgumentType)StringArgumentType.word()).suggests(CameraCommand::suggestInterpolations).executes(CameraCommand::setInterpolation))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(s -> CommandUtils.permCheck(s, 2))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PATH_SUGGESTER).then(Commands.m_82129_((String)"file", (ArgumentType)StringArgumentType.word()).executes(CameraCommand::exportAs)))));
    }

    private static int list(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        List<String> ids = CameraPathService.list(level);
        if (ids.isEmpty()) {
            CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "No saved camera paths.");
        } else {
            CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Saved camera paths: " + String.join((CharSequence)", ", ids));
        }
        return 1;
    }

    private static int play(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player;
        String name = StringArgumentType.getString(ctx, (String)"name");
        float speed = ctx.getInput().contains(" ") && ctx.getInput().split(" ").length >= 4 ? FloatArgumentType.getFloat(ctx, (String)"speed") : 1.0f;
        boolean loop = ctx.getInput().contains(" ") && ctx.getInput().split(" ").length >= 5 ? BoolArgumentType.getBool(ctx, (String)"loop") : false;
        try {
            player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        }
        catch (Exception e) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Player-only command");
            return 0;
        }
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        GlobalCameraPath path = data.getPath(name);
        if (path == null) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Unknown path: '" + name + "'");
            return 0;
        }
        int receiver = loop ? 1 : 2;
        ServerPayloadSender.sendGlobalPath(path, player, receiver);
        CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Playing '" + name + "' (speed=" + speed + ", loop=" + loop + ")");
        return 1;
    }

    private static int playWithLoop(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player;
        String name = StringArgumentType.getString(ctx, (String)"name");
        float speed = FloatArgumentType.getFloat(ctx, (String)"speed");
        boolean loop = BoolArgumentType.getBool(ctx, (String)"loop");
        boolean autoReset = true;
        try {
            player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        }
        catch (Exception e) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Player-only command");
            return 0;
        }
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        GlobalCameraPath path = data.getPath(name);
        if (path == null) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Unknown path: '" + name + "'");
            return 0;
        }
        int receiver = CameraCommand.calculateReceiver(loop, autoReset);
        ServerPayloadSender.sendGlobalPath(path, player, receiver);
        CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Playing '" + name + "' (speed=" + speed + ", loop=" + loop + ", auto-reset=" + autoReset + ")");
        return 1;
    }

    private static int playWithOptions(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player;
        String name = StringArgumentType.getString(ctx, (String)"name");
        float speed = FloatArgumentType.getFloat(ctx, (String)"speed");
        boolean loop = BoolArgumentType.getBool(ctx, (String)"loop");
        boolean autoReset = BoolArgumentType.getBool(ctx, (String)"auto-reset");
        try {
            player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        }
        catch (Exception e) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Player-only command");
            return 0;
        }
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        GlobalCameraPath path = data.getPath(name);
        if (path == null) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Unknown path: '" + name + "'");
            return 0;
        }
        int receiver = CameraCommand.calculateReceiver(loop, autoReset);
        ServerPayloadSender.sendGlobalPath(path, player, receiver);
        CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Playing '" + name + "' (speed=" + speed + ", loop=" + loop + ", auto-reset=" + autoReset + ")");
        return 1;
    }

    private static int playForTarget(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"name");
        float speed = FloatArgumentType.getFloat(ctx, (String)"speed");
        boolean loop = BoolArgumentType.getBool(ctx, (String)"loop");
        boolean autoReset = true;
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        GlobalCameraPath path = data.getPath(name);
        if (path == null) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Unknown path: '" + name + "'");
            return 0;
        }
        int receiver = CameraCommand.calculateReceiver(loop, autoReset);
        ServerPayloadSender.sendGlobalPath(path, target, receiver);
        CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Playing '" + name + "' for " + target.m_36316_().getName() + " at speed=" + speed + " loop=" + loop + " auto-reset=" + autoReset);
        return 1;
    }

    private static int playForTargetWithOptions(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = StringArgumentType.getString(ctx, (String)"name");
        float speed = FloatArgumentType.getFloat(ctx, (String)"speed");
        boolean loop = BoolArgumentType.getBool(ctx, (String)"loop");
        boolean autoReset = BoolArgumentType.getBool(ctx, (String)"auto-reset");
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        GlobalCameraPath path = data.getPath(name);
        if (path == null) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Unknown path: '" + name + "'");
            return 0;
        }
        int receiver = CameraCommand.calculateReceiver(loop, autoReset);
        ServerPayloadSender.sendGlobalPath(path, target, receiver);
        CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Playing '" + name + "' for " + target.m_36316_().getName() + " at speed=" + speed + " loop=" + loop + " auto-reset=" + autoReset);
        return 1;
    }

    private static int calculateReceiver(boolean loop, boolean autoReset) {
        if (autoReset) {
            return loop ? 1 : 2;
        }
        return loop ? 3 : 4;
    }

    private static CompletableFuture<Suggestions> suggestSpeeds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder b) {
        for (String s : new String[]{"0.5", "1.0", "2.0"}) {
            if (!s.startsWith(b.getRemaining())) continue;
            b.suggest(s);
        }
        return b.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestInterpolations(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder b) {
        String[] modes;
        for (String s : modes = new String[]{"linear", "smooth", "bezier", "step", "cosine", "catmull:uniform", "catmull:centripetal", "catmull:chordal"}) {
            if (!s.startsWith(b.getRemaining())) continue;
            b.suggest(s);
        }
        return b.buildFuture();
    }

    private static int stopSelf(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerPayloadSender.send("stopCamera", new CompoundTag(), player);
            CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Stopped camera for " + player.m_36316_().getName());
            return 1;
        }
        catch (Exception e) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Player-only command");
            return 0;
        }
    }

    private static int stopTarget(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
            ServerPayloadSender.send("stopCamera", new CompoundTag(), target);
            CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Stopped camera for " + target.m_36316_().getName());
            return 1;
        }
        catch (Exception e) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Failed to stop for target: " + e.getMessage());
            return 0;
        }
    }

    private static int resetSelf(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            CompoundTag resetTag = new CompoundTag();
            resetTag.m_128379_("force_reset", true);
            ServerPayloadSender.send("resetCamera", resetTag, player);
            CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Reset camera for " + player.m_36316_().getName());
            return 1;
        }
        catch (Exception e) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Player-only command");
            return 0;
        }
    }

    private static int resetTarget(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
            CompoundTag resetTag = new CompoundTag();
            resetTag.m_128379_("force_reset", true);
            ServerPayloadSender.send("resetCamera", resetTag, target);
            CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Reset camera for " + target.m_36316_().getName());
            return 1;
        }
        catch (Exception e) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Failed to reset for target: " + e.getMessage());
            return 0;
        }
    }

    private static int setInterpolation(CommandContext<CommandSourceStack> ctx) {
        PathInterpolator interp;
        String name = StringArgumentType.getString(ctx, (String)"name");
        String mode = StringArgumentType.getString(ctx, (String)"mode");
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        GlobalCameraPath path = data.getPath(name);
        if (path == null) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Unknown path: '" + name + "'");
            return 0;
        }
        switch (mode.toLowerCase()) {
            case "linear": {
                PathInterpolator pathInterpolator = PathInterpolator.LINEAR;
                break;
            }
            case "smooth": {
                PathInterpolator pathInterpolator = PathInterpolator.SMOOTH;
                break;
            }
            case "bezier": {
                PathInterpolator pathInterpolator = PathInterpolator.BEZIER;
                break;
            }
            case "step": {
                PathInterpolator pathInterpolator = PathInterpolator.STEP;
                break;
            }
            case "cosine": {
                PathInterpolator pathInterpolator = PathInterpolator.COSINE;
                break;
            }
            case "catmull:uniform": {
                PathInterpolator pathInterpolator = PathInterpolator.CATMULL_UNIFORM;
                break;
            }
            case "catmull:centripetal": {
                PathInterpolator pathInterpolator = PathInterpolator.CATMULL_CENTRIPETAL;
                break;
            }
            case "catmull:chordal": {
                PathInterpolator pathInterpolator = PathInterpolator.CATMULL_CHORDAL;
                break;
            }
            default: {
                PathInterpolator pathInterpolator = interp = null;
            }
        }
        if (interp == null) {
            CommandUtils.msgError((CommandSourceStack)ctx.getSource(), "Unknown interpolation mode: '" + mode + "'");
            return 0;
        }
        for (Int2ObjectMap.Entry e : path.getEntries()) {
            ((CameraKeyframe)e.getValue()).setPathInterpolator(interp);
            path.updateBezier(e.getIntKey());
        }
        CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Set interpolation for '" + name + "' to " + mode);
        return 1;
    }

    private static int exportAs(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        String file = StringArgumentType.getString(ctx, (String)"file");
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        CameraPathService.ExportResult res = CameraPathService.exportAs(level, name, file);
        if (res.success()) {
            CommandUtils.msgInfo((CommandSourceStack)ctx.getSource(), "Exported '" + name + "' \u2192 " + String.valueOf(res.path()));
            return 1;
        }
        CommandUtils.msgError((CommandSourceStack)ctx.getSource(), res.message());
        return 0;
    }

    private static CompletableFuture<Suggestions> suggestPathIds(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder b) {
        ServerLevel level = CommandUtils.level((CommandSourceStack)ctx.getSource());
        for (String id : CameraPathService.list(level)) {
            if (!id.startsWith(b.getRemaining())) continue;
            b.suggest(id);
        }
        return b.buildFuture();
    }
}

