/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.commandutil;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.fml.loading.FMLPaths;
import net.tysontheember.apertureapi.common.GlobalCameraSavedData;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import net.tysontheember.apertureapi.common.animation.TimeBezierController;
import net.tysontheember.apertureapi.common.animation.TimeInterpolator;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class CameraPathService {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static List<String> list(ServerLevel level) {
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        ArrayList<String> ids = new ArrayList<String>();
        for (GlobalCameraPath p : data.getPaths()) {
            ids.add(p.getId());
        }
        ids.sort(String::compareToIgnoreCase);
        return ids;
    }

    public static boolean create(ServerLevel level, String name) {
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        if (data.getPath(name) != null) {
            return false;
        }
        GlobalCameraPath path = new GlobalCameraPath(name, null);
        data.addPath(path);
        return true;
    }

    public static boolean delete(ServerLevel level, String name) {
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        if (data.getPath(name) == null) {
            return false;
        }
        data.removePath(name);
        return true;
    }

    public static boolean rename(ServerLevel level, String oldName, String newName) {
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        if (data.getPath(newName) != null) {
            return false;
        }
        GlobalCameraPath path = data.getPath(oldName);
        if (path == null) {
            return false;
        }
        GlobalCameraPath renamed = path.resetID(newName);
        data.addPath(renamed);
        data.removePath(oldName);
        return true;
    }

    public static ExportResult exportOne(ServerLevel level, String name) {
        return CameraPathService.exportAs(level, name, name + ".json");
    }

    public static ExportResult exportAs(ServerLevel level, String name, String fileName) {
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        GlobalCameraPath path = data.getPath(name);
        if (path == null) {
            return new ExportResult(false, "Unknown path: " + name, null);
        }
        try {
            Path dir = CameraPathService.ensureConfigDir();
            Object fn = fileName.endsWith(".json") ? fileName : fileName + ".json";
            Path file = dir.resolve(CameraPathService.safeFileName((String)fn));
            JsonObject root = CameraPathService.toJson(path);
            String json = GSON.toJson((JsonElement)root);
            Path tmp = file.resolveSibling(file.getFileName().toString() + ".tmp");
            Files.writeString(tmp, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            Files.move(tmp, file, StandardCopyOption.REPLACE_EXISTING);
            return new ExportResult(true, "", file);
        }
        catch (IOException e) {
            return new ExportResult(false, "Failed to export: " + e.getMessage(), null);
        }
    }

    public static ImportResult importFile(ServerLevel level, String fileOrDir, boolean overwrite) {
        ArrayList<Path> files;
        block13: {
            Path p = Path.of(fileOrDir, new String[0]);
            if (!p.isAbsolute()) {
                p = FMLPaths.CONFIGDIR.get().resolve("aperture").resolve("paths").resolve(fileOrDir);
            }
            files = new ArrayList<Path>();
            if (Files.isDirectory(p, new LinkOption[0])) {
                try (Stream<Path> s = Files.list(p);){
                    s.filter(f -> f.toString().endsWith(".json")).forEach(files::add);
                    break block13;
                }
                catch (IOException e) {
                    return new ImportResult(false, e.getMessage(), 0);
                }
            }
            files.add(p);
        }
        int count = 0;
        GlobalCameraSavedData data = GlobalCameraSavedData.getData(level);
        for (Path f2 : files) {
            try {
                String text = Files.readString(f2, StandardCharsets.UTF_8);
                JsonObject obj = (JsonObject)GSON.fromJson(text, JsonObject.class);
                GlobalCameraPath path = CameraPathService.fromJson(obj);
                if (!overwrite && data.getPath(path.getId()) != null) continue;
                data.addPath(path);
                ++count;
            }
            catch (Exception e) {
                return new ImportResult(false, "Failed at " + String.valueOf(f2.getFileName()) + ": " + e.getMessage(), count);
            }
        }
        return new ImportResult(true, "", count);
    }

    private static Path ensureConfigDir() throws IOException {
        Path dir = FMLPaths.CONFIGDIR.get().resolve("aperture").resolve("paths");
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    private static String safeFileName(String id) {
        return id.replaceAll("[^a-zA-Z0-9_.-]+", "_");
    }

    private static JsonObject toJson(GlobalCameraPath path) {
        JsonObject root = new JsonObject();
        root.addProperty("id", path.getId());
        root.addProperty("version", (Number)path.getVersion());
        UUID last = path.getLastModifier();
        root.addProperty("lastModifier", last == null ? "00000000-0000-0000-0000-000000000000" : last.toString());
        root.addProperty("native", Boolean.valueOf(path.isNativeMode()));
        JsonArray keyframes = new JsonArray();
        for (Int2ObjectMap.Entry e : path.getEntries()) {
            int time = e.getIntKey();
            CameraKeyframe kf = (CameraKeyframe)e.getValue();
            JsonObject k = new JsonObject();
            k.addProperty("time", (Number)time);
            JsonArray pos = new JsonArray();
            Vector3f p = kf.getPos();
            pos.add((Number)Float.valueOf(p.x));
            pos.add((Number)Float.valueOf(p.y));
            pos.add((Number)Float.valueOf(p.z));
            k.add("pos", (JsonElement)pos);
            JsonArray rot = new JsonArray();
            Vector3f r = kf.getRot();
            rot.add((Number)Float.valueOf(r.x));
            rot.add((Number)Float.valueOf(r.y));
            rot.add((Number)Float.valueOf(r.z));
            k.add("rot", (JsonElement)rot);
            k.addProperty("fov", (Number)Float.valueOf(kf.getFov()));
            k.addProperty("pathType", (Number)kf.getPathInterpolator().index);
            k.addProperty("posType", (Number)kf.getPosTimeInterpolator().index);
            k.addProperty("rotType", (Number)kf.getRotTimeInterpolator().index);
            k.addProperty("fovType", (Number)kf.getFovTimeInterpolator().index);
            if (kf.getPathInterpolator() == PathInterpolator.BEZIER) {
                JsonObject bez = new JsonObject();
                JsonArray left = new JsonArray();
                JsonArray right = new JsonArray();
                Vector3f L = kf.getPathBezier().getLeft();
                Vector3f R = kf.getPathBezier().getRight();
                left.add((Number)Float.valueOf(L.x));
                left.add((Number)Float.valueOf(L.y));
                left.add((Number)Float.valueOf(L.z));
                right.add((Number)Float.valueOf(R.x));
                right.add((Number)Float.valueOf(R.y));
                right.add((Number)Float.valueOf(R.z));
                bez.add("left", (JsonElement)left);
                bez.add("right", (JsonElement)right);
                k.add("pathBezier", (JsonElement)bez);
            }
            if (kf.getPosTimeInterpolator() == TimeInterpolator.BEZIER) {
                k.add("posBezier", (JsonElement)CameraPathService.bez2(kf.getPosBezier()));
            }
            if (kf.getRotTimeInterpolator() == TimeInterpolator.BEZIER) {
                k.add("rotBezier", (JsonElement)CameraPathService.bez2(kf.getRotBezier()));
            }
            if (kf.getFovTimeInterpolator() == TimeInterpolator.BEZIER) {
                k.add("fovBezier", (JsonElement)CameraPathService.bez2(kf.getFovBezier()));
            }
            JsonObject entry = new JsonObject();
            entry.addProperty("time", (Number)time);
            entry.add("keyframe", (JsonElement)k);
            keyframes.add((JsonElement)entry);
        }
        root.add("keyframes", (JsonElement)keyframes);
        return root;
    }

    private static JsonObject bez2(TimeBezierController c) {
        JsonObject o = new JsonObject();
        Vector2f L = c.getLeft();
        Vector2f R = c.getRight();
        JsonArray left = new JsonArray();
        JsonArray right = new JsonArray();
        left.add((Number)Float.valueOf(L.x));
        left.add((Number)Float.valueOf(L.y));
        right.add((Number)Float.valueOf(R.x));
        right.add((Number)Float.valueOf(R.y));
        o.add("left", (JsonElement)left);
        o.add("right", (JsonElement)right);
        return o;
    }

    private static GlobalCameraPath fromJson(JsonObject root) {
        String id = root.get("id").getAsString();
        boolean nativeMode = root.has("native") && root.get("native").getAsBoolean();
        GlobalCameraPath path = new GlobalCameraPath(id, null);
        if (nativeMode) {
            path.setNativeMode(true);
        }
        for (JsonElement el : root.getAsJsonArray("keyframes")) {
            JsonObject entry = el.getAsJsonObject();
            int time = entry.get("time").getAsInt();
            JsonObject k = entry.getAsJsonObject("keyframe");
            JsonArray posArr = k.getAsJsonArray("pos");
            JsonArray rotArr = k.getAsJsonArray("rot");
            Vector3f pos = new Vector3f(posArr.get(0).getAsFloat(), posArr.get(1).getAsFloat(), posArr.get(2).getAsFloat());
            Vector3f rot = new Vector3f(rotArr.get(0).getAsFloat(), rotArr.get(1).getAsFloat(), rotArr.get(2).getAsFloat());
            float fov = k.get("fov").getAsFloat();
            CameraKeyframe keyframe = new CameraKeyframe(pos, rot, fov);
            int pathType = k.get("pathType").getAsInt();
            keyframe.setPathInterpolator(PathInterpolator.values()[pathType]);
            keyframe.setPosTimeInterpolator(TimeInterpolator.values()[k.get("posType").getAsInt()]);
            keyframe.setRotTimeInterpolator(TimeInterpolator.values()[k.get("rotType").getAsInt()]);
            keyframe.setFovTimeInterpolator(TimeInterpolator.values()[k.get("fovType").getAsInt()]);
            path.add(time, keyframe);
        }
        return path;
    }

    public record ExportResult(boolean success, String message, Path path) {
    }

    public record ImportResult(boolean success, String message, int count) {
    }
}

