/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.commandutil;

import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class CommandUtils {
    private static boolean DEBUG = false;

    public static boolean permCheck(CommandSourceStack s, int level) {
        if (s.f_81288_ instanceof BaseCommandBlock) {
            return true;
        }
        if (s.m_230897_()) {
            return s.m_81377_().m_129944_(s.m_230896_().m_36316_()) >= level;
        }
        return false;
    }

    public static void msgInfo(CommandSourceStack s, String msg) {
        s.m_288197_(() -> Component.m_237113_((String)msg), false);
    }

    public static void msgWarn(CommandSourceStack s, String msg) {
        s.m_288197_(() -> Component.m_237113_((String)("[warn] " + msg)), false);
    }

    public static void msgError(CommandSourceStack s, String msg) {
        s.m_81352_((Component)Component.m_237113_((String)msg));
    }

    public static ServerLevel level(CommandSourceStack s) {
        return s.m_81372_();
    }

    public static float clamp01(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    public static void setDebug(boolean v) {
        DEBUG = v;
    }

    public static String versionLine() {
        String mod = "Aperture-API";
        String version = "unknown";
        try {
            Optional opt = ModList.get().getModContainerById("apertureapi");
            if (opt.isPresent()) {
                version = ((ModContainer)opt.get()).getModInfo().getVersion().toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mod + " v" + version + ", MC 1.20.1";
    }
}

