/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import org.jetbrains.annotations.Nullable;

public class GlobalCameraSavedData
extends SavedData {
    private final HashMap<String, GlobalCameraPath> paths = new HashMap();

    private static GlobalCameraSavedData create() {
        return new GlobalCameraSavedData();
    }

    private static GlobalCameraSavedData load(CompoundTag tag) {
        GlobalCameraSavedData data = new GlobalCameraSavedData();
        ListTag paths = tag.m_128437_("paths", 10);
        for (int i = 0; i < paths.size(); ++i) {
            CompoundTag path = paths.m_128728_(i);
            data.paths.put(path.m_128461_("id"), GlobalCameraPath.fromNBT(path.m_128469_("path")));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag paths = new ListTag();
        for (Map.Entry<String, GlobalCameraPath> entry : this.paths.entrySet()) {
            CompoundTag path = new CompoundTag();
            path.m_128359_("id", entry.getKey());
            path.m_128365_("path", (Tag)GlobalCameraPath.toNBT(entry.getValue()));
            paths.add((Object)path);
        }
        tag.m_128365_("paths", (Tag)paths);
        return tag;
    }

    public void addPath(GlobalCameraPath path) {
        this.paths.put(path.getId(), path);
        this.m_77762_();
    }

    public void removePath(String id) {
        this.paths.remove(id);
        this.m_77762_();
    }

    @Nullable
    public GlobalCameraPath getPath(String id) {
        return this.paths.get(id);
    }

    public Collection<GlobalCameraPath> getPaths() {
        return this.paths.values();
    }

    public static GlobalCameraSavedData getData(ServerLevel level) {
        return (GlobalCameraSavedData)level.m_7654_().m_129783_().m_8895_().m_164861_(GlobalCameraSavedData::load, GlobalCameraSavedData::create, "camera_anim");
    }
}

