/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.common.animation;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import net.tysontheember.apertureapi.common.animation.TimeBezierController;
import net.tysontheember.apertureapi.common.animation.TimeInterpolator;
import net.tysontheember.apertureapi.common.animation.Vec3BezierController;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CameraKeyframe {
    public static final CameraKeyframe NULL = new CameraKeyframe(new Vector3f(Float.MIN_VALUE), new Vector3f(), 0.0f, PathInterpolator.STEP);
    private final Vector3f pos;
    private final Vector3f rot;
    private float fov;
    private PathInterpolator pathType;
    private final Vec3BezierController pathBezier;
    private TimeInterpolator posType;
    private final TimeBezierController posBezier;
    private TimeInterpolator rotType;
    private final TimeBezierController rotBezier;
    private TimeInterpolator fovType;
    private final TimeBezierController fovBezier;

    public CameraKeyframe(Vector3f pos, Vector3f rot, float fov, PathInterpolator pathType) {
        this.pos = pos;
        this.rot = rot;
        this.fov = fov;
        this.pathType = pathType;
        this.posType = TimeInterpolator.LINEAR;
        this.rotType = TimeInterpolator.LINEAR;
        this.fovType = TimeInterpolator.LINEAR;
        this.pathBezier = new Vec3BezierController(new Vector3f(), new Vector3f());
        this.posBezier = new TimeBezierController();
        this.rotBezier = new TimeBezierController();
        this.fovBezier = new TimeBezierController();
    }

    public CameraKeyframe(Vector3f pos, Vector3f rot, float fov) {
        this(pos, rot, fov, PathInterpolator.LINEAR);
    }

    private CameraKeyframe(Vector3f pos, Vector3f rot, float fov, PathInterpolator pathType, Vec3BezierController pathBezier, TimeInterpolator posType, TimeBezierController posBezier, TimeInterpolator rotType, TimeBezierController rotBezier, TimeInterpolator fovType, TimeBezierController fovBezier) {
        this.pos = pos;
        this.rot = rot;
        this.fov = fov;
        this.pathType = pathType;
        this.posType = posType;
        this.rotType = rotType;
        this.fovType = fovType;
        this.pathBezier = pathBezier;
        this.posBezier = posBezier;
        this.fovBezier = fovBezier;
        this.rotBezier = rotBezier;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public void setPos(float x, float y, float z) {
        this.pos.set(x, y, z);
    }

    public Vector3f getRot() {
        return this.rot;
    }

    public float getFov() {
        return this.fov;
    }

    public void setFov(float fov) {
        this.fov = fov;
    }

    public PathInterpolator getPathInterpolator() {
        return this.pathType;
    }

    public void setPathInterpolator(PathInterpolator type) {
        this.pathType = type;
    }

    public Vec3BezierController getPathBezier() {
        return this.pathBezier;
    }

    public TimeBezierController getPosBezier() {
        return this.posBezier;
    }

    public TimeBezierController getRotBezier() {
        return this.rotBezier;
    }

    public TimeBezierController getFovBezier() {
        return this.fovBezier;
    }

    public TimeInterpolator getPosTimeInterpolator() {
        return this.posType;
    }

    public TimeInterpolator getRotTimeInterpolator() {
        return this.rotType;
    }

    public TimeInterpolator getFovTimeInterpolator() {
        return this.fovType;
    }

    public void setPosTimeInterpolator(TimeInterpolator type) {
        this.posType = type;
    }

    public void setRotTimeInterpolator(TimeInterpolator type) {
        this.rotType = type;
    }

    public void setFovTimeInterpolator(TimeInterpolator type) {
        this.fovType = type;
    }

    public CameraKeyframe copy() {
        return new CameraKeyframe(new Vector3f(this.pos.x, this.pos.y, this.pos.z), new Vector3f(this.rot.x, this.rot.y, this.rot.z), this.fov, this.pathType, new Vec3BezierController(new Vector3f((Vector3fc)this.pathBezier.getLeft()), new Vector3f((Vector3fc)this.pathBezier.getRight())), this.posType, new TimeBezierController(new Vector2f((Vector2fc)this.posBezier.getLeft()), new Vector2f((Vector2fc)this.posBezier.getRight())), this.rotType, new TimeBezierController(new Vector2f((Vector2fc)this.rotBezier.getLeft()), new Vector2f((Vector2fc)this.rotBezier.getRight())), this.fovType, new TimeBezierController(new Vector2f((Vector2fc)this.fovBezier.getLeft()), new Vector2f((Vector2fc)this.fovBezier.getRight())));
    }

    public static CompoundTag toNBT(CameraKeyframe keyframe) {
        CompoundTag root = new CompoundTag();
        ListTag pos = new ListTag();
        pos.add((Object)FloatTag.m_128566_((float)keyframe.pos.x));
        pos.add((Object)FloatTag.m_128566_((float)keyframe.pos.y));
        pos.add((Object)FloatTag.m_128566_((float)keyframe.pos.z));
        root.m_128365_("pos", (Tag)pos);
        ListTag rot = new ListTag();
        rot.add((Object)FloatTag.m_128566_((float)keyframe.rot.x));
        rot.add((Object)FloatTag.m_128566_((float)keyframe.rot.y));
        rot.add((Object)FloatTag.m_128566_((float)keyframe.rot.z));
        root.m_128365_("rot", (Tag)rot);
        root.m_128350_("fov", keyframe.fov);
        root.m_128405_("pathType", keyframe.pathType.index);
        root.m_128405_("posType", keyframe.posType.index);
        root.m_128405_("rotType", keyframe.rotType.index);
        root.m_128405_("fovType", keyframe.fovType.index);
        root.m_128365_("pathBezier", (Tag)Vec3BezierController.toNBT(keyframe.pathBezier));
        root.m_128365_("posBezier", (Tag)TimeBezierController.toNBT(keyframe.posBezier));
        root.m_128365_("rotBezier", (Tag)TimeBezierController.toNBT(keyframe.rotBezier));
        root.m_128365_("fovBezier", (Tag)TimeBezierController.toNBT(keyframe.fovBezier));
        return root;
    }

    public static CameraKeyframe fromNBT(CompoundTag root) {
        return new CameraKeyframe(new Vector3f(root.m_128437_("pos", 5).m_128775_(0), root.m_128437_("pos", 5).m_128775_(1), root.m_128437_("pos", 5).m_128775_(2)), new Vector3f(root.m_128437_("rot", 5).m_128775_(0), root.m_128437_("rot", 5).m_128775_(1), root.m_128437_("rot", 5).m_128775_(2)), root.m_128457_("fov"), PathInterpolator.fromIndex(root.m_128451_("pathType")), Vec3BezierController.fromNBT(root.m_128437_("pathBezier", 5)), TimeInterpolator.fromIndex(root.m_128451_("posType")), TimeBezierController.fromNBT(root.m_128437_("posBezier", 5)), TimeInterpolator.fromIndex(root.m_128451_("rotType")), TimeBezierController.fromNBT(root.m_128437_("rotBezier", 5)), TimeInterpolator.fromIndex(root.m_128451_("fovType")), TimeBezierController.fromNBT(root.m_128437_("fovBezier", 5)));
    }
}

