/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.common.animation;

import org.joml.Vector3f;
import org.joml.Vector3fc;

public class JitterPrevention {
    private static final float EPSILON = 0.001f;

    public static float calculateSmoothT(float currentTime, int keyframeTime1, int keyframeTime2) {
        float timeDelta = keyframeTime2 - keyframeTime1;
        if (timeDelta <= 0.001f) {
            return 0.0f;
        }
        float rawT = (currentTime - (float)keyframeTime1) / timeDelta;
        return Math.max(0.0f, Math.min(1.0f, rawT));
    }

    public static boolean isTimeEqual(float time1, float time2) {
        return Math.abs(time1 - time2) <= 0.001f;
    }

    public static Vector3f smoothLerp(float t, Vector3f start, Vector3f end, Vector3f result) {
        float smoothT = JitterPrevention.smoothStep(t);
        return result.set((Vector3fc)start).lerp((Vector3fc)end, smoothT);
    }

    private static float smoothStep(float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        return t * t * (3.0f - 2.0f * t);
    }

    public static Vector3f smoothRotationLerp(float t, Vector3f startRot, Vector3f endRot, Vector3f result) {
        float smoothT = JitterPrevention.smoothStep(t);
        float x = JitterPrevention.lerpAngle(startRot.x, endRot.x, smoothT);
        float y = JitterPrevention.lerpAngle(startRot.y, endRot.y, smoothT);
        float z = JitterPrevention.lerpAngle(startRot.z, endRot.z, smoothT);
        return result.set(x, y, z);
    }

    private static float lerpAngle(float start, float end, float t) {
        start = JitterPrevention.normalizeAngle(start);
        float diff = (end = JitterPrevention.normalizeAngle(end)) - start;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        return JitterPrevention.normalizeAngle(start + diff * t);
    }

    private static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static float smoothFovLerp(float t, float startFov, float endFov) {
        float smoothT = JitterPrevention.smoothStep(t);
        return startFov + (endFov - startFov) * smoothT;
    }

    public static boolean isAtKeyframeBoundary(float currentTime, int keyframeTime, float tolerance) {
        return Math.abs(currentTime - (float)keyframeTime) <= tolerance;
    }

    public static float temporalSmoothing(float currentValue, float previousValue, float smoothingFactor) {
        smoothingFactor = Math.max(0.0f, Math.min(1.0f, smoothingFactor));
        return currentValue + (previousValue - currentValue) * smoothingFactor;
    }
}

