/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.apertureapi.common.animation;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import net.tysontheember.apertureapi.common.animation.CameraKeyframe;
import net.tysontheember.apertureapi.common.animation.GlobalCameraPath;
import net.tysontheember.apertureapi.common.animation.PathInterpolator;
import net.tysontheember.apertureapi.common.animation.TimeInterpolator;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SmoothingUtils {
    public static void applyCinematicSmoothing(CameraKeyframe keyframe, EaseType easeType) {
        keyframe.setPathInterpolator(PathInterpolator.SMOOTH);
        keyframe.setPosTimeInterpolator(TimeInterpolator.BEZIER);
        keyframe.setRotTimeInterpolator(TimeInterpolator.BEZIER);
        keyframe.setFovTimeInterpolator(TimeInterpolator.BEZIER);
        switch (easeType) {
            case EASE_IN: {
                keyframe.getPosBezier().easyIn();
                keyframe.getRotBezier().easyIn();
                keyframe.getFovBezier().easyIn();
                break;
            }
            case EASE_OUT: {
                keyframe.getPosBezier().easyOut();
                keyframe.getRotBezier().easyOut();
                keyframe.getFovBezier().easyOut();
                break;
            }
            case EASE_IN_OUT: {
                keyframe.getPosBezier().easyInOut();
                keyframe.getRotBezier().easyInOut();
                keyframe.getFovBezier().easyInOut();
                break;
            }
            case EASE: {
                keyframe.getPosBezier().easy();
                keyframe.getRotBezier().easy();
                keyframe.getFovBezier().easy();
            }
        }
    }

    public static void applyBezierSmoothing(CameraKeyframe keyframe, EaseType easeType) {
        keyframe.setPathInterpolator(PathInterpolator.BEZIER);
        keyframe.setPosTimeInterpolator(TimeInterpolator.BEZIER);
        keyframe.setRotTimeInterpolator(TimeInterpolator.BEZIER);
        keyframe.setFovTimeInterpolator(TimeInterpolator.BEZIER);
        switch (easeType) {
            case EASE_IN: {
                keyframe.getPosBezier().easyIn();
                keyframe.getRotBezier().easyIn();
                keyframe.getFovBezier().easyIn();
                break;
            }
            case EASE_OUT: {
                keyframe.getPosBezier().easyOut();
                keyframe.getRotBezier().easyOut();
                keyframe.getFovBezier().easyOut();
                break;
            }
            case EASE_IN_OUT: {
                keyframe.getPosBezier().easyInOut();
                keyframe.getRotBezier().easyInOut();
                keyframe.getFovBezier().easyInOut();
                break;
            }
            case EASE: {
                keyframe.getPosBezier().easy();
                keyframe.getRotBezier().easy();
                keyframe.getFovBezier().easy();
            }
        }
    }

    public static void autoSmoothPath(GlobalCameraPath path) {
        Int2ObjectMap.FastEntrySet<CameraKeyframe> keyframes = path.getEntries();
        CameraKeyframe previousKeyframe = null;
        for (Int2ObjectMap.Entry entry : keyframes) {
            CameraKeyframe keyframe = (CameraKeyframe)entry.getValue();
            if (previousKeyframe != null) {
                Vector3f posDiff = new Vector3f((Vector3fc)keyframe.getPos()).sub((Vector3fc)previousKeyframe.getPos());
                Vector3f rotDiff = new Vector3f((Vector3fc)keyframe.getRot()).sub((Vector3fc)previousKeyframe.getRot());
                float fovDiff = Math.abs(keyframe.getFov() - previousKeyframe.getFov());
                EaseType easeType = SmoothingUtils.determineOptimalEasing(posDiff, rotDiff, fovDiff);
                if (SmoothingUtils.shouldUseBezierPath(posDiff, rotDiff)) {
                    SmoothingUtils.applyBezierSmoothing(keyframe, easeType);
                } else {
                    SmoothingUtils.applyCinematicSmoothing(keyframe, easeType);
                }
            }
            previousKeyframe = keyframe;
        }
        for (Int2ObjectMap.Entry entry : keyframes) {
            path.updateBezier(entry.getIntKey());
        }
    }

    public static int[] detectKeyframeJumps(GlobalCameraPath path) {
        Int2ObjectMap.FastEntrySet<CameraKeyframe> keyframes = path.getEntries();
        ArrayList<Integer> jumpTimes = new ArrayList<Integer>();
        CameraKeyframe previousKeyframe = null;
        int previousTime = 0;
        for (Int2ObjectMap.Entry entry : keyframes) {
            int time = entry.getIntKey();
            CameraKeyframe keyframe = (CameraKeyframe)entry.getValue();
            if (previousKeyframe != null) {
                float timeDelta = time - previousTime;
                Vector3f posDiff = new Vector3f((Vector3fc)keyframe.getPos()).sub((Vector3fc)previousKeyframe.getPos());
                Vector3f rotDiff = new Vector3f((Vector3fc)keyframe.getRot()).sub((Vector3fc)previousKeyframe.getRot());
                float fovDiff = Math.abs(keyframe.getFov() - previousKeyframe.getFov());
                float posRate = posDiff.length() / timeDelta;
                float rotRate = rotDiff.length() / timeDelta;
                float fovRate = fovDiff / timeDelta;
                boolean hasJump = false;
                if (posRate > 0.5f && keyframe.getPathInterpolator() == PathInterpolator.LINEAR) {
                    hasJump = true;
                }
                if (rotRate > 5.0f && keyframe.getRotTimeInterpolator() == TimeInterpolator.LINEAR) {
                    hasJump = true;
                }
                if (fovRate > 1.0f && keyframe.getFovTimeInterpolator() == TimeInterpolator.LINEAR) {
                    hasJump = true;
                }
                if (keyframe.getPathInterpolator() == PathInterpolator.STEP) {
                    hasJump = true;
                }
                if (hasJump) {
                    jumpTimes.add(time);
                }
            }
            previousKeyframe = keyframe;
            previousTime = time;
        }
        return jumpTimes.stream().mapToInt(Integer::intValue).toArray();
    }

    public static void fixDetectedJumps(GlobalCameraPath path, int[] jumpTimes) {
        for (int time : jumpTimes) {
            CameraKeyframe previous;
            CameraKeyframe keyframe = path.getPoint(time);
            if (keyframe == null || (previous = path.getPrePoint(time)) == null) continue;
            Vector3f posDiff = new Vector3f((Vector3fc)keyframe.getPos()).sub((Vector3fc)previous.getPos());
            Vector3f rotDiff = new Vector3f((Vector3fc)keyframe.getRot()).sub((Vector3fc)previous.getRot());
            float fovDiff = Math.abs(keyframe.getFov() - previous.getFov());
            EaseType easeType = SmoothingUtils.determineOptimalEasing(posDiff, rotDiff, fovDiff);
            SmoothingUtils.applyCinematicSmoothing(keyframe, easeType);
        }
        for (int time : jumpTimes) {
            path.updateBezier(time);
        }
    }

    private static EaseType determineOptimalEasing(Vector3f posDiff, Vector3f rotDiff, float fovDiff) {
        float totalMovement = posDiff.length() + rotDiff.length() + fovDiff;
        if (totalMovement < 2.0f) {
            return EaseType.EASE_IN_OUT;
        }
        if (totalMovement < 10.0f) {
            return EaseType.EASE;
        }
        return EaseType.EASE_IN_OUT;
    }

    private static boolean shouldUseBezierPath(Vector3f posDiff, Vector3f rotDiff) {
        float complexity = posDiff.length() + rotDiff.length();
        return complexity > 15.0f;
    }

    public static enum EaseType {
        EASE_IN,
        EASE_OUT,
        EASE_IN_OUT,
        EASE;

    }
}

